/*    XAttack - a poor game :)
*     Copyright (C) 1998  Andrius Glozheckas
*     
*     This program is free software; you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation; either version 2 of the License, or
*     (at your option) any later version.
*     
*     This program is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*     
*     You should have received a copy of the GNU General Public License
*     along with this program; if not, write to the Free Software
*     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*
*     You can contact the author at aces@softhome.net, aces@hempseed.com.
*/#include "xattack.h"

void EndMatch(int winner_team) {
	int i;
	char *tmp;
	int pos;
	XEvent evnt;
	
	tank_in_turn = 0;
	for(i = 0; i < number_of_tanks; i++) {
		if ((tanks[i].team == winner_team) && tanks[i].max_power)
		{
			tanks[i].wins++;
			tanks[i].money += 10000;
			tanks[i].points += 10000;
		}
	}
	for(i = 0; i < num_shots; i++) {
		shots[i].type = 0;
		shots[i].owner = MAX_TANKS;
	}
	XSetForeground(dpy, gc, XColors[4].pixel);
        pos = (height / 2) - ((number_of_tanks + 2) * 10);
        tmp = (char *) malloc(100);
        sprintf(tmp, "Current Results:");
	XDrawString(dpy, textwind, gc, (width / 2) - XTextWidth(playfont, tmp, strlen(tmp)), pos, tmp, strlen(tmp));
	pos += 20;
	sprintf(tmp, "Name");
	XDrawString(dpy, textwind, gc, (width / 2) - 100, pos, tmp, strlen(tmp));
        sprintf(tmp, "Points");
        XDrawString(dpy, textwind, gc, (width / 2), pos, tmp, strlen(tmp));
        sprintf(tmp, "Current Money");
        XDrawString(dpy, textwind, gc, (width / 2) + 100, pos, tmp, strlen(tmp));
	for(i = 0; i < number_of_tanks; i++)
	{
		pos += 20;
		XSetForeground(dpy, gc, XColors[tanks[i].color].pixel);
                sprintf(tmp, "%s", tanks[i].name);
                XDrawString(dpy, mainwind, gc, (width / 2) - 100, pos, tmp, strlen(tmp));
                sprintf(tmp, "%li", tanks[i].points);
                XDrawString(dpy, mainwind, gc, (width / 2), pos, tmp, strlen(tmp));
                sprintf(tmp, "%li", tanks[i].money);
                XDrawString(dpy, mainwind, gc, (width / 2) + 100, pos, tmp, strlen(tmp));
	}
	while(!XCheckTypedEvent(dpy, KeyPress, &evnt) && !XCheckTypedEvent(dpy, ButtonPress, &evnt));
	tank_in_turn = 0;
	PaintMenu();
	buy_mode = 1;
	battletime = 0;
}


void BeginNewMatch()
{
	int n, tmp_convert, playertanks, playertank = 0;
	char *tmp;
	
	battletime = 0;
	XClearWindow(dpy, mainwind);
	ClearBattlefield();
	CreateLandscape();	
	DrawLandscapeInBattlefield();
	DrawLandscape();
	tmp = (char *) malloc(100);
	if (max_wind != 0) {
		srand(time(0));
		wind = rand() * (2 * max_wind / (float) RAND_MAX);
		wind = wind - max_wind;
		}
	sprintf(tmp, "Wind: %d", wind);
	XSetForeground(dpy, Textgc, XColors[1].pixel);
	XClearArea(dpy, textwind, wind_text_reserve, 0, width - wind_text_reserve,
		20, False);
	XDrawString(dpy, textwind, Textgc, wind_text_reserve, 10, tmp, strlen(tmp));
	for(n = 0; n < number_of_tanks; n++) {
        	if (tanks[n].computer_type == 0)
                	playertanks++;
	}

	for(n = 0; n < number_of_tanks; n++) {
                if (playertanks == 0)
                {
                        tanks[n].text_box_place = 0;
                } else if (tanks[n].computer_type == 0)
                {
                        tanks[n].text_box_place = playertank * (wind_text_reserve / playertanks);
			playertank++;
		}	
		tanks[n].cur_x = ((2 * (n + 1)) - 1) * ((width / (number_of_tanks)) / 2);
		tmp_convert = tanks[n].cur_x;
		tanks[n].cur_y = landscape[tmp_convert];
		tanks[n].cur_angle = 180;
		tanks[n].max_power = 1000;
                tanks[n].guiding = 0;
                tanks[n].fire_delay = 0;
                tanks[n].tank_angle = 0;
		DrawTank(n, tanks[n].color, 2);
	}

}



