/*    XAttack - a poor game :)
*     Copyright (C) 1998  Andrius Glozheckas
*     
*     This program is free software; you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation; either version 2 of the License, or
*     (at your option) any later version.
*     
*     This program is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*     
*     You should have received a copy of the GNU General Public License
*     along with this program; if not, write to the Free Software
*     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*
*     You can contact the author at aces@softhome.net, aces@hempseed.com.
*/#include "xattack.h"

double FindAngle(int from, int to);
int FindSmallestDistanceWithHeightCheck(int from);
int FindSmallestDistance(int from);
void StupidShot(int tank);

void StupidShot(int tank)
{
    DrawTank(tank, 0, 0);
    tanks[tank].cur_angle = 160 + (rand() * (40 / (float)
			RAND_MAX));
		if (tanks[tank].max_power > 100) {
			if (tanks[tank].max_power > 300)
    	tanks[tank].power = 100 + (rand() * ((tanks[tank].max_power - 300) /
				(float) RAND_MAX));
			else
    	tanks[tank].power = 100 + (rand() * ((tanks[tank].max_power - 100) /
				(float) RAND_MAX));
		}
		else
    	tanks[tank].power = (rand() * ((tanks[tank].max_power) /
				(float) RAND_MAX));
    DrawTank(tank, tanks[tank].color, 2);
    QueryShot(tank);


}

double FindAngle(int from, int to)
{
	if (tanks[from].cur_x < tanks[to].cur_x)
	{
		return(PI + atan((tanks[to].cur_y - tanks[from].cur_y) / (float)(tanks[to].cur_x -
			tanks[from].cur_x)));
	} else {
		return(atan((tanks[to].cur_y - tanks[from].cur_y) / (float)(tanks[to].cur_x -
			tanks[from].cur_x)));
	}
}

int FindSmallestDistance(int from)
{
        int tmp_distance, smallest_distance, target_tank, i;

        smallest_distance = 32000;
        for(i = 0; i < number_of_tanks; i++)
        {
            if (i != from) {
                tmp_distance = CalcDistance(tanks[from].cur_x, tanks[i].cur_x,
                    tanks[from].cur_y, tanks[i].cur_y);
                if (tmp_distance < smallest_distance) {
                    smallest_distance = tmp_distance;
                    target_tank = i;
                    }
                }
            }
        return target_tank;
}
int FindSmallestDistanceWithHeightCheck(int from)
{
        int tmp_distance, smallest_distance, target_tank, i;


       smallest_distance = 32000;
				target_tank = -1;
        for(i = 0; i < number_of_tanks; i++) {
            if ((tanks[i].team != tanks[from].team) && (tanks[from].cur_y >
							tanks[i].cur_y) && (tanks[i].max_power > 0)) {
                tmp_distance = CalcDistance(tanks[from].cur_x, tanks[i].cur_x,
                    tanks[from].cur_y, tanks[i].cur_y);
                if (tmp_distance < smallest_distance) {
                    smallest_distance = tmp_distance;
                    target_tank = i;
                    }
                }
            }

				return target_tank;
}

void CalculateShot(int tank)
{
        int i, tmp_tank, tmpx, tmpy;

	if (tanks[tank].max_power <= 0) return;
	tank_in_turn = tank;
	switch (tanks[tank].computer_type) {
                case 1:
		StupidShot(tank);
		break;
                case 2:
		DrawTank(tank, 0, 0);
                tmp_tank = FindSmallestDistanceWithHeightCheck(tank);
		if (tmp_tank == -1)
		{
			StupidShot(tank);
		} else {
			tanks[tank].cur_angle = 90 + 1 + RadToDeg(FindAngle(tank, tmp_tank));
			tanks[tank].power = tanks[tank].max_power;
                       	DrawTank(tank, tanks[tank].color, 2);
                       	QueryShot(tank);
			break;
		}
	}
}

