/*

	sp_types.h

	Space Plumber - Angel Ortega

*/

#ifndef NULL
#define NULL 0
#endif

/* Space Plumber 0.9.2 funcion en Linux + svgalib el 05/08/1997 */
/* Space Plumber 0.9.3 funcion (toscamente) el laberinto el 14/08/1997 */
/* Space Plumber 0.9.4 funcionaron el men, los forks, broken_light,
   _writable_dir y el shift izquierdo el 21/08/1997 */
/* Space Plumber 0.9.5 aadido la bifurcacin en K, terminado el
   motor de laberintos aleatorios 28/08/1997 */
/* Space Plumber 1.0.1 el 17/09/1997 */
/* Space Plumber 1.0.2 el 19/11/1997 para Stratos */
/* Space Plumber 1.0.3 aadido mirar arriba y abajo y _wave_water */
/* Space Plumber 1.0.4 versin X11 y otros cambios estticos
   en el cdigo fuente */
/* Space Plumber 1.0.4i nuevo el parmetro intro */
/* Space Plumber 1.0.5 con soporte de joystick 21/03/1998 */

/* versin */
#define SP_VERSION "1.0.5"

/* Space Plumber comercial s/no */

#ifdef STRATOS
#define COMMERCIAL
#endif

/* pantalla */
#define SCREEN_X_SIZE 320
#define SCREEN_Y_SIZE 200
#define SCREEN_HALF_Y_SIZE 100

/* texturas */
#define TEXTURE_X_SIZE 128
#define TEXTURE_Y_SIZE 128
#define TEXTURE_X_MASK 127
#define TEXTURE_Y_MASK 127
#define TEXTURE_SIZE   (TEXTURE_X_SIZE*TEXTURE_Y_SIZE)
#define TEXTURE_MASK   (TEXTURE_SIZE-1)

/* nmero de bits que definen el tamao del bloque */
#define BLOCK_BITS 7

/* tamao del bloque en pxels */
#define BLOCK_SIZE (1<<BLOCK_BITS)
#define BLOCK_MASK (BLOCK_SIZE-1)


typedef struct
{
	int r;
	int g;
	int b;
} sp_palette;

typedef unsigned char sp_texture;

typedef struct
{
	unsigned char *data;
	int length;
	int stereo;
	int bits;
	int left_volume;
	int right_volume;
	void (*callback)();
	int loop;
} sp_sound;


/* cdigos de retorno */

#define SPLUMBER_SYSTEMERR -1
#define SPLUMBER_RESOLVED   0
#define SPLUMBER_DEAD	    1
#define SPLUMBER_CANCEL     2
#define SPLUMBER_WIN	    3
#define SPLUMBER_BANG	    6

#if defined(LINUX_SVGALIB) || defined(UNIX_X11)
#define SPLUMBER_UNIX
#endif
