/*

	sp_sb.c

	Soporte de SoundBlaster.

	Space Plumber - Angel Ortega

	Notas:

	- Oscuro y muy mal documentado, fuertemente
	  basado en la Sound-Blaster Library for DJGPP 2.0
	  de jhunter@kendaco.telebyte.net.

	- No tiene cdigo de bloqueo de funciones y datos,
	  por tanto necesita que el ejecutable no haga paginaciones
	  (esto desactiva la memoria virtual)

*/

/* en linux no hay sonido */

#ifdef linux
#define NO_SOUND
#endif


#ifndef NO_SOUND

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dpmi.h>
#include <go32.h>
#include <inlines/pc.h>
#include <sys/farptr.h>
#include <crt0.h>
#include <dos.h>

#include "sp_supp.h"
#include "sp_types.h"
#include "sp_sb.h"


/* switch de uso de sonido */
int _no_sound=0;

/* frecuencia de muestreo general requerida */
/* 11025-22050 es lo mejor */
int _wanted_sample_frequency=11025;

/* frecuencia real de muestreo */
int _real_sample_frequency;


#define BYTE	unsigned char
#define WORD	unsigned short
#define DWORD	unsigned long


/* frecuencia del ltimo .WAV cargado */
WORD _wav_frequency;

/* nmero de ficheros mezclados y encolados */

#define _SB_MAX_MIX		64
#define _SB_MAX_QUEUE		16


/* tamao del buffer de transferencia del DMA */

#define _SB_BUFFER_SIZE 	96
#define _SB_BLOCK_SIZE		(_SB_BUFFER_SIZE/2)


/* puertos de los DMA,s. */

static int pagePort[8] = { 0x87, 0x83, 0x81, 0x82, -1, 0x8B, 0x89, 0x8A };


/* operacin a ejecutar en el DMA. AO: por qu no es
   un parmetro de la funcin programDMA()? */

static BYTE dmaCommand;


/* estructura de informacin sobre la SoundBlaster */
struct
{
	WORD reset;
	WORD readData;
	WORD writeData;
	WORD dataAvail;
	int IRQ;
	int DMA;
	int dspVersion;
} sb_info;


/* estructura de control de un sample sonando */
typedef struct
{
	sp_sound *sample;
	int elapsedBytes;
	int bytesLeft;
} sampleTracker;

int *sb_mixing_buffer;
int *sb_left_buffer, *sb_right_buffer;

int sb_multTable[64][256];

/* tabla y nmero de sonidos encolados */
sp_sound *sb_queue[_SB_MAX_QUEUE];
int sb_numInQueue;

/* tabla y nmero de sonidos simultneos */
sampleTracker sb_mix[_SB_MAX_MIX];
int sb_numInMix;


#define _SB_HAS_HIGH_SPEED_MODE    (sb_info.dspVersion>0x0202)

DWORD sb_dmaBufferLinearAddress[2];
DWORD sb_miniDMABufferAddress[2];
int sb_currentBlock;

/* valor por defecto del mixer */
static BYTE mixerDefault;

/* valores por defecto en los dos PIC,s. */
static BYTE pic1Default, pic2Default;

static WORD dmaBufferSelector;
static int endOfDMAInterruptVector;
static __dpmi_paddr oldHandler, newHandler;
static _go32_dpmi_seginfo wrapper;


/********************
	Cdigo
*********************/

/** rutinas de lectura/escritura en el DSP **/

static void sb_dspWrite(int val)
{
	while((inportb(sb_info.writeData)&0x80)!=0);
	outportb(sb_info.writeData,val);
}

static int sb_dspRead(void)
{
	while((inportb(sb_info.dataAvail)&0x80)==0);
	return inportb(sb_info.readData);
}

static int sb_dspReset(void)
{
	int a;
	int success;

	outportb(sb_info.reset,1);

	/* AO: sustitudo para no usar la funcin que tena,
	   ya que tocaba en el PIC. Probablemente as no funcione */
	delay(5);

	outportb(sb_info.reset,0);

	success=0;
	for(a=0;a<1000;a++)
	{
		if(inportb(sb_info.dataAvail)&0x80)
		{
			success=1;
			break;
		}
	}

	if(success)
	{
		for(a=0;a<1000;a++)
		{
			if(inportb(sb_info.readData)==0xAA)
			{
				success=2;
				break;
			}
		}
	}

	if(success!=2)
		return(0);

	sb_dspWrite(0xE1);
	sb_info.dspVersion=sb_dspRead();
	sb_info.dspVersion<<=8;
	sb_info.dspVersion|=sb_dspRead();

	return(1);
}

static void sb_dspSetTimeConstant(int freq)
{
	BYTE tc;

	sb_dspWrite(0x40);

	tc=256-(1000000/freq);
	sb_dspWrite(tc);
}

static void sb_dspSetHighSpeedTimeConstant(int freq)
{
	unsigned tc;

	sb_dspWrite(0x40);

	tc=65536-(256000000/freq);
	tc>>=8;
	sb_dspWrite(tc);
}

static void sb_dspStartDMATransferAI(int length)
{
	sb_dspWrite(0x48);
	sb_dspWrite(length&0xFF);
	sb_dspWrite(length>>8);
	sb_dspWrite(0x1C);
}

static void sb_dspStartHighSpeedDMATransferAI(int length)
{
	sb_dspWrite(0x48);
	sb_dspWrite(length&0xFF);
	sb_dspWrite(length>>8);
	sb_dspWrite(0x90);
}

static void sb_dspStartDMATransferSC(int length)
{
	sb_dspWrite(0x14);
	sb_dspWrite(length&0xFF);
	sb_dspWrite(length>>8);
}


/** rutinas de DMA **/

static inline void programDMA(DWORD linearAddressOfBuffer, int length)
{
	int offset, page;
	int port;

	page=linearAddressOfBuffer>>16;
	offset=linearAddressOfBuffer&0xFFFF;

	outportb(0x0A,sb_info.DMA|0x04);	/* Mask DMA channel	*/
	outportb(0x0C,0);			/* Clear byte flip-flop */
	outportb(0x0B,sb_info.DMA|dmaCommand);	/* Set mode		*/

	port=sb_info.DMA<<1;
	outportb(port,offset&0xFF);		/* Program offset	*/
	outportb(port,offset>>8);

	port+=1;
	outportb(port,length&0xFF);		/* Program length	*/
	outportb(port,length>>8);

	outportb(pagePort[sb_info.DMA],page);	/* Program page 	*/

	outportb(0x0A,sb_info.DMA);		/* Clear channel mask	*/
}


static void sb_dma8bitReadAI(DWORD linearAddressOfBuffer, int length)
{
	dmaCommand=0x58;
	programDMA(linearAddressOfBuffer,length);
}

static void sb_dma8bitReadSC(DWORD linearAddressOfBuffer, int length)
{
	dmaCommand=0x48;
	programDMA(linearAddressOfBuffer,length);
}


static int sb_is_present(void)
{
	static char *blaster;
	char *address;
	short sbIO;

	blaster=getenv("BLASTER");

	if(blaster!=NULL)
	{
		strupr(blaster);

		if((address=strrchr(blaster,'A'))==NULL)
			return(0);

		++address;
		sscanf(address,"%hx",&sbIO);

		sb_info.reset=sbIO+0x06;
		sb_info.readData=sbIO+0x0A;
		sb_info.writeData=sbIO+0x0C;
		sb_info.dataAvail=sbIO+0x0E;

		if((address=strrchr(blaster,'I'))==NULL)
			return(0);

		++address;
		sscanf(address,"%d",&sb_info.IRQ);

		if((address=strrchr(blaster,'D'))==NULL)
			return(0);

		++address;
		sscanf(address,"%d",&sb_info.DMA);

		return(1);
	}

	return(0);
}


void start_sound(sp_sound *ss)
/* lanza un sonido */
{
	int a;

	if(!_no_sound && ss!=NULL)
	{
		if(sb_numInMix>=_SB_MAX_MIX)
		{
			sb_numInMix-=1;

			for(a=0;a<sb_numInMix;a++)
				sb_mix[a]=sb_mix[a+1];
		}

		sb_mix[sb_numInMix].elapsedBytes=0;
		sb_mix[sb_numInMix].bytesLeft=ss->length;
		sb_mix[sb_numInMix].sample=ss;
		sb_numInMix++;
	}
}


static int seek_sound_mix(sp_sound *ss)
/* localiza un sonido en el mixer */
{
	int n;

	/* localiza el slot de sb_mix donde est ese sample */
	for(n=0;n<sb_numInMix;n++)
	{
		if(sb_mix[n].sample==ss)
			return(n);
	}

	return(-1);
}


static void sb_mix_mono_samples(void)
{
	int a, b;
	int temp;

	for(a=0;a<sb_numInMix;a++)
	{
		temp=(sb_mix[a].sample->left_volume+sb_mix[a].sample->right_volume)>>1;

		if(sb_mix[a].bytesLeft>(_SB_BLOCK_SIZE/2))
		{
			for(b=0;b<(_SB_BLOCK_SIZE/2);b++)
				sb_mixing_buffer[b]+=(sb_multTable[temp][sb_mix[a].sample->data[sb_mix[a].elapsedBytes++]])>>5;
			sb_mix[a].bytesLeft-=(_SB_BLOCK_SIZE/2);
		}
		else
		{
			for(b=0;b<sb_mix[a].bytesLeft;b++)
				sb_mixing_buffer[b]+=(sb_multTable[temp][sb_mix[a].sample->data[sb_mix[a].elapsedBytes++]])>>5;

			if(sb_mix[a].sample->loop)
			{
				sb_mix[a].elapsedBytes=0;
				sb_mix[a].bytesLeft=sb_mix[a].sample->length;

				for(;b<(_SB_BLOCK_SIZE/2);b++)
					sb_mixing_buffer[b]+=(sb_multTable[temp][sb_mix[a].sample->data[sb_mix[a].elapsedBytes++]])>>5;

				sb_mix[a].bytesLeft-=(_SB_BLOCK_SIZE/2);
			}
			else
			{
				if(sb_mix[a].sample->callback!=NULL)
					sb_mix[a].sample->callback();

				if(sb_mix[a].sample==sb_queue[0])
				{
					if(sb_numInQueue>1)
					{
						start_sound(sb_queue[1]);
						sb_numInQueue-=1;

						for(b=0;b<sb_numInQueue;b++)
							sb_queue[b]=sb_queue[b+1];

						temp=(sb_mix[sb_numInMix-1].sample->left_volume+sb_mix[sb_numInMix-1].sample->right_volume)>>1;

						for(b=sb_mix[a].bytesLeft;b<(_SB_BLOCK_SIZE/2);b++)
							sb_mixing_buffer[b]+=(sb_multTable[temp][sb_mix[sb_numInMix-1].sample->data[sb_mix[sb_numInMix-1].elapsedBytes++]])>>5;

						sb_mix[sb_numInMix-1].bytesLeft-=sb_mix[sb_numInMix-1].elapsedBytes;
					}
					else
					if(sb_numInQueue>0)
						sb_numInQueue-=1;
				}

				sb_numInMix-=1;

				for(b=a;b<sb_numInMix;b++)
					sb_mix[b]=sb_mix[b+1];

				a-=1;
			}
		}
	}
}


static void sb_mix_stereo_samples(void)
{
	int a, b;

	for(a=0;a<sb_numInMix;a++)
	{
		if(sb_mix[a].bytesLeft>(_SB_BLOCK_SIZE/2))
		{
			for(b=0;b<(_SB_BLOCK_SIZE/2);b++)
			{
				if(sb_mix[a].sample->left_volume)
					sb_left_buffer[b]+=(sb_multTable[sb_mix[a].sample->left_volume-1][sb_mix[a].sample->data[sb_mix[a].elapsedBytes]])>>5;

				if(sb_mix[a].sample->right_volume)
					sb_right_buffer[b]+=(sb_multTable[sb_mix[a].sample->right_volume-1][sb_mix[a].sample->data[sb_mix[a].elapsedBytes]])>>5;

				sb_mix[a].elapsedBytes+=1;
			}

			sb_mix[a].bytesLeft-=(_SB_BLOCK_SIZE/2);
		}
		else
		{
			for(b=0;b<sb_mix[a].bytesLeft;b++)
			{
				if(sb_mix[a].sample->left_volume)
					sb_left_buffer[b]+=(sb_multTable[sb_mix[a].sample->left_volume-1][sb_mix[a].sample->data[sb_mix[a].elapsedBytes]])>>5;

				if(sb_mix[a].sample->right_volume)
					sb_right_buffer[b]+=(sb_multTable[sb_mix[a].sample->right_volume-1][sb_mix[a].sample->data[sb_mix[a].elapsedBytes]])>>5;

				sb_mix[a].elapsedBytes+=1;
			}

			/* si es un loop, contina rellenando
			   desde el principio */
			if(sb_mix[a].sample->loop)
			{
				sb_mix[a].elapsedBytes=0;
				sb_mix[a].bytesLeft=sb_mix[a].sample->length;

				/* rellena hasta el final del bloque */
				for(;b<(_SB_BLOCK_SIZE/2);b++)
				{
					if(sb_mix[a].sample->left_volume)
						sb_left_buffer[b]+=(sb_multTable[sb_mix[a].sample->left_volume-1][sb_mix[a].sample->data[sb_mix[a].elapsedBytes]])>>5;

					if(sb_mix[a].sample->right_volume)
						sb_right_buffer[b]+=(sb_multTable[sb_mix[a].sample->right_volume-1][sb_mix[a].sample->data[sb_mix[a].elapsedBytes]])>>5;

					sb_mix[a].elapsedBytes+=1;
				}

				/* los loops siempre rellenan el bloque */
				sb_mix[a].bytesLeft-=(_SB_BLOCK_SIZE/2);
			}
			else
			{
				/* no es un loop: terminar */

				if(sb_mix[a].sample->callback!=NULL)
					sb_mix[a].sample->callback();

				if(sb_mix[a].sample==sb_queue[0])
				{
					if(sb_numInQueue>1)
					{
						start_sound(sb_queue[1]);
						sb_numInQueue-=1;

						for(b=0;b<sb_numInQueue;b++)
							sb_queue[b]=sb_queue[b+1];

						for(b=sb_mix[a].bytesLeft;b<(_SB_BLOCK_SIZE/2);b++)
						{
							if(sb_mix[sb_numInMix-1].sample->left_volume)
								sb_left_buffer[b]+=(sb_multTable[sb_mix[sb_numInMix-1].sample->left_volume-1][sb_mix[sb_numInMix-1].sample->data[sb_mix[sb_numInMix-1].elapsedBytes]])>>5;

							if(sb_mix[sb_numInMix-1].sample->right_volume)
								sb_right_buffer[b]+=(sb_multTable[sb_mix[sb_numInMix-1].sample->right_volume-1][sb_mix[sb_numInMix-1].sample->data[sb_mix[sb_numInMix-1].elapsedBytes]])>>5;

							sb_mix[sb_numInMix-1].elapsedBytes+=1;
						}

						sb_mix[sb_numInMix-1].bytesLeft-=sb_mix[sb_numInMix-1].elapsedBytes;
					}
					else
					if(sb_numInQueue>0)
						sb_numInQueue-=1;
				}

				sb_numInMix-=1;

				for(b=a;b<sb_numInMix;b++)
					sb_mix[b]=sb_mix[b+1];

				a-=1;
			}
		}
	}
}


#ifdef NOTUSED
static int sb_queue_sample(sp_sound *ss)
{
	if(ss!=NULL)
	{
		if(sb_numInQueue>=_SB_MAX_QUEUE)
			return(-1);

		if(sb_numInQueue==0)	      /* If the queue is empty right now, just */
			start_sound(ss);	  /* start playing this one right away.    */

		sb_queue[sb_numInQueue]=ss;
		sb_numInQueue++;

		return(0);
	}

	return(-2);
}
#endif


static sp_sound * sb_convert_frequency(sp_sound *srcSample,
	int srcFreq, int destFreq)
{
	sp_sound *ss;
	double ratio;
	int a;
	long long int position, end, increment;       /* 64-bit fixed-point vars */
	long *integral;
  
	ss=(sp_sound *)a_malloc(sizeof(sp_sound));

	ratio=(double)srcFreq/(double)destFreq;
	ss->length=(double)srcSample->length/ratio;

	end=(long long)srcSample->length<<32;
	increment=ratio*((long long)1<<32);
	integral=(long *)((BYTE *)&position+4);

	ss->data=(BYTE *)a_malloc(ss->length);

	for(position=0,a=0;position<end;position+=increment,a++)
		ss->data[a]=srcSample->data[*integral];

	ss->stereo=srcSample->stereo;
	ss->bits=srcSample->bits;
	ss->left_volume=srcSample->left_volume;
	ss->right_volume=srcSample->right_volume;
	ss->callback=srcSample->callback;
	ss->loop=srcSample->loop;

	return(ss);
}


static int sb_digi_initialize(void)
{
	int a, b;
	char c;

	sb_mixing_buffer=(int *)a_malloc((_SB_BLOCK_SIZE*2)*sizeof(int));

	sb_left_buffer=sb_mixing_buffer+_SB_BLOCK_SIZE;
	sb_right_buffer=sb_left_buffer+(_SB_BLOCK_SIZE/2);

	c=0;
	for(a=0;a<256;a++)
	{
		for(b=1;b<=64;b++)
			sb_multTable[b-1][a]=c*b;

		++c;
	}

	sb_numInQueue=0;
	sb_numInMix=0;

	return(0);
}


static int load_wav(FILE *fp, sp_sound *ss)
{
	BYTE dummydata[255];
	DWORD rlen,flen;
	WORD b_per_sec,num_channels,tag;
	char riffid[5],waveid[5],fmtid[5],dataid[5];

	fread(riffid,1,4,fp);
	riffid[4] = 0;
	fread(&rlen,1,4,fp);
	fread(waveid,1,4,fp);
	waveid[4] = 0;

	if(strcmp(waveid,"WAVE"))
		return(0);

	fread(fmtid,1,4,fp);
	fmtid[4] = 0;
	fread(&flen,1,4,fp);

	if(flen>240)
		flen=240;

	fread(&tag,1,2,fp);
	fread(&num_channels,1,2,fp);
	fread(&_wav_frequency,1,2,fp);
	fread(&b_per_sec,1,2,fp);
	fread(dummydata,1,(size_t)flen-8,fp);
	fread(dataid,1,4,fp);
	dataid[4] = 0;
	fread(&(ss->length),1,4,fp);

	ss->data=(BYTE *)a_malloc(ss->length+1);

	fread(ss->data,1,ss->length,fp);

	return(1);
}


static sp_sound * sb_load_sample(char *fname)
{
	sp_sound *ss;
	int err, i;
	FILE *fp;

	ss=(sp_sound *)a_malloc(sizeof(sp_sound));

	ss->callback=NULL;
	ss->left_volume=32;
	ss->right_volume=32;

	/* por defecto, no hay loops */
	ss->loop=0;

	fp=pack_fopen(fname,"rb");
  
	err=load_wav(fp,ss);

	fclose(fp);

	for(i=0;i<ss->length;i++)
		*(ss->data+i)=((BYTE)*(ss->data + i))-128;

	return(ss);
}


static void sb_free_sample(sp_sound *ss)
{
	if(ss!=NULL)
	{
		a_free(ss->data,ss->length);

		a_free(ss,sizeof(sp_sound));
	}
}


/* sbdriver.c */


static void sb_interrupt_handler(void)
{
	int a;
	DWORD addr;

	asm("movl $96, %%ecx
	     movl $0x80, %%eax
	     movl %0, %%edi
	     cld
	     rep
	     stosl"
	    :
	    : "m" (sb_mixing_buffer)
	    : "%eax", "%ecx", "%edi");


	if(sb_info.dspVersion>=0x0300)
	{
		/* Use STEREO */

		sb_mix_stereo_samples();

		_farsetsel(_go32_info_block.selector_for_linear_memory);

		addr=sb_dmaBufferLinearAddress[sb_currentBlock];

		for(a=0;a<(_SB_BLOCK_SIZE/2);a++,addr+=2)
		{
			if(sb_left_buffer[a]<0)
				_farnspokeb(addr,(BYTE)0);
			else
			if(sb_left_buffer[a]>255)
				_farnspokeb(addr,(BYTE)255);
			else
				_farnspokeb(addr,(BYTE)sb_left_buffer[a]);
		}

		addr-=47;

		for(a=0;a<(_SB_BLOCK_SIZE/2);a++,addr+=2)
		{
			if(sb_right_buffer[a]<0)
				_farnspokeb(addr,(BYTE)0);
			else
			if(sb_right_buffer[a]>255)
				_farnspokeb(addr,(BYTE)255);
			else
				_farnspokeb(addr,(BYTE)sb_right_buffer[a]);
		}

		sb_currentBlock^=1;
	}
	else
	{
		/* Use MONO (Blech!) */

		sb_mix_mono_samples();

		addr=sb_miniDMABufferAddress[sb_currentBlock];

		_farsetsel(_go32_info_block.selector_for_linear_memory);

		for(a=0;a<(_SB_BLOCK_SIZE/2);a++,addr++)
		{
			if(sb_mixing_buffer[a]<0)
				_farnspokeb(addr,(BYTE)0);
			else
			if(sb_mixing_buffer[a]>255)
				_farnspokeb(addr,(BYTE)255);
			else
				_farnspokeb(addr,(BYTE)sb_mixing_buffer[a]);
		}

		sb_currentBlock^=1;
	}

	if(sb_info.dspVersion<0x0200)
	{
		/* Ancient SB? */

		sb_dma8bitReadSC(sb_miniDMABufferAddress[sb_currentBlock],(_SB_BLOCK_SIZE/2)-1);
		sb_dspStartDMATransferSC((_SB_BLOCK_SIZE/2)-1);
	}

	inportb(sb_info.dataAvail);
	outportb(0x20,0x20);
	outportb(0xA0,0x20); 
}


static int allocateDosMem(int bytes, WORD *dosSeg, WORD *dosSel)
/* Allocate some DOS memory that doesnt cross a PAGE boundary (for the DMA
   buffer.) */
{
	int firstPage, lastPage;
	int linearAddress;
	int dosSegs[16];
	int dosSels[16];
	int paragraphs=(bytes+15)>>4;
	int currentTry=-1;

	do
	{
		++currentTry;

		if(currentTry>15)
			return(0);

		dosSegs[currentTry]=__dpmi_allocate_dos_memory(paragraphs,&dosSels[currentTry]);

		if(dosSegs[currentTry]==-1)
			return(0);

		linearAddress=dosSegs[currentTry]<<4;
		firstPage=linearAddress>>16;
		lastPage=(linearAddress+bytes-1)>>16;

	} while(firstPage!=lastPage);

	*dosSeg=(WORD)dosSegs[currentTry];
	*dosSel=(WORD)dosSels[currentTry];

	for(currentTry-=1;currentTry>=0;currentTry--)
		__dpmi_free_dos_memory(dosSels[currentTry]);

	return(1);
}


void SoundShutdown(void)
/* cierra el sistema de sonido */
{
	if(_no_sound)
		return;

	if(!_SB_HAS_HIGH_SPEED_MODE)
	{
		if(sb_info.dspVersion==0x0200)
			sb_dspWrite(0xDA);

		sb_dspWrite(0xD0);	      /* Stop any DMA transfers currently going on */
	}

	sb_dspReset();		      /* Hard-reset the DSP */
	sb_dspWrite(0xD3);	      /* and turn its speaker-output off */

	__dpmi_set_protected_mode_interrupt_vector(endOfDMAInterruptVector,&oldHandler);

	outportb(0x21,pic1Default);
	outportb(0xA1,pic2Default);

	if((sb_info.dspVersion>=0x0300)&&(sb_info.dspVersion<0x0400))
	{
		outportb(sb_info.reset-2,0x0E);
		outportb(sb_info.reset-1,mixerDefault);
	}

	_go32_dpmi_free_iret_wrapper(&wrapper);
	__dpmi_free_dos_memory(dmaBufferSelector);
	free(sb_mixing_buffer);
}


int SoundStartup(void)
/* arranca el sistema de sonido */
{
	WORD dmaBufferSegment;
	BYTE picMask;

	/* obliga a que la memoria est siempre bloqueada */
	_crt0_startup_flags|=_CRT0_FLAG_LOCK_MEMORY;

	if(_no_sound)
	{
		_real_sample_frequency=_wanted_sample_frequency;
		return(-1);
	}

	if(sb_is_present())
	{
		sb_dspReset();

		if(!allocateDosMem(_SB_BUFFER_SIZE,&dmaBufferSegment,&dmaBufferSelector))
			return(-2);

		sb_dmaBufferLinearAddress[0]=(DWORD)dmaBufferSegment<<4;
		sb_dmaBufferLinearAddress[1]=sb_dmaBufferLinearAddress[0]+_SB_BLOCK_SIZE;
		sb_miniDMABufferAddress[0]=sb_dmaBufferLinearAddress[0];
		sb_miniDMABufferAddress[1]=sb_dmaBufferLinearAddress[0]+(_SB_BLOCK_SIZE/2);

		pic1Default=inportb(0x21);
		pic2Default=inportb(0xA1);

		if(sb_info.IRQ<8)
		{
			endOfDMAInterruptVector=sb_info.IRQ+0x08;
			picMask=1<<sb_info.IRQ;
			picMask=~picMask;
			outportb(0x21,pic1Default&picMask);	    /* Enable PIC-1s IRQ */
		}
		else
		{
			endOfDMAInterruptVector=sb_info.IRQ+0x68;
			picMask=1<<(sb_info.IRQ-8);
			picMask=~picMask;
			outportb(0x21,pic1Default&0xFB);	    /* Enable IRQ2 */
			outportb(0xA1,pic2Default&picMask);	    /* As well as PIC-2s IRQ */
		}

		wrapper.pm_offset=(int)sb_interrupt_handler;
		wrapper.pm_selector=_my_cs();
		_go32_dpmi_allocate_iret_wrapper(&wrapper);
		newHandler.offset32=wrapper.pm_offset;
		newHandler.selector=wrapper.pm_selector;
	}
	else
	{
		_no_sound=1;
		_real_sample_frequency=_wanted_sample_frequency;

		logger("SoundStartup","No sound devices found");

		return(-1);
	}

	sb_currentBlock=0;
	_real_sample_frequency=_wanted_sample_frequency;

	if(_real_sample_frequency<5000)
		_real_sample_frequency=5000;

	if(sb_info.dspVersion>=0x0400)
	{
		if(_real_sample_frequency>45454)
			_real_sample_frequency=45454;
	}
	else
	if(sb_info.dspVersion>=0x0300)
	{
		if(_real_sample_frequency>22727)
			_real_sample_frequency=22727;
	}
	else
	if(_SB_HAS_HIGH_SPEED_MODE)
	{
		if(_real_sample_frequency>45454)
			_real_sample_frequency=45454;
	}
	else
	{
		if(_real_sample_frequency>22222)
			_real_sample_frequency=22222;
	}

	__dpmi_get_protected_mode_interrupt_vector(endOfDMAInterruptVector,&oldHandler);
	__dpmi_set_protected_mode_interrupt_vector(endOfDMAInterruptVector,&newHandler);

	if(_SB_HAS_HIGH_SPEED_MODE)
	{
		/* Use High-Speed Mode */
		if((sb_info.dspVersion>=0x0300)&&(sb_info.dspVersion<0x0400))
			sb_dspSetHighSpeedTimeConstant(_real_sample_frequency*2);
		else
			sb_dspSetHighSpeedTimeConstant(_real_sample_frequency);
	}
	else
		/* Use normal mode */
		sb_dspSetTimeConstant(_real_sample_frequency);

	sb_digi_initialize();

	sb_dspWrite(0xD1);			    /* Turn the speaker on */

	if(sb_info.dspVersion>=0x0400)
	{
		/* SB16 or better */
		sb_dma8bitReadAI(sb_dmaBufferLinearAddress[0],_SB_BUFFER_SIZE-1);
		sb_dspWrite(0xC4);
		sb_dspWrite(0x20);
		sb_dspWrite((_SB_BLOCK_SIZE-1)&0xFF);
		sb_dspWrite((_SB_BLOCK_SIZE-1)/256);
	}
	else
	if(sb_info.dspVersion>=0x0300)
	{
		/* SBPro */
		outportb(sb_info.reset-2,0x0E);
		mixerDefault=inportb(sb_info.reset-1);
		outportb(sb_info.reset-2,0x0E);
		outportb(sb_info.reset-1,mixerDefault|0x22);
		sb_dma8bitReadAI(sb_dmaBufferLinearAddress[0],_SB_BUFFER_SIZE-1);
		sb_dspStartHighSpeedDMATransferAI(_SB_BLOCK_SIZE-1);
	}
	else
	if(_SB_HAS_HIGH_SPEED_MODE)
	{
		/* SB 2.0 */
		sb_dma8bitReadAI(sb_dmaBufferLinearAddress[0],_SB_BUFFER_SIZE-1);
		sb_dspStartHighSpeedDMATransferAI(_SB_BLOCK_SIZE-1);
	}
	else
	if(sb_info.dspVersion>=0x0200)
	{
		/* SB 1.5 */
		sb_dma8bitReadAI(sb_miniDMABufferAddress[0],_SB_BLOCK_SIZE-1);
		sb_dspStartDMATransferAI((_SB_BLOCK_SIZE/2)-1);
	}
	else
	{
		/* SB 1.0 (VERY OLD!) */
		sb_dma8bitReadSC(sb_miniDMABufferAddress[0],(_SB_BLOCK_SIZE/2)-1);
		sb_dspStartDMATransferSC((_SB_BLOCK_SIZE/2)-1);
	}

	atexit(SoundShutdown);

	logger("SoundStartup",
		s_sprintf("Sound Blaster DSP %d.%d, %d Hz",
		sb_info.dspVersion>>8,sb_info.dspVersion&0xff,
		_real_sample_frequency));

	return(0);
}


void StartSound(sp_sound * ss)
/* lanza un sonido, slo si no est sonando ya */
{
	if(ss==NULL)
		return;

	if(seek_sound_mix(ss)==-1)
		start_sound(ss);
}


void ShutSound(sp_sound * ss)
/* calla un wav */
{
	int n;

	if(ss==NULL)
		return;

	/* necesario para que se calle */
	ss->loop=0;

	if((n=seek_sound_mix(ss))!=-1)
		sb_mix[n].bytesLeft=0;
}


sp_sound * LoadSound(char * wavfile)
/* carga un .WAV y le ajusta la frecuencia */
{
	sp_sound * rawsmp;
	sp_sound * smp;

	if(_no_sound)
		return(NULL);

	/* lo carga */
	rawsmp=sb_load_sample(wavfile);

	/* ajusta la frecuencia */
	smp=sb_convert_frequency(rawsmp,_wav_frequency,
		_real_sample_frequency);

	/* libera el original */
	sb_free_sample(rawsmp);

	return(smp);
}


void SetSound(sp_sound * s, int left, int right, int loop)
/* define las caractersticas del sonido */
{
	if(s==NULL)
		return;

	if(left!=-1)
		s->left_volume=left;

	if(right!=-1)
		s->right_volume=right;

	if(loop!=-1)
		s->loop=loop;
}

#else /* NO_SOUND */


/* Si no hay sonido, definir las funciones como stubs */

#include "sp_types.h"


int _no_sound=0;
int _wanted_sample_frequency=11025;
int _real_sample_frequency=11025;

/* para evitar warnings */
static int _i1,_i2,_i3;
static sp_sound * _s;
static char * _wavfile;


/********************
	Cdigo
*********************/

int SoundStartup(void)
{
	return(-1);
}


void SoundShutdown(void)
{
}


sp_sound * LoadSound(char * wavfile)
{
	_wavfile=wavfile;

	return(NULL);
}


void StartSound(sp_sound * s)
{
	_s=s;
}


void SetSound(sp_sound * s, int left, int right, int loop)
{
	_s=s;
	_i1=left;
	_i2=right;
	_i3=loop;
}


void ShutSound(sp_sound * s)
{
	_s=s;
}


#endif /* NO_SOUND */
