/*

	sp_play.h

	Space Plumber - Angel Ortega

*/

/* variables */

extern int _frames_per_sec;
extern int _avg_frames_per_sec;
extern int _max_frames_per_sec;
extern int _water_speed;
extern int _water_limit;
extern int _left_minutes;
extern int _left_seconds;
extern int _oxygen;
extern int _player_dead;
extern int _level_resolved;
extern int _last_level_resolved;
extern int _show_frames_per_sec;
extern int _num_pumps;
extern int _num_consoles;
extern int _random_seed;
extern int _alt_frame;
extern int _never_die;
extern int _no_timing;
extern int _broken_light;
extern int _float;
extern int _run;

extern char * _game_name;


/* tamaos del jugador */

#define PS_TOTAL	64		  /* tamao del cuerpo entero */
#define PS_HEAD 	8		  /* tamao de la cabeza */
#define PS_LEGS 	28		  /* tamao de las piernas */
#define PS_BODY 	PS_TOTAL-PS_LEGS  /* tamao del cuerpo */
#define PS_DEAD 	8		  /* tamao del ahogado */


/* velocidades */

#define PV_FORWARD	18		/* andando hacia adelante */
#define PV_BACK 	18		/* andando hacia atrs (10) */
#define PV_FAST_FWD	40		/* corriendo hacia adelante */
#define PV_FAST_BACK	40		/* corriendo hacia atrs (22) */
#define PV_FALL 	4		/* cayendo */
#define PV_WATER_FALL	1		/* hundindose */
#define PV_SWIM_FWD	8		/* nadando hacia adelante */
#define PV_SWIM_BACK	8		/* nadando hacia atrs */
#define PV_WATER_FWD	6		/* buceando hacia adelante */
#define PV_WATER_BACK	6		/* buceando hacia atrs */
#define PV_WATER_UP	1		/* nadando hacia arriba */
#define PV_WATER_DOWN	4		/* nadando hacia abajo */
#define PV_TURN 	18		/* giro 12 */
#define PV_FAST_TURN	40		/* giro rpido */
#define PV_LOOK 	10		/* mirar arriba/abajo */

/* externos */

extern sp_sound * _snd_left_step;
extern sp_sound * _snd_right_step;
extern sp_sound * _snd_wleft_step;
extern sp_sound * _snd_wright_step;
extern sp_sound * _snd_water;
extern sp_sound * _snd_underwater;
extern sp_sound * _snd_player_dead;
extern sp_sound * _snd_pump;
extern sp_sound * _snd_console;
extern sp_sound * _snd_water_go;


/* sonidos aleatorios */

struct rnd_sound
{
	int num;
	sp_sound * sounds[10];
};

extern struct rnd_sound _over_water_sounds;
extern struct rnd_sound _under_water_sounds;


/** prototipos **/

void LoadRandomSound(struct rnd_sound * q, char * sound);
void StartRandomSound(struct rnd_sound * q);

void SetMessage(char * msg_0, char * msg_1, char * msg_2, char * msg3,
	int seconds);

int  DrawNewFrame(void);
void Motion(int * x, int * y, int * z, int * a, int motion);
void TimeEvents(int y);
void Objects(void);

void PlayerStartup(void);
void PlayerShutdown(void);
