/*

	sp_param.c

	Proceso de parmetros.

	Space Plumber - Angel Ortega

*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "sp_types.h"
#include "sp_supp.h"
#include "sp_grx.h"
#include "sp_sb.h"
#include "sp_kbd.h"
#include "sp_ray.h"
#include "sp_map.h"
#include "sp_maze.h"
#include "sp_play.h"

extern int _menu;
extern int _custom;
extern int _intro;

struct int_param
{
	char * label;
	int * value;
};

struct string_param
{
	char * label;
	char * value;
};


/* parmetros enteros */
struct int_param int_params[]=
{
	"pack_extensions", &_pack_extensions,
	"use_logger", &_use_logger,
	"use_wait_retrace", &_use_wait_retrace,
	"no_sound", &_no_sound,
	"wanted_sample_frequency", &_wanted_sample_frequency,
	"low_detail", &_low_detail,
	"use_motion_blur", &_use_motion_blur,
	"use_gamma_correct", &_use_gamma_correct,
	"gc_level", &_gc_level,
	"show_frames_per_sec", &_show_frames_per_sec,
	"ambient_light", &_ambient_light,
	"water_speed", &_water_speed,
	"num_pumps", &_num_pumps,
	"num_consoles", &_num_consoles,
	"random_seed", &_random_seed,
	"maze_steps", &_maze_steps,
	"broken_light", &_broken_light,
	"area_num", &_area_num,
	"dump_maze", &_dump_maze,
	"never_die", &_never_die,
	"no_timing", &_no_timing,
	"menu", &_menu,
	"level", &_level,
	"custom", &_custom,
	"wave_water", &_wave_water,
	"log_to_stderr", &_log_to_stderr,
	"intro",&_intro,
	"no_joystick",&_no_joystick,
	"float",&_float,
	"run",&_run,
	"perspective_correct",&_perspective_correct,
	NULL, NULL
};


struct string_param string_params[]=
{
	"std_pack_file", _std_pack_file,
	"alt_pack_file", _alt_pack_file,
	"writable_dir", _writable_dir,
	"font_file", _font_file,
	"area_file", _area_file,
#ifdef UNIX_X11
	"x_display", _x_display_name,
	"display", _x_display_name,
#endif
	NULL, NULL
};


/* parmetros de main */
char _main_argv[500]="";


/********************
	Cdigo
*********************/

void _ParseParam(char * p)
/* interpreta una lnea de la forma variable=valor */
{
	char param[250];
	char * label;
	char * value;
	int ivalue;
	struct int_param * i;
	struct string_param * s;

	strcpy(param,p);

	label=strtok(param,"=");
	value=strtok(NULL,"");

	for(i=int_params;i->label!=NULL;i++)
	{
		if(strcmp(label,i->label)==0)
		{
			ivalue=atoi(value);
			*i->value=ivalue;

			return;
		}
	}

	for(s=string_params;s->label!=NULL;s++)
	{
		if(strcmp(label,s->label)==0)
		{
			strncpy(s->value,value,150);

			return;
		}
	}
}


void ParseParam(char * p)
/* interpreta un grupo de uno  ms parmetros */
{
	int goon;
	char * s;

	if(p==NULL)
		return;

	s=p;

	goon=1;
	for(;;)
	{
		/* busca una coma */
		while(*s!='\0' && *s!=',' && *s!=';')
			s++;

		if(*s=='\0')
			goon=0;
		else
			*s='\0';

		_ParseParam(p);

		if(!goon)
			break;

		s++;
		p=s;
	}		 
}


void ParseFile(char * file)
/* interpreta los parmetros de un fichero de configuracin */
{
	FILE * f;
	char lin[1024];

	if((f=fopen(file,"r"))==NULL)
		return;

	for(;;)
	{
		if(fgets(lin,sizeof(lin)-1,f)==NULL)
			break;

		if(lin[strlen(lin)-1]=='\n')
			lin[strlen(lin)-1]='\0';

		if(lin[strlen(lin)-1]=='\r')
			lin[strlen(lin)-1]='\0';

		if(lin[0]=='\0' || lin[0]==';' || lin[0]=='#')
			continue;

		ParseParam(lin);
	}

	fclose(f);
}


void ParseMain(int argc, char * argv[])
/* interpreta los parmetros de main */
{
	int n;

	_main_argv[0]='\0';

	for(n=1;n<argc;n++)
	{
		ParseParam(argv[n]);

		if(n!=1)
			strcat(_main_argv," ");

		strcat(_main_argv,argv[n]);
	}
}
