/*

	sp_kbd.c

	Teclado.

	Un poco catico. Debera estar diseado de una
	forma ms ordenada.

	Space Plumber - Angel Ortega

*/

#ifdef DJGPP
#include <pc.h>
#include <dpmi.h>
#include <string.h>
#endif

#ifdef LINUX_SVGALIB
#include <vgakeyboard.h>
#endif

#ifdef UNIX_X11
#include <X11/Xlib.h>
#include <X11/keysym.h>

/* estas definiciones estn en sp_grx */
extern Display * _x_display;
extern XEvent _x_event;

#endif

#include <stdlib.h>


/* scancodes de las teclas en uso */

#define SC_CRSRUP	0x48
#define SC_CRSRDN	0x50
#define SC_CRSRLF	0x4b
#define SC_CRSRRT	0x4d
#define SC_SHIFT	0x36
#define SC_LEFTSHIFT	0x2a
#define SC_ESCAPE	0x01
#define SC_D		0x20
#define SC_C		0x2e
#define SC_SPACE	0x39
#define SC_F1		0x3b
#define SC_F2		0x3c
#define SC_F3		0x3d
#define SC_F12		0x58
#define SC_ENTER	0x1c
#define SC_PAUSE	0x19
#define SC_1		0x02
#define SC_2		0x03
#define SC_3		0x04
#define SC_4		0x05
#define SC_5		0x06
#define SC_6		0x07
#define SC_7		0x08
#define SC_8		0x09
#define SC_9		0x0a
#define SC_0		0x0b
#define SC_BACKSPC	0x0e

/* en LINUX_SVGALIB estos scancodes son distintos
   Alguien lo entiende? */

#ifdef LINUX_SVGALIB
#define SC_PAGEDOWN	0x6d
#define SC_END		0x6b
#define SC_DEL		0x6f
#else
#define SC_PAGEDOWN	0x51
#define SC_END		0x4f
#define SC_DEL		0x53
#endif

#include "sp_types.h"
#include "sp_kbd.h"
#include "sp_grx.h"
#include "sp_ray.h"
#include "sp_play.h"

#ifdef DJGPP

/* vector de interrupcin */
#define KBD_INT 0x9

/* descriptores del vector nuevo y el viejo */
static _go32_dpmi_seginfo oldkbdisr;
static _go32_dpmi_seginfo kbdisr;

/* array de scan codes */
static int _scan_codes[128];

#define KEY_DOWN(sc) _scan_codes[sc]

unsigned char _last_scan_code;

#endif /* DJGPP */


#ifdef LINUX_SVGALIB
#define KEY_DOWN(sc) keyboard_keypressed(sc)
#endif /* LINUX_SVGALIB */


#ifdef UNIX_X11

/* se almacenan los scancodes igual */
static int _scan_codes[128];

#define KEY_DOWN(sc) _scan_codes[sc]

#endif /* ifdef UNIX_X11 */


#define KBD_SETBIT(sc,bit) if(KEY_DOWN(sc)) _kbd_actions|=bit

/* flags de acciones */
unsigned int _kbd_actions;

/* flag de cancelacin por parte del usuario */
int _user_cancel=0;

/* flag de pausa */
int _user_pause=0;

/* flag de pulsacin de ENTER */
int _user_enter=0;

static int kbd_installed=0;

/* ltimo nmero pulsado */
static int _last_num=-1;


/** joystick **/

/* joystick s/no */
int _no_joystick=0;

/* variables internas de control */
static int _joy_upper_x=0xffffffff;
static int _joy_lower_x=0xffffffff;
static int _joy_upper_y=0xffffffff;
static int _joy_lower_y=0xffffffff;
static int _joy_steer_x=0;
static int _joy_steer_y=0;

/* movimiento y botones del joystick */
int _joy_x=0;
int _joy_y=0;
int _joy_button_A=0;
int _joy_button_B=0;

/* umbrales de deteccin de movimiento
   (para eliminacin del ruido del joystick) */
#define JOY_THRESHOLD	2
#define JOY_MAX 	5


/********************
	Cdigo
*********************/

void _poll_joystick(void)
/* chequea los movimientos del joystick */
{
#ifdef DJGPP
	int _joy_poll_x,_joy_poll_y;
	unsigned char c;

	/* si no se quiere joystick o no hay, fuera */
	if(_no_joystick)
		return;

	_joy_poll_x=_joy_poll_y=0;

	/* fuerza el polling */
	outportb(0x201, 0);

	/* lee la respuesta */
	c=inportb(0x201);

	/* recoge informacin de los botones */
	_joy_button_A=!(c & 0x10);
	_joy_button_B=!(c & 0x20);

	while(_joy_poll_x<0x3000)
	{
		/* si ya est, fuera */
		if(!(c & 0x03))
			break;

		if(c & 0x01)
			_joy_poll_x++;
		if(c & 0x02)
			_joy_poll_y++;

		c=inportb(0x201);
	}

	/* timeout? desactivar joystick */
	if(_joy_poll_x==0x3000)
	{
		_no_joystick=1;

		return;
	}

	/* si es la primera vez, se autocalibra */
	if(_joy_upper_x==0xffffffff)
	{
		_joy_lower_x=(_joy_poll_x * 6)/10;
		_joy_upper_x=(_joy_poll_x * 13)/10;
		_joy_lower_y=(_joy_poll_y * 6)/10;
		_joy_upper_y=(_joy_poll_y * 13)/10;

		logger("JoyStartup",
			s_sprintf("joystick auto-calibration [%d-%d-%d],[%d-%d-%d]",
				_joy_lower_x,_joy_poll_x,_joy_upper_x,
				_joy_lower_y,_joy_poll_y,_joy_upper_y));
	}
	else
	{
		/* debido a que los joysticks son ruidosos
		   y no envan valores contiguos, las variables
		   _joy_steer_x y _joy_steer_y contienen
		   valores +/- segn el joystick *parece* que
		   se mueve hacia un lado. Si se supera
		   el valor JOY_THRESHOLD (es decir, cuando
		   se va hacia un lado u otro de forma contnua)
		   es cuando se activan las variables */

		if(_joy_poll_x < _joy_lower_x)
		{
			if(_joy_steer_x>-JOY_MAX)
				_joy_steer_x--;
		}
		else
		if(_joy_poll_x > _joy_upper_x)
		{
			if(_joy_steer_x<JOY_MAX)
				_joy_steer_x++;
		}
		else
		{
			if(_joy_steer_x<0)
				_joy_steer_x++;
			else
				_joy_steer_x--;
		}

		if(_joy_poll_y < _joy_lower_y)
		{
			if(_joy_steer_y>-JOY_MAX)
				_joy_steer_y--;
		}
		else
		if(_joy_poll_y > _joy_upper_y)
		{
			if(_joy_steer_y<JOY_MAX)
				_joy_steer_y++;
		}
		else
		{
			if(_joy_steer_y<0)
				_joy_steer_y++;
			else
				_joy_steer_y--;
		}

		/* si se superan los umbrales,
		   se activan las variables de giro */

		if(_joy_steer_x > JOY_THRESHOLD)
			_joy_x=1;
		else
		if(_joy_steer_x < -JOY_THRESHOLD)
			_joy_x=-1;
		else
			_joy_x=0;

		if(_joy_steer_y > JOY_THRESHOLD)
			_joy_y=1;
		else
		if(_joy_steer_y < -JOY_THRESHOLD)
			_joy_y=-1;
		else
			_joy_y=0;
	}

#endif /* ifdef DJGPP */
}


#ifdef UNIX_X11

void _x_key(void)
/* traduce un evento X-Window a una tecla */
{
	int k;
	int sc;

	while(XPending(_x_display))
	{
		XNextEvent(_x_display, &_x_event);

		if(_x_event.type==KeyPress || _x_event.type==KeyRelease)
		{
			k=XKeycodeToKeysym(_x_display,
				_x_event.xkey.keycode,0);

			switch(k)
			{
			case XK_Up: sc=SC_CRSRUP; break;
			case XK_Down: sc=SC_CRSRDN; break;
			case XK_Left: sc=SC_CRSRLF; break;
			case XK_Right: sc=SC_CRSRRT; break;

			/* en X11 se acelera pulsando Ctrl en lugar
			   de shift, porque cursor+shift mueve el
			   puntero del ratn (al menos en XFree86) */
			case XK_Control_L:
			case XK_Control_R: sc=SC_SHIFT; break;

			case XK_Escape: sc=SC_ESCAPE; break;

			case 100: sc=SC_D; break;
			case 99: sc=SC_C; break;
			case XK_space: sc=SC_SPACE; break;

			case XK_F1: sc=SC_F1; break;
			case XK_F2: sc=SC_F2; break;
			case XK_F3: sc=SC_F3; break;
			case XK_F12: sc=SC_F12; break;

			case XK_Return: sc=SC_ENTER; break;
			case 112: sc=SC_PAUSE; break;

			case XK_1: sc=SC_1; break;
			case XK_2: sc=SC_2; break;
			case XK_3: sc=SC_3; break;
			case XK_4: sc=SC_4; break;
			case XK_5: sc=SC_5; break;
			case XK_6: sc=SC_6; break;
			case XK_7: sc=SC_7; break;
			case XK_8: sc=SC_8; break;
			case XK_9: sc=SC_9; break;
			case XK_0: sc=SC_0; break;

			case XK_BackSpace: sc=SC_BACKSPC; break;

			case XK_Delete: sc=SC_DEL; break;
			case XK_End: sc=SC_END; break;
			case XK_Page_Down: sc=SC_PAGEDOWN; break;

			default: sc=0; break;
			}

			/* almacena el s/no */
			_scan_codes[sc]=(_x_event.type==KeyPress);
		}
	}
}

#endif /* ifdef UNIX_X11 */


static void key_toggle(int sc, int * var)
/* activa/desactiva la variable segn la pulsacin de sc */
{
	if(KEY_DOWN(sc))
	{
		if((*var)==0)
			(*var)=2;
		else
		if((*var)==1)
			(*var)=3;
	}
	else
	{
		if((*var)==2)
			(*var)=1;
		else
		if((*var)==3)
			(*var)=0;
	}
}


#ifdef DJGPP

static void KbdISR(void)
/* Nueva ISR del teclado */
{
	unsigned char k;
	unsigned char s;
	int release;

	/* lee la tecla */
	k=inportb(0x60);

	/* la marca como leda */
	s=inportb(0x61);
	outportb(0x61,s|0x80);
	outportb(0x61,s);

	if(k&0x80)
	{
		release=1;
		k&=0x7f;
	}
	else
		release=0;

	if(_last_scan_code==0x60 && k==SC_LEFTSHIFT)
		k=0;

	_scan_codes[k]=!release;

	_last_scan_code=k;

	outportb(0x20,0x20);
}
#endif


void KbdPoll(void)
/* chequea el teclado */
{
#ifdef LINUX_SVGALIB
	keyboard_update();
#endif

#ifdef UNIX_X11
	_x_key();
#endif

	_user_cancel=KEY_DOWN(SC_ESCAPE);
	_user_enter=KEY_DOWN(SC_ENTER);

	_kbd_actions=0;

	/* acciones */

	KBD_SETBIT(SC_CRSRUP,ACT_FORWARD);
	KBD_SETBIT(SC_CRSRDN,ACT_BACK);
	KBD_SETBIT(SC_CRSRLF,ACT_LEFT);
	KBD_SETBIT(SC_CRSRRT,ACT_RIGHT);
	KBD_SETBIT(SC_SHIFT,ACT_FAST);
	KBD_SETBIT(SC_LEFTSHIFT,ACT_FAST);
	KBD_SETBIT(SC_D,ACT_UP);
	KBD_SETBIT(SC_SPACE,ACT_UP);
	KBD_SETBIT(SC_C,ACT_DOWN);
	KBD_SETBIT(SC_PAGEDOWN,ACT_LOOKUP);
	KBD_SETBIT(SC_DEL,ACT_LOOKDOWN);

	if(KEY_DOWN(SC_END))
		_vertical_bias=0;

	/* variables activadas/desactivadas */

	key_toggle(SC_F1,&_low_detail);
	key_toggle(SC_F2,&_use_gamma_correct);
	key_toggle(SC_F3,&_use_motion_blur);

	/* variables no documentadas */

	key_toggle(SC_F12,&_show_frames_per_sec);

	/* pausa */

	key_toggle(SC_PAUSE,&_user_pause);

	/* joystick */

	_poll_joystick();

	if(_joy_button_A) _kbd_actions|=ACT_FAST;
	if(_joy_button_B) _kbd_actions|=ACT_UP;

	if(_joy_x==-1) _kbd_actions|=ACT_LEFT;
	if(_joy_x==1) _kbd_actions|=ACT_RIGHT;
	if(_joy_y==-1) _kbd_actions|=ACT_FORWARD;
	if(_joy_y==1) _kbd_actions|=ACT_BACK;
}


void KbdGetNumber(char * str, int max)
/* pide por teclado una cadena numrica, menor que max */
{
	int n;
	char str_num[15];
	int val;

	KbdPoll();

	if(KEY_DOWN(SC_BACKSPC))
		*str='\0';

	/* si la cadena est vaca, se inicializa */
	if(*str=='\0')
		_last_num=-1;

	/* busca cul de los scancodes est pulsado */
	for(n=SC_1;n<=SC_0;n++)
	{
		if(KEY_DOWN(n))
			break;
	}

	/* no hay nada pulsado */
	if(n>SC_0)
	{
		_last_num=-1;
		return;
	}

	/* lo convierte en el nmero */
	n-=(SC_1-1);

	if(n==10)
		n=0;

	/* controla si ya est pulsado de antes */
	if(n==_last_num)
		return;

	/* lo guarda */
	_last_num=n;

	val=(atoi(str)*10)+n;

	/* si no se pasa, se aade */
	if(val<=max)
	{
		sprintf(str_num,"%1d",n);
		strcat(str,str_num);
	}
}


void KbdShutdown(void)
/* desactiva el control de teclado */
{
	if(!kbd_installed)
		return;

#ifdef DJGPP
	_go32_dpmi_set_protected_mode_interrupt_vector(KBD_INT,&oldkbdisr);
#endif

#ifdef LINUX_SVGALIB
	keyboard_close();
#endif

	kbd_installed=0;
}


void KbdStartup(void)
/* instala el control del teclado */
{
	if(kbd_installed)
		return;

#ifdef DJGPP
	_go32_dpmi_get_protected_mode_interrupt_vector(KBD_INT,&oldkbdisr);

	kbdisr.pm_offset=(int) KbdISR;
	_go32_dpmi_allocate_iret_wrapper(&kbdisr);

	_go32_dpmi_set_protected_mode_interrupt_vector(KBD_INT,&kbdisr);

	_kbd_actions=0;
	_last_scan_code=0;

	memset(_scan_codes,'\0',sizeof(_scan_codes));

	_poll_joystick();

#endif

#ifdef LINUX_SVGALIB
	keyboard_init();

	keyboard_translatekeys(TRANSLATE_CURSORKEYS);
#endif

	kbd_installed=1;

	atexit(KbdShutdown);
}
