/*

	sp_grx.h

	Space Plumber - Angel Ortega

*/


/* externas */

extern int _use_wait_retrace;

extern sp_texture * _original_water_texture;
extern sp_texture * _water_texture;

extern sp_palette * _normal_palette;
extern sp_palette * _water_palette;

extern sp_palette * _gc_normal_palette;
extern sp_palette * _gc_water_palette;

extern int _use_gamma_correct;
extern int _gc_level;

extern char * _virtual_screen;
extern char * _water_virtual_screen;

extern void (* DrawMask)(char *);

extern char _font_file[];

#ifdef UNIX_X11
extern char _x_display_name[];
#endif


/* prototipos */

void SetGraphMode(void);
void SetTextMode(void);

void	     SetPalette  (sp_palette * pal);
void	     InvalidPalette(void);
sp_palette * LoadPalette (char * palfile);
sp_palette * WaterPalette(sp_palette * orgpal);
sp_palette * BrightPalette(sp_palette * orgpal, int factor);

sp_texture * LoadTexture (char * pcxfile);
void	     LoadPcx	 (char * pcx,char * pcxfile,int size);
void	     LoadScreen  (char * screen,char * pcxfile);

void DumpScreen 	   (char * screen);
void CleanVirtualScreen    (void);
void DrawVirtualScreen	   (void);
void DrawWaterVirtualScreen(void);

void WaveWaterTexture(void);

void LoadFont(char * filename);
void PrintString(unsigned char * screen, int x, int y,
	unsigned char color, unsigned char * string);

void GrxStartup(void);
