// world3.cc

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#define USECOLOR false
#define COLORA RGB_to_Pixel(63484,0,4);                   //   color of wings
#define COLORB RGB_to_Pixel(0,1024,44444); 
#define COLORC RGB_to_Pixel(1024,13256,24587); 
#define COLORD RGB_to_Pixel(56484,12456,3276); 
#define COLORE RGB_to_Pixel(4091,0,32732); 
#define COLORSHOT RGB_to_Pixel(63484,0,0);           // color of shots
#define CONTAINER_COLOR ((Pixel )rand() | 31); // color of container
#define TRANSPORTER_COLOR RGB_to_Pixel(65535,0,0); // color of transporter
#define EFCOLOR ((Pixel )rand() | 31);

#define SHOOT_CYCLE_INIT 10
#define BACKFACE true // do not change

#define FRIEND_POWER1 100
#define FRIEND_POWER2 100
#define ENEMY_POWER1 30
#define ENEMY_POWER2 20
#define EFIGHTER_MASS 50
#define AFIGHTER_MASS 50
#define MINE_POWER 1
#define MINE_MASS 20
#define CONTAINER_POWER 10
#define CONTAINER_MASS 20
#define TRANSPORTER_POWER 200
#define TRANSPORTER_MASS 1000

/*=================================
 *    Targets
 *================================*/
Regex targetA("A.*");
Regex targetB("B.*");
Regex targetBF("BF.*");
Regex targetBM("BM.*");

/*=================================
 *    Cockpits
 *================================*/

#ifdef HICOLOR
  #define BLEND_OUT 29618  // this value is the color which should be treated as transparent
#else
  #define BLEND_OUT 105  // this value is the color which should be treated as transparent
#endif

Cockpit cockpit1("textures/cockpit",BLEND_OUT);

cockpit1.friends=&targetA;
cockpit1.not_moving_enemies=&targetBM;


//Cockpit cockpit2("cockpit",BLEND_OUT); 
  
#ifdef COCKPIT_IN_MEMORY

cockpit1.keep_in_memory=true;
//cockpit2.keep_in_memory=true;
#endif

/*============================================
 *    explosions
 *===========================================*/


/*=============================================
 *    explosion of efighters objects
 *============================================*/
Object * efexplos=new Object;
efexplos->facing=true;
efexplos->size_type=1;
efexplos->shape=new BSP_Tree;  
efexplos->solid=false;
efexplos->power=0;
efexplos->radius=0; 
efexplos->velocity.init(0,0,0);

Point ex1(0, -5,-5);
Point ex2(0,  5,-5);
Point ex3(0, 5, 5);
Point ex4(0, -5,5);

Point exa1(0, -1,5);
Point exa2(0, -5,0);
Point exa3(0, -2.5,-5);
Point exa4(0, 4.5,-3.8);
Point exa5(0, 5,0);
Point exa6(0, 2,5);


// Texture-Koordinate Vectors
Point exr,exu;
exr.adjust(ex1,ex2,128);
exu.adjust(ex1,ex4,128);

Mipmap ex;
ex.load("textures/expl");

// Polygons

MPolygon pex(exa1,exa2,exa3,exa4,exa5,exa6); 
pex.set_signature("pex");
pex.attach_mipmap(ex,ex1,exr,exu);
pex.backface=false;
efexplos->registrate(&pex);

Pilot explos_pilot;
efexplos->attach_pilot(explos_pilot);
efexplos->build();

/*===============================================
    explosion of afighters
 =============================================*/

Object * afexplos=new Object(efexplos);
afexplos->attach_pilot(explos_pilot);


/*===============================================
    explosion of container
 =============================================*/

Object * cexplos=new Object(efexplos);
cexplos->attach_pilot(explos_pilot);

/*===============================================
    explosion of transporter
 =============================================*/
Object * texplos=new Object;
texplos->facing=true;
texplos->size_type=1;
texplos->shape=new BSP_Tree;  
texplos->solid=false;
texplos->power=0;
texplos->radius=0; 
texplos->velocity.init(0,0,0);

Point tex1(0, -15,-15);
Point tex2(0,  15,-15);
Point tex3(0, 15, 15);
Point tex4(0, -15,15);

Point texa1(0, -3,15);
Point texa2(0, -15,0);
Point texa3(0, -7.5,-15);
Point texa4(0, 13.5,-11.4);
Point texa5(0, 15,0);
Point texa6(0, 6,15);


// Texture-Koordinate Vectors
Point texr,texu;
texr.adjust(tex1,tex2,128);
texu.adjust(tex1,tex4,128);


// Polygon
MPolygon tex(texa1,texa2,texa3,texa4,texa5,texa6); 
tex.set_signature("tex");
tex.attach_mipmap(ex,tex1,texr,texu);
tex.backface=false;
texplos->registrate(&tex);
texplos->attach_pilot(explos_pilot);
texplos->build();

/*===============================================
    explosion of mine
 =============================================*/

Object * mexplos=new Object(efexplos);
mexplos->attach_pilot(explos_pilot);

/*===============================================
    explosion of shots
 =============================================*/
Object * sexplos=new Object;
sexplos->facing=true;
sexplos->size_type=1;
sexplos->shape=new BSP_Tree;  
sexplos->solid=false;
sexplos->power=0;
sexplos->radius=0; 
sexplos->velocity.init(0,0,0);

Point exn1(0, -0.5,-0.5);
Point exn2(0,  0.5,-0.5);
Point exn3(0, 0.5, 0.5);
Point exn4(0, -0.5,0.5);

Point exan1(0, -0.1,0.5);
Point exan2(0, -0.5,0);
Point exan3(0, -0.25,-0.5);
Point exan4(0, 0.45,-0.38);
Point exan5(0, 0.5,0);
Point exan6(0, 0.2,0.5);


/// Texture-Koordinate Vectors
Point exnr,exnu;
exnr.adjust(exn1,exn2,128);
exnu.adjust(exn1,exn4,128);

// Polygons
MPolygon pexn(exan1,exan2,exan3,exan4,exan5,exan6); 
pexn.set_signature("pexn");
pexn.attach_mipmap(ex,exn1,exnr,exnu);
pexn.backface=false;
sexplos->registrate(&pexn);

sexplos->attach_pilot(explos_pilot);
sexplos->build();



//==============================================




/*==============================================
    shots
===============================================*/
#define NR_OF_SHOTS 16

// shot  0 for mines
// shots 1....7 for afighters,
// shots 8....NR_OF_SHOTS-1 for efighters,

/// shot
Object * shot[NR_OF_SHOTS];
shot[0]=new Object; 
shot[0]->size_type=1;
shot[0]->shape=new BSP_Tree;  
shot[0]->radius=0.01; 
shot[0]->solid=false;

double shot_height=1;
double shot_width=1;

Point ps1(-2.5,-0.1,0);
Point ps2(0, 0,0);
Point ps3(-2.5,0.1,0);

// Polygons

Polygon wshot(ps1,ps2,ps3); 
wshot.set_signature("wshot");
wshot.backface=false;
wshot.color=COLORSHOT;
shot[0]->registrate(&wshot);

Shot_Pilot shot_pilot;
shot[0]->attach_pilot(shot_pilot);
shot[0]->attach_explosion(*sexplos);
shot[0]->build();


// create all the other shots
for (int i=1; 
 i<NR_OF_SHOTS; 
 i++) {
  shot[i]=new Object(shot[0]); 
};



/*==========================================
   afighter
==========================================*/

// afighter  number 1
Object * afighter1=new Object; 
afighter1->size_type=1;
afighter1->shape=new BSP_Tree;  
afighter1->velocity.init(0,0,0);
afighter1->view.O.init(-27.206,-45.607,-119.172); // -344
afighter1->view.Xv.init(0.947285,0.0439445,0.317365);
afighter1->view.Yv.init(0.224863,-0.796796,-0.56085);
afighter1->view.Zv.init(0.228229,0.602648,-0.764675);
//afighter1->radius=1.0;
MConsole_Pilot afpilot1; 
String targetC("AT");
afpilot1.set_target(&targetC);
afighter1->attach_pilot(afpilot1);
afighter1->attach_explosion(*afexplos);
afighter1->shoot_cycle_init=SHOOT_CYCLE_INIT;
afighter1->power=FRIEND_POWER1;
afighter1->mass=AFIGHTER_MASS;
afighter1->id=new String("AF1");
afighter1->attach_cockpit(cockpit1);
afighter1->cid=new Regex("AF1S");
/// attach these shots to afighter1
for (int i=1; i<8; i++)
    afighter1->attach_shot(*shot[i]);
    

// right wing bottom 
Point sp1(-2.5, 0,0.25);
Point sp2(-1.5,0,0.5);
Point sp3(-1.5,0.25,0.75);
Point sp4(-2.0,0,0.75);
Point sp5(-1.0  , 0, 1.0);
Point sp6(-0,0.35,0.125);
Point sp7(1.5 ,0,0.25);
Point sp8(-1.0,0,0.25);

// right wing top 
Point sp3_u(-1.5,-0.25,0.75);
Point sp6_u(-0,-0.35,0.125);

// left wing bottom 
Point sp1_l(-2.5,0,-0.25);
Point sp2_l(-1.5,0,-0.5);
Point sp3_l(-1.5,0.25,-0.75);
Point sp4_l(-2.0,0,-0.75);
Point sp5_l(-1.0,0,-1.0);
Point sp6_l(0,0.35,-0.125);
Point sp7_l(1.5,0,-0.25);
Point sp8_l(-1.0,0,-0.25);

// left wing top 
Point sp3_l_u(-1.5,-0.25,-0.75);
Point sp6_l_u(0,-0.35,-0.125);

// body top 
Point sp9  (-1.35,-0.3, 0);
Point sp10 ( 1.5,  0  , 0);
Point sp9_u(-1.35, 0.3, 0);


// Polygons

// right wing bottom 

Polygon spp1(sp3,sp2,sp1); 
spp1.set_signature("spp1");
spp1.color=EFCOLOR;
spp1.backface=BACKFACE;
afighter1->registrate(&spp1);

Polygon spp2(sp4,sp3,sp1); 
spp2.set_signature("spp2");
spp2.color=EFCOLOR;
spp2.backface=BACKFACE;
afighter1->registrate(&spp2);

Polygon spp3(sp3,sp4,sp5); 
spp3.set_signature("spp3");
spp3.color=EFCOLOR;
spp3.backface=BACKFACE;
afighter1->registrate(&spp3);

Polygon spp4(sp6,sp3,sp5); 
spp4.set_signature("spp4");
spp4.color=EFCOLOR;
spp4.backface=BACKFACE;
afighter1->registrate(&spp4);

Polygon spp5(sp7,sp6,sp5); 
spp5.set_signature("spp5");
spp5.color=EFCOLOR;
spp5.backface=BACKFACE;
afighter1->registrate(&spp5);

Polygon spp6(sp2,sp3,sp8); 
spp6.set_signature("spp6");
spp6.color=EFCOLOR;
spp6.backface=BACKFACE;
afighter1->registrate(&spp6);

Polygon spp7(sp6,sp8,sp3); 
spp7.set_signature("spp7");
spp7.color=EFCOLOR;
spp7.backface=BACKFACE;
afighter1->registrate(&spp7);


// right wing top 
Polygon spp8(sp1,sp2,sp3_u); 
spp8.set_signature("spp8");
spp8.color=EFCOLOR;
spp8.backface=BACKFACE;
afighter1->registrate(&spp8);

Polygon spp9(sp1,sp3_u,sp4); 
spp9.set_signature("spp9");
spp9.color=EFCOLOR;
spp9.backface=BACKFACE;
afighter1->registrate(&spp9);

Polygon spp10(sp5,sp4,sp3_u); 
spp10.set_signature("spp10");
spp10.color=EFCOLOR;
spp10.backface=BACKFACE;
afighter1->registrate(&spp10);

Polygon spp11(sp5,sp3_u,sp6_u); 
spp11.set_signature("spp11");
spp11.color=EFCOLOR;
spp11.backface=BACKFACE;
afighter1->registrate(&spp11);

Polygon spp12(sp5,sp6_u,sp7); 
spp12.set_signature("spp12");
spp12.color=EFCOLOR;
spp12.backface=BACKFACE;
afighter1->registrate(&spp12);

Polygon spp13(sp8,sp3_u,sp2); 
spp13.set_signature("spp13");
spp13.color=EFCOLOR;
spp13.backface=BACKFACE;
afighter1->registrate(&spp13);

Polygon spp14(sp3_u,sp8,sp6_u); 
spp14.set_signature("spp14");
spp14.color=EFCOLOR;
spp14.backface=BACKFACE;
afighter1->registrate(&spp14);

// left wing bottom 

Polygon spp15(sp1_l,sp2_l,sp3_l); 
spp15.set_signature("spp15");
spp15.color=EFCOLOR;
spp15.backface=BACKFACE;
afighter1->registrate(&spp15);

Polygon spp16(sp1_l,sp3_l,sp4_l); 
spp16.set_signature("spp16");
spp16.color=EFCOLOR;
spp16.backface=BACKFACE;
afighter1->registrate(&spp16);

Polygon spp17(sp5_l,sp4_l,sp3_l); 
spp17.set_signature("spp17");
spp17.color=EFCOLOR;
spp17.backface=BACKFACE;
afighter1->registrate(&spp17);

Polygon spp18(sp5_l,sp3_l,sp6_l); 
spp18.set_signature("spp18");
spp18.color=EFCOLOR;
spp18.backface=BACKFACE;
afighter1->registrate(&spp18);

Polygon spp19(sp5_l,sp6_l,sp7_l); 
spp19.set_signature("spp19");
spp19.color=EFCOLOR;
spp19.backface=BACKFACE;
afighter1->registrate(&spp19);

Polygon spp20(sp8_l,sp3_l,sp2_l); 
spp20.set_signature("spp20");
spp20.color=EFCOLOR;
spp20.backface=BACKFACE;
afighter1->registrate(&spp20);

Polygon spp21(sp3_l,sp8_l,sp6_l); 
spp21.set_signature("spp21");
spp21.color=EFCOLOR;
spp21.backface=BACKFACE;
afighter1->registrate(&spp21);

// left wing top 

Polygon spp22(sp3_l_u,sp2_l,sp1_l); 
spp22.set_signature("spp22");
spp22.color=EFCOLOR;
spp22.backface=BACKFACE;
afighter1->registrate(&spp22);

Polygon spp23(sp4_l,sp3_l_u,sp1_l); 
spp23.set_signature("spp23");
spp23.color=EFCOLOR;
spp23.backface=BACKFACE;
afighter1->registrate(&spp23);

Polygon spp24(sp3_l_u,sp4_l,sp5_l); 
spp24.set_signature("spp24");
spp24.color=EFCOLOR;
spp24.backface=BACKFACE;
afighter1->registrate(&spp24);

Polygon spp25(sp6_l_u,sp3_l_u,sp5_l); 
spp25.set_signature("spp25");
spp25.color=EFCOLOR;
spp25.backface=BACKFACE;
afighter1->registrate(&spp25);

Polygon spp26(sp7_l,sp6_l_u,sp5_l); 
spp26.set_signature("spp26");
spp26.color=EFCOLOR;
spp26.backface=BACKFACE;
afighter1->registrate(&spp26);

Polygon spp27(sp2_l,sp3_l_u,sp8_l); 
spp27.set_signature("spp27");
spp27.color=EFCOLOR;
spp27.backface=BACKFACE;
afighter1->registrate(&spp27);

Polygon spp28(sp6_l_u,sp8_l,sp3_l_u); 
spp28.set_signature("spp28");
spp28.color=EFCOLOR;
spp28.backface=BACKFACE;
afighter1->registrate(&spp28);


// body top 

Polygon spp29(sp9,sp6_u,sp8); 
spp29.set_signature("spp29");
spp29.color=EFCOLOR;
spp29.backface=BACKFACE;
afighter1->registrate(&spp29);

Polygon spp30(sp8_l,sp6_l_u,sp9); 
spp30.set_signature("spp30");
spp30.color=EFCOLOR;
spp30.backface=BACKFACE;
afighter1->registrate(&spp30);

Polygon spp31(sp6_l_u,sp6_u,sp9); 
spp31.set_signature("spp31");
spp31.color=EFCOLOR;
spp31.backface=BACKFACE;
afighter1->registrate(&spp31);

Polygon spp32(sp10,sp7,sp6_u); 
spp32.set_signature("spp32");
spp32.color=EFCOLOR;
spp32.backface=BACKFACE;
afighter1->registrate(&spp32);

Polygon spp33(sp6_l_u,sp7_l,sp10); 
spp33.set_signature("spp33");
spp33.color=EFCOLOR;
spp33.backface=BACKFACE;
afighter1->registrate(&spp33);

Polygon spp34(sp10,sp6_u,sp6_l_u); 
spp34.set_signature("spp34");
spp34.color=EFCOLOR;
spp34.backface=BACKFACE;
afighter1->registrate(&spp34);

Polygon spp35(sp8,sp6,sp9_u); 
spp35.set_signature("spp35");
spp35.color=EFCOLOR;
spp35.backface=BACKFACE;
afighter1->registrate(&spp35);

Polygon spp36(sp9_u,sp6_l,sp8_l); 
spp36.set_signature("spp36");
spp36.color=EFCOLOR;
spp36.backface=BACKFACE;
afighter1->registrate(&spp36);

Polygon spp37(sp9_u,sp6,sp6_l); 
spp37.set_signature("spp37");
spp37.color=EFCOLOR;
spp37.backface=BACKFACE;
afighter1->registrate(&spp37);

Polygon spp38(sp6,sp7,sp10); 
spp38.set_signature("spp38");
spp38.color=EFCOLOR;
spp38.backface=BACKFACE;
afighter1->registrate(&spp38);

Polygon spp39(sp10,sp7_l,sp6_l); 
spp39.set_signature("spp39");
spp39.color=EFCOLOR;
spp39.backface=BACKFACE;
afighter1->registrate(&spp39);

Polygon spp40(sp6_l,sp6,sp10); 
spp40.set_signature("spp40");
spp40.color=EFCOLOR;
spp40.backface=BACKFACE;
afighter1->registrate(&spp40);


// engine
Polygon spp41(sp9_u,sp9,sp8); 
spp41.set_signature("spp41");
spp41.color=0;
spp41.backface=BACKFACE;
afighter1->registrate(&spp41);

Polygon spp42(sp8_l,sp9,sp9_u); 
spp42.set_signature("spp42");
spp42.color=0;
spp42.backface=BACKFACE;
afighter1->registrate(&spp42);

afighter1->build();


//=================================================

// afighter2
Object * afighter2=new Object(afighter1);
afighter2->size_type=1;
afighter2->power=FRIEND_POWER2;
afighter2->velocity.init(0,0,0);
afighter2->view.O.init(46.690888,-20.699907,40.095932);
afighter2->id=new String("AF2");


CPilot afpilot2;
ManeuverA manA;
afpilot2.add(manA);
ManeuverB manB;
afpilot2.add(manB);
ManeuverC manC;
afpilot2.add(manC);
//Basic_CPilot afpilot2;
afpilot2.set_targets(&targetBF);
afighter2->attach_pilot(afpilot2);
afighter2->attach_cockpit(cockpit1);
afighter2->cid=new Regex("AF2S");


//===========================================



/*==========================================
   efighters
==========================================*/

// efighter number 1
Object * efighter1=new Object; 
efighter1->size_type=2;
efighter1->shape=new BSP_Tree;  
efighter1->velocity.init(0,0,0);
efighter1->view.O.init(144.166670,-2.789568,-0.557033);
Basic_CPilot efpilot1; 
efpilot1.set_targets(&targetA);
efighter1->attach_pilot(efpilot1);
efighter1->attach_cockpit(cockpit1);
efighter1->attach_explosion(*efexplos);
efighter1->shoot_cycle_init=SHOOT_CYCLE_INIT;
efighter1->power=ENEMY_POWER1;
efighter1->mass=EFIGHTER_MASS;
efighter1->id=new String("BF1");
efighter1->cid=new Regex("BF1S");
/// attach these shots to efighter1
for (int i=8; i<NR_OF_SHOTS; i++)
    efighter1->attach_shot(*shot[i]);
    
double l0=3;
double b0=3;
double h0=2.5;
double l1=0.3;
double l2=0.8;
double l3=0.1;
double l4=0.9;
double l5=0.7*l2;
double b1=0.05;
double b2=0.3;
double b3=0.4;
double b4=0.5;
double h1=0.1;
double h2=b4;
double h3=0.03*h0;
double h4=0.09*h0;
double mr1=0.05*b0;
double mr2=0.13*b0;

Point lw_t1(-l0*0.5,-h1*h0,-b0*0.5);
Point lw_t2(  l0*0.5,-h1*h0,-b0*0.5);
Point lw_t3(  l0*0.5,   h1*h0,-b0*0.5);
Point lw_t4(-l0*0.5,   h1*h0,-b0*0.5);

Point sp(0,0,b1*b0);

Point lw_b1=lw_t1+sp;
Point lw_b2=lw_t2+sp;
Point lw_b3=lw_t3+sp;
Point lw_b4=lw_t4+sp;

Point lw_1(-l1*l0,-h0*0.5,-b0*0.5+b2*b0);
Point lw_2(   l1*l0,-h0*0.5,-b0*0.5+b2*b0);
Point lw_3(  l1*l0,   h0*0.5,-b0*0.5+b2*b0);
Point lw_4(-l1*l0,   h0*0.5,-b0*0.5+b2*b0);

// Texture-Koordinate Vectors
Point tx,ty,tz;
tx.adjust(lw_t1,lw_t2,128);
ty.adjust(lw_t1,lw_t4,128);
tz.adjust(lw_t1,lw_b1,128);

// textures
Mipmap t1;
t1.load("textures/stone1");
Mipmap t2;
t2.load("textures/stone4");
Mipmap t3;
t3.load("textures/stone7");

// Polygons

// lw
MPolygon lw1(lw_t4,lw_t3,lw_t2,lw_t1); 
lw1.set_signature("lw1");
lw1.attach_mipmap(t3,lw_t1,tx,ty);
lw1.color=COLORA;
lw1.usecolor=USECOLOR;
efighter1->registrate(&lw1);

MPolygon lw2(lw_b1,lw_b2,lw_b3,lw_b4); 
lw2.set_signature("lw2");
lw2.attach_mipmap(t2,lw_b1,tx,ty);
lw2.color=COLORA;
lw2.usecolor=USECOLOR;
efighter1->registrate(&lw2);

MPolygon lw3(lw_t1,lw_t2,lw_2,lw_1); 
lw3.set_signature("lw3");
lw3.attach_mipmap(t3,lw_t1,tx,ty);
lw3.color=COLORA;
lw3.usecolor=USECOLOR;
efighter1->registrate(&lw3);

MPolygon lw4(lw_1,lw_2,lw_b2,lw_b1); 
lw4.set_signature("lw4");
lw4.attach_mipmap(t3,lw_b1,tx,ty);
lw4.color=COLORA;
lw4.usecolor=USECOLOR;
efighter1->registrate(&lw4);

MPolygon lw5(lw_4,lw_3,lw_t3,lw_t4); 
lw5.set_signature("lw5");
lw5.attach_mipmap(t3,lw_t1,tx,ty);
lw5.color=COLORA;
lw5.usecolor=USECOLOR;
efighter1->registrate(&lw5);

MPolygon lw6(lw_b4,lw_b3,lw_3,lw_4); 
lw6.set_signature("lw6");
lw6.attach_mipmap(t3,lw_b1,tx,ty);
lw6.color=COLORA;
lw6.usecolor=USECOLOR;
efighter1->registrate(&lw6);

MPolygon lw7(lw_b1,lw_b4,lw_t4,lw_t1); 
lw7.set_signature("lw7");
lw7.attach_mipmap(t3,lw_b1,ty,tz);
lw7.color=COLORA;
lw7.usecolor=USECOLOR;
efighter1->registrate(&lw7);

MPolygon lw8(lw_t2,lw_t3,lw_b3,lw_b2); 
lw8.set_signature("lw8");
lw8.attach_mipmap(t3,lw_b2,ty,tz);
lw8.color=COLORA;
lw8.usecolor=USECOLOR;
efighter1->registrate(&lw8);

MPolygon lw9(lw_t1,lw_1,lw_b1); 
lw9.set_signature("lw9");
lw9.attach_mipmap(t1,lw_b1,ty,tz);
lw9.color=COLORA;
lw9.usecolor=USECOLOR;
efighter1->registrate(&lw9);

MPolygon lw10(lw_b2,lw_2,lw_t2); 
lw10.set_signature("lw10");
lw10.attach_mipmap(t1,lw_b2,ty,tz);
lw10.color=COLORA;
lw10.usecolor=USECOLOR;
efighter1->registrate(&lw10);

MPolygon lw11(lw_b4,lw_4,lw_t4); 
lw11.set_signature("lw11");
lw11.attach_mipmap(t1,lw_b4,ty,tz);
lw11.color=COLORA;
lw11.usecolor=USECOLOR;
efighter1->registrate(&lw11);

MPolygon lw12(lw_t3,lw_3,lw_b3); 
lw12.set_signature("lw12");
lw12.attach_mipmap(t1,lw_b3,ty,tz);
lw12.color=COLORA;
lw12.usecolor=USECOLOR;
efighter1->registrate(&lw12);

sp.init(0,0,b0);

Point rw_t1=lw_t1+sp;
Point rw_t2=lw_t2+sp;
Point rw_t3=lw_t3+sp;
Point rw_t4=lw_t4+sp;

sp.init(0,0,-b1*b0);

Point rw_b1=rw_t1+sp;
Point rw_b2=rw_t2+sp;
Point rw_b3=rw_t3+sp;
Point rw_b4=rw_t4+sp;

sp.init(0,0,b0-2*b2*b0);

Point rw_1=lw_1+sp;
Point rw_2=lw_2+sp;
Point rw_3=lw_3+sp;
Point rw_4=lw_4+sp;

// Polygons

/// rw
MPolygon rw1(rw_t1,rw_t2,rw_t3,rw_t4); 
rw1.set_signature("rw1");
rw1.attach_mipmap(t1,rw_t1,tx,ty);
rw1.color=COLORA;
rw1.usecolor=USECOLOR;
efighter1->registrate(&rw1);

MPolygon rw2(rw_b4,rw_b3,rw_b2,rw_b1); 
rw2.set_signature("rw2");
rw2.attach_mipmap(t2,rw_b1,tx,ty);
rw2.color=COLORA;
rw2.usecolor=USECOLOR;
efighter1->registrate(&rw2);

MPolygon rw3(rw_1,rw_2,rw_t2,rw_t1); 
rw3.set_signature("rw3");
rw3.attach_mipmap(t3,rw_t1,tx,ty);
rw3.color=COLORA;
rw3.usecolor=USECOLOR;
efighter1->registrate(&rw3);

MPolygon rw4(rw_b1,rw_b2,rw_2,rw_1); 
rw4.set_signature("rw4");
rw4.attach_mipmap(t3,rw_b1,tx,ty);
rw4.color=COLORA;
rw4.usecolor=USECOLOR;
efighter1->registrate(&rw4);

MPolygon rw5(rw_t4,rw_t3,rw_3,rw_4); 
rw5.set_signature("rw5");
rw5.attach_mipmap(t3,rw_t1,tx,ty);
rw5.color=COLORA;
rw5.usecolor=USECOLOR;
efighter1->registrate(&rw5);

MPolygon rw6(rw_4,rw_3,rw_b3,rw_b4); 
rw6.set_signature("rw6");
rw6.attach_mipmap(t3,rw_b1,tx,ty);
rw6.color=COLORA;
rw6.usecolor=USECOLOR;
efighter1->registrate(&rw6);

MPolygon rw7(rw_t1,rw_t4,rw_b4,rw_b1); 
rw7.set_signature("rw7");
rw7.attach_mipmap(t3,rw_b1,ty,tz);
rw7.color=COLORA;
rw7.usecolor=USECOLOR;
efighter1->registrate(&rw7);

MPolygon rw8(rw_b2,rw_b3,rw_t3,rw_t2); 
rw8.set_signature("rw8");
rw8.attach_mipmap(t3,rw_b2,ty,tz);
rw8.color=COLORA;
rw8.usecolor=USECOLOR;
efighter1->registrate(&rw8);

MPolygon rw9(rw_b1,rw_1,rw_t1); 
rw9.set_signature("rw9");
rw9.attach_mipmap(t1,rw_b1,ty,tz);
rw9.color=COLORA;
rw9.usecolor=USECOLOR;
efighter1->registrate(&rw9);

MPolygon rw10(rw_t2,rw_2,rw_b2); 
rw10.set_signature("rw10");
rw10.attach_mipmap(t1,rw_b2,ty,tz);
rw10.color=COLORA;
rw10.usecolor=USECOLOR;
efighter1->registrate(&rw10);

MPolygon rw11(rw_t4,rw_4,rw_b4); 
rw11.set_signature("rw11");
rw11.attach_mipmap(t1,rw_b4,ty,tz);
rw11.color=COLORA;
rw11.usecolor=USECOLOR;
efighter1->registrate(&rw11);

MPolygon rw12(rw_b3,rw_3,rw_t3); 
rw12.set_signature("rw12");
rw12.attach_mipmap(t1,rw_b3,ty,tz);
rw12.color=COLORA;
rw12.usecolor=USECOLOR;
efighter1->registrate(&rw12);

Point lm_center(-l0*0.5+l4*l0-l5*l0,0,-b3*0.5*b0);
Point sh1(l2*l0,0,0);
Point sh2((l2+l3)*l0,0,0);

sp.init(0,sin(0.523598775),cos(0.523598775));

Point lm_b1=lm_center+mr1*sp;
Point lm_tt1=lm_b1+sh2;
lm_b1=lm_center+mr2*sp;
Point lm_t1=lm_b1+sh1;

sp.init(0,sin(1.570796327),cos(1.570796327));
Point lm_b2=lm_center+mr1*sp;
Point lm_tt2=lm_b2+sh2;
lm_b2=lm_center+mr2*sp;
Point lm_t2=lm_b2+sh1;

sp.init(0,sin(2.617993878),cos(2.617993878));
Point lm_b3=lm_center+mr1*sp;
Point lm_tt3=lm_b3+sh2;
lm_b3=lm_center+mr2*sp;
Point lm_t3=lm_b3+sh1;

sp.init(0,sin(3.665191429),cos(3.665191429));
Point lm_b4=lm_center+mr1*sp;
Point lm_tt4=lm_b4+sh2;
lm_b4=lm_center+mr2*sp;
Point lm_t4=lm_b4+sh1;

sp.init(0,sin(4.71238898),cos(4.71238898));
Point lm_b5=lm_center+mr1*sp;
Point lm_tt5=lm_b5+sh2;
lm_b5=lm_center+mr2*sp;
Point lm_t5=lm_b5+sh1;

sp.init(0,sin(5.759586532),cos(5.759586532));

Point lm_b6=lm_center+mr1*sp;
Point lm_tt6=lm_b6+sh2;
lm_b6=lm_center+mr2*sp;
Point lm_t6=lm_b6+sh1;

/// lm
MPolygon lm1(lm_b1,lm_t1,lm_t2,lm_b2); 
lm1.set_signature("lm1");
lm1.attach_mipmap(t1,lm_b1,tx,ty);
lm1.color=COLORB;
lm1.usecolor=USECOLOR;
efighter1->registrate(&lm1);

MPolygon lm2(lm_b2,lm_t2,lm_t3,lm_b3); 
lm2.set_signature("lm2");
lm2.attach_mipmap(t1,lm_b1,tx,ty);
lm2.color=COLORB;
lm2.usecolor=USECOLOR;
efighter1->registrate(&lm2);

MPolygon lm3(lm_b3,lm_t3,lm_t4,lm_b4); 
lm3.set_signature("lm3");
lm3.attach_mipmap(t1,lm_b1,tx,ty);
lm3.color=COLORB;
lm3.usecolor=USECOLOR;
efighter1->registrate(&lm3);

MPolygon lm4(lm_b4,lm_t4,lm_t5,lm_b5); 
lm4.set_signature("lm4");
lm4.attach_mipmap(t1,lm_b1,tx,ty);
lm4.color=COLORB;
lm4.usecolor=USECOLOR;
efighter1->registrate(&lm4);

MPolygon lm5(lm_b5,lm_t5,lm_t6,lm_b6); 
lm5.set_signature("lm5");
lm5.attach_mipmap(t1,lm_b1,tx,ty);
lm5.color=COLORB;
lm5.usecolor=USECOLOR;
efighter1->registrate(&lm5);

MPolygon lm6(lm_b6,lm_t6,lm_t1,lm_b1); 
lm6.set_signature("lm6");
lm6.attach_mipmap(t1,lm_b1,tx,ty);
lm6.color=COLORB;
lm6.usecolor=USECOLOR;
efighter1->registrate(&lm6);

MPolygon lm7(lm_b1,lm_b2,lm_b3,lm_b4,lm_b5,lm_b6); 
lm7.set_signature("lm7");
///lm7.attach_mipmap(t1,lm_b1,tz,ty);
lm7.color=0;
lm7.usecolor=true;
efighter1->registrate(&lm7);

MPolygon lm8(lm_tt6,lm_tt5,lm_tt4,lm_tt3,lm_tt2,lm_tt1); 
lm8.set_signature("lm8");
lm8.attach_mipmap(t1,lm_tt1,tz,ty);
lm8.color=COLORD;
lm8.usecolor=USECOLOR;
efighter1->registrate(&lm8);

MPolygon lm9(lm_t1,lm_tt1,lm_tt2,lm_t2);  
lm9.set_signature("lm9");
lm9.attach_mipmap(t1,lm_t1,tx,ty);
lm9.color=COLORB;
lm9.usecolor=USECOLOR;
efighter1->registrate(&lm9);

MPolygon lm10(lm_t2,lm_tt2,lm_tt3,lm_t3);  
lm10.set_signature("lm10");
lm10.attach_mipmap(t1,lm_t1,tx,ty);
lm10.color=COLORB;
lm10.usecolor=USECOLOR;
efighter1->registrate(&lm10);

MPolygon lm11(lm_t3,lm_tt3,lm_tt4,lm_t4);  
lm11.set_signature("lm11");
lm11.attach_mipmap(t1,lm_t1,tx,ty);
lm11.color=COLORB;
lm11.usecolor=USECOLOR;
efighter1->registrate(&lm11);

MPolygon lm12(lm_t4,lm_tt4,lm_tt5,lm_t5);  
lm12.set_signature("lm12");
lm12.attach_mipmap(t1,lm_t1,tx,ty);
lm12.color=COLORB;
lm12.usecolor=USECOLOR;
efighter1->registrate(&lm12);

MPolygon lm13(lm_t5,lm_tt5,lm_tt6,lm_t6);  
lm13.set_signature("lm13");
lm13.attach_mipmap(t1,lm_t1,tx,ty);
lm13.color=COLORB;
lm13.usecolor=USECOLOR;
efighter1->registrate(&lm13);

MPolygon lm14(lm_t6,lm_tt6,lm_tt1,lm_t1);  
lm14.set_signature("lm14");
lm14.attach_mipmap(t1,lm_t1,tx,ty);
lm14.color=COLORB;
lm14.usecolor=USECOLOR;
efighter1->registrate(&lm14);

// rm
Point rm_center(-l0*0.5+l4*l0-l5*l0,0,+b3*0.5*b0);

sp.init(0,sin(0.523598775),cos(0.523598775));

Point rm_b1=rm_center+mr1*sp;
Point rm_tt1=rm_b1+sh2;
rm_b1=rm_center+mr2*sp;
Point rm_t1=rm_b1+sh1;

sp.init(0,sin(1.570796327),cos(1.570796327));

Point rm_b2=rm_center+mr1*sp;
Point rm_tt2=rm_b2+sh2;
rm_b2=rm_center+mr2*sp;
Point rm_t2=rm_b2+sh1;

sp.init(0,sin(2.617993878),cos(2.617993878));

Point rm_b3=rm_center+mr1*sp;
Point rm_tt3=rm_b3+sh2;
rm_b3=rm_center+mr2*sp;
Point rm_t3=rm_b3+sh1;

sp.init(0,sin(3.665191429),cos(3.665191429));

Point rm_b4=rm_center+mr1*sp;
Point rm_tt4=rm_b4+sh2;
rm_b4=rm_center+mr2*sp;
Point rm_t4=rm_b4+sh1;

sp.init(0,sin(4.71238898),cos(4.71238898));

Point rm_b5=rm_center+mr1*sp;
Point rm_tt5=rm_b5+sh2;
rm_b5=rm_center+mr2*sp;
Point rm_t5=rm_b5+sh1;

sp.init(0,sin(5.759586532),cos(5.759586532));

Point rm_b6=rm_center+mr1*sp;
Point rm_tt6=rm_b6+sh2;
rm_b6=rm_center+mr2*sp;
Point rm_t6=rm_b6+sh1;

/// rm
MPolygon rm1(rm_b1,rm_t1,rm_t2,rm_b2); 
rm1.set_signature("rm1");
rm1.attach_mipmap(t1,rm_b1,tx,ty);
rm1.color=COLORB;
rm1.usecolor=USECOLOR;
efighter1->registrate(&rm1);

MPolygon rm2(rm_b2,rm_t2,rm_t3,rm_b3); 
rm2.set_signature("rm2");
rm2.attach_mipmap(t1,rm_b1,tx,ty);
rm2.color=COLORB;
rm2.usecolor=USECOLOR;
efighter1->registrate(&rm2);

MPolygon rm3(rm_b3,rm_t3,rm_t4,rm_b4); 
rm3.set_signature("rm3");
rm3.attach_mipmap(t1,rm_b1,tx,ty);
rm3.color=COLORB;
rm3.usecolor=USECOLOR;
efighter1->registrate(&rm3);

MPolygon rm4(rm_b4,rm_t4,rm_t5,rm_b5); 
rm4.set_signature("rm4");
rm4.attach_mipmap(t1,rm_b1,tx,ty);
rm4.color=COLORB;
rm4.usecolor=USECOLOR;
efighter1->registrate(&rm4);


MPolygon rm5(rm_b5,rm_t5,rm_t6,rm_b6); 
rm5.set_signature("rm5");
rm5.attach_mipmap(t1,rm_b1,tx,ty);
rm5.color=COLORB;
rm5.usecolor=USECOLOR;
efighter1->registrate(&rm5);

MPolygon rm6(rm_b6,rm_t6,rm_t1,rm_b1); 
rm6.set_signature("rm6");
rm6.attach_mipmap(t1,rm_b1,tx,ty);
rm6.color=COLORB;
rm6.usecolor=USECOLOR;
efighter1->registrate(&rm6);

MPolygon rm7(rm_b1,rm_b2,rm_b3,rm_b4,rm_b5,rm_b6); 

rm7.set_signature("rm7");
///rm7.attach_mipmap(t1,rm_b1,tz,ty);
rm7.color=0;
rm7.usecolor=true;
efighter1->registrate(&rm7);

MPolygon rm8(rm_tt6,rm_tt5,rm_tt4,rm_tt3,rm_tt2,rm_tt1); 
rm8.set_signature("rm8");
rm8.attach_mipmap(t1,rm_tt1,tz,ty);
rm8.color=COLORD;
rm8.usecolor=USECOLOR;
efighter1->registrate(&rm8);

MPolygon rm9(rm_t1,rm_tt1,rm_tt2,rm_t2);  
rm9.set_signature("rm9");
rm9.attach_mipmap(t1,rm_t1,tx,ty);
rm9.color=COLORB;
rm9.usecolor=USECOLOR;
efighter1->registrate(&rm9);

MPolygon rm10(rm_t2,rm_tt2,rm_tt3,rm_t3);  
rm10.set_signature("rm10");
rm10.attach_mipmap(t1,rm_t1,tx,ty);
rm10.color=COLORB;
rm10.usecolor=USECOLOR;
efighter1->registrate(&rm10);

MPolygon rm11(rm_t3,rm_tt3,rm_tt4,rm_t4);  
rm11.set_signature("rm11");
rm11.attach_mipmap(t1,rm_t1,tx,ty);
rm11.color=COLORB;
rm11.usecolor=USECOLOR;
efighter1->registrate(&rm11);

MPolygon rm12(rm_t4,rm_tt4,rm_tt5,rm_t5);  
rm12.set_signature("rm12");
rm12.attach_mipmap(t1,rm_t1,tx,ty);
rm12.color=COLORB;
rm12.usecolor=USECOLOR;
efighter1->registrate(&rm12);

MPolygon rm13(rm_t5,rm_tt5,rm_tt6,rm_t6);  
rm13.set_signature("rm13");
rm13.attach_mipmap(t1,rm_t1,tx,ty);
rm13.color=COLORB;
rm13.usecolor=USECOLOR;
efighter1->registrate(&rm13);

MPolygon rm14(rm_t6,rm_tt6,rm_tt1,rm_t1);  
rm14.set_signature("rm14");
rm14.attach_mipmap(t1,rm_t1,tx,ty);
rm14.color=COLORB;
rm14.usecolor=USECOLOR;
efighter1->registrate(&rm14);

// la
// to change: h3,h4

Point la_center(-l0*0.5+l4*l0,0,-b0*0.5+b1*b0+0.0000001);

sp.init(h3,0,0);
Point la_1=la_center+sp;
Point la_3=la_center-sp;

sp.init(0,h3,0);

Point la_2=la_center+sp;
Point la_4=la_center-sp;

sp.init(0,0,lm_t3.z-lw_b1.z-0.00001);

Point la_01=la_1+sp;
Point la_02=la_2+sp;
Point la_03=la_3+sp;
Point la_04=la_4+sp;

MPolygon la1(la_1,la_01,la_02,la_2);  
la1.set_signature("la1");
la1.attach_mipmap(t2,la_1,tz,ty);
la1.color=COLORE;
la1.usecolor=USECOLOR;
efighter1->registrate(&la1);

MPolygon la2(la_2,la_02,la_03,la_3);  
la2.set_signature("la2");
la2.attach_mipmap(t2,la_1,tz,ty);
la2.color=COLORE;
la2.usecolor=USECOLOR;
efighter1->registrate(&la2);

MPolygon la3(la_3,la_03,la_04,la_4);  
la3.set_signature("la3");
la3.attach_mipmap(t2,la_1,tz,ty);
la3.color=COLORE;
la3.usecolor=USECOLOR;
efighter1->registrate(&la3);

MPolygon la4(la_4,la_04,la_01,la_1);  
la4.set_signature("la4");
la4.attach_mipmap(t2,la_1,tz,ty);
la4.color=COLORE;
la4.usecolor=USECOLOR;
efighter1->registrate(&la4);

// ra
/// to change: h3,h4

Point ra_center(-l0*0.5+l4*l0,0, b0*0.5-b1*b0-0.0000001);

sp.init(h3,0,0);

Point ra_1=ra_center+sp;
Point ra_3=ra_center-sp;

sp.init(0,h3,0);

Point ra_2=ra_center+sp;
Point ra_4=ra_center-sp;

sp.init(0,0,rm_t1.z-rw_b1.z+0.00001);

Point ra_01=ra_1+sp;
Point ra_02=ra_2+sp;
Point ra_03=ra_3+sp;
Point ra_04=ra_4+sp;

MPolygon ra1(ra_1,ra_01,ra_02,ra_2);  
ra1.set_signature("ra1");
ra1.attach_mipmap(t2,ra_1,tz,ty);
ra1.color=COLORE;
ra1.usecolor=USECOLOR;
efighter1->registrate(&ra1);

MPolygon ra2(ra_2,ra_02,ra_03,ra_3);  
ra2.set_signature("ra2");
ra2.attach_mipmap(t2,ra_1,tz,ty);
ra2.color=COLORE;
ra2.usecolor=USECOLOR;
efighter1->registrate(&ra2);

MPolygon ra3(ra_3,ra_03,ra_04,ra_4);  
ra3.set_signature("ra3");
ra3.attach_mipmap(t2,ra_1,tz,ty);
ra3.color=COLORE;
ra3.usecolor=USECOLOR;
efighter1->registrate(&ra3);

MPolygon ra4(ra_4,ra_04,ra_01,ra_1);  
ra4.set_signature("ra4");
ra4.attach_mipmap(t2,ra_1,tz,ty);
ra4.color=COLORE;
ra4.usecolor=USECOLOR;
efighter1->registrate(&ra4);

// ma
// to change: h4

Point ma_center(-l0*0.5+l4*l0,0,0);

sp.init(h3,0,lm_t1.z+0.00001);

Point ma_1=ma_center+sp;

sp.init(-h3,0,lm_t1.z+0.00001);

Point ma_3=ma_center+sp;

sp.init(0,h3,lm_t1.z+0.00001);

Point ma_2=ma_center+sp;

sp.init(0,-h3,lm_t1.z+0.00001);

Point ma_4=ma_center+sp;

sp.init(0,0,rm_t3.z-lm_t1.z-0.00001);

Point ma_01=ma_1+sp;
Point ma_02=ma_2+sp;
Point ma_03=ma_3+sp;
Point ma_04=ma_4+sp;

MPolygon ma1(ma_1,ma_01,ma_02,ma_2);  
ma1.set_signature("ma1");
ma1.attach_mipmap(t2,ma_1,tz,ty);
ma1.color=COLORE;
ma1.usecolor=USECOLOR;
efighter1->registrate(&ma1);

MPolygon ma2(ma_2,ma_02,ma_03,ma_3);  
ma2.set_signature("ma2");
ma2.attach_mipmap(t2,ma_1,tz,ty);
ma2.color=COLORE;
ma2.usecolor=USECOLOR;
efighter1->registrate(&ma2);

MPolygon ma3(ma_3,ma_03,ma_04,ma_4);  
ma3.set_signature("ma3");
ma3.attach_mipmap(t2,ma_1,tz,ty);
ma3.color=COLORE;
ma3.usecolor=USECOLOR;
efighter1->registrate(&ma3);

MPolygon ma4(ma_4,ma_04,ma_01,ma_1);  
ma4.set_signature("ma4");
ma4.attach_mipmap(t2,ma_1,tz,ty);
ma4.color=COLORE;
ma4.usecolor=USECOLOR;
efighter1->registrate(&ma4);

efighter1->build();

//===========================================

// efighter2
Object * efighter2=new Object(efighter1);
efighter2->size_type=2;
efighter2->power=ENEMY_POWER2;
efighter2->velocity.init(0,0,0);
efighter2->view.O.init(146.690888,-20.699907,80.095932);
efighter2->id=new String("BF2");
Basic_CPilot efpilot2;
efpilot2.set_targets(&targetA);
efighter2->attach_pilot(efpilot2);
efighter2->attach_cockpit(cockpit1);
efighter2->cid=new Regex("BF2S");


//===========================================


// efighter3 
Object * efighter3=new Object(efighter1);
efighter3->size_type=2;
efighter3->power=ENEMY_POWER1;
efighter3->velocity.init(0,0,0);
efighter3->view.O.init(-45.4599,-12.5813,-17.8502);
efighter3->view.Xv.init(-0.866763,0.0579338,-0.495343);
efighter3->view.Yv.init(0.268545,-0.782724,-0.561451);
efighter3->view.Zv.init(-0.420244,-0.619667,0.662879);
efighter3->id=new String("BF3");
Basic_CPilot efpilot3; 
efpilot3.set_targets(&targetA);
efighter3->attach_pilot(efpilot3);
efighter3->attach_cockpit(cockpit1);
efighter3->cid=new Regex("BF3S");

//============================================

// efighter4
Object * efighter4=new Object(efighter1);
efighter4->size_type=2;
efighter4->power=ENEMY_POWER1;
efighter4->velocity.init(0,0,0);
efighter4->view.O.init(-60.1898,-8.61917,-33.1036);
efighter4->view.Xv.init(0.814276,-0.105858,0.570744);
efighter4->view.Yv.init(0.283517,-0.785449,-0.550171);
efighter4->view.Zv.init(0.506531,0.609807,-0.609559);
efighter4->id=new String("BF4");
Basic_CPilot efpilot4; 
efpilot4.set_targets(&targetA);
efighter4->attach_pilot(efpilot4);
efighter4->attach_cockpit(cockpit1);
efighter4->cid=new Regex("BF4S");


//===========================================

// efighter5
Object * efighter5=new Object(efighter1);
efighter5->size_type=2;
efighter5->power=ENEMY_POWER1;
efighter5->velocity.init(0,0,0);
efighter5->view.O.init(60.0572,123.15,33.2983);
efighter5->view.Xv.init(0.682846,0.679417,0.268541);
efighter5->view.Yv.init(0.708616,-0.705385,-0.0172232);
efighter5->view.Zv.init(0.177723,0.202053,-0.963114);
efighter5->id=new String("BF5");
Basic_CPilot efpilot5; 
efpilot5.set_targets(&targetA);
efighter5->attach_pilot(efpilot5);
efighter5->attach_cockpit(cockpit1);
efighter5->cid=new Regex("BF5S");

//===========================================




/*==========================================
   mines
==========================================*/

// mine number 1
Object * mine1=new Object; 
mine1->size_type=1;
mine1->shape=new BSP_Tree;  
mine1->velocity.init(0,0,0);
mine1->view.O.init(45,-30,50);
Mine_Pilot mpilot1; 
mpilot1.set_wait(300);
mpilot1.set_targets(&targetA);
mine1->attach_pilot(mpilot1);
mine1->attach_explosion(*mexplos);
mine1->power=MINE_POWER;
mine1->mass=MINE_MASS;
mine1->id=new String("BM1");
mine1->attach_shot(*shot[0]);


Point m1(-1,-1,-1);
Point m2(-1, 1,-1);
Point m3( 1, 0,-1);
Point m4( 0, 0, 1);

/// Texture-Koordinate Vectors
Point mt1,mt2,mt3,mt4,mt5;
mt1.adjust(m1,m2,128);
double mlen=mt1.length();
mt2.adjust(mlen,m1,m3);
mt3.adjust(mlen,m1,m4);
mt4.adjust(mlen,m2,m4);
mt5.adjust(mlen,m2,m3);




// Polygons
MPolygon pm1(m1,m2,m3); 
pm1.set_signature("pm1");
pm1.attach_mipmap(t2,m1,mt1,mt2);
pm1.backface=false;
mine1->registrate(&pm1);

MPolygon pm2(m1,m4,m2); 
pm2.set_signature("pm2");
pm2.attach_mipmap(t2,m1,mt3,mt1);
pm2.backface=false;
mine1->registrate(&pm2);

MPolygon pm3(m2,m4,m3); 
pm3.set_signature("pm1");
pm3.attach_mipmap(t2,m2,mt4,mt5);
pm3.backface=false;
mine1->registrate(&pm3);

MPolygon pm4(m1,m3,m4); 
pm4.set_signature("pm4");
pm4.attach_mipmap(t2,m1,mt2,mt3);
pm4.backface=false;
mine1->registrate(&pm4);

mine1->build();


//=================================================



// Mine number 2
Object * mine2=new Object(mine1);
mine2->size_type=1;
mine2->view.O.init(50,25,50);
mine2->id=new String("BM2");
Mine_Pilot mpilot2; 
mpilot2.set_wait(300);
mpilot2.set_targets(&targetA);
mine2->attach_pilot(mpilot2);


//===========================================

// Mine number 3
Object * mine3=new Object(mine1);
mine3->size_type=1;
mine3->view.O.init(25,15,-35);
mine3->id=new String("BM3");
Mine_Pilot mpilot3; 
mpilot3.set_wait(300);
mpilot3.set_targets(&targetA);
mine3->attach_pilot(mpilot3);


//===========================================

// Mine number 4
Object * mine4=new Object(mine1);
mine4->size_type=1;
mine4->view.O.init(30,30,25);
mine4->id=new String("BM4");
Mine_Pilot mpilot4; 
mpilot4.set_wait(300);
mpilot4.set_targets(&targetA);
mine4->attach_pilot(mpilot4);


//===========================================

// Mine number 5
Object * mine5=new Object(mine1);
mine5->size_type=1;
mine5->view.O.init(35,-35,20);
mine5->id=new String("BM5");
Mine_Pilot mpilot5; 
mpilot5.set_wait(300);
mpilot5.set_targets(&targetA);
mine5->attach_pilot(mpilot5);


//===========================================

// Mine number 6
Object * mine6=new Object(mine1);
mine6->size_type=1;
mine6->view.O.init(-10,-25,60);
mine6->id=new String("BM6");
Mine_Pilot mpilot6; 
mpilot6.set_wait(300);
mpilot6.set_targets(&targetA);
mine6->attach_pilot(mpilot6);


//===========================================

// Mine number 7
Object * mine7=new Object(mine1);
mine7->size_type=1;
mine7->view.O.init(-30,-30,-30);
mine7->id=new String("BM7");
Mine_Pilot mpilot7; 
mpilot7.set_wait(300);
mpilot7.set_targets(&targetA);
mine7->attach_pilot(mpilot7);


//===========================================

// Mine number 8
Object * mine8=new Object(mine1);
mine8->size_type=1;
mine8->view.O.init(-50,20,-30);
mine8->id=new String("BM8");
Mine_Pilot mpilot8; 
mpilot8.set_wait(100);
mpilot8.set_targets(&targetA);
mine8->attach_pilot(mpilot8);


//===========================================

// Mine number 9
Object * mine9=new Object(mine1);
mine9->size_type=1;
mine9->view.O.init(25,-35,60);
mine9->id=new String("BM9");
Mine_Pilot mpilot9; 
mpilot9.set_wait(200);
mpilot9.set_targets(&targetA);
mine9->attach_pilot(mpilot9);


//===========================================

// Mine number 10
Object * mine10=new Object(mine1);
mine10->size_type=1;
mine10->view.O.init(60,-30,20);
mine10->id=new String("BMA");
Mine_Pilot mpilot10; 
mpilot10.set_wait(300);
mpilot10.set_targets(&targetA);
mine10->attach_pilot(mpilot10);


//===========================================

// Mine number 11
Object * mine11=new Object(mine1);
mine11->size_type=1;
mine11->view.O.init(40,-20,20);
mine11->id=new String("BMB");
Mine_Pilot mpilot11; 
mpilot11.set_wait(200);
mpilot11.set_targets(&targetA);
mine11->attach_pilot(mpilot11);


//===========================================

// Mine number 12
Object * mine12=new Object(mine1);
mine12->size_type=1;
mine12->view.O.init(-40,-30,60);
mine12->id=new String("BMC");
Mine_Pilot mpilot12; 
mpilot12.set_wait(300);
mpilot12.set_targets(&targetA);
mine12->attach_pilot(mpilot12);

/*==========================================
   container
==========================================*/

// constainer
Object * container=new Object; 
container->size_type=1;
container->shape=new BSP_Tree;  
container->velocity.init(0,0,0);
container->view.O.init(0,0,0);
Pilot containerpilot; 
container->attach_pilot(containerpilot);
container->attach_explosion(*cexplos);
container->power=CONTAINER_POWER;
container->mass=CONTAINER_MASS;
container->id=new String("C");
container->cid=new Regex("AT");

Point c1( 1.5,-1.0,-0.5);
Point c2( 1.5, 1.0,-0.5);
Point c3(-1.5, 1.0,-0.5);
Point c4(-1.5,-1.0,-0.5);
Point c5( 1.2,-0.8, 0.5);
Point c6( 1.2, 0.8, 0.5);
Point c7(-1.2, 0.8, 0.5);
Point c8(-1.2,-0.8, 0.5);


// Polygons
//bottom
Polygon pc1(c4,c3,c2,c1); 
pc1.set_signature("pc1");
pc1.color=CONTAINER_COLOR;
container->registrate(&pc1);

// top
Polygon pc2(c5,c6,c7,c8); 
pc2.set_signature("pc2");
pc2.color=CONTAINER_COLOR;
container->registrate(&pc2);

// front
Polygon pc3(c1,c2,c6,c5); 
pc3.set_signature("pc3");
pc3.color=CONTAINER_COLOR;
container->registrate(&pc3);

// back
Polygon pc4(c3,c4,c8,c7); 
pc4.set_signature("pc4");
pc4.color=CONTAINER_COLOR;
container->registrate(&pc4);

// left
Polygon pc5(c5,c8,c4,c1); 
pc5.set_signature("pc4");
pc5.color=CONTAINER_COLOR;
container->registrate(&pc5);

// right
Polygon pc6(c7,c6,c2,c3); 
pc6.set_signature("pc6");
pc6.color=CONTAINER_COLOR;
container->registrate(&pc6);

container->build();


/*==========================================
   transporter
==========================================*/

// transporter
Object * transporter=new Object; 
transporter->size_type=3;
transporter->shape=new BSP_Tree;  
transporter->velocity.init(0,0,0);
transporter->view.O.init(2000,0,0);
transporter->view.Xv.init(1,0,0);
transporter->view.Yv.init(0,-0.40703320665926551,-0.91341336134122508);
transporter->view.Zv.init(0, 0.91341336134122508,-0.40703320665926551);
Transporter_Pilot transporterpilot; 
transporter->attach_pilot(transporterpilot);
transporter->attach_explosion(*texplos);
transporter->power=0; // TRANSPORTER_POWER;
transporter->mass=TRANSPORTER_MASS;
transporter->id=new String("AT");
transporter->cid=new Regex("C");

double tw=10;
double th=6;
double tl=12;
double twf=0.5;
double tmwf=0.8;
double tmhf=0.3;

// section bottom
Point tb1( tl*0.5,-tw*0.5    , -th*0.5);
Point tb2( tl*0.5,-tw*0.5*twf, -th*0.5);
Point tb3(-tl*0.5,-tw*0.5*twf, -th*0.5);
Point tb4(-tl*0.5,-tw*0.5    , -th*0.5);
Point tb5( tl*0.5, tw*0.5*twf, -th*0.5);
Point tb6( tl*0.5, tw*0.5    , -th*0.5);
Point tb7(-tl*0.5, tw*0.5    , -th*0.5);
Point tb8(-tl*0.5, tw*0.5*twf, -th*0.5);

// section top
Point tt1( tl*0.5,-tw*0.5    ,  th*0.5);
Point tt2( tl*0.5,-tw*0.5*twf,  th*0.5);
Point tt3(-tl*0.5,-tw*0.5*twf,  th*0.5);
Point tt4(-tl*0.5,-tw*0.5    ,  th*0.5);
Point tt5( tl*0.5, tw*0.5*twf,  th*0.5);
Point tt6( tl*0.5, tw*0.5    ,  th*0.5);
Point tt7(-tl*0.5, tw*0.5    ,  th*0.5);
Point tt8(-tl*0.5, tw*0.5*twf,  th*0.5);

// middle section bottom
Point tmb2( tl*0.5,-tw*0.5*twf*tmwf, -th*0.5*tmhf);
Point tmb3(-tl*0.5,-tw*0.5*twf*tmwf, -th*0.5*tmhf);
Point tmb5( tl*0.5, tw*0.5*twf*tmwf, -th*0.5*tmhf);
Point tmb8(-tl*0.5, tw*0.5*twf*tmwf, -th*0.5*tmhf);

// middle section top
Point tmt2( tl*0.5,-tw*0.5*twf*tmwf,  th*0.5*tmhf);
Point tmt3(-tl*0.5,-tw*0.5*twf*tmwf,  th*0.5*tmhf);
Point tmt5( tl*0.5, tw*0.5*twf*tmwf,  th*0.5*tmhf);
Point tmt8(-tl*0.5, tw*0.5*twf*tmwf,  th*0.5*tmhf);


/// Texture-Koordinate Vectors
Point tr,tu,tb;
tr.adjust( tt1,tt2,64);
double trlen=tr.length();
tu.adjust(trlen,tt1,tb1);
tb.adjust(trlen, tt1,tt4);

   
// Polygons
//top
MPolygon pt1(tt1,tt2,tt3,tt4); 
pt1.set_signature("pt1");
pt1.attach_mipmap(t1,tt1,tr,tb);
pt1.color=TRANSPORTER_COLOR;
pt1.usecolor=USECOLOR;
pt1.backface=true;
transporter->registrate(&pt1);

MPolygon pt2(tt5,tt6,tt7,tt8); 
pt2.set_signature("pt2");
pt2.attach_mipmap(t1,tt1,tr,tb);
pt2.color=TRANSPORTER_COLOR;
pt2.usecolor=USECOLOR;
pt2.backface=true;
transporter->registrate(&pt2);

// bottom
MPolygon pb1(tb4,tb3,tb2,tb1); 
pb1.set_signature("pb1");
pb1.attach_mipmap(t1,tb1,tr,tb);
pb1.color=TRANSPORTER_COLOR;
pb1.usecolor=USECOLOR;
pb1.backface=true;
transporter->registrate(&pb1);

MPolygon pb2(tb8,tb7,tb6,tb5); 
pb2.set_signature("pb2");
pb2.attach_mipmap(t1,tb1,tr,tb);
pb2.color=TRANSPORTER_COLOR;
pb2.usecolor=USECOLOR;
pb2.backface=true;
transporter->registrate(&pb2);



// left
MPolygon pl1(tt1,tt4,tb4,tb1); 
pl1.set_signature("pl1");
pl1.attach_mipmap(t1,tb1,tu,tb);
pl1.color=TRANSPORTER_COLOR;
pl1.usecolor=USECOLOR;
pl1.backface=true;
transporter->registrate(&pl1);


// right
MPolygon pr1(tt7,tt6,tb6,tb7); 
pr1.set_signature("pr1");
pr1.attach_mipmap(t1,tb1,tu,tb);
pr1.color=TRANSPORTER_COLOR;
pr1.usecolor=USECOLOR;
pr1.backface=true;
transporter->registrate(&pr1);


Point ts1;
ts1.adjust(trlen,tt2,tmt2);

// top to middle left
MPolygon ptml(tmt2,tmt3,tt3,tt2); 
ptml.set_signature("ptml");
ptml.attach_mipmap(t1,tt2,ts1,tb);
ptml.color=TRANSPORTER_COLOR;
ptml.usecolor=USECOLOR;
ptml.backface=true;
transporter->registrate(&ptml);

Point ts2;
ts2.adjust(trlen,tt5,tmt5);

// top to middle right
MPolygon ptmr(tt5,tt8,tmt8,tmt5); 
ptmr.set_signature("ptmr");
ptmr.attach_mipmap(t1,tb1,ts2,tb);
ptmr.color=TRANSPORTER_COLOR;
ptmr.usecolor=USECOLOR;
ptmr.backface=true;
transporter->registrate(&ptmr);


Point ts3;
ts3.adjust(trlen,tb2,tmb2);

// bottom to middle left
MPolygon pbml(tb2,tb3,tmb3,tmb2); 
pbml.set_signature("pbml");
pbml.attach_mipmap(t1,tb2,ts3,tb);
pbml.color=TRANSPORTER_COLOR;
pbml.usecolor=USECOLOR;
pbml.backface=true;
transporter->registrate(&pbml);

Point ts4;
ts4.adjust(trlen,tb5,tmb5);

// bottom to middle right
MPolygon pbmr(tmb5,tmb8,tb8,tb5); 
pbmr.set_signature("pbmr");
pbmr.attach_mipmap(t1,tb5,ts4,tb);
pbmr.color=TRANSPORTER_COLOR;
pbmr.usecolor=USECOLOR;
pbmr.backface=true;
transporter->registrate(&pbmr);

// front left
MPolygon pfl(tb2,tmb2,tmt2,tt2,tt1,tb1); 
pfl.set_signature("pfl");
pfl.attach_mipmap(t1,tb1,tr,tu);
pfl.color=TRANSPORTER_COLOR;
pfl.usecolor=USECOLOR;
pfl.backface=true;
transporter->registrate(&pfl);
   
// front right
MPolygon pfr(tt6,tt5,tmt5,tmb5,tb5,tb6); 
pfr.set_signature("pfr");
pfr.attach_mipmap(t1,tb1,tr,tu);
pfr.color=TRANSPORTER_COLOR;
pfr.usecolor=USECOLOR;
pfr.backface=true;
transporter->registrate(&pfr);

// back left
MPolygon pbl(tt3,tmt3,tmb3,tb3,tb4,tt4); 
pbl.set_signature("pbl");
pbl.attach_mipmap(t1,tb1,tr,tu);
pbl.color=TRANSPORTER_COLOR;
pbl.usecolor=USECOLOR;
pbl.backface=true;
transporter->registrate(&pbl);

// back right
MPolygon pbr(tb8,tmb8,tmt8,tt8,tt7,tb7);    
pbr.set_signature("pbr");
pbr.attach_mipmap(t1,tb1,tr,tu);
pbr.color=TRANSPORTER_COLOR;
pbr.usecolor=USECOLOR;
pbr.backface=true;
transporter->registrate(&pbr);


// middle section

// middle bottom
MPolygon pmb(tmb3,tmb8,tmb5,tmb2); 
pmb.set_signature("pmb");
pmb.attach_mipmap(t3,tmb2,tr,tb);
pmb.color=TRANSPORTER_COLOR;
pmb.usecolor=USECOLOR;
pmb.backface=true;
transporter->registrate(&pmb);

// middle top
MPolygon pmt(tmt2,tmt5,tmt8,tmt3); 
pmt.set_signature("pmt");
pmt.attach_mipmap(t3,tmb2,tr,tb);
pmt.color=TRANSPORTER_COLOR;
pmt.usecolor=USECOLOR;
pmt.backface=true;
transporter->registrate(&pmt);


// front middle
Polygon pfm(tmb5,tmt5,tmt2,tmb2); 
pfm.set_signature("pfm");
//pfm.attach_mipmap(t3,tmb2,tr,tu);
pfm.color=0; //TRANSPORTER_COLOR;
//pfm.usecolor=USECOLOR;
pfm.backface=true;
transporter->registrate(&pfm);

// back middle
MPolygon pbm(tmt3,tmt8,tmb8,tmb3); 
pbm.set_signature("pbm");
pbm.attach_mipmap(t3,tmb2,tr,tu);
pbm.color=TRANSPORTER_COLOR;
pbm.usecolor=USECOLOR;
pbm.backface=true;
transporter->registrate(&pbm);


transporter->build();


//=================================================

objects.add(efighter1);
objects.add(efighter2);
objects.add(efighter3);
objects.add(efighter4);
objects.add(efighter5);
objects.add(afighter1);
objects.add(afighter2);
objects.add(container);
objects.add(transporter);
objects.add(mine1);
objects.add(mine2);
objects.add(mine3);
objects.add(mine4);
objects.add(mine5);
objects.add(mine6);
objects.add(mine7);
objects.add(mine8);
objects.add(mine9);
objects.add(mine10);
objects.add(mine11);
objects.add(mine12);

objects.mark_as_active(*afighter1); 



