// tpointset.h

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
 
#ifndef F_TPOINTSET
#define F_TPOINTSET

#include "points.h"

/// a Wrapper class for TPoint, to create a list of TPoints
class W_TPoint : public TPoint {
  public:
    /// pointer to next wrapper class
    W_TPoint * next;
};



/// a class which implements a finite set of TPoints 
class TPoint_Set {
  W_TPoint * first;
  W_TPoint * last;
  public:
    /// constructor for a set of TPoints
    TPoint_Set (void);
    /// should not be used
    TPoint_Set (const TPoint &);
    /// destructor for TPoint_Set
    ~TPoint_Set (void); 
    /// true iff p is a address of a W_TPoint which is part of this TPoint_Set
    bool manages (const TPoint *p);
    /// add a TPoint to the set, and return address of this point
    TPoint * add (const TPoint *);
    /// true iff list is empty
    bool is_empty (void);
    /// 0x0 iff the point is not contained in the set (otherwise it returns pointer to contained point)
    TPoint * is_in (const TPoint *);
    /// calculates for all TPoints of this Set the world coordinates
    void to_world (View &);
    /// calculates for all TPoints of this Set the world coordinates, but treat TPoints as direction vectors
    void dir_to_world (View &);
    /// calculates for all TPoints of this Set the view  coordinates (world coordinates must be valid !)
    void to_view (View &);
    /** calculates for all TPoints of this Set the view  coordinates (world coordinates must be valid !),
       * but treat TPoints as direction vectors */
    void dir_to_view (View &);
    /// calculates maximal length of a vector in this list (only for relative coordinates) 
    double calc_max_length (void);
    /// prints all TPoints contained in TPoint_Set
    void print (void);
    // shuffles the set (actually a set has no ordering, but internally there is one)
    //void shuffle (void);
};

#endif




