// tpointset.cc

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "tpointset.h"
#include <iostream.h>

TPoint_Set::TPoint_Set (void) {
  first=last=NULL;
};


TPoint_Set::TPoint_Set (const TPoint &p) {
  cout << "ERROR: do not use copy constructor for TPoint!\n";
  exit(-1);
};

TPoint_Set::~TPoint_Set(void) {
  // later
};

///
bool TPoint_Set::manages (const TPoint *p) {
  W_TPoint * run=first;
  while (run!=NULL) {
    if (run==p) return true;
    run=run->next;
  };
  return false;
};

/// adds a copy of TPoint to the set
TPoint * TPoint_Set::add (const TPoint *p) {
  TPoint * a=is_in(p);
  if (a != 0x0) return a; 
  if (is_empty()) { 
    first=new(W_TPoint);
    last=first;
  } 
  else {
    last->next=new(W_TPoint);
    last=last->next;
  };
  last->init(*p);
  last->next=NULL;
  return last;
};


bool TPoint_Set::is_empty (void) {
  if (first==NULL) return true; 
  return false; 
};

TPoint * TPoint_Set::is_in (const TPoint *p) {
  W_TPoint * run=first;
  while (run!=NULL) {
    if (run->r==p->r) return run;
    run=run->next;
  };
  return NULL;
};
  


// calculates for all TPoints of this Set the world coordinates
void TPoint_Set::to_world (View &v) {
  W_TPoint * run=first;
  while (run!=NULL) {
    run->to_world(v);
    run=run->next;
  };
};

// calculates for all TPoints of this Set the world coordinates, but treat TPoints as direction vectors
void TPoint_Set::dir_to_world (View &v) {
  W_TPoint * run=first;
  while (run!=NULL) {
    run->dir_to_world(v);
    run=run->next;
  };
};
  

// calculates for all TPoints of this Set the view  coordinates (world coordinates must be valid !)
void TPoint_Set::to_view (View &v) {
  W_TPoint * run=first;
  while (run!=NULL) {
    run->to_view(v);
    run=run->next;
  };
};
  
  
/* calculates for all TPoints of this Set the view  coordinates (world coordinates must be valid !),
 * but treat TPoints as direction vectors */
void TPoint_Set::dir_to_view (View &v) {
  W_TPoint * run=first;
  while (run!=NULL) {
    run->dir_to_view(v);
    run=run->next;
  };
};
  
///
double TPoint_Set::calc_max_length (void) {
  if (first==NULL) return 0;
  W_TPoint * run=first;
  double len=-1;
  while (run!=NULL) {
    double sp=run->r.length();
    if (len<sp) len=sp;
    run=run->next;
  };
  return len;
};

///
void TPoint_Set::print (void) {
  if (first==NULL) return;
  cout << "Content:" << endl;
  W_TPoint * run=first;
  while (run!=NULL) {
    cout << "(" << run->r.x << "," << run->r.y << "," << run->r.z << ")" << endl;
    run=run->next;
  };  
}