// timer.cc

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "timer.h"


///
Clocks::Clocks(void) {
  set_zero();
};

///
Clocks::set_zero(void) {
  low=high=0;
};

///
Clocks operator+(const Clocks &P,const Clocks &Q) {
  Clocks c;
  c.low=P.low+Q.low;
  c.high=P.high+Q.high;
  if ((P.low & 0x80000000) & (Q.low & 0x80000000)) 
    c.high++;
  return c;
};

/// P is supposed to be bigger!
Clocks operator-(const Clocks &P,const Clocks &Q) {
  Clocks c;
  c.low=P.low-Q.low;
  c.high=P.high-Q.high;
  if (P.low<Q.low) c.high--;
  return c;
};


//===================================


Timer::Timer (void) {
  init();
};

///
void Timer::init (void) {
  start.set_zero();
  stp.set_zero();
  start=get();
  is_running=true;
};

///
Clocks Timer::get (void) {
  Clocks val;
  unsigned int low;
  unsigned int high;
  __asm __volatile (".byte 0xf; .byte 0x31     # RDTSC instruction"
                    : "=a" (low), "=d" (high) :);
  val.low= (unsigned long int) low;
  val.high= (unsigned long int) high;
  val=val-start;
  return  val;
};

///
double Timer::get_sec (void) {  
  double val;
  Clocks c=get();
  val=((double) c.high)*4294967296.0+(double) c.low;
  return (val * (CPS));
};

///
void Timer::stop (void) {
  if (is_running) {
    stp=get();
    is_running=false;
  };
};

///
void Timer::go_on (void) {
  if (is_running) return; // timer was stopped
  // cut out time between stop and ag;
  start=start+(get()-stp);
  is_running=true;
};

