// texture.h

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef F_TEXTURE
#define F_TEXTURE

#include "globals.h"
#include <String.h>

/// convert integer to string
String i2string(unsigned int);

/// convert RGB to pixel
Pixel RGB_to_Pixel(unsigned short red, unsigned short green, unsigned short blue);

///
class Texture {
  public:
    ///
    int width,height;
    ///
    Pixel * content;
    ///
    Pixel ** tex;
    ///
    Texture (void);
    /// true iff image file exists in texture directory
    bool is_existing (char const * filename);   
    /// returnvalue indicates wheather the Texture was successfully loaded or not. 
    bool load (char const * filename, bool prt=true);  // if prt==true then there will be  messages (like Loading...) printed
    /** returnvalue indicates wheather the Texture was successfully loaded or not; 
       * filename is only needed to print error messages */
    bool load (istream &inp, char const * filename=NULL, bool prt=true);  // if prt==true then there will be  messages (like Loading...) printed
    ///
    void del (void);
    ///
    void draw(int x=0, int y=0);
};


#define MAX_NR_OF_TEXTURES 8

///
class Mipmap {
  public:
    ///
    int nr_of_textures;
    ///
    Texture texture[MAX_NR_OF_TEXTURES]; // texture[0] is the main texture
    ///
    double factor[MAX_NR_OF_TEXTURES]; // factor is the scaling factor of texture-coordinates compared to those of texture[0]
    //-------------------
    ///
    Mipmap (void);
    ///
    void load (char const * filename);
    ///
    void del (void);
};

#endif F_TEXTURE
