// stars.h

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "globals.h"
#include "points.h"

///
class Star : Point {
  public:
    ///
    Pixel color;
    ///
    int max_blink;
    ///
    Pixel blink;
    //----------------------
    ///
    Star (void);
    ///
    void draw(View &);
};

class Star_List {
  public:
    ///
    const int nr_of_stars=1000;
    ///
    Star star[nr_of_stars];
    //------------------------
    ///
    Star_List (void);
    ///
    draw(View &);
};



