// stars.cc

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include "scrman.h"
#include "stars.h"
#include <stdlib.h>
#include "graphics.h"
#include "frustrum.h"

///
extern Graphics graphics;
extern Frustrum frustrum;
extern Screen_Manager screen_manager;

///
Star::Star (void) {
  int rm=RAND_MAX/2;
  x=(double) (rand()-rm);
  y=(double) (rand()-rm);
  z=(double) (rand()-rm);
  x+=0.01; // therefore (x,y,z) != 0 
  normalize();
  double denom=16383.0/((double)RAND_MAX);
  color=(Pixel) (((double) rand()) *denom)+(Pixel) 49152 ;
  max_blink=100;
  blink=0;
};

///
void Star::draw(View &view) {
  Point v;
  v.x=*this * view.Xv; // scalarproduct
  if (v.x<=0) return; // not visible 
  v.y=*this * view.Yv; // scalarproduct
  v.z=*this * view.Zv; // scalarproduct
  
  double lambda=frustrum.distance_to_vp / v.x;
  int sy=(int) ((lambda*v.y+frustrum.scr_half_width-1)*frustrum.vh_scale);
  if (sy<0) return;
  if (sy>=frustrum.scr_height) return;

  int sz=(int) ((lambda*v.z+frustrum.scr_half_height-1));  
  //sz++; // because our stars are 2 pixels width
  if (sz<1) return;
  if (sz>=frustrum.scr_width) return;

  if (screen_manager.content[sy].is_free(sz)) {
    Pixel * pstart=graphics.framebuffer+sy*frustrum.scr_width+sz;
    blink++;
    if (blink>max_blink) blink=0;
    *pstart=color+blink;
    //pstart++;
    //*pstart=color;
  };
};


///
Star_List::Star_List (void) {};

///
Star_List::draw (View &view) {
  for (int i=0; i<nr_of_stars; i++)
    star[i].draw(view);
};









