// sofie.cc  (not really used)

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include <signal.h>
#include "globals.h"
#include "graphics.h"
#include "sofie.h"
#include "pilot.h"
#include "objects.h"
#include "objectlist.h"
#include "cockpit.h"
#include "stars.h"
#include "console.h"
#include <iostream.h>
#include <fstream.h>
#include <Regex.h> // for regular expressions

#ifdef TIMER
#include "timer.h"
#endif


bool use_mipmaps=true;
bool no_collisions=false;

const String recorder_name("recorder.rec");

Player player(recorder_name);
  
bool automatic=false;


Graphics graphics;
Input input;
Global_Input ginput;
Console console;
Object_Locs objectlocs;
Object_List objects;


///
Star_List stars;




///
static void catch_SIGSEGV (int sig) {
  static int i=1;
  signal(SIGSEGV,SIG_IGN);
  cout << "\nERROR: Segmentation Violation!\n";
  exit(-1);
};


///
int main()
{ 
  
  // catch the Segmentation Fault signal
  // because we want to have the last viewer 
  // coordinates, to reproduce the fault. 
  if (signal(SIGSEGV,catch_SIGSEGV) == SIG_ERR) {
    cout << "ERROR: function to catch the segmentation fault signal could not be installed!\n";
    exit(-1);
  };

  cout << "\n\nThis is Sofie Version 0.1  alpha\n\n";
  
  cout << "This binary works for screens with the size " << frustrum.screen_w << " cm x " << frustrum.screen_h << " cm,\n";
  cout << "and with the resolution " << frustrum.x_res << " x " << frustrum.y_res << '\n';
  cout << "(to change, see the README file)\n";


#ifndef ACCURATE
  init_not_accurate_texture_mapping();
#endif

  // set the default screen-size
  // width has to be even (eg. not 321 !!)
  frustrum.init(320,200);

  // initialize the window

  // gets the pointer to the framebuffer (virtual-screen)
  // because it is better to finish drawing
  // the complete view of the world, and
  // then copy all date in one fast process
  // to the screen. It avoids flickering of
  // the screen.

#ifdef JOYSTICK
  init_joystick();
#endif

  Texture title;
  title.load("textures/title");
  title.draw(0,0);

  // show title immediately
  graphics.update_screen();

  
  // include the world-file
#include WORLDFILE
  


  
  // cockpit should be visible as default
  console.set_cockpit();
  //cockpit.load(); // not really necessary, but if you use timer, it's better
  
  
#ifdef JOYSTICK
  // calibrate joystick
#ifndef PLAY
  calibrate_joystick();
#endif
#endif
  

#ifdef PLAY
player.as_player();
player.run(objects.active_object()); // start Player
#endif

#ifdef TIMER
long frames=0;
Timer tm;
#endif



/*==========================================
  main loop
 =========================================*/

for (;;) { // the main loop
    
  console.refresh();
  console.read(ginput);
  console.read(input);  
  
    
  // occured a ConfigureNotify ?
  if (ginput.con_notify) {
    if ((ginput.width!=frustrum.scr_width) || (ginput.height!=frustrum.scr_height)) {
      // screen is resized
      frustrum.init(ginput.width,ginput.height);
      // there is a new framebuffer
      cout << "Screen size set to " << frustrum.scr_width << "x" << frustrum.scr_height << '\n';
      objects.cockpit_on_screen=false; // Cockpit must be redrawn
    };
    ginput.con_notify=false;
  };
  
  
  // process special input
  if (ginput.special!=Global_Input::NO) {
    if (ginput.special==Global_Input::F1) { 
      // help screen
      cout << "Commands:\n";
      cout << "   F1            Help\n";
      cout << "   F2            Autopilot on/off\n";
      cout << "   F3            Recorder on/off\n";
      cout << "   F4            Player on/off\n";
      cout << "   F6            Fighter1 active\n";
      cout << "   F7            Fighter2 active\n";
      cout << "   F8            Fighter3 active\n";
    };
    if (ginput.special==Global_Input::F6) { 
      objects.mark_as_active(*fighter1); 
      cout << "fighter1 marked as active.\n";
    };
    if (ginput.special==Global_Input::F7) { 
      objects.mark_as_active(*fighter2); 
      cout << "fighter 2 marked as active.\n";
    };
    if (ginput.special==Global_Input::F8) { 
      //      objects.mark_as_active(*fighter3); 
      //cout << "fighter 3 marked as active.\n";
    };
    if (ginput.special==Global_Input::F2) { 
      if (automatic) {
	automatic=false;
	cout << "autopilot off\n";
      }
      else {
	automatic=true;
	cout << "autopilot on\n";
      };
    };
    if (ginput.special==Global_Input::F3) { 
      player.as_recorder();
      player.pswitch(objects.active_object()); // if on then off and the other way round
    };
    if (ginput.special==Global_Input::F4) {  
      player.as_player();
      player.pswitch(objects.active_object()); // if on then off and the other way round
    };
  };
  
  // needed because player could decide to stop himself
  player.update();
  
  objects.update_shots();
  
  objects.process();
  objects.process_velocity();
  
  objects.to_world();
  

  if (!no_collisions)
    objects.collisions();
  
  objects.update_explosion();
  
  // initializes Screen_Manager, draws cockpit, radar if wanted
  objects.draw_cockpit(ginput.cockpit);
  
  // draws the world
  objects.draw();
  
  // if all walls are drawn, then there could be still
  // free pixels on the screen. The following
  // function clears that. In "good" world this
  // should be deleted
  
  /*
  if (flickertimer>0) {
    Pixel col=rand() % 32*2048; // only red colors
    screen_manager.clear_remaining(col);
    flickertimer--;
  }
  else
  */ 
  

#ifndef INROOM   
  screen_manager.clear_remaining(0);
  
  // draws stars
  stars.draw(*objects.active_view());
#endif
  
  // until now nothing appeared on the screen, because
  // we use a virtual screen. The following function
  // copies the virtual screen to the actual screen,
  // therefore after update_screen is finished, we
  // can see what we have drawn.
  // ( this is really necessary, because otherwise
  // we would see flickering of the screen,
  // the vertical retrace is not waiting for us.)
  graphics.update_screen();
  


  if (objects.active_object()->power <= 0) {
    cout << "active object  destroyed !!!!\n";
    break;
  };


  if (ginput.quit) break; // ginput tells you when our program is finished


#ifdef TIMER
  // initialize the timer at the end of frame 0,
  // because in frame 0 there may be some initializations
  if (frames==0) {
    cout << "Timer started.\n";
    tm.init();
  };
  frames++;
#endif
  
  
  
#ifdef PLAY
  if (!player.on()) break;
#endif
  
}; // this is the end of the main loop


#ifdef TIMER
tm.stop();
cout << "Statistics" << '\n';
cout << "number_of_frames_: " << frames-1 << '\n'; 
cout << "time____________ : " << tm.get_sec() << '\n';
cout << "frames_per_second: " << ((double) frames)/ (tm.get_sec()) << '\n'; 
#endif

exit(0);
}
  





