// scrman.h

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef F_SCRMAN
#define F_SCRMAN

#include "globals.h"
#include "texture.h"
#include "frustrum.h"

extern Frustrum frustrum;



/// per definition:  interval empty  iff  from>to  
class Interval {
  public:
    ///
    int from,to;
    //----------------
    ///
    Interval(void) {from=0;to=-1;};
    /// true  iff   p is contained in the interval  from..to 
    bool is_empty(void) { return (from>to); };
    ///
    bool is_in (int);
    /** true  iff  intersection of (*this) with (*iv) is not empty.
       * after the function returns, (*iv) ist this intersection interval,
       * but does not change if this intersection is empty. */
    bool intersects (Interval &iv);
    /** (*sec) must be empty if the function is envoked!
       * Equal to intersects, but here (*this) could be changed. 
       * explicitly: the intersection of two intervals is again an interval,
       * but an interval minus another interval is not necessary an interval,
       * but a disjunct unity of at most two intervals.
       * Suppose it is only one interval, then after the function returns, you can find it
       * in (*this) ant (*sec) is empty. In the other case you will find the first interval in
       * (*this) and the second in (*sec). */
    bool adapts (Interval &iv,Interval &sec);
};


///
class Row_Manager {
  public:
    ///
    const max_intervals=20;
    ///
    Interval interval[max_intervals];
    /// -1 means empty, there are actually nr_of_contents+1 intervals
    int nr_of_contents;
    /** temporary variable ( better private )
       * has to be empty at the end of a methode */
    Interval sec; 
    //------------------------------------
    ///
    Row_Manager(void);
    ///
    void init (void);
    ///
    void init (Row_Manager &);
    ///
    void init (Texture &, int row, Pixel blend_out);
    ///
    bool get (Interval &);
    ///
    bool is_free (int);
};


/** this class manages intervals of regions on the screen
   * which are still free to write to.
   * For example a wall was drawn on the screen. Then a
   * wall which is behind the first should be drawn.
   * But the first wall should not be overdrawn.
   * The solution is the following. Tell the screen manager
   * what regions the first wall occupies. 
   * Every time something should be drawn on the screen
   * one should tell the screenmanager what regions are still free. */
class Screen_Manager {
  public:
    ///
    const max_rows=768;
    ///
    Row_Manager content[max_rows]; //doit: need a dynamic version (or not)/ but clearly dangerous
    //------------------------------------
    ///
    Screen_Manager (void) {};
    ///
    Screen_Manager (Texture &,Pixel blend_out);
    ///
    void init (Texture &,Pixel blend_out);
    ///
    void init(void);
    ///
    void init(Screen_Manager &);
    ///
    void clear_remaining(Pixel color=0);
};

#endif F_SCRMAN


