// radar.h

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifndef F_RADAR
#define F_RADAR

#include "objectloc.h"
#include <Regex.h>

///
class Radar_Object {
  public:
    ///
    double x;
    ///
    double y;
    ///
    double distance;
    ///
    bool in_front_of;
    ///
    String * id;
    //------------------
    ///
    Radar_Object(void);
    ///
    inline void init(double,double,double,bool,String *);
};

///
class Radar {
  public:
    ///
    int nr_of_objects;
    ///
    Radar_Object * object;
    //------------------------
    ///
    Radar (void);
    ///
    ~Radar (void);
    /// gets all objects 
    void get_radar(const View &view); 
    /// gets all objects with match specified id
    void get_radar(const View &view, Regex * searchid); 
    /// gets coordinates of object named searchid, or get nothing
    void get_radar(const View &view, String * searchid); 
    ///
    void get_first_radarobject(const View &view, Regex * searchid);

};

#endif F_RADAR


