// radar.cc

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "radar.h"
#include <stdlib.h>

///
extern Object_Locs objectlocs;


//=====================================

Radar_Object::Radar_Object(void) {
  x=y=distance=0;
  in_front_of=true;
  id=NULL;
}

///
inline void Radar_Object::init(double ax,double ay,double d,bool ifo,String * aid) {
  x=ax;
  y=ay;
  distance=d;
  in_front_of=ifo;
  id=aid;
}

/// used to sort Radar_Objects by distance
inline int rovgl(const Radar_Object * a, const Radar_Object * b) {
  if (a->distance > b->distance) return 1;
  if (a->distance == b->distance) return 0;
  return -1;
}

//======================================

Radar::Radar(void) {
  nr_of_objects=0;
  object=NULL;
}

///
Radar::~Radar(void) {
  delete[] object;
}

///
void Radar::get_radar(const View &view) {
  delete[] object;
  nr_of_objects=objectlocs.nr_of_locs;
  if (nr_of_objects==0) return;
  object=new Radar_Object[nr_of_objects];
  int j=0;
  for (int i=0; i<nr_of_objects; i++) {
    Point P(objectlocs.locs[i].loc); 
    P.to_view(view);
    double dist=P.length();
    if (dist > 1.0) { // radar should not see objects, which are to close (radar should not see own object) 
      P=(1.0/dist)*P;
      object[j].init(P.y,P.z,dist,(P.x>=0),objectlocs.locs[i].id);
      j++;
    };
  };
  nr_of_objects=j;
  // now sort all entries
  qsort(object,nr_of_objects,sizeof(Radar_Object),&rovgl);
}

///
void Radar::get_radar(const View &view, Regex *searchid) {
  if ( searchid == NULL ) {
    get_radar(view);
    return;
  };  
  delete[] object;
  nr_of_objects=objectlocs.nr_of_locs;
  if (nr_of_objects==0) return;
  object=new Radar_Object[nr_of_objects];
  int j=0;
  for (int i=0; i<nr_of_objects; i++) {
    if (objectlocs.locs[i].id->matches(*searchid) != 0) { 
      // they are equal (or no searchid specified)
      Point P(objectlocs.locs[i].loc); 
      P.to_view(view);
      double dist=P.length();
      if (dist > 1.0) { // radar should not see objects, which are to close (radar should not see own object) 
	P=(1.0/dist)*P;
	object[j].init(P.y,P.z,dist,(P.x>=0),objectlocs.locs[i].id);
	j++;
      };
    };
  };
  nr_of_objects=j;
  // now sort all entries
  qsort(object,nr_of_objects,sizeof(Radar_Object),&rovgl);
}


/// gets only object (0 or 1) with specified id (but all objects if id==NULL)
void Radar::get_first_radarobject(const View &view, Regex * searchid) {
  
  if ( searchid == NULL ) {
    get_radar(view);
    return;
  };
  
  delete[] object;
  nr_of_objects=0;
  if (objectlocs.nr_of_locs==0) return;

  int i=0;
  while (i < objectlocs.nr_of_locs) {
    if (objectlocs.locs[i].id->matches(*searchid) != 0) { // they are equal
      Point P(objectlocs.locs[i].loc); 
      P.to_view(view);
      double dist=P.length();
      if (dist > 1.0) { // radar should not see objects, which are to close (radar should not see own object) 
	P=(1.0/dist)*P;
	object=new Radar_Object[1];
	object[0].init(P.y,P.z,dist,(P.x>=0),objectlocs.locs[i].id);
	nr_of_objects=1;
      };
      return;
    };
    i++;
  };
  nr_of_objects=0;
}

/// gets only object (0 or 1) with specified id (but all objects if id==NULL)
void Radar::get_radar(const View &view, String * searchid) {

  if ( searchid == NULL ) {
    get_radar(view);
    return;
  };

  
  delete[] object;
  nr_of_objects=0;
  if (objectlocs.nr_of_locs==0) return;

  int i=0;
  while (i < objectlocs.nr_of_locs) {
    if (objectlocs.locs[i].id->matches(*searchid) != 0) { // they are equal
      Point P(objectlocs.locs[i].loc); 
      P.to_view(view);
      double dist=P.length();
      if (dist > 1.0) { // radar should not see objects, which are to close (radar should not see own object) 
	P=(1.0/dist)*P;
	object=new Radar_Object[1];
	object[0].init(P.y,P.z,dist,(P.x>=0),objectlocs.locs[i].id);
	nr_of_objects=1;
      };
      return;
    };
    i++;
  };
  nr_of_objects=0;
}


//======================================



