// pilots3.cc

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

//#include "pilot.h"
//#include "console.h"
//#include "objects.h"
//#include <math.h>
//#include <stdlib.h>

///
extern Console console;
static Input transporter_input; 


class Transporter_Pilot : public Pilot {
  public:
    enum {WAITING = 1, COMING = 2, DOCKING = 3, LEAVING = 4} status;
    bool no_docking;
    int cycles;
    double speed;
    Transporter_Pilot (void);
    Input * process(const View &view);
    /// get the container
    virtual void message (const String &s);
};


//=========================================

Transporter_Pilot::Transporter_Pilot (void) : Pilot() {
  status=WAITING;
  no_docking=false;
};

void Transporter_Pilot::message (const String &s) {
  if (status==WAITING)
    if (s=="get it")
      status=COMING;
};

///
Input * Transporter_Pilot::process(const View &view) {
  
  transporter_input.x=0;
  transporter_input.y=0;
  transporter_input.z=0;
  transporter_input.angley=0;
  transporter_input.anglez=0;
  transporter_input.anglex=0;
  
  if (status==WAITING) return &transporter_input;

  if (status==COMING) { 
    transporter_input.x=-3;
    if (view.O.x<100) 
      transporter_input.x=-2;
    if (view.O.x<60) 
      transporter_input.x=-1.5;
    if (view.O.x<45) 
      transporter_input.x=-1;
    if (view.O.x<35) 
      transporter_input.x=-0.5;
    if (view.O.x<25) 
      transporter_input.x=-0.1;
    if (view.O.x<20) {
      transporter_input.x=0;
      status=DOCKING;
      cycles=0;
      cout << "Transporter arrived" << endl;
    };
  };
    
  
  if (status==DOCKING) {
    if (no_docking) {
      status=LEAVING;
      speed=-0.01;
      cycles=0;
      no_docking=false;
      cout << "Transporter leaving" << endl;
    } else {
      cycles++;
      if (cycles < 200) {
	//transporter_input.z=-0.01;
	transporter_input.x=-0.01;
	transporter_input.anglex=0.01;
      } else {
	if (cycles < 400) {
	  transporter_input.x=-0.01;
	  transporter_input.z=-0.01;
	} else {
	  if (cycles < 2000) {
	    transporter_input.x=-0.01;
	  } else {
	    if (cycles < 2520) {
	      transporter_input.z=0.001;
	    } else {
	      cout << " Docking finished, Transporter leaving " << endl;
	      status=LEAVING;
	      speed=-0.01;
	      cycles=0;
	      
	    };
	  };
	};
      };
    };
  };
  
  if (status==LEAVING) { 
    cycles++;
    if ((cycles & 1)==0)
      speed-=0.0001; // increase every second time, because two objects use the same pilot
    if (speed>-1) 
      transporter_input.x=speed;
    else {
      status=WAITING;
      cout << "Transporter in Hyperspace" << endl;
    };
  };
  
  return &transporter_input;
};


//=========================================


