// pilot.h

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef F_PILOT
#define F_PILOT

#include "input.h"
#include "radar.h"
#include <fstream.h>
#include <Regex.h>


///
class Pilot {
  public:
    ///
    String * target;
    //--------------------
    ///
    Pilot (void);
    ///
    virtual Input * process(const View &view);
    ///
    void set_target (String *);
    ///
    String * current_target (void);
    ///
    virtual void message (const String &s) {}; 
};

///
class Shot_Pilot : public Pilot {
  public:
    ///
    virtual Input * process(const View &view);
};

///
class Console_Pilot : public Pilot {
  public:
    ///
    virtual Input * process(const View &view);
};

///
class MConsole_Pilot : public Console_Pilot {
  ///
  float speed;
  public:
    ///
    MConsole_Pilot (void) { speed=1.0; };
    ///
    virtual Input * process(const View &view);
};

/// used as recorder 
class RPilot : public Pilot {
  ///
  ofstream rec;
  //-----------------------
  public:
    ///
    RPilot(String &filename);
    ///
    ~RPilot (void);
    //-----------------------
    virtual Input * process(const View &view);
};


/// used as counterpart to RPilot: a player 
class PPilot : public Pilot {
  /// 
  bool * status;
  ///
  ifstream recplay;
  //-----------------------
  public:
    ///
    PPilot(String &filename, bool *s);
    ///
    ~PPilot (void);
    //-----------------------
    ///
    virtual Input * process(const View &view);
};


///
class Basic_CPilot : public Pilot {
  protected:
    ///
    Regex *targets;
    //-----------------------------
  public:
    ///
    Basic_CPilot(void);
    ///
    void set_targets (Regex *);
    ///
    virtual Input * process(const View &view);
    ///
    virtual String * current_target (void);
};

class Mine_Pilot : public Basic_CPilot {
  /// a counter; Mine can only shoot if cwait < 0
  int cwait;
  /// initialvalue for counter cwait
  int wait;
  public:  
    ///
    Mine_Pilot (void);
    ///
    void set_wait (int w);
    /// 
    virtual Input * process(const View &view);
};

///
class Maneuver : public Basic_CPilot {
  protected:
    int live_time;
    //-------------------
  public:
    ///
    Maneuver (void);
    //-------------------
    ///
    virtual void init (void);
    /// returns NULL iff maneuver is finished
    virtual Input * process(const View &view);
    /** an integer from 0 to 100 which describes
       * how good the Maneuver thinks it is to solve 
       * the problem */
    virtual int how_good_am_i(const View &view);
};  

///
class ManeuverA : public Maneuver {
  public:
    ///
    ManeuverA (void);
    //-------------------
    ///
    virtual void init (void);
    /// returns NULL iff maneuver is finished
    virtual Input * process(const View &view);
    /** an integer from 0 to 100 which describes
       * how good the Maneuver thinks it is to solve 
       * the problem */
    virtual int how_good_am_i(const View &view);  
};

///
class ManeuverB : public Maneuver {
  public:
    ///
    ManeuverB (void);
    //-------------------
    ///
    virtual void init (void);
    /// returns NULL iff maneuver is finished
    virtual Input * process(const View &view);
    /** an integer from 0 to 100 which describes
       * how good the Maneuver thinks it is to solve 
       * the problem */
    virtual int how_good_am_i(const View &view);  
};

///
class ManeuverC : public Maneuver {
  public:
    ///
    ManeuverC (void);
    //-------------------
    ///
    virtual void init (void);
    /// returns NULL iff maneuver is finished
    virtual Input * process(const View &view);
    /** an integer from 0 to 100 which describes
       * how good the Maneuver thinks it is to solve 
       * the problem */
    virtual int how_good_am_i(const View &view);  
};

///
class CPilot : public Basic_CPilot {
  ///
  Maneuver * current;
  ///
  int nr_of_maneuvers;
  ///
  Maneuver ** maneuver;
  //----------------------
  public:
    ///
    CPilot (void);
    //----------------------
    ///
    virtual Input * process(const View &view);
    ///
    void add (const Maneuver &);
  protected:
    ///
    void init_maneuver (const View &view);
};


//==========================================

class Object;

/// used as a unit to control a Player from top level
class Player {
  // true iff if player is in recorder mode
  bool rec_mode;
  bool running;
  bool stopped;
  Object * object;
  Pilot * pilotsp; /// store old pilot
  PPilot * ppilot;
  RPilot * rpilot;
  String * filename;
  //----------------
  public:
    ///
    Player (const String & name);
    ///
    ~Player (void);
    ///
    void as_recorder (void);
    ///
    void as_player (void);
    ///
    void run (Object * o);
    ///
    void stop (void);
    ///
    bool on (void);
    ///
    void pswitch (Object *o);
    ///
    void update (void);
};


#endif F_PILOT
