// objman.h

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef F_OBJECTMANAGER
#define F_OBJECTMANAGER

#include "objects.h"
#include "objectloc.h"

///
extern Object_Locs objectlocs;

///
class OMdata {
  public:
    ///
    Object * object;
    //------links-----
    /// used by waiting and sleeping lists 
    OMdata * next;
    /// used by working list
    OMdata * wnext;
    ///
    OMdata * wunder;
    ///
    double distance2;
    //-----------------------------
    ///
    OMdata (Object * o);
    //-----------------------------
    ///
    OMdata * touches_bigger (Object * o);
};

/// 
class Stack {
  ///
  const max_elements=50;
  ///
  BSP_Tree ** content[max_elements];
  ///
  int next_free;
  public:
    ///
    Stack (void) { next_free=0; };
    ///
    void push(BSP_Tree ** b);
    ///
    BSP_Tree ** pop (void);
    ///
    bool not_empty (void);
};


/** to add an object * obj to List list, type list.add(obj).
   * then obj will be added to the waiting list. (the object
   * is not copied by that!).
   * Type list.sort() to sort all objects between waiting
   * and sleeping list.
   * a object is contained in exactly 1 (!) of the lists
   * sleeping or waiting */
class Object_Manager {
  public:
    /// pointer to the OMdata of active object 
    OMdata * active;
    /// a working list, 
    OMdata * working;
    ///
    int nr_waiting;
    /// list of solid active objects
    OMdata * waiting;
    /// list of non solid active objects
    OMdata * ns_waiting;
    /// list of inactive solid objects (under not used)
    OMdata * sleeping;    
    /// list of inactive non solid objects (under not used)
    OMdata * ns_sleeping;    
    ///
    bool cockpit_on_screen;
    /// for merging and unmerging
    Stack merged;
    //--------------------
    Object_Manager (void);
    //--------------------
    /// adds an object to waiting list
    void add (Object * o);
    /// adds an object to non solid waiting list
    void ns_add (Object * o);
    /// sorts objects between sleeping and working
    void sort(void);
    /// move sleepers of waiting list to sleeping list
    void move_sleepers (void);
    /// move ns_sleepers of ns_waiting list to ns_sleeping list
    void move_ns_sleepers (void);
    /// move non sleepers of sleeping list to waiting list
    void move_non_sleepers (void);
    /// move non ns_sleepers of ns_sleeping list to ns_waiting list
    void move_non_ns_sleepers (void);
    /// calls for each non sleeping object its pilot
    void process (void);
    /// calculates for each non sleeping object the new velocity (call rocess() before!) 
    void process_velocity (void);
    ///
    void update_objects(void); 
    /// transform to world coordinates
    void to_world (void);
    /// used as input for radars
    Object_Locs save_locs (void);
    ///
    void distance_sort (void);
    /// creates working list from waiting and ns_waiting
    void build_working (void);
    /// draws all non sleeping objects
    void draw (void);
    /// draws cockpit on screen and initializes screen manager
    void draw_cockpit(bool to_draw);
    /// returns Pointer to active object
    Object * active_object(void);
    /// returns Pointer to active view    
    View * active_view(void);
    /// marks object as the active object (this object has to be in waiting list!)
    void mark_as_active(Object &);
    ///
    OMdata * touches_bigger (Object * o);
    /// 
    void collisions (void);
    /// print working list for debugging
    void print (void);
    /// print waiting list for debugging
    void printw (void);
    /// print sleeping list for debugging
    void prints (void);
};

#endif F_OBJECTMANAGER

