// input.h

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef F_INPUT
#define F_INPUT


#define DX 0.5
#define DY 0.5
#define DZ 0.5
#define DAX 0.02
#define DAY 0.02
#define DAZ 0.02
#define DSHAKE 0.02
#define MAX_DSHAKE 0.1


///
const static int nr_of_shifts=20;                   /// number of steps for shake_shift
const static double am_shift=0.1;                /// amplitude of shift
static double shake_shift[nr_of_shifts];   // y-shift which is used for shake 


class Input {
  public:
    ///
    double x,y,z;
    ///
    double anglex,angley,anglez;
    ///
    double t_factor,g_factor;
    ///
    bool shoot;
    ///
    bool shake;
    ///
    unsigned short timer;
    //-----------------
    ///
    Input(void);
    ///
    void clear(void);
    ///
    void shoot_on(void);
    ///
    void stop_shoot(void);
    ///
    void incr(void);
    ///
    void decr(void);
    // the next is used for shake
    // function is executed each time
    /// the keyboard is watched
    void pre(void);
    ///
    void calc(void);
    /// for x
    void incx(void);
    ///
    void decx(void);
    ///
    void stopx(void);
    /// for y
    void incy(void);
    ///
    void decy(void);
    ///
    void stopy(void);
    /// for z
    void incz(void);
    ///
    void decz(void);
    ///
    void stopz(void);
    /// for anglex
    void incax(void);
    ///
    void decax(void);
    ///
    void stopax(void);
    /// for angley
    void incay(void);
    ///
    void decay(void);
    ///
    void stopay(void);
    /// for anglez
    void incaz(void);
    ///
    void decaz(void);
    ///
    void stopaz(void);
};

class Global_Input {
  public:
    ///
    enum {NO=0,F1=1,F2=2,F3=3,F4=4,F5=5,F6=6,F7=7,F8=8,F9=9} special;
    ///
    bool quit;
    ///
    bool cockpit;
    /// in case a ConfigureNotify of the window appeared
    bool con_notify;  
    /// after configure notify, this contains the new width of the window
    int width;    
    /// after configure notify, this contains the new height of the window
    int height;   
    //-----------------------------------
    ///
    General_Input(void);
    ///
    void clear(void);
    ///
    void pre(void);
};

#ifdef JOYSTICK
///
extern void init_joystick(void);
///
extern void calibrate_joystick(void);
#endif 



#endif F_INPUT





