// graphics.h

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifndef F_GRAPHICS
#define F_GRAPHICS

#include <stdlib.h>
#include <String.h>
#include <stdio.h>
#include <stdlib.h>
#include <X11/Xatom.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#include "globals.h"


/*********************************************
  class Graphics
 ********************************************/
class Graphics {
public:
  ///
  Window win;
  ///
  Display *display;
  ///
  Colormap cmap;
  ///
  int height;
  ///
  int width;
  ///
  Pixel *framebuffer;
  ///
  char *win_name;
  ///
  char *icon_name;
private:
  ///
  int screen;
  ///
  GC gc;
  ///
  XShmSegmentInfo shminfo;
  ///
  XImage *image;
  ///
  XSizeHints size_hints;
  ///
  int depth;
  ///
  Visual *visual;
  ///---------------------------
public:
  Graphics (char * wname="Sofie",char *iname="sofie",int wd=320, int ht=200);
  ///
  ~Graphics(void);
  ///---------------------------
private:
  void create_window(void);
  ///
  void map_shared_mem(void);
  ///
  void unmap_shared_mem(void);
public:
  ///
  void update_screen(void);
  ///
  void resize(int w, int h);
  ///bool get_color (unsigned short red, unsigned short green, unsigned short blue , unsigned short &pixel);
  Colormap * get_colormap(void);
};
/********************************************
  END class Graphics
 ********************************************/

#endif F_GRAPHICS
