// graphics.cc

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include "graphics.h"
#include <iostream.h>



///
Graphics::Graphics (char * wname="Sofie",char *iname="sofie",int wd=320, int ht=200) {
  win_name=wname;
  icon_name=iname;
  width  = wd;
  height = ht;
  create_window();
  map_shared_mem();
}


///
Graphics::~Graphics(void) {
  unmap_shared_mem();
  XCloseDisplay(display);
}


///
void Graphics::create_window(void)
{
     XGCValues gc_values;
     char *argv[2];
     XTextProperty w_name_prop, i_name_prop;

     display = XOpenDisplay(NULL);
     if (display == NULL) {
       cout << "Unable to open display.\n";
       exit(-1);
     };


     screen = DefaultScreen(display);


     depth=DefaultDepth(display,screen);
     visual=DefaultVisual(display,screen);

#ifdef HICOLOR // TrueColor 16 bit
     if (depth!=16)
       {
	 cout << "Sofie needs a color depth of 16!\n";
	 cout << "Now the color depth is " << depth << ".\n";
	 exit(-1);
       };     

     if (visual->c_class != TrueColor)
       {
	 cout << "Sofie needs the TrueColor-visual!\n";
	 if (visual->c_class==PseudoColor)
	   cout << "Now you have the PseudoColor-visual.\n";
	 if (visual->c_class==GrayScale)
	   cout << "Now you have the GrayScale-visual.\n";
	 if (visual->c_class==DirectColor)
	   cout << "Now you have the DirectColor-visual.\n";
	 exit(-1);
       };
#else // Pseudo-Color 8 bit
     if (depth!=8)
       {
	 cout << "This Version of Sofie needs a color depth of 8!\n";
	 cout << "Now the color depth is " << depth << ".\n";
	 cout << "(Remark: Sofie is designed to use 16 bit colordepth, see README !\n";
	 exit(-1);
       };     

     if (visual->c_class != PseudoColor)
       {
	 cout << "Sofie needs the PseudeColor-visual!\n";
	 cout << "Best choice: use X with 16 bit depth.\n";
	 exit(-1);
       };
#endif


     win = XCreateSimpleWindow(display, DefaultRootWindow(display),
				 0, 0, width, height, 2,
				 BlackPixel(display, screen),
				 BlackPixel(display, screen));

     XStringListToTextProperty(&win_name, 1, &w_name_prop);
     XStringListToTextProperty(&icon_name, 1, &i_name_prop);

     size_hints.flags = PSize | PMinSize | PMaxSize | PResizeInc;
     size_hints.min_width=50;
     size_hints.max_width=1000;
     size_hints.min_height=50;
     size_hints.max_height=700;
     size_hints.width= width;
     size_hints.height= height;
     size_hints.width_inc=2; // resize only in even steps, because we want scr_half_width
     size_hints.height_inc=2;


     argv[0] = "Sofie";
     argv[1] = NULL;
     XSetWMProperties(display, win, &w_name_prop, &i_name_prop, argv, 1,
                      &size_hints, NULL, NULL);

     XMapWindow(display, win);
     gc_values.graphics_exposures = False;
     gc = XCreateGC(display, win, GCGraphicsExposures, &gc_values);

#ifdef HICOLOR
     cmap=DefaultColormap(display, screen);
#else
     //XFreeColors(display, cmap, (unsigned long *) pinfo.color_lookup, index, 0);
     cmap = XCreateColormap(display, win, visual,AllocNone);
     //     index = alloc_colors(cmap, color_levels,(unsigned long *) pinfo.color_lookup);
     {
       XColor color;      
       color.flags = DoRed | DoGreen | DoBlue;
       for (int red = 0; red < 6; red++)
	 for (int green = 0; green < 7; green++)
	   for (int blue = 0; blue < 6; blue++) {
	     color.red =   (short) (red * 65535 / 5);
	     color.green = (short) (green * 65535 / 6);
	     color.blue =  (short) (blue * 65535 / 5);
	     XAllocColor(display, cmap, &color);
	   };
     XSetWindowColormap(display, win, cmap);
     }
#endif

     /*
     {
       XColor color;
       for (int i=0; i<256;i++) {
	 color.pixel=i;
	 XQueryColor(display,cmap,&color);
	 printf("%d :  %d : %d : %d \n",i,color.red,color.green,color.blue);
       };
       exit(1);
     };
     */
}

/*

int alloc_colors(Colormap colormap, int color_levels, unsigned long *pixels)
}

// only used to get a colormap in PseudeColor/8bit similar to TrueColor
void install_palette(void) 
{
     int color_levels = 6;
     int index, ncolors;
     Colormap cmap;
     Palette_info pinfo;

     ncolors = color_levels * color_levels * color_levels;
     pinfo.rgb_cube_size = color_levels;
     pinfo.color_lookup = wtmalloc(sizeof(*pinfo.color_lookup) * ncolors);

     cmap = DefaultColormap(display, screen);
     index = alloc_colors(cmap, color_levels, 
			  (unsigned long *) pinfo.color_lookup);
     if (index < ncolors) {
     }

     return pinfo;
}


*/

/**
bool get_color (unsigned short red,unsigned short green,unsigned short blue,unsigned short &pixel) {
  XColor color;
  color.red=red;
  color.green=green;
  color.blue=blue;
  color.flags = DoRed | DoGreen | DoBlue;
  bool status;
  status=XAllocColor(display, cmap, &color);
  pixel=color.pixel;
  return status;
}
*/


Colormap * Graphics::get_colormap(void) {
  return &cmap;
};


/// information to MIT-SHM can be found in sofie.html
void Graphics::map_shared_mem(void)
{
     int depth;
     XWindowAttributes win_attributes;
     Status result;

     XGetWindowAttributes(display, DefaultRootWindow(display),&win_attributes);
     depth = win_attributes.depth;
          

     if (!XShmQueryExtension(display)) {
       cout << "Sorry there is no MIT-SHM available !\n";
       exit(-1);
     };

     image = XShmCreateImage(display, visual, depth, ZPixmap, NULL, &shminfo,width, height);
     
     shminfo.shmid = shmget(IPC_PRIVATE,image->bytes_per_line * image->height,IPC_CREAT | 0777);
       
     //image->data = (char *) shmat(shminfo.shmid, 0, 0);
     shminfo.shmaddr = image->data = shmat(shminfo.shmid, 0, 0);
     
     shminfo.readOnly = False;
       
     if (!XShmAttach(display, &shminfo)) {
       cout << "Sorry MIT-SHM failed !\n";
       exit(-1);       
     };

     framebuffer = (Pixel *) image->data;
    
}

/// destroy shared memory XImage
void Graphics::unmap_shared_mem(void) {
    XShmDetach(display, &shminfo);
    XDestroyImage(image);
    shmdt(shminfo.shmaddr);
    shmctl(shminfo.shmid, IPC_RMID, 0);
}


///
void Graphics::update_screen(void)
{
  XShmPutImage(display, win, gc, image, 0, 0, 0, 0,width, height, 0);
  XSync(display, 0);
}

///
void Graphics::resize(int w, int h) {
  if ((width!=w) || (height != h)) {
    width=w;
    height=h;
    unmap_shared_mem(); 
    map_shared_mem();
  };
}





