// globals.h

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/



#ifndef F_GLOBALS
#define F_GLOBALS

#ifdef HICOLOR
///
typedef unsigned short Pixel;  // 16 bit
#else
///
typedef unsigned char Pixel;  // 8 bit
#endif


//#define DEBUG
//#define TEST
//#define SAFE
//#define ACCURATE
//#define COCKPIT_IN_MEMORY



#define EPSILON 1e-7 

#define INFINITY 1e+7

#define VECTOR_PRODUCT(A,B,C) ((A).x=(B).y*(C).z-(B).z*(C).y, (A).y=(B).z*(C).x-(B).x*(C).z, (A).z=(B).x*(C).y-(B).y*(C).x)

#define SCALAR_PRODUCT(A,B) ((A).x*(B).x+(A).y*(B).y+(A).z*(B).z)

#define IS_ZERO(a) (fabs(a)<EPSILON)

#define IS_BIGGER_ZERO(a) (a>=EPSILON)


#endif F_GLOBALS
