// frustrum.h

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifndef F_FRUSTRUM
#define F_FRUSTRUM

#include "points.h"
#include "globals.h"

/// describes viewing frustrum and screen dependent variables
class Frustrum {
  public:
    /// distance of the viewer to the view-plane
    const double distance_to_vp=500;
    /// the real width of the screen, eg. 25cm
    const double screen_w=25;
    /// the real height of the screen, eg. 18.2cm
    const double screen_h=18.2;   
    /// the resolution in x direction, eg. 1024 (not the virtual screen size!)
    const int x_res=1024; 
    /// the resolution in y direction, eg. 768 (not the virtual screen size!)
    const int y_res=768; 
    /// factors which indicate that pixels need not be quadratic (do not change!)
    const double rez_vh_scale=((double)y_res)/((double)x_res)*screen_w/screen_h;
    /// factors which indicate that pixels need not be quadratic (do not change!)
    const double vh_scale=1.0/rez_vh_scale;
    //-----------------------------------------------
    /// 
    int scr_width;
    ///
    int scr_height;
    ///
    int scr_half_width;
    ///
    int scr_half_height;
    //-----------------------------
    ///
    Point over;
    ///
    Point under;
    ///
    Point left;
    ///
    Point right;
    //----------------
    ///
    void init (int width,int height);
    /// true iff sphere around o with radius intersects frustrum
    bool intersects(const Point &o,const double radius);
};


#endif F_FRUSTRUM