// frustrum.cc

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "frustrum.h"
#include "polygon.h" // we only need plane

///
void Frustrum::init (int width,int height) {
  scr_width=width;
  scr_height=height;
  scr_half_width=scr_width>>1;
  scr_half_height=scr_height>>1;
  //-----------------------------
  // now calculate the normals of the frustrum planes
  //              over
  //          e1---------e2
  //          |..........|
  //     left |..........| right
  //          e4---------e3
  //              under
  Point e1(distance_to_vp,scr_half_height,-scr_half_width);
  Point e2(distance_to_vp,scr_half_height,scr_half_width);
  Point e3(distance_to_vp,-scr_half_height,scr_half_width);
  Point e4(distance_to_vp,-scr_half_height,-scr_half_width);
  Point o(0,0,0);
  
  
  // one has to be carefull: normals have to point into the frustrum (not outside)
  Plane plane(o,e1,e2);
  over.init(plane.n);
  over.normalize();
  plane.calc_plane(o,e3,e4);
  under.init(plane.n);
  under.normalize();
  plane.calc_plane(o,e4,e1);
  left.init(plane.n);
  left.normalize();
  plane.calc_plane(o,e2,e3);
  right.init(plane.n);
  right.normalize();
};


bool Frustrum::intersects (const Point &o, const double radius) {
  if (o.x<=-radius) return false; // is behind
  if ((o*over)<=-radius) return false; // to high
  if ((o*under)<=-radius) return false; // to low
  if ((o*left)<=-radius) return false; // to much left
  if ((o*right)<=-radius) return false; // to much right
  return true;  
};