// console.cc

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include "console.h"
#include "graphics.h"
#include <X11/keysym.h>
#include <iostream.h>

///
extern Graphics graphics;


///
Console::Console(void) {
  // init console here
  XSelectInput(graphics.display, graphics.win,
	       KeyPressMask | KeyReleaseMask | ExposureMask |
	       EnterWindowMask | LeaveWindowMask | StructureNotifyMask);
};

///
Console::~Console(void) {
};

///
void Console::set_cockpit(void) {
  ginput.cockpit=true;
};

///
void Console::read(Global_Input &gi) {
  gi=ginput;
};

///
void Console::read(Input &i) {
  i=input;
};

///
void Console::refresh(void) {  
  int count;
  char buffer[20];
  KeySym key;
  XComposeStatus compose;
  XEvent event;
  int n_events;
  
  input.pre();
  ginput.pre();
  
  n_events = XEventsQueued(graphics.display, QueuedAlready);
  
  
  while (n_events--) {
    XNextEvent(graphics.display, &event);
    
    if (event.type == ConfigureNotify) {
      cout << "ConfigureNotify\n";
      ginput.con_notify=true;
      int dw=ginput.width=event.xconfigure.width;
      int dh=ginput.height=event.xconfigure.height;
      graphics.resize(dw,dh);
    };
    
    if (event.type == KeyPress) {
      
      count = XLookupString(&event.xkey, buffer, 20, &key, &compose);
      
      switch (key) {
	
      case XK_Control_L:
	input.shoot_on();
	break;
	
      case XK_KP_1:
	input.decz();
	break;
	
      case XK_KP_3:
	input.incz();
	break;
	
      case XK_KP_7:
	input.incax();
	break;
	
      case XK_KP_9:
	input.decax();
	break;
	
      case XK_KP_2:
	input.decaz();
	break;
	
      case XK_KP_8:
	input.incaz();
	break;
	
      case XK_KP_6:
	input.incay();
	break;
	
      case XK_KP_4:
	input.decay();
	break;
	
      case XK_KP_Subtract:
	input.decy();
	break;
	
      case XK_KP_Add:
	input.incy();
	break;
	
      case XK_a:
	input.incx();
	break;
	
      case XK_y:
	input.decx();
	break;

      case XK_z:
	input.decx();
	break;

      case XK_q:
	ginput.quit=true;
	break;
	
      case XK_s:
	input.shake^=true;
	break;
	
      case XK_c:  // use cockpit or not
	ginput.cockpit^=true;
	break;
	
      case XK_KP_0:
	{
	  input.incr();
	};
      break;
      
      case XK_KP_Enter:
	{
	  input.decr();
	};
      break;
      
      case XK_F1:
	{
	  ginput.special=Global_Input::F1;
	};
      break;
      
      case XK_F2:
	{
	  ginput.special=Global_Input::F2;
	};
      break;
      
      case XK_F3:
	{
	  ginput.special=Global_Input::F3;
	};
      break;
      
      case XK_F4:
	{
	  ginput.special=Global_Input::F4;
	};
      break;
      
      case XK_F5:
	{
	  ginput.special=Global_Input::F5;
	};
      break;
      
      case XK_F6:
	{
	  ginput.special=Global_Input::F6;
	};
      break;
      
      case XK_F7:
	{
	  ginput.special=Global_Input::F7;
	};
      break;
      
      case XK_F8:
	{
	  ginput.special=Global_Input::F8;
	};
      break;
      
      case XK_F9:
	{
	  ginput.special=Global_Input::F9;
	};
      break;
      
      
      default:
	break;
      }
      
    }
    
    if (event.type == KeyRelease) {
      
      count = XLookupString(&event.xkey, buffer, 20, &key, &compose);
      
      switch (key) {

      case XK_Control_L:
	input.stop_shoot();
	break;
      
      case XK_KP_1:
	input.stopz();
	break;
	
      case XK_KP_3:
	input.stopz();
	break;
	
      case XK_KP_7:
	input.stopax();
	break;
	
      case XK_KP_9:
	input.stopax();
	break;
	
      case XK_KP_2:
	input.stopaz();
	break;
	
      case XK_KP_8:
	input.stopaz();
	break;
	
      case XK_KP_6:
	input.stopay();
	break;
	
      case XK_KP_4:
	input.stopay();
	break;
	
      case XK_KP_Subtract:
	input.stopy();
	break;
	
      case XK_KP_Add:
	input.stopy();
	break;
	
      case XK_a:
	input.stopx();
	break;
	
      case XK_y:
	input.stopx();
	break;

      case XK_z:
	input.stopx();
	break;

	
      case XK_w:
	cout << "t_factor=" << input.t_factor << " , g_factor=" <<  input.g_factor << "\n";
	break;
	
      default:
	break;
      }
      
      
    }
    
  }
  input.calc();
};


