// cockpit.h

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef F_COCKPIT
#define F_COCKPIT

#include "texture.h"
#include "scrman.h"
#include "objects.h"
#include "radar.h"



/** a cockpit is a great idea, to reduce the amount of pixels, which have to be drawn
   * on the screen */
class Cockpit {
  public:
    //bool on_screen;  // is the cockpit visible on screen ? (yes==true)
    ///
    bool in_memory;     // is the cockpit-texture loaded ?
    ///
    bool keep_in_memory;
    //-----------for radar------
    ///
    Regex * friends;    
    ///
    Regex * not_moving_enemies;    
    ///
    float fradar_x;
    ///
    float fradar_y;
    ///
    float fradar_size;
    ///
    int radar_x;
    ///
    int radar_y;
    ///
    int radar_size;
    //-----------for powerdisplay------
    ///
    float fpowerdisplay_x;
    ///
    float fpowerdisplay_y;
    ///
    float fpowerdisplay_size_x;
    ///
    float fpowerdisplay_size_y;
    ///
    int powerdisplay_x;
    ///
    int powerdisplay_y;
    ///
    int powerdisplay_size_x;
    ///
    int powerdisplay_size_y;
    //-----------for speeddisplay------
    ///
    float fspeeddisplay_x;
    ///
    float fspeeddisplay_y;
    ///
    float fspeeddisplay_size_x;
    ///
    float fspeeddisplay_size_y;
    ///
    int speeddisplay_x;
    ///
    int speeddisplay_y;
    ///
    int speeddisplay_size_x;
    ///
    int speeddisplay_size_y;
    //-----------------------------
    ///
    Texture cockpit;
    ///
    Pixel blend_out;
    ///
    Screen_Manager sm;
    ///
    char * name;
    //-------------------
    ///
    Cockpit (void);
    ///
    Cockpit (char * filename, Pixel bo);
    ///
    ~Cockpit (void);
    /// true iff in_memory and of the right size
    bool is_ok(void);
    ///
    void load(void);
    ///
    void draw(void);
    ///
    void set_radar(void);
    ///
    void draw_radar(Radar &, String * stid=NULL);
    ///
    void set_powerdisplay(void);
    ///
    void draw_powerdisplay(float p);
    ///
    void set_speeddisplay(void);
    ///
    void draw_speeddisplay(float p);
    /// unload cockpit-texture
    void del(void);
};

#endif F_COCKPIT
