// bsp.h

/*
   Sofie, a real time 3d engine / Copyright (C) 1997 Stephan Schiessling
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/



#ifndef F_BSP
#define F_BSP

#include "polygon.h"



/** Class to implement a BSP_tree.
* BSP is an abbreviation of binary space partitioning.*/
class BSP_Tree : public Polygon_List {
public:
  /// front leaf of BSP_Tree
  BSP_Tree * front;
  /// back leaf of BSP_Tree
  BSP_Tree * back;
  //----------------------
  /// constructor creates an empty BSP tree
  BSP_Tree (void);
  /// constructor creates an BSP tree from a Polygon_List
  BSP_Tree (const Polygon_List *);
  /// a virtual constructor
  virtual Polygon_List * new_Polygon_List(void); 
  /// a virtual constructor 
  virtual Polygon_List * new_Polygon_List(const Polygon_List *);
  /// copies other polygon list into this polygon list  
  void copy (BSP_Tree *);
  /// produces a copy of this object
  virtual Polygon_List * clone (void);
  /** given a list of polygons, this function calculates a BSP tree for that;
     * 2 Tpoint_Sets are needed to registrate polygon points of splitted parts;
     * plane_d of each polygon has to be calculated for relative coordinates
     * before this methode is called !!! */
  virtual void build (void);
  /// 
  BSP_Tree ** merge (BSP_Tree * other,Point * o);
  /// draws the BSP tree, ie. the polygons of which the tree consists
  virtual void draw(View *v=NULL); // here v is used!  
  // only for debugging
  /// registrate the vertices and direction vectors of the each polygon in Polygon_List
  virtual void registrate_points(TPoint_Set &,TPoint_Set &);
  void print(void);
  // is needed for print
  void sub_print(void); // should be private
};

#endif F_BSP
