/* --------------------------------- stick.h -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Common joystick definitions.
*/

#define HAT		0x0001		/* only on A */
#define THROTTLE	0x0002		/* only on A */
#define THTDOWN		0x0004		/* only on A */
#define FOURBUTTONS	0x0008		/* only on A: 4 analog buttons */
#define ZEROBUTTONS	0x0010		/* only on A: no analog buttons */
#define READA3		0x0020		/* only on A */
#define USELOG		0x0040		/* log scale on x/y (default) */
#define CHPRO		0x0080		/* CH Pro */
#define USETIMER	0x1000		/* msdos/mswin: read h'ware timer */
#define USEGAME		0x2000		/* Linux: use <game.h> */
#define USEGP		0x4000		/* unix: use GP */
#define CALIBRATED	0x8000

#define JS_X1	0x01
#define JS_Y1	0x02
#define JS_X2	0x04
#define JS_Y2	0x08

struct stick {
	Ushort	a[4];
	Ushort	b[4];
};
typedef struct stick	STICK;

extern int	FAR initstick (int which, char *options, int opts);
extern int	FAR termstick (int which, int opts);
extern Uint	FAR readstick (int which, STICK *s, int mask, int opts);
