/****************************************************************/
/* code copyright 1995-1996 Andrew Johnson - ALL RIGHTS RESERVED*/
/*                          ajohnson@eecs.uic.edu               */
/*                                                              */
/*                      Electronic Visualization Lab (M/C 154)  */
/*                      University of Illinois at Chicago       */
/*                      851 South Morgan St. Room 1120 SEO      */
/*                      Chicago, IL 60607-7053                  */
/*                                                              */
/*                      (312) 996-3002     (312) 413-7585 FAX   */
/***********************************************************************/
/* graphics.c v 1.2                                                    */
/* high level graphics routines for battalion                          */
/***********************************************************************/

#include "battalion.h"

    /*************/
    /* colours   */
    /*************/

    float colorolive[4]	    	= {0,    0.34,  0.0,  0.0};
    float planeGreen[4]	    	= {0.21, 0.49,  0.0,  0.0};
    float planeGreen2[4]    	= {0.25, 0.60,  0.0,  0.0}; 
    float planeGreen3[4]    	= {0.10, 0.25,  0.0,  0.0}; 

    float colorgreen[4]	    	= {0.0,  0.9,  0.1,  0.0};
    float colorblack[4]	    	= {0.0,  0.0,  0.0,  0.95};
    float colorred[4]	    	= {0.98, 0.17, 0.0,  0.7};
    float colorred2[4]	    	= {1.0,  0.0,  0.0,  0.0};
    float colorred3[4]	   	= {0.5,  0.08, 0.0,  0.7};
    float colormaserblue[4] 	= {0.3,  0.7,  1.0,  0.75};
    float colormaserblue2[4]	= {0.0,  1.0,  1.0,  0.75};
    float colorwhite[4]	    	= {1.0,  1.0,  1.0,  0.2};
    float colorwhite2[4]    	= {1.0,  1.0,  1.0,  0.4};
    float colorsnow[4]	    	= {0.8,  0.8,  0.9,  0.4};
    float colorsnow2[4]	    	= {0.7,  0.7,  0.8,  0.4};
/*    float colorsnow3[4]	    	= {0.6,  0.6,  0.7,  0.4}; */
    float colorgrey1[4]	    	= {0.5,  0.5,  0.5,  0.8};
    float colorgrey2[4]	    	= {0.7,  0.7,  0.7,  0.0};
    float colorgrey3[4]	    	= {0.6,  0.6,  0.6,  0.0};
    float colorgrey4[4]	    	= {0.55, 0.55, 0.55, 0.0};
    float colorbrown[4]	    	= {0.75, 0.33, 0.0,  0.8};
    float colorbeige[4]	    	= {0.75, 0.75, 0.5,  0.7};
    float colorblue[4]	    	= {0.0,  0.0,  1.0,  0.6};
    float colorwater[4]	    	= {0.0,  0.25, 0.5,  0.0};
    float colorsnowvapour[4]	= {0.3,  0.3,  1.0,  0.4};
    float coloryellow[4]    	= {1.0,  1.0,  0.0,  0.0};
    float colormaseryellow[4]	= {1.0,  0.7,  0.0,  0.0};
    float colororange[4]    	= {1.0,  0.7,  0.0,  0.0};

    float healthGreen[4]    	= {0.21, 0.49, 0.0,  0.0}; 

    float treeColor[4] 		= {0.03, 0.34, 0.025, 0};
    float treeColor2[4] 	= {0.05, 0.4,  0.025, 0};
    
    /*************/
    /* objects   */
    /*************/

    GLuint 
	plaintank, slagtank, masertank, slagmasertank,  
	launchertank, slaglaunchertank, helo, slagHelo, 
	bigRotor, smallRotor, propeller,  

	airplaneBody, fighterBody,  
    
	monsterleg, monsterHead, monsterTail, monsterBody, 
	flutterHead,  
	techsBody, techsHead, techsShadow, 
	
	watershellObj, heroshellObj,  

	tankShadow, planeShadow, fighterShadow, 

	flutterShadow, flutterBody, flutterXMas, 
	flutterWing1, flutterWing2, 

	planeDotsObj, 
    
	shellObj, shell2Obj, 
 
	titleObj,
	lowDPlane, highDPlane, bigPlane, 
		
	roundTreeShadow,   

	boom1Obj, boom2Obj, boom3Obj, boom4Obj, boom5Obj, 
	boom6Obj, boom7Obj, boom8Obj, boom9Obj, boom10Obj, 
	
	strip1Obj, strip2Obj, strip3Obj, 
    
	powerTower, coolingTower, 
	genericWindows, 
 
	building1Obj, building2Obj, building7Obj, building9Obj,  
	building10Obj, building12Obj, building14Obj, building19Obj,  
	building20Obj, building21Obj, building31Obj, building32Obj,  
	building5Obj;


    /***************************/
    /* texture mapping stuff   */
    /***************************/

    GLuint leftScreen, rightScreen;

    char picleft[32400], picright[32400]; /* 180 x 180 tmap arrays*/
					  /* only 128 x 128 in use now */
    char textline[80];

    GLuint strokeBase;
    
    struct road roadsOnPlane[MAXROADSONPLANE];

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* create the objects to be used in the game                     */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void makeObjects(char * dataPath)
    {
    int width = 128,  height = 128;
    register int x, y;
    FILE * imageFilel, *imageFiler;
    char fullPath[MAXPATH];
    int arrayLoc;

    /*****************************/
    /* load in drive-in textures */
    /*****************************/

    strcpy(fullPath, dataPath);
    strcat(fullPath, "screenleft");
    imageFilel = fopen(fullPath, "r");

    strcpy(fullPath, dataPath);
    strcat(fullPath, "screenright");
    imageFiler = fopen(fullPath, "r");

    if ((imageFilel == NULL) || (imageFiler == NULL))
	showError("Cannot find screenleft and screenright files in data directory");
    else
	{	    
	for (y = 0; y < height; y++)
	    for (x = 0; x < width; x++)
		    {
		    arrayLoc = (height-1-y) * width + (width-1-x);
		    picleft[arrayLoc]	= (char) fgetc(imageFilel);
		    picright[arrayLoc]	= (char) fgetc(imageFiler);
		    }
		    
	leftScreen = glGenLists(1);		    
	glNewList(leftScreen, GL_COMPILE);
	
	    glTexImage2D(GL_TEXTURE_2D, 0, 1, width, height, 0, GL_LUMINANCE, GL_UNSIGNED_BYTE, (const GLvoid *) picleft);
    
	    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
	    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	    glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	glEndList();
	
	rightScreen = glGenLists(1);			    
	glNewList(rightScreen, GL_COMPILE);
	
	    glTexImage2D(GL_TEXTURE_2D, 0, 1, width, height, 0, GL_LUMINANCE, GL_UNSIGNED_BYTE, picright);
    
	    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
	    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	    glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	glEndList();
	
	fclose(imageFilel);
	fclose(imageFiler);

	}

    /********************/
    /* make the objects */
    /********************/

    plaintank	    = makeTank();
    slagtank	    = makeSlagTank();
    masertank	    = makeMaserTank();
    slagmasertank   = makeSlagMaserTank();
    launchertank	= makeLauncherTank();
    slaglaunchertank	= makeSlagLauncherTank();
    helo	    = makeHelo();
    slagHelo	    = makeSlagHelo();
    bigRotor	    = makeBigRotor();
    smallRotor	    = makeSmallRotor();
    propeller	    = makePropeller();
    
    monsterleg	    = makeLeg();
    monsterHead	    = makeHead();
    monsterTail	    = makeTail();
    monsterBody	    = makeBody();
    flutterHead	    = makeFlutterHead();
    techsBody	    = makeTechsBody();
    techsHead	    = makeTechsHead();
    techsShadow	    = makeTechsShadow();

    tankShadow	    = makeTankShadow();
    planeShadow	    = makePlaneShadow();
    fighterShadow   = makeFighterShadow();
 
    shellObj	    = glGenLists(1);     
    shell2Obj	    = makeshell2();
    heroshellObj    = makeHeroShell();
    watershellObj   = makeWaterShell();

    titleObj	    = makeTitles();
    
    planeDotsObj    = makePlaneDots();

    powerTower      = makePowerTower(); 
    coolingTower    = makeCooling(); 
    genericWindows  = makeGenericWindows(); 

    strip1Obj       = makeStrip1(); 
    strip2Obj       = makeStrip2(); 
    strip3Obj       = makeStrip3(); 

    building1Obj    = makebuilding1(); 
    building2Obj    = makebuilding2();
    building5Obj    = makebuilding5();
    building7Obj    = makebuilding7();
    building9Obj    = makebuilding9();
    building10Obj   = makebuilding10();
    building12Obj   = makebuilding12();
    building14Obj   = makebuilding14();
    building19Obj   = makebuilding19();
    building20Obj   = makebuilding20();
    building31Obj   = makebuilding31();
    building32Obj   = makebuilding32();
    building21Obj   = makebuilding21();

    lowDPlane	    = makeLowDPlane();
    highDPlane	    = makeHighDPlane();
    bigPlane	    = makeBigPlane();

    airplaneBody    = makeAirplaneBody();
    fighterBody     = makeFighterBody();
    flutterShadow   = makeFlutterShadow();
    flutterXMas	    = makeFlutterXMas();
    flutterBody	    = makeFlutterBody();
    flutterWing1    = makeFlutterWing1();
    flutterWing2    = makeFlutterWing2();

    roundTreeShadow = makeRoundTreeShadow();

    makeBooms();

    strokeBase = glGenLists(256);
    if (tkCreateStrokeFont(strokeBase) == GL_FALSE)
	{
	showError("Can't create font");
	exit(1);
	}

    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* create object for tech's shell                                */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeshell2()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);
    
    makerbluecube(0, 0, 0, 0.04, 0.04, 0.04, colorred2);
    
    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* create object for an operational maser tank                   */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeMaserTank()
    {
    GLuint O;
    
    /**********************/
    /* maser tank support */
    /**********************/

    float support1[8][3] = {
	-0.1,  1.8,  -1.3,
	-0.1,  1.2,   0.0,
	 0.1,  1.2,   0.0, 
	 0.1,  1.8,  -1.3,
  	 0.1,  1.8,  -1.7,
	 0.1,  1.2,  -0.4,
	-0.1,  1.2,  -0.4,
	-0.1,  1.8,  -1.7 };

    float support2[8][3] = {
	-0.1,  2.5,  -0.6,
	-0.1,  1.8,  -1.3,
	 0.1,  1.8,  -1.3, 
	 0.1,  2.5,  -0.6,
  	 0.1,  2.5,  -1.0,
	 0.1,  1.8,  -1.7,
	-0.1,  1.8,  -1.7,
	-0.1,  2.5,  -1.0 };


    O = glGenLists(1);
    glNewList(O, GL_COMPILE);
   
    makercubenobtm(-0.8, 0.5,  0.0, 0.5, 0.5, 1.2, colorblue);
    makercubenobtm( 0.8, 0.5,  0.0, 0.5, 0.5, 1.2, colorblue);

    makercubenobtm( 0.0, 1.0,  0.0, 1.1, 0.2, 1.75, colorgrey2);
    makercubenobtm( 0.0, 1.0, -0.5, 0.5, 0.3, 0.5, colorwhite);
    makercube(0.0, 1.5, 1.25,  1.1, 0.3, 0.5, colorgrey3);

    makercube(0.0, 1.5, 1.752, 0.6, 0.1, 0.01, colorblack);

    makercube(0.0, 2.5,  0.0,  0.4, 0.4, 0.1, colorwhite);
    makercube(0.0, 2.5, -0.8,  0.2, 0.2, 0.91, colorblue);

    glColor3fv(colorgrey1);

    glBegin(GL_QUAD_STRIP);
	glVertex3fv(support1[0]);glVertex3fv(support1[1]);glVertex3fv(support1[3]);glVertex3fv(support1[2]);
	glVertex3fv(support1[4]);glVertex3fv(support1[5]); 
	glVertex3fv(support1[7]);glVertex3fv(support1[6]);
	glVertex3fv(support1[0]);glVertex3fv(support1[1]);
    glEnd();

    glBegin(GL_QUAD_STRIP);
	glVertex3fv(support2[0]);glVertex3fv(support2[1]);glVertex3fv(support2[3]);glVertex3fv(support2[2]);
	glVertex3fv(support2[4]);glVertex3fv(support2[5]); 
	glVertex3fv(support2[7]);glVertex3fv(support2[6]);
	glVertex3fv(support2[0]);glVertex3fv(support2[1]);
    glEnd();

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* create object for melting maser tank                          */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeSlagMaserTank()
    {
    GLuint O;

    /**********************/
    /* maser tank support */
    /**********************/

    float support1[8][3] = {
	-0.1,  1.8,  -1.3,
	-0.1,  1.2,   0.0,
	 0.1,  1.2,   0.0, 
	 0.1,  1.8,  -1.3,
  	 0.1,  1.8,  -1.7,
	 0.1,  1.2,  -0.4,
	-0.1,  1.2,  -0.4,
	-0.1,  1.8,  -1.7 };

    float support2[8][3] = {
	-0.1,  2.5,  -0.6,
	-0.1,  1.8,  -1.3,
	 0.1,  1.8,  -1.3, 
	 0.1,  2.5,  -0.6,
  	 0.1,  2.5,  -1.0,
	 0.1,  1.8,  -1.7,
	-0.1,  1.8,  -1.7,
	-0.1,  2.5,  -1.0 };

    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    makercubenobtm( -0.8, 0.5, 0,  0.5,0.5,1.2, colorwhite);
    makercubenobtm(0.8, 0.5 ,0,  0.5,0.5,1.2, colorwhite);

    makercubenobtm(  0, 1, 0,  1.1, 0.2, 1.75, colorwhite);
    makercubenobtm(  0, 1, -.5,  .5, 0.3, .5, colorwhite);
    makercube(0.0, 1.5, 1.25,  1.1, 0.3, 0.5, colorwhite);

    makercube(0.0, 1.5, 1.751, 0.6, 0.1, 0.01, colorwhite);

    makercube(0.0, 2.5,  0.0,  0.4, 0.4, 0.1, colorwhite);
    makercube(0.0, 2.5, -0.8,  0.2, 0.2, 0.91, colorwhite);
    
    glColor3fv(colorwhite);

    glBegin(GL_QUAD_STRIP);
	glVertex3fv(support1[0]);glVertex3fv(support1[1]);glVertex3fv(support1[3]);glVertex3fv(support1[2]);
	glVertex3fv(support1[4]);glVertex3fv(support1[5]); 
	glVertex3fv(support1[7]);glVertex3fv(support1[6]);
	glVertex3fv(support1[0]);glVertex3fv(support1[1]);
    glEnd();

    glBegin(GL_QUAD_STRIP);
	glVertex3fv(support2[0]);glVertex3fv(support2[1]);glVertex3fv(support2[3]);glVertex3fv(support2[2]);
	glVertex3fv(support2[4]);glVertex3fv(support2[5]); 
	glVertex3fv(support2[7]);glVertex3fv(support2[6]);
	glVertex3fv(support2[0]);glVertex3fv(support2[1]);
    glEnd();

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeStrip1()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    drawBuilding15(colorwhite,  colorred);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeStrip2()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    drawBuilding15(colorgrey2,  coloryellow);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeStrip3()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    drawBuilding15(colorbeige,  colorblue);

    glEndList();
    return(O);
    }


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* create object for an operational plain tank                   */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeTank()
    {
    GLuint O;

    /***************/
    /* tank barrel */
    /****************/

    float gun[8][3] = {
	-0.03, 0.280, 0.23,
	-0.03, 0.220, 0.24,
	 0.03, 0.220, 0.24, 
	 0.03, 0.280, 0.23,
  	 0.03, 0.225, 0.09,
	 0.03, 0.165, 0.09,
	-0.03, 0.165, 0.09,
	-0.03, 0.225, 0.09 };

    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    makeitPyr(11, colorgrey2, -0.12, 0.075, 0.0, 0.075, 0.075, 0.18);
    makeitPyr(11, colorgrey2,  0.12, 0.075, 0.0, 0.075, 0.075, 0.18);

    makercubenobtm(0.0, 0.15,  0.0,  0.15, 0.03,  0.225, colorolive);
    makercubenobtm(0.0, 0.195, 0.0,  0.09, 0.045, 0.09,  colorgrey1);

    maker(gun, 0,  0,  0, 1, 1, 1, colorwhite, 1, 0.8, 0.66, 0.5);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeLauncherTank()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    makeitPyr(11, colorgrey2, -0.12, 0.075, 0.0, 0.075, 0.075, 0.18);
    makeitPyr(11, colorgrey2,  0.12, 0.075, 0.0, 0.075, 0.075, 0.18);

    makercubenobtm(0.0, 0.15,  0.0,  0.15, 0.03,  0.225, colorwhite);

    makercube(0.0, 0.26, 0.075,  0.12, 0.01, 0.075,  colorgrey2);

    makercubenobtm(-0.05, 0.2, 0.075,  0.01, 0.07, 0.01,  colorgrey2);
    makercubenobtm(0.05, 0.2, 0.075,  0.01, 0.07, 0.01,  colorgrey2);

    makercube(0.0, 0.28, 0.075,  0.02, 0.02, 0.1,  colorgrey1);
    makercube(-0.05, 0.28, 0.075,  0.02, 0.02, 0.1,  colorgrey1);
    makercube(0.05, 0.28, 0.075,  0.02, 0.02, 0.1,  colorgrey1);
    makercube(-0.1, 0.28, 0.075,  0.02, 0.02, 0.1,  colorgrey1);
    makercube(0.1, 0.28, 0.075,  0.02, 0.02, 0.1,  colorgrey1);

    makercube(0.0, 0.28, 0.05,  0.021, 0.021, 0.02,  colorred);
    makercube(-0.05, 0.28, 0.05,  0.021, 0.021, 0.02,  colorred);
    makercube(0.05, 0.28, 0.05,  0.021, 0.021, 0.02,  colorred);
    makercube(-0.1, 0.28, 0.05,  0.021, 0.021, 0.02,  colorred);
    makercube(0.1, 0.28, 0.05,  0.021, 0.021, 0.02,  colorred);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* create object for melting plain tank                          */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeSlagTank()
    {
    GLuint O;

    /***************/
    /* tank barrel */
    /****************/

    float gun[8][3] = {
	-0.03, 0.280, 0.23,
	-0.03, 0.220, 0.24,
	 0.03, 0.220, 0.24, 
	 0.03, 0.280, 0.23,
  	 0.03, 0.225, 0.09,
	 0.03, 0.165, 0.09,
	-0.03, 0.165, 0.09,
	-0.03, 0.225, 0.09 };

    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);
    
    makeitPyr(11, colorwhite, -0.12, 0.075, 0.0, 0.075, 0.075, 0.18);
    makeitPyr(11, colorwhite,  0.12, 0.075, 0.0, 0.075, 0.075, 0.18);

    makercubenobtm(0.0, 0.15,  0.0,  0.15, 0.03,  0.225, colorwhite);
    makercubenobtm(0.0, 0.195, 0.0,  0.09, 0.045, 0.09,  colorwhite);

    maker(gun, 0,  0,  0, 1, 1, 1, colorwhite, 1, 0.8, 0.66, 0.5);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeSlagLauncherTank()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);
    
    makeitPyr(11, colorwhite, -0.12, 0.075, 0.0, 0.075, 0.075, 0.18);
    makeitPyr(11, colorwhite,  0.12, 0.075, 0.0, 0.075, 0.075, 0.18);

    makercubenobtm(0.0, 0.15,  0.0,  0.15, 0.03,  0.225, colorwhite);

    makercube(0.0, 0.26, 0.075,  0.12, 0.01, 0.075,  colorgrey2);

    makercubenobtm(-0.05, 0.2, 0.075,  0.01, 0.07, 0.01,  colorwhite);
    makercubenobtm(0.05, 0.2, 0.075,  0.01, 0.07, 0.01,  colorwhite);

    makercube(0.0, 0.28, 0.075,  0.02, 0.02, 0.1,  colorwhite);
    makercube(-0.05, 0.28, 0.075,  0.02, 0.02, 0.1,  colorwhite);
    makercube(0.05, 0.28, 0.075,  0.02, 0.02, 0.1,  colorwhite);
    makercube(-0.1, 0.28, 0.075,  0.02, 0.02, 0.1,  colorwhite);
    makercube(0.1, 0.28, 0.075,  0.02, 0.02, 0.1,  colorwhite);

    makercube(0.0, 0.28, 0.05,  0.021, 0.021, 0.02,  colorwhite);
    makercube(-0.05, 0.28, 0.05,  0.021, 0.021, 0.02,  colorwhite);
    makercube(0.05, 0.28, 0.05,  0.021, 0.021, 0.02,  colorwhite);
    makercube(-0.1, 0.28, 0.05,  0.021, 0.021, 0.02,  colorwhite);
    makercube(0.1, 0.28, 0.05,  0.021, 0.021, 0.02,  colorwhite);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw a rectangular shadow on the ground                       */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void shadow (float x, float z, float wx, float wz)
    {
    float v[3];
    v[1] = SHADOWS;

/*    
    glColor4fv(colorblack);
*/

    glBegin(GL_QUADS);
	v[0] = x+wx; v[2] = z+wz;
	glVertex3fv(v);

	v[2] = z-wz;
	glVertex3fv(v);

	v[0] = x-wx;
	glVertex3fv(v);

	v[2] = z+wz;
	glVertex3fv(v);
    glEnd();
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw a  hunter                                                */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void makeCHH(int dam)
    {
    if (dam > 16)
	makercube(-0.15, -0.05, -0.2, 0.07, 0.07, 0.1, colorblue);
    else
	makeitd(0, colorblue,  -0.15, -0.05, -0.2, 0.07, 0.07, 0.1);

    if (dam > 12)
	makercube(0.15, -0.05, -0.2, 0.07, 0.07, .1, colorblue);
    else
	makeitd(1, colorblue, 0.15, -0.05, -0.2, 0.07, 0.07, .1);

    if (dam > 8)
	makercube(0.0, -0.05, 0.1, 0.2, 0.05, 0.1, colorgrey1);
    else
	makeitd(0, colorgrey1,  0.0, -0.05, 0.1, 0.2, 0.05, 0.1);

    if (dam > 4)
	makercube(0.0, -0.05, -0.2, 0.1, 0.05, 0.2, colorgrey1);
    else
	makeitd(1, colorgrey1,  0.0, -0.05, -0.2, 0.1, 0.05, 0.2);

    if (dam > 0)
	makeitPyr(3, colorgrey2,  0.0, +0.05, 0.1, 0.2, 0.05, 0.1);
    else
	makeitPyr(3, colorgrey1,  0.0, +0.05, 0.1, 0.2, 0.05, 0.1);

    makercube( 0.05, -0.1,  0.15, 0.02, 0.01, 0.02, colorwhite);
    makercube(-0.05, -0.1,  0.15, 0.02, 0.01, 0.02, colorwhite);
    makercube( 0.05, -0.1, -0.35, 0.02, 0.01, 0.02, colorwhite);
    makercube(-0.05, -0.1, -0.35, 0.02, 0.01, 0.02, colorwhite);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* create object for an operational helicopter                   */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeHelo()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    makercube(0.0,  0.0,     0.0,    0.1, 0.1,    0.2, colorgrey2);
    makercube(0.0, -0.0375, -0.225,  0.1, 0.0625, 0.025, colorgrey2);

    makercubenobtm( -0.05, +0.0625, -0.2,  0.025, 0.025, 0.025, colorblack);
    makercubenobtm(  0.05, +0.0625, -0.2,  0.025, 0.025, 0.025, colorblack);

    makercube(0.0, 0.0,   0.3, 0.0375, 0.0375, 0.1, colorgrey1);
    makercubenobtmnotop( 0.0, 0.125, 0.0, 0.025,  0.05,   0.025, colorgrey1);

    /**************/
    /* draw skids */
    /**************/

    makercube( 0.075, -0.2, 0.0,  0.025, 0.0125, 0.175, colorwhite);
    makercube(-0.075, -0.2, 0.0,  0.025, 0.0125, 0.175, colorwhite);

    makercubenobtm(  0.075, -0.15, 0.025,  0.0125, 0.05, 0.05, colorgrey1);
    makercubenobtm( -0.075, -0.15, 0.025,  0.0125, 0.05, 0.05, colorgrey1);

    glEndList();
    return(O);
    }
 
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* create object for melting helicopter                          */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeSlagHelo()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);
	
    makercube(0.0,  0.0,     0.0,    0.1, 0.1,    0.2, colorwhite);
    makercube(0.0, -0.0375, -0.225,  0.1, 0.0625, 0.025, colorwhite);

    makercubenobtm( -0.05, +0.0625, -0.2, 0.025, 0.025, 0.025,colorwhite);
    makercubenobtm(  0.05, +0.0625, -0.2, 0.025, 0.025, 0.025, colorwhite);

    makercube(0.0, 0.0,   0.3, 0.0375, 0.0375, 0.1, colorwhite);
    makercubenobtmnotop( 0.0, 0.125, 0.0, 0.025,  0.05,   0.025, colorwhite);

    /**************/
    /* draw skids */
    /**************/

    makercube( 0.075, -0.2, 0.0,  0.025, 0.0125, 0.175, colorwhite);
    makercube(-0.075, -0.2, 0.0,  0.025, 0.0125, 0.175, colorwhite);

    makercubenobtm( 0.075, -0.15, 0.025, 0.0125, 0.05, 0.05, colorwhite);
    makercubenobtm(-0.075, -0.15, 0.025, 0.0125, 0.05, 0.05, colorwhite);

    glEndList();
    return(O);
    }
 
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* create object for main rotor of the helicopters               */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
  
GLuint makeBigRotor()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    makercube(0.0, 0.175, 0.0, 0.025, 0.01, 0.3, colorwhite);
    makercube(0.0, 0.175, 0.0, 0.3,   0.01, 0.025, colorwhite);
    
    glEndList();
    return(O);
    }

 
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* create object for small rotor of the helicopters              */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
  
GLuint makeSmallRotor()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    makercube(0.0, 0.0, 0.0, 0.0025, 0.15, 0.02, colorwhite);
    
    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw a helicopter                                             */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawHelo(float percent,  int slag)
    {
    GLint shadeNow;
    
    glGetIntegerv(GL_SHADE_MODEL, &shadeNow);
    
    /*************/
    /* draw body */
    /*************/

    glShadeModel(GL_FLAT);

    if (!slag)
	glCallList(helo);
    else
	glCallList(slagHelo);
	
    glShadeModel(shadeNow);

    /***************/
    /* draw rotors */
    /***************/

    glPushMatrix();
	glRotatef(-percent, 0, 1, 0);
	glCallList(bigRotor);	
    glPopMatrix();

    /********************/
    /* draw tail rotor  */
    /********************/

    glPushMatrix();
	glTranslatef(0.04,  0,  0.375);
	glRotatef( -percent, 1, 0, 0);
	glCallList(smallRotor);
    glPopMatrix();
	}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* create object for propeller for bomber                        */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
  
GLuint makePropeller()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    makercube(0.0, 0.0, 0.0, 0.005, 0.05, 0.001, colorwhite);
    
    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* make bomber body                                              */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeAirplaneBody()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

	/*************/
	/* draw body */
	/*************/

	makercube(0.0, 0.0, 0.0, 0.03, 0.03, 0.14, colorwhite);

	glPushMatrix();
		glTranslatef(0,  0,  -0.14);
		glRotatef(-90, 1, 0, 0);
		makeitPyr(1, colorwhite, 0.0, 0.08, 0.0, 0.03, 0.08, 0.03);
	glPopMatrix();

	/*************/
	/* draw tail */
	/*************/

	makercube(0.0, 0.07, 0.11, 0.002, 0.04 ,0.02, colorwhite);

	makeitPyr(1, colorwhite, 0.0, 0.03, 0.09, 0.002, 0.08, 0.02);

	/**************/
	/* draw wings */
	/**************/

	makercube(0.0, 0.0, -0.01, 0.16, 0.004, 0.02, colorgrey3);

	glPushMatrix();
		glTranslatef(0,  0,  -0.03);
		glRotatef(-90,1, 0, 0);
		makeitPyr(1, colorgrey2, 0.0, 0.03, 0, 0.16, 0.03, 0.004);
	glPopMatrix();

	makercube(0.0, 0.0, 0.11, 0.08, 0.004, 0.015, colorgrey3);

	glPushMatrix();
		glTranslatef(0,  0,  0.095);
		glRotatef(-90, 1, 0, 0);
		makeitPyr(1, colorgrey2, 0.0, 0.02, 0.0, 0.08, 0.02, 0.004);
	glPopMatrix();
    
    makercube(-0.09, -0.004-0.01, -0.07+0.02, 0.01, 0.01, 0.02, colorgrey1);

    makercube( 0.09, -0.004-0.01, -0.07+0.02, 0.01, 0.01, 0.02, colorgrey1);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* make fighter body                                              */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeFighterBody()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

	/*************/
	/* draw body */
	/*************/

	makercube(0.0, 0.0, 0.0, 0.03, 0.03, 0.14, colorwhite);

	glPushMatrix();
		glTranslatef(0,  0,  -0.14);
		glRotatef(-90, 1, 0, 0);
		makeitPyr(1, colorwhite, 0.0, 0.08, 0.0, 0.03, 0.08, 0.03);
	glPopMatrix();

	/*************/
	/* draw tail */
	/*************/

	glPushMatrix();
		glTranslatef(-0.05, 0.05, 0.11);
		glRotatef(45, 0, 0, 1);
	    makercube(0.0, 0, 0, 0.002, 0.04 ,0.02, colorgrey3);
	glPopMatrix();

	glPushMatrix();
		glTranslatef(0.05, 0.05, 0.11);
		glRotatef(-45, 0, 0, 1);
	    makercube(0.0, 0, 0, 0.002, 0.04 ,0.02, colorgrey3);
	glPopMatrix();


	/**************/
	/* draw wings */
	/**************/

	glPushMatrix();
		glTranslatef(0,  0,  0.03);
		glRotatef(90, 1, 0, 0);
		makeitPyr(1, colorgrey3, 0.0, 0.01, 0, 0.16, 0.085, 0.004);
	glPopMatrix();

	glPushMatrix();
		glTranslatef(0,  0,  0.03);
		glRotatef(-90, 1, 0, 0);
		makeitPyr(1, colorgrey3, 0.0, 0.2, 0, 0.1, 0.04, 0.004);
	glPopMatrix();

    
    makercube(-0.09, -0.004-0.01, 0.02, 0.01, 0.01, 0.04, colorred);

    makercube( 0.09, -0.004-0.01, 0.02, 0.01, 0.01, 0.04, colorred);

    glEndList();
    return(O);
    }
    
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw a bomber                                                 */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawAirplane(int counter)
    {
    float percent;

    percent = counter * 10.0;

    glCallList(airplaneBody);
    
    /*******************/
    /* draw propellers */
    /*******************/

    glPushMatrix();
	glTranslatef(-0.09,  -0.014,  -0.07);
	glRotatef( -percent, 0, 0, 1);
	glCallList(propeller);	
    glPopMatrix();

    glPushMatrix();
	glTranslatef(+0.09,  -0.014,  -0.07);
	glRotatef( -percent, 0, 0, 1);
	glCallList(propeller);	
    glPopMatrix();

    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw a fighter                                                 */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawFighter(void)
    {
    glCallList(fighterBody);    
    }
	
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* create object for Googelon's leg                              */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeLeg()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    makercube( 0.0,   PLANEY+0.2,  0.0,   0.1,  0.2,  0.1,  colorred);
    makercube( 0.0,   PLANEY+0.06, 0.17,  0.1,  0.06, 0.08, colorred);
    makercube( 0.05,  PLANEY+0.05, 0.25,  0.03, 0.04, 0.05, colorwhite);
    makercube(-0.05,  PLANEY+0.05, 0.25,  0.03, 0.04, 0.05, colorwhite);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* create object for Googelon's head                             */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeHead()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);
    
    makercube(0.0, PLANEY+1.15,  0.0,  0.22, 0.15, 0.1, colorred);
    makercube(0.0, PLANEY+1.15, -0.1,  0.1,  0.1,  0.1, colorred);

    /********/
    /* eyes */
    /********/

    makercube( 0.15, PLANEY+1.20, 0.1, 0.06, 0.06, 0.05, colorwhite);
    makercube(-0.15, PLANEY+1.20, 0.1, 0.06, 0.06, 0.05, colorwhite);

    /**********/
    /* pupils */
    /**********/

    makercube( 0.15, PLANEY+1.21, 0.1, 0.03, 0.03, 0.06, colorblack);
    makercube(-0.15, PLANEY+1.21, 0.1, 0.03, 0.03, 0.06, colorblack);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* create object for Googelon's tail                             */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeTail()
    {	
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);
   
    makercube(0.0, PLANEY+0.23, -0.2,   0.1, 0.15, 0.2, colorred);
    makercube(0.0, PLANEY+0.13, -0.35,  0.1, 0.1,  0.15, colorred);
    makeitPyr(2, colorred, 0, PLANEY+0.13, -0.6,  0.1, 0.1, 0.1);

    /****************/
    /* dorsal spine */
    /****************/

    makercubenobtm(0.0, PLANEY+0.4, -0.16, 0.02, 0.06, 0.12, colorwhite);
    makercube(     0.0, PLANEY+0.7, -0.16, 0.02, 0.06, 0.1,  colorwhite);
    
    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* create object for an Googelon's body                          */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeBody()
    {    
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);
    
    makercube(     0.0, PLANEY+0.5, 0.0,  0.2,  0.3, 0.2,  colorred);
    makercubenobtm(0.0, PLANEY+0.9, 0.0,  0.15, 0.2, 0.15, colorred);
   
    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw Googelon                                                 */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawMonster(struct monsterInfo monster, int counter,
		int itsChristmas)
    {    
    float v[4];

    /*********************/
    /* googelon's shadow */
    /*********************/

static    float googShadow1[3] = {0.1, SHADOWS, -0.5};
static    float googShadow2[3] = {0.0, SHADOWS, -0.7};
static    float googShadow3[3] = {-0.1, SHADOWS, -0.5};

    glPushMatrix();

	glRotatef(.1*monster.headHorzRotate, 0, 1, 0);

	/********/
	/* head */
	/********/

	glPushMatrix();
	    glRotatef(.1*monster.headVertRotate, 1, 0, 0);

	    glCallList(monsterHead);
	    	    
	    if (itsChristmas)
		{
		glPushMatrix();
		    glScalef(1.2,  .5,  1.2);
		    glTranslatef(0.0,  PLANEY+1.7,  0.0);
			glColor3fv(colorwhite);
			v[0] = v[1] = v[2] = 0;
			v[3] = .14;
			andysphdraw(v, 4);
		glPopMatrix();
		glPushMatrix();
		    glTranslatef(-0.15,  PLANEY+1.55,  -0.15);
		    glScalef(0.15,  0.2,  0.15);
		    drawClosedCone(colorred, colorred, 1);
		glPopMatrix();

		glPushMatrix();
		    glTranslatef(-0.09,  PLANEY+1.75,  0.04);
		    glRotatef(.1*(1100), 1, 0, 0);
		    glRotatef(.1*(450), 0, 0, 1);
		    glScalef(.04,  .11,  .1);
		    drawClosedCone(colorred, colorred, 1);
		glPopMatrix();

		glColor3fv(colorwhite);
		v[0] = -0.15;
		v[1] = PLANEY+1.6;
		v[2] = 0.1;
		v[3] = 0.05;
		andysphdraw(v, 4);
		}
	    
	glPopMatrix();   

	/********/
	/* body */
	/********/

	glCallList(monsterBody);
    
	/***********************/
	/* legs, feet and toes */
	/***********************/

	glPushMatrix();
	    glTranslatef(0.2,  monster.rot1,  monster.rot2);
	    glCallList(monsterleg);
	    glTranslatef(-0.4,   -2*monster.rot1,  -2*monster.rot2);
	    glCallList(monsterleg);
	glPopMatrix();

	if (!monster.monsterIsDead)
	      {
	      glColor4fv(colorblack);
	      
	      shadow (0.0,   0.0,          0.2, 0.2);
	      shadow (0.2,   monster.rot2, 0.1, 0.15);
	      shadow (-0.2, -monster.rot2, 0.1, 0.15);
	      }

	/********/
	/* tail */
	/********/
    
	    glRotatef(sin(counter * 0.15915)*10, 0, 1, 0); /* 1/(2 * pi) */

	    glCallList(monsterTail);

	    if (itsChristmas)
		{
 		glPushMatrix();
		    glTranslatef(-0.15,  PLANEY+0.85,  -0.45);
		    glScalef(0.15,  0.15,  0.15);
		    drawClosedCone(colorbeige, colorbrown, 1);
		glPopMatrix();
   
		glPushMatrix();
		    glTranslatef(0.0,  PLANEY+0.5,  -0.3);
		    glScalef(1,  1.5,  1);
		    glColor3fv(colorbeige);
		    v[0] = v[1] = v[2] = 0;
		    v[3] = 0.2;
		    andysphdraw(v, 4);
		glPopMatrix();
		}

	    if (!monster.monsterIsDead)
		{
		glColor4fv(colorblack);
		
		shadow (0.0,  -0.25,  0.1,  0.25);

		glColor3fv(colorblack);

		glBegin(GL_TRIANGLES);
		    glVertex3fv(googShadow1);
		    glVertex3fv(googShadow2);
		    glVertex3fv(googShadow3);
		glEnd();
		}

    glPopMatrix();
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* Draw the Vapour                                               */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawVapour(struct monsterInfo monster,  int itsChristmas)
    {
    register int i;
    glPushMatrix();

    glEnable(GL_BLEND);
	
    glRotatef(0.1 * monster.headHorzRotate, 0, 1, 0);
    
    if (monster.monsterIsDead)
	{
	colorwhite2[3] = 1 - monster.deadCount * 0.022;
	glColor4fv(colorwhite2);
	}
    else if (itsChristmas)
	glColor4fv(colorsnowvapour);
    else
	glColor4fv(colorwhite); 
	
    for(i=0; i<MAXTRIBUTES; i++)
	andysphdraw(monster.a[i], 0);

    glDisable(GL_BLEND);

    glPopMatrix();
    } 

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* create object for flutter's head                              */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeFlutterHead()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

	makercube( 0.0,  PLANEY+1.15, 0.05, 0.1,  0.1,  0.05, colorbrown);
	makercube( 0.07, PLANEY+1.23, 0.08, 0.04, 0.04, 0.04, colorwhite);
	makercube(-0.07, PLANEY+1.23, 0.08, 0.04, 0.04, 0.04, colorwhite);
	makercube( 0.07, PLANEY+1.23, 0.11, 0.02, 0.02, 0.02, colorblack);
	makercube(-0.07, PLANEY+1.23, 0.11, 0.02, 0.02, 0.02, colorblack);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeWaterShell()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    makerbluecube(0, 0, 0, 0.02, 0.02, 0.02, colormaserblue2);

    glEndList();
    return(O);
    }


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeHeroShell()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    makerbluecube(0, 0, 0, 0.03, 0.03, 0.03, colormaserblue2);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeTankShadow()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    glColor4fv(colorblack);
    
    shadow (0, 0 ,  0.16,  0.16);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makePlaneShadow()
    {
    GLuint O;

    float p1[3] = {0.12,  SHADOWS, 0.4};
    float p2[3] = {-0.12, SHADOWS, 0.4};
    float p3[3] = {0,     SHADOWS, 0.8};

    float p4[3] = {0.4,   SHADOWS, 0.1};
    float p5[3] = {-0.4,  SHADOWS, 0.1};
    float p6[3] = {0,     SHADOWS, 0.2};
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    glColor4fv(colorblack);
    
    shadow (0, -0.1 ,  0.12,  0.5);
    shadow (0, 0 ,  0.4,  0.1);
    shadow (0, -.5 ,  0.2,  0.05);

    glBegin(GL_TRIANGLES);
	glVertex3fv(p1);
	glVertex3fv(p2);
	glVertex3fv(p3);

	glVertex3fv(p4);
	glVertex3fv(p5);
	glVertex3fv(p6);
    glEnd();

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeFighterShadow()
    {
    GLuint O;

    float p7[3] = {0.2,   SHADOWS, 0.13};
    float p8[3] = {-0.2,  SHADOWS, 0.13};
    float p9[3] = {0,     SHADOWS, 0.33};
 
    float p10[3] = {0,    SHADOWS, -0.33};
    float p11[3] = {-0.33, SHADOWS, 0};
    float p12[3] = {0.33,  SHADOWS, 0};

    float p13[3] = {0.08,  SHADOWS, 0.26};
    float p14[3] = {-0.08, SHADOWS, 0.26};
    float p15[3] = {0,     SHADOWS, 0.54};
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    glColor4fv(colorblack);

    shadow (0, -0.066 ,  0.08,  0.33);
    shadow (0, -.33 ,  0.13,  0.033); 

    glBegin(GL_TRIANGLES);
	glVertex3fv(p13);
	glVertex3fv(p14);
	glVertex3fv(p15);

	glVertex3fv(p7);
	glVertex3fv(p8);
	glVertex3fv(p9);

	glVertex3fv(p10);
	glVertex3fv(p11);
	glVertex3fv(p12);
    glEnd();
    
    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeFlutterShadow()
    {
    GLuint O;

    /********************/
    /* flutter's shadow */
    /********************/

    float flutshad1[3]	= { 0.1,  SHADOWS, -0.1};   
    float flutshad2[3]	= {-0.1,  SHADOWS, -0.1};   
    float flutshad3[3]	= { 0.1,  SHADOWS,  0.1};   
    float flutshad4[3]	= {-0.1,  SHADOWS,  0.1};   
    float flutshad5[3]	= {   0,  SHADOWS, -0.3};   
    float flutshad6[3]	= {0.25,  SHADOWS,  0.5};   
    float flutshad7[3]	= {0.25,  SHADOWS, -0.5};   
    float flutshad8[3]	= {-0.25, SHADOWS, -0.5};   
    float flutshad9[3]	= {-0.25, SHADOWS,  0.5};   
    float flutshad10[3]	= { 0.5,  SHADOWS,  0.0};   
    float flutshad11[3]	= {-0.5,  SHADOWS,  0.0};   
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    glColor4fv(colorblack);
    
    shadow (0,  0,  0.1,  0.1);

    glBegin(GL_TRIANGLES);
	glVertex3fv(flutshad1);
	glVertex3fv(flutshad5);
	glVertex3fv(flutshad2);

	glVertex3fv(flutshad6);
	glVertex3fv(flutshad10);
	glVertex3fv(flutshad7);

	glVertex3fv(flutshad8);
	glVertex3fv(flutshad11);
	glVertex3fv(flutshad9);
    glEnd();

    glBegin(GL_QUADS);
	glVertex3fv(flutshad3);
	glVertex3fv(flutshad6);
	glVertex3fv(flutshad7);
	glVertex3fv(flutshad1);

	glVertex3fv(flutshad2);
	glVertex3fv(flutshad8);
	glVertex3fv(flutshad9);
	glVertex3fv(flutshad4);
    glEnd();


    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeFlutterXMas()
    {
    float v[4];

    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

		glPushMatrix();
		    glTranslatef(0, PLANEY+1.25, -0.1);
		    glScalef(1.2,  0.45,  1.2);
			glColor3fv(colorwhite);
			v[0] = v[1] = v[2] = 0;
			v[3] = 0.14;
			andysphdraw(v, 4);
		glPopMatrix();

		glPushMatrix();
		    glTranslatef(-0.15,  PLANEY+1.45,  -0.25);
		    glScalef(0.15,  0.2,  0.15);
		    drawClosedCone(healthGreen, healthGreen, 1);
		glPopMatrix();

		glPushMatrix();
		    glTranslatef(-0.09,  PLANEY+1.65,  -0.06);
		    glRotatef(.1*(1100), 1, 0, 0);
		    glRotatef(.1*(450), 0, 0, 1);
		    glScalef(0.04,  0.11,  0.1);
		    drawClosedCone(healthGreen, healthGreen, 1);
		glPopMatrix();

		glColor3fv(colorwhite);
		v[0] = -0.15;
		v[1] = PLANEY+1.50;
		v[2] = -0.0;
		v[3] = 0.05;
		andysphdraw(v, 4);		    

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeFlutterWing1()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    makeitPyr(10, colorbrown, 0.25, 0, 0, 0.15, 0.03, 0.5);
    makeitPyr(7, colorbrown, 0.25, 0, 0, 0.25, 0.03, 0.5);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeFlutterWing2()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    makeitPyr(9, colorbrown, -0.25, 0, 0, 0.15, 0.03, 0.5);
    makeitPyr(8, colorbrown, -0.25, 0, 0, 0.25, 0.03, 0.5);

    glEndList();
    return(O);
    }
 
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeFlutterBody()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

	    makercube(0.0, PLANEY+1.15, 0.0, 0.1, 0.08, 0.1, colorbrown);
	    
	    makeitPyr(2, coloryellow, 0.0, PLANEY+1.15, -0.2, 0.1, 0.1, 0.1);

    glEndList();
    return(O);
    }
   
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw Flutter                                                  */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawFlutter(struct monsterInfo monster,  int counter,  int itsChristmas, float offsetX, int thaView)
    {
    float rotAmt;
    
    rotAmt = sin(counter * 0.3183) * 15;
    
    glPushMatrix();
	glRotatef(0.1 * monster.headHorzRotate, 0, 1, 0);

	/* shadow */
	
	if (!monster.monsterIsDead)
	    {
	    if (thaView == MONSTERVIEW)
		{
		glEnable(GL_BLEND);		    
		glDisable(GL_DEPTH_TEST);
		}
    
	    glCallList(flutterShadow); 
	
	    if (thaView == MONSTERVIEW)
		{
		glDisable(GL_BLEND);		
		glEnable(GL_DEPTH_TEST);
		}
	    }


	glPushMatrix();
	    glRotatef(offsetX * 10, 0, 0, 1);

	    if (itsChristmas)
		glCallList(flutterXMas);		
		
	    glPushMatrix();
		glRotatef(monster.headVertRotate * 0.05, 1, 0, 0);

		glCallList(flutterHead);
	    glPopMatrix();

	    glCallList(flutterBody);
    
	    glTranslatef(0, PLANEY+1.15, 0);

	    glPushMatrix();
		glRotatef(  rotAmt, 0, 0, 1); /* 1/(2 * pi) */
		glCallList(flutterWing1);
	    glPopMatrix();
	    
	    glPushMatrix();
		glRotatef( - rotAmt, 0, 0, 1); /* 1/(2 * pi) */
		glCallList(flutterWing2);
	    glPopMatrix();

	    
	glPopMatrix();
	
    glPopMatrix();
    } 


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* create object for tech's body                                 */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeTechsBody()
    {
    int sph;
    GLuint O;
    float sp[4];
    
    sph =3;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    glColor3fv(colorgrey1);

    sp[0] = sp[2] = 0;
    sp[1] = PLANEY+ 0.2;
    sp[3] = 0.15;
    andysphdraw(sp, sph);

    makercubenobtm(0, PLANEY+0.6, 0, 0.07, 0.5, 0.07, colorgrey1);

    makercube( 0, PLANEY+0.5, 0, 0.2, 0.05, 0.05, colorgrey3);

    makercube( 0.2,    PLANEY+0.5, 0, 0.03, 0.25, 0.2, colorgrey2);
    makercube( 0.22,  PLANEY+0.5, 0, 0.025, 0.2, 0.15, colorblack);

    makercube(-0.2,   PLANEY+0.5, 0, 0.03, 0.25, 0.2, colorgrey2);
    makercube(-0.22, PLANEY+0.5, 0, 0.025, 0.2, 0.15, colorblack);

    glEndList();
    return(O);
    }
    
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeTechsHead()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

	makercube(0, PLANEY+1.2, 0, 0.15, 0.15, 0.1, colorgrey3);
	makercube(0, PLANEY+1.2, 0.13, 0.06, 0.06, 0.04, colorblack);
	makercube(0, PLANEY+1.2, -0.15, 0.075, 0.11, 0.1, colorgrey2);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeTechsShadow()
    {
    GLuint O;
    GLUquadricObj *qobj;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    glPushMatrix();
	glColor3fv(colorblack);
	glTranslatef(0,  SHADOWS,   0);
	glRotatef(-90, 1, 0, 0);

	qobj = gluNewQuadric();
	gluDisk( qobj, 0.,   0.13, 32, 1);
	gluDeleteQuadric(qobj);

    glPopMatrix();

    glColor4fv(colorblack);
    
    shadow (0,  0,  0.2,  0.05);

    shadow (0.2,   0,  0.03,  0.2);
    shadow (-0.2,  0,  0.03,  0.2);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw Techs                                                    */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawTechs(struct monsterInfo monster)
    {
    glPushMatrix();

    glRotatef(0.1 * monster.headHorzRotate, 0, 1, 0);
 
    if (monster.deadCount < 45)
	{    
	glPushMatrix();
	    glRotatef(0.1 * monster.headVertRotate, 1, 0, 0);
	    glCallList(techsHead);    
	glPopMatrix();   

	glCallList(techsBody);
	}
    
    if (!monster.monsterIsDead)
	{
	glCallList(techsShadow);
	}
	
    glPopMatrix();
		    
    if (monster.deadCount >= 45)
	{
	glPushMatrix();
	    glTranslatef(monster.timeDead * 0.05 + 0.2,  -monster.timeDead * 0.05,   monster.timeDead * 0.05);
	    glRotatef(monster.timeDead*10, 1, 0, 0);
	    glRotatef(monster.timeDead*15, 0, 1, 0);
	    makercube(0.0,    0, 0, 0.03, 0.25, 0.2, colorgrey2);
	    makercube(0.011,  0, 0, 0.02, 0.2, 0.15, colorblack);
	glPopMatrix();

	glPushMatrix();
	    glTranslatef(-monster.timeDead * 0.05 - 0.2,  monster.timeDead * 0.05,   monster.timeDead * 0.05);
	    glRotatef(monster.timeDead*10, 1, 0, 0);
	    glRotatef(monster.timeDead*15, 0, 1, 0);
	    makercube( 0.0,   0, 0, 0.03, 0.25, 0.2, colorgrey2);
	    makercube(-0.011, 0, 0, 0.02, 0.2, 0.15, colorblack);
	glPopMatrix();
	}
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw the energy typhoon hero                                  */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawHeroDude(int power, int counter,
		int mcount, int dCount, int detailOn)
    {
    float spheredat[4];
    int ang;
    int amount, amount2;
    float dam;
    float c1[4], c2[4], c3[4], c4[4], c5[4];
    int sph;
    
    if (detailOn > 0)
	sph=4;
    else
	sph =3;

    c1[3] = c2[3] = c3[3] = c4[3] = c5[3] = 1;
    dam = dCount * 0.075;
    
    c2[0] = colorwhite[0] + dam;
    c2[1] = colorwhite[1] + dam;
    c2[2] = colorwhite[2] + dam;
    
    c1[0] = colorwater[0] + dam;
    c1[1] = colorwater[1] + dam;
    c1[2] = colorwater[2] + dam;

    c3[0] = colorblack[0] + dam;
    c3[1] = colorblack[1] + dam;
    c3[2] = colorblack[2] + dam;

    c4[0] = colorgrey2[0] + dam;
    c4[1] = colorgrey2[1] + dam;
    c4[2] = colorgrey2[2] + dam;

    c5[0] = colorwater[0] + dam;
    c5[1] = colorwater[1] + dam;
    c5[2] = colorwater[2] + dam;

    /********/
    /* head */
    /********/
    
    glPushMatrix();
	    glScalef(0.55,  1,  0.55);  
	    glColor4fv(c4);
	    spheredat[0] = 0;
	    spheredat[1] = PLANEY+1.21;
	    spheredat[2] = 0;
	    spheredat[3] = 0.12;
	    andysphdraw(spheredat, sph);
	    
	    if (power > 8)
		makercube(.06, PLANEY+1.25, .075,  0.03, 0.015, 0.035, c3);
	    else
		makeitd(1, c3, .06, PLANEY+1.25, .075,  0.03, 0.015, 0.035);

	    if (power > 5)	    
		makercube(-.06, PLANEY+1.25, .075,  0.03, 0.015, 0.035, c3);
	    else
		makeitd(0, c3, -.06, PLANEY+1.25, .075,  0.03, 0.015, 0.035);
		
	    if (power > 3)
		makercube(0, PLANEY+1.16, .075,  0.03, 0.014, 0.035, c4);
	    else
		makeitd(1,  c4, 0, PLANEY+1.16, .075,  0.03, 0.014, 0.035);
	    glColor4fv(c5);
	    spheredat[2] = -0.01;
	    andysphdraw(spheredat, sph);
    glPopMatrix();


    /********/
    /* neck */
    /********/
    
    if (power > 10)
	makercube(0, PLANEY+1.075, 0,  0.025, 0.025, 0.025, c2);
    else
	makeitd(1, c2, 0, PLANEY+1.075, 0,  0.025, 0.025, 0.025);
   
    /********/
    /* body */
    /********/
   
    if (power > 15)
	makercube(0, PLANEY+0.95, 0,  0.075, 0.1, 0.055, c1);
    else
	makeitd(0, c1, 0, PLANEY+0.95, 0,  0.075, 0.1, 0.055);
	
    if (power > 20)
	makercube(0, PLANEY+0.75, 0,  0.075, 0.1, 0.055, c2);
    else
	makeitd(0, c2, 0, PLANEY+0.75, 0,  0.075, 0.1, 0.055);
	
    if (power > 25)
	makercube(0, PLANEY+1.01, 0.055,  0.02, 0.05, 0.01, c2);
    else
	makeitd(1, c2, 0, PLANEY+1.01, 0.055,  0.02, 0.05, 0.01);

    /*************/
    /* shoulders */
    /*************/

    if (power > 30)
	makercube(0.075, PLANEY+1.0, 0,  0.075, 0.051, 0.05, c2);
    else
	makeitd(0, c2, 0.075, PLANEY+1.0, 0,  0.075, 0.051, 0.05);
	
    if (power > 35)
	makercube(-0.075, PLANEY+1.0, 0,  0.075, 0.051, 0.05, c2);
    else
	makeitd(1, c2, -0.075, PLANEY+1.0, 0,  0.075, 0.051, 0.05);

    /********/
    /* arms */
    /********/

    if (mcount > 30)
	amount = (40 - mcount) * 9;
    else if (mcount > 10)
	amount = 90;
    else
	amount = mcount * 9;
    
    ang = (int) amount * 10;

    glPushMatrix();
	glRotatef(.1*(-ang), 1, 0, 0);

	if (power > 40)
	    makercube(0.13, PLANEY+0.875, 0,  0.025, 0.125, 0.025, c1);
	else
	    makeitd(1, c1, 0.13, PLANEY+0.875, 0,  0.025, 0.125, 0.025);

	glPushMatrix();
	    glTranslatef(0.13,  PLANEY+0.75,  0);
	
	    if (power > 45)
		makercube(0, -0.09, 0,  0.024, 0.11, 0.024, c2);
	    else
		makeitd(0, c2, 0, -0.09, 0,  0.024, 0.11, 0.024);
	    
	    if (power > 50)
		makercube(0, -0.19, 0,  0.03, 0.03, 0.028, c1);
	    else
		makeitd(1, c1, 0, -0.19, 0,  0.03, 0.03, 0.028);
	glPopMatrix();
    glPopMatrix();
 
    glPushMatrix();
	glRotatef(.1*(-ang), 1, 0, 0);

	if (power > 55)
	    makercube(-0.13, PLANEY+0.875, 0,  0.025, 0.125, 0.025, c1);
	else
	    makeitd(0, c1, -0.13, PLANEY+0.875, 0,  0.025, 0.125, 0.025);
   
	glPushMatrix();
	    glTranslatef(-0.13,  PLANEY+0.75,  0);
	    
	    if (power > 60)
		makercube(0, -0.09, 0,  0.024, 0.11, 0.024, c2);
	    else
		makeitd(0, c2, 0, -0.09, 0,  0.024, 0.11, 0.024);
	    
	    if (power > 65)
		makercube(0, -0.19, 0,  0.03, 0.03, 0.028, c1);
	    else
		makeitd(1, c1, 0, -0.19, 0,  0.03, 0.03, 0.028);
	glPopMatrix();
    glPopMatrix();
    
    /********/
    /* legs */
    /********/

    amount = (counter * 100) % 2400;
    if (amount < 1200)
        amount2 = 300 + amount;
    else
        amount2 = 900 + amount;

    ang = (int) (cos(BIG_DEG_TO_RAD * amount2) * RAD_TO_SMALL_DEG * 2.5);

    glPushMatrix();
	glTranslatef(0.04,  PLANEY+0.65,  0);
	glRotatef(.1*(ang ), 1, 0, 0);
	
	if (power > 70)
	    makercube(0, -0.12, 0,  0.035, 0.13, 0.03, c2);
	else
	    makeitd(0, c2, 0, -0.12, 0,  0.035, 0.13, 0.03);
	    
	if (power > 75)	
	    makercube(0, -.35, 0,  0.024, 0.2, 0.029, c1);
	else
	    makeitd(1, c1, 0, -.35, 0,  0.024, 0.2, 0.029);
	    
	if (power > 80)
	    makercube(0, -.59, +0.025,  0.026, 0.04, 0.075, c2);
	else
	    makeitd(0, c2, 0, -.59, +0.025,  0.026, 0.04, 0.075);
    glPopMatrix();
    
    glPushMatrix();
	glTranslatef(-0.04,  PLANEY+0.65,  0);
	glRotatef(.1*(-ang), 1, 0, 0);
	
	if (power > 85)
	    makercube(0, -0.12, 0,  0.035, 0.13, 0.03, c2);
	else
	    makeitd(1, c2, 0, -0.12, 0,  0.035, 0.13, 0.03);
	    
	if (power > 90)
	    makercube(0, -.35, 0,  0.024, 0.2, 0.029, c1);
	else
	    makeitd(0, c1, 0, -.35, 0,  0.024, 0.2, 0.029);
	    
	if (power > 95)
	    makercube(0, -.59, +0.025,  0.026, 0.04, 0.075, c2);
	else
	    makeitd(1, c2, 0, -.59, +0.025,  0.026, 0.04, 0.075);
    glPopMatrix();
    
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw the energy beam hero                                     */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawHeroDude2(int power, int counter,
		    int mcount, int dCount, int detailOn)
    {
    float spheredat[4];
    int ang;
    int amount, amount2;
    float dam;
    float c1[4], c2[4], c3[4], c4[4], c5[4];
    int sph;
    

    if (detailOn > 0)
	sph=4;
    else
	sph=3 ;


    c1[3] = c2[3] = c3[3] = c4[3] = c5[3] = 1;
    dam = dCount * 0.075;

    c1[0] = colorwhite[0] + dam;
    c1[1] = colorwhite[1] + dam;
    c1[2] = colorwhite[2] + dam;
    
    c2[0] = colorred[0] + dam;
    c2[1] = colorred[1] + dam;
    c2[2] = colorred[2] + dam;

    c3[0] = colorblack[0] + dam;
    c3[1] = colorblack[1] + dam;
    c3[2] = colorblack[2] + dam;

    c4[0] = colorgrey2[0] + dam;
    c4[1] = colorgrey2[1] + dam;
    c4[2] = colorgrey2[2] + dam;

    c5[0] = colorred3[0] + dam;
    c5[1] = colorred3[1] + dam;
    c5[2] = colorred3[2] + dam;

    /********/
    /* head */
    /********/
    
    glPushMatrix();
	    glScalef(0.55, 1,   0.55);  
	    glColor4fv(c4);
	    spheredat[0] = 0;
	    spheredat[1] = PLANEY+1.21;
	    spheredat[2] = 0;
	    spheredat[3] = 0.12;
	    andysphdraw(spheredat, sph);
	    
	    if (power > 8)
		makercube(.06, PLANEY+1.25, .075,  0.03, 0.015, 0.035, c3);
	    else
		makeitd(1, c3, .06, PLANEY+1.25, .075,  0.03, 0.015, 0.035);

	    if (power > 5)	    
		makercube(-.06, PLANEY+1.25, .075,  0.03, 0.015, 0.035, c3);
	    else
		makeitd(0, c3, -.06, PLANEY+1.25, .075,  0.03, 0.015, 0.035);
		
	    if (power > 3)
		makercube(0, PLANEY+1.16, .075,  0.03, 0.014, 0.035, c4);
	    else
		makeitd(1,  c4, 0, PLANEY+1.16, .075,  0.03, 0.014, 0.035);
	    glColor4fv(c5);
	    spheredat[2] = -0.01;
	    andysphdraw(spheredat, sph);
    glPopMatrix();

    /********/
    /* neck */
    /********/
    
    if (power > 10)
	makercube(0, PLANEY+1.075, 0,  0.025, 0.025, 0.025, c2);
    else
	makeitd(1, c2, 0, PLANEY+1.075, 0,  0.025, 0.025, 0.025);
   
    /********/
    /* body */
    /********/
   
    if (power > 15)
	makercube(0, PLANEY+0.95, 0,  0.075, 0.1, 0.055, c1);
    else
	makeitd(0, c1, 0, PLANEY+0.95, 0,  0.075, 0.1, 0.055);
	
    if (power > 20)
	makercube(0, PLANEY+0.75, 0,  0.075, 0.1, 0.055, c2);
    else
	makeitd(0, c2, 0, PLANEY+0.75, 0,  0.075, 0.1, 0.055);
	
    if (power > 25)
	makercube(0, PLANEY+1.01, 0.055,  0.02, 0.05, 0.01, c2);
    else
	makeitd(1, c2, 0, PLANEY+1.01, 0.055,  0.02, 0.05, 0.01);

    /*************/
    /* shoulders */
    /*************/

    if (power > 30)
	makercube(0.075, PLANEY+1.0, 0,  0.075, 0.051, 0.05, c2);
    else
	makeitd(0, c2, 0.075, PLANEY+1.0, 0,  0.075, 0.051, 0.05);
	
    if (power > 35)
	makercube(-0.075, PLANEY+1.0, 0,  0.075, 0.051, 0.05, c2);
    else
	makeitd(1, c2, -0.075, PLANEY+1.0, 0,  0.075, 0.051, 0.05);

    /********/
    /* arms */
    /********/

    if (mcount > 30)
	amount = (40 - mcount) * 9;
    else if (mcount > 10)
	amount = 90;
    else
	amount = mcount * 9;
    
    ang = (int) amount * 10;

    if (power > 40)
	makercube(0.13, PLANEY+0.875, 0,  0.025, 0.125, 0.025, c1);
    else
	makeitd(1, c1, 0.13, PLANEY+0.875, 0,  0.025, 0.125, 0.025);

    glPushMatrix();
	glTranslatef(0.13,  PLANEY+0.75,  0);
	
	if (power > 45)
	    makercube(0, -0.09, 0,  0.024, 0.11, 0.024, c2);
	else
	    makeitd(0, c2, 0, -0.09, 0,  0.024, 0.11, 0.024);
	    
	if (power > 50)
	    makercube(0, -0.19, 0,  0.03, 0.03, 0.028, c1);
	else
	    makeitd(1, c1, 0, -0.19, 0,  0.03, 0.03, 0.028);
    glPopMatrix();

 
    glPushMatrix();
	glRotatef(.1*(-ang/2 ), 1, 0, 0);

	if (power > 55)
	    makercube(-0.13, PLANEY+0.875, 0,  0.025, 0.125, 0.025, c1);
	else
	    makeitd(0, c1, -0.13, PLANEY+0.875, 0,  0.025, 0.125, 0.025);
   
	glPushMatrix();
	    glTranslatef(-0.13,  PLANEY+0.75,  0);
	    glRotatef(.1*(ang ), 0, 0, 1);
	    
	    if (power > 60)
		makercube(0, -0.09, 0,  0.024, 0.11, 0.024, c2);
	    else
		makeitd(0, c2, 0, -0.09, 0,  0.024, 0.11, 0.024);
	    
	    if (power > 65)
		makercube(0, -0.19, 0,  0.03, 0.03, 0.028, c1);
	    else
		makeitd(1, c1, 0, -0.19, 0,  0.03, 0.03, 0.028);
	glPopMatrix();
    glPopMatrix();
    
    /********/
    /* legs */
    /********/

    amount = (counter *100) % 2400;
    if (amount < 1200)
        amount2 = 300 + amount;
    else
        amount2 = 900 + amount;

    ang = (int) (cos(BIG_DEG_TO_RAD * amount2) * RAD_TO_SMALL_DEG * 2.5);

    glPushMatrix();
	glTranslatef(0.04,  PLANEY+0.65,  0);
	glRotatef(.1*(ang ), 1, 0, 0);
	
	if (power > 70)
	    makercube(0, -0.12, 0,  0.035, 0.13, 0.03, c2);
	else
	    makeitd(0, c2, 0, -0.12, 0,  0.035, 0.13, 0.03);
	    
	if (power > 75)	
	    makercube(0, -.35, 0,  0.024, 0.2, 0.029, c1);
	else
	    makeitd(1, c1, 0, -.35, 0,  0.024, 0.2, 0.029);
	    
	if (power > 80)
	    makercube(0, -.59, +0.025,  0.026, 0.04, 0.075, c2);
	else
	    makeitd(0, c2, 0, -.59, +0.025,  0.026, 0.04, 0.075);
    glPopMatrix();
    
    glPushMatrix();
	glTranslatef(-0.04,  PLANEY+0.65,  0);
	glRotatef(.1*(-ang), 1, 0, 0);
	
	if (power > 85)
	    makercube(0, -0.12, 0,  0.035, 0.13, 0.03, c2);
	else
	    makeitd(1, c2, 0, -0.12, 0,  0.035, 0.13, 0.03);
	    
	if (power > 90)
	    makercube(0, -.35, 0,  0.024, 0.2, 0.029, c1);
	else
	    makeitd(0, c1, 0, -.35, 0,  0.024, 0.2, 0.029);
	    
	if (power > 95)
	    makercube(0, -.59, +0.025,  0.026, 0.04, 0.075, c2);
	else
	    makeitd(1, c2, 0, -.59, +0.025,  0.026, 0.04, 0.075);
    glPopMatrix();
    
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw MechaGoogelon                                            */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/


void drawMechaMonster(int dam, int counter)
    {
    if (dam > 48)
       makercube(0.2, PLANEY+0.7, 0,  0.05, 0.05, 0.15, colorblue);
    else
       makeitd(1, colorblue, 0.2, PLANEY+0.7, 0,  0.05, 0.05, 0.15);

    if (dam > 45)
       makercube(-0.2, PLANEY+0.7, 0,  0.05, 0.05, 0.15, colorblue);
    else
       makeitd(0, colorblue, -0.2, PLANEY+0.7, 0,  0.05, 0.05, 0.15);

    /**************************/
    /* legs, feet of one side */
    /**************************/

    if (dam > 43)
       makercube(0.2, PLANEY+0.2, 0,  0.12, 0.2, 0.1, colorgrey2);
    else
       makeitd(0, colorgrey2, 0.2, PLANEY+0.2, 0,  0.12, 0.2, 0.1);

    if (dam > 40)
       makercube(0.2, PLANEY+0.06, 0.1,  0.1, 0.06, 0.15, colorwhite);
    else
       makeitd(1, colorwhite, 0.2, PLANEY+0.06, 0.1,  0.1, 0.06, 0.15);

    /****************************/
    /* legs, feet of other side */
    /****************************/

    if (dam > 38)
       makercube(-0.2, PLANEY+0.2, 0,  0.12, 0.2, 0.1, colorgrey2);
    else
        makeitd(1, colorgrey2, -0.2, PLANEY+0.2, 0,  0.12, 0.2, 0.1);

    if (dam > 35)
        makercube(-0.2, PLANEY+0.06, 0.1,  0.1, 0.06, 0.15, colorwhite);
    else
        makeitd(0, colorwhite, -0.2, PLANEY+0.06, 0.1,  0.1, 0.06, 0.15);
  
    /********/
    /* tail */
    /********/

    if (dam > 30)
        {
        makercube(0, PLANEY+0.2, -0.2,  0.1, 0.15, 0.2, colorwhite);
        makercube(0, PLANEY+0.1, -0.4,  0.08, 0.1, 0.2, colorgrey2);
        }
    else
        {
        makeitd(0, colorwhite, 0, PLANEY+0.2, -0.2,  0.1, 0.15, 0.2);
        makeitd(1, colorgrey2, 0, PLANEY+0.1, -0.4,  0.08, 0.1, 0.2);
        }

    glColor4fv(colorblack);
    
    shadow (0,  -0.2,  0.1,  0.2);
    shadow (0,  -0.4,  0.08,  0.2);
    
    /********/
    /* head */
    /********/

    if (dam > 26)
        makercube(0, PLANEY + 1.15, 0,  0.25, 0.15, 0.12, colorwhite);
    else
        makeitd(0, colorwhite, 0, PLANEY + 1.15, 0,  0.25, 0.15, 0.12);

    makeitPyr(2, colorwhite, 0, PLANEY + 1.15, -.24,  0.25, 0.15, 0.12);

    if (dam > 22)
        makercube(0, PLANEY + 1.15, -0.24,  0.13, 0.08, 0.1, colorgrey2);
    else
        makeitd(1, colorgrey2, 0, PLANEY + 1.15, -0.24,  0.13, 0.08, 0.1);

    /*******/
    /* eye */
    /*******/

    if (dam > 18)
        makercube(0, PLANEY + 1.20, 0.1, 0.15, 0.06, 0.05, colorblack);
    else
        makeitd(1, colorblack,  0, PLANEY + 1.20, 0.1, 0.15, 0.06, 0.05);

    if (dam > 14)
       makercube(sin((counter % 20) * 0.314) * 0.14, PLANEY + 1.20, 0.14,  0.04, 0.04, 0.04, colorred);
    else
       makeitd(0, colorred, sin((counter % 20) * 0.314) * 0.14, PLANEY + 1.20, 0.14,  0.04, 0.04, 0.04);

    /********/
    /* body */
    /********/

    if (dam > 10)
       makercube(0, PLANEY + 0.9, 0,  0.1, 0.2, 0.1, colorgrey2);
    else
       makeitd(0, colorgrey2, 0, PLANEY + 0.9, 0,  0.1, 0.2, 0.1);


    if (dam > 5)
       makercube(0, PLANEY + 0.5, 0.2, 0.1, 0.15, 0.05, colorgrey1);
    else
       makeitd(1, colorgrey1, 0, PLANEY + 0.5, 0.2, 0.1, 0.15, 0.05);


    if (dam > 0)
       makercube(0, PLANEY + 0.5, 0, 0.2, 0.3, 0.2, colorwhite);
    else
       makeitd(0, colorwhite, 0, PLANEY + 0.5, 0, 0.2, 0.3, 0.2);

    glColor4fv(colorblack);
    
    shadow (0,  0,  0.2,  0.2);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw a window on the negative z side of a building            */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void wzminus(float x,  float y,  float z,  float wx,  float wy)
    {
    float v[3];

    v[2] = z;

/*    
    glColor3fv(colorblack);
*/
    
    glBegin(GL_QUADS);
	v[0] = x-wx; v[1] = y-wy;   
	glVertex3fv(v);

	v[1] = y+wy;
	glVertex3fv(v);

	v[0] = x+wx;
	glVertex3fv(v);

	v[1] = y-wy;
	glVertex3fv(v);
    glEnd();
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw a window on the positive z side of a building            */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
   
void wzplus(float x,  float y,  float z,  float wx,  float wy)
    {
    float v[3];

    v[2] = z;

/*    
    glColor3fv(colorblack);
*/

    glBegin(GL_QUADS);
	v[0] = x+wx; v[1] = y-wy;
	glVertex3fv(v);

	v[1] = y+wy;
	glVertex3fv(v);

	v[0] = x-wx;
	glVertex3fv(v);

	v[1] = y-wy;
	glVertex3fv(v);
    glEnd();
    }
 
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw a window on the positive x side of a building            */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void wxplus(float x,  float y,  float z,  float wy,  float wz)
    {
    float v[3];

    v[0] = x;
    
/*
    glColor3fv(colorblack);
*/
    glBegin(GL_QUADS);
	v[1] = y+wy;   v[2] = z-wz;
	glVertex3fv(v);

	v[2] = z+wz;
	glVertex3fv(v);

	v[1] = y-wy;
	glVertex3fv(v);

	v[2] = z-wz;
	glVertex3fv(v);
    glEnd();
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw a window on the negative x side of a building            */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void wxminus(float x,  float y,  float z,  float wy,  float wz)
    {
    float v[3];

    v[0] = x;

/*    
    glColor3fv(colorblack);
*/
    glBegin(GL_QUADS);
	v[1] = y-wy;   v[2] = z-wz;
	glVertex3fv(v);

	v[2] = z+wz;
	glVertex3fv(v);

	v[1] = y+wy;
	glVertex3fv(v);

	v[2] = z-wz;
	glVertex3fv(v);
    glEnd();
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw intact power line tower                                  */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makePowerTower()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    drawTower(0, 0);
        
    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw cooling tower                                            */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeCooling()
    {
    GLuint O;
    GLUquadricObj *qobj;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    
    glPushMatrix();
	glTranslatef(-0.3,  0.5,  -0.3);
	glScalef(0.3,  0.5,  0.3);
	drawClosedCylinder(colorgrey3,  colorwhite,  0, 1);
    glPopMatrix();

    glPushMatrix();
	glColor3fv(colorblack);
	glTranslatef(0.0,  0.9,  0.0);
	glRotatef(-90, 1, 0, 0);
	
	qobj = gluNewQuadric();
	gluDisk( qobj, 0.,  0.28, 32, 1);
	gluDeleteQuadric(qobj);

    glPopMatrix();
    
    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeGenericWindows()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    glColor3fv(colorblack);
    
    wzminus(-0.15, 0.6,  -0.303,  0.05,  0.1);
    wzminus( 0.0,  0.6,  -0.303,  0.05,  0.1);
    wzminus( 0.15, 0.6,  -0.303,  0.05,  0.1);
    wzminus(-0.15, 0.3,  -0.303,  0.05,  0.1);
    wzminus( 0.0,  0.3,  -0.303,  0.05,  0.1);
    wzminus( 0.15, 0.3,  -0.303,  0.05,  0.1);

    wzplus(-0.15, 0.6,  0.303,  0.05,  0.1);
    wzplus( 0.0,  0.6,  0.303,  0.05,  0.1);
    wzplus(-0.15, 0.3,  0.303,  0.05,  0.1);
    wzplus( 0.0,  0.3,  0.303,  0.05,  0.1);

    wxplus( 0.303,  0.6,  -0.15, 0.1, 0.05);
    wxplus( 0.303,  0.6,   0.0,  0.1, 0.05);
    wxplus( 0.303,  0.6,   0.15, 0.1, 0.05);

    wxminus(-0.303, 0.6,  -0.15, 0.1, 0.05);
    wxminus(-0.303, 0.6,   0.0,  0.1, 0.05);
    wxminus(-0.303, 0.6,   0.15, 0.1, 0.05);
    
    
    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw generic square building                                  */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawBuilding0(float * colour)
    {
    makercubenobtm(0.0, 0.4, 0.0, 0.3, 0.4, 0.3, colour);
    glCallList(genericWindows);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw high-rise building                                       */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makebuilding1()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);
    
    makercubenobtmnotop(  0,  .7, 0,  .3, .7, .3, colorwhite);
    makercubenobtm(  0,  1.5, 0,  .3, .1, .3, colorgrey1);

    glColor3fv(colorblack);
    
    wzminus(-0.15, 1.2,  -0.303,  0.05,  0.1);
    wzminus( 0.0,  1.2,  -0.303,  0.05,  0.1);
    wzminus( 0.15, 1.2,  -0.303,  0.05,  0.1);
    wzminus(-0.15, 0.9,  -0.303,  0.05,  0.1);
    wzminus( 0.0,  0.9,  -0.303,  0.05,  0.1);
    wzminus( 0.15, 0.9,  -0.303,  0.05,  0.1);
    wzminus(-0.15, 0.6,  -0.303,  0.05,  0.1);
    wzminus( 0.0,  0.6,  -0.303,  0.05,  0.1);
    wzminus( 0.15, 0.6,  -0.303,  0.05,  0.1);
    wzminus(-0.15, 0.3,  -0.303,  0.05,  0.1);
    wzminus( 0.0,  0.3,  -0.303,  0.05,  0.1);
    wzminus( 0.15, 0.3,  -0.303,  0.05,  0.1);

    wzplus(-0.15, 1.2,  0.303,  0.05,  0.1);
    wzplus( 0.0,  1.2,  0.303,  0.05,  0.1);
    wzplus( 0.15, 1.2,  0.303,  0.05,  0.1);
    wzplus(-.15,  0.9,  0.303,  0.05,  0.1);
    wzplus( 0.0,  0.9,  0.303,  0.05,  0.1);
    wzplus( 0.15, 0.9,  0.303,  0.05,  0.1);
    wzplus(-0.15, 0.6,  0.303,  0.05,  0.1);
    wzplus( 0.0,  0.6,  0.303,  0.05,  0.1);
    wzplus( 0.15, 0.6,  0.303,  0.05,  0.1);
    wzplus(-0.15, 0.3,  0.303,  0.05,  0.1);
    wzplus( 0.0,  0.3,  0.303,  0.05,  0.1);
    wzplus( 0.15, 0.3,  0.303,  0.05,  0.1);

    wxplus(0.303,  0.6,  -0.15,  0.1,  0.05);
    wxplus(0.303,  0.3,  -0.15,  0.1,  0.05);

    wxminus(-0.303,  0.6,  -0.15, 0.1,  0.05);
    wxminus(-0.303,  0.6,   0.0,  0.1,  0.05);
    wxminus(-0.303,  0.3,  -0.15, 0.1,  0.05);
    wxminus(-0.303,  0.3,   0.0,  0.1,  0.05);
    
    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw generic beige building                                   */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
   
GLuint makebuilding2()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);
    
    
    makercubenobtm(  0.0,  0.4, 0.0,  0.3, 0.4, 0.3, colorbeige);

    glColor3fv(colorblack);
    
    wzminus(-0.15, 0.6, -0.303,  0.05,  0.15);
    wzminus( 0.0,  0.6, -0.303,  0.05,  0.15);
    wzminus( 0.15, 0.6, -0.303,  0.05,  0.15);

    wzplus(-0.15,  0.6,  0.303,  0.05,  0.15);
    wzplus( 0.0,   0.6,  0.303,  0.05,  0.15);
    wzplus( 0.15,  0.6,  0.303,  0.05,  0.15);

    wxplus( 0.303, 0.6,  -0.15,  0.15,  0.05);
    wxplus( 0.303, 0.6,   0.0,   0.15,  0.05);
    wxplus( 0.303, 0.6,   0.15,  0.15,  0.05);

    wxminus(-0.303, 0.6,  -0.15, 0.15,  0.05);
    wxminus(-0.303, 0.6,   0.0,  0.15,  0.05);
    wxminus(-0.303, 0.6,   0.15, 0.15,  0.05);
    
    
    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw generic suburban home                                    */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makebuilding5()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);
    
    makercubenobtmnotop(  0,  .2, 0,  .3, .2, .35, colorwhite);
    makeitPyr(1, colorgrey2,  0,  .5, 0,  .35, .1, .45);
    makercubenobtm(  .2,  .4, 0,  .03, .2, .05, colorwhite);
    
    glColor3fv(colorblack);
    
    wxminus(-0.303,  0.15, -0.15,  0.15,  0.05);
    wxplus(  0.303,  0.25,  0.15,  0.05,  0.05);
    wzminus(-0.15,   0.25, -0.352, 0.05,  0.05);
    wzminus( 0.0,    0.25, -0.352, 0.05,  0.05);
    wzplus(  0.15,   0.25,  0.352, 0.05,  0.05);
    
    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw generic fast food resteraunt                             */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
   
void drawBuilding6(int counter, float * c1,  float * c2)
    {
    makercubenobtmnotop(  0,  .2, 0,  .3, .2, .35, c1);
    makeitPyr(1, c2,  0,  .5, 0,  .35, .1, .45);

    makercubenobtm(  .38,  .25, 0.1,  .01, .25, .015, colorgrey2);
    
    glPushMatrix();
    glTranslatef(.38,   .6,  0.1);
	glRotatef((counter*15) % 360, 0, 1, 0);
	makercube(0.0, 0.0, 0.0, 0.01,  0.1,  0.14, c2);
	makercube(0.0, 0.0, 0.0, 0.013, 0.07, 0.11, c1);
    glPopMatrix();
    
    glColor3fv(colorblack);
    
    wxplus(0.303, 0.15, -0.15, 0.15,  0.05);

    wxplus(0.303, 0.2,   0.15, 0.075, 0.075);
    
    wzminus(-0.15, 0.2, -0.352, 0.075, 0.075);
    wzplus( -0.15, 0.2,  0.352, 0.075, 0.075);
    wzplus(  0.15, 0.2,  0.352, 0.075, 0.075);
    wzminus( 0.15, 0.2, -0.352, 0.075, 0.075);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw granite monument                                         */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makebuilding7()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);
    
    makeitPyr(3, colorgrey2, 0.0, 0.4, 0.0, 0.3, 0.4, 0.3);
    
    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw warehouse / hanger                                       */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawBuilding8(float * c1,  float * c2)
    {
    makercubenobtmnotop(0,  .2, 0,  .35, .2, .3, c1);
    makeitPyr(4, c2,  0,  .5, 0,  .35, .1, .3);
    
    glColor3fv(colorblack);
    
    wzminus(0.0, 0.15, -0.303, 0.25, 0.15);
    wzplus( 0.0, 0.15,  0.303, 0.25, 0.15);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw water tower                                              */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makebuilding9()
    {
    GLuint O;
    GLUquadricObj *qobj;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

     
    glPushMatrix();
	glTranslatef(-0.3,  1,  -0.3);
	glScalef(.3,  .2,  .3);
	drawClosedCylinder(colorgrey1,  colorwhite,  1, 1);
    glPopMatrix();
  
    glPushMatrix();
	glTranslatef(-0.1,  0.5,  -0.1);
	glScalef(0.1,  0.5,  0.1);
	drawClosedCylinder(colorgrey3,  colorwhite,  0, 0);
    glPopMatrix();
  
    makercubenobtm(-0.22,  0.5, -0.22,  0.025, 0.5, 0.025, colorgrey2);
    makercubenobtm( 0.22,  0.5, -0.22,  0.025, 0.5, 0.025, colorgrey2);
    makercubenobtm(-0.22,  0.5,  0.22,  0.025, 0.5, 0.025, colorgrey2);
    makercubenobtm( 0.22,  0.5,  0.22,  0.025, 0.5, 0.025, colorgrey2);
     
    makercube(-0.2,  0.4,  0.0,  0.015, 0.015, 0.2, colorgrey3);
    makercube( 0.2,  0.4,  0.0,  0.015, 0.015, 0.2, colorgrey3);
    makercube( 0.0,  0.4,  0.2,  0.2,   0.015, 0.015, colorgrey3);
    makercube( 0.0,  0.4, -0.2,  0.2,   0.015, 0.015, colorgrey3);
   
    glPushMatrix();
	glColor3fv(colorblack);
	glRotatef(-90, 1, 0, 0);

	qobj = gluNewQuadric();
	gluDisk( qobj, 0.,   0.3, 32, 1);
	gluDeleteQuadric(qobj);

    glPopMatrix();
     
    glEndList();
    return(O);
    }


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw construction                                             */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makebuilding10()
    {
    GLuint O;

    /****************/
    /* construction */
    /****************/

    float cons1[3] = {-0.29, 0.1, -0.29};
    float cons2[3] = {-0.29, 0.8, -0.29};
    float cons3[3] = { 0.29, 0.1, -0.29};
    float cons4[3] = { 0.29, 0.8, -0.29};
    float cons5[3] = { 0.29, 0.1,  0.29};
    float cons6[3] = { 0.29, 0.8,  0.29};
    float cons7[3] = {-0.29, 0.1,  0.29};
    float cons8[3] = {-0.29, 0.8,  0.29};

    float cons9[3] = {-0.29, 0.45, -0.29};
    float cons10[3] ={-0.29, 0.45,  0.29};
    float cons11[3] ={ 0.29, 0.45,  0.29};
    float cons12[3] ={ 0.29, 0.45, -0.29};

    float cons13[3] ={ 0.0, 0.45, -0.29};
    float cons14[3] ={ 0.0, 0.45,  0.29};
    float cons15[3] ={ 0.0, 0.8,   0.29};
    float cons16[3] ={ 0.0, 0.8,  -0.29};

    float cons17[3] ={-0.29, 0.45, 0.0};
    float cons18[3] ={ 0.29, 0.45, 0.0};
    float cons19[3] ={ 0.29, 0.8,  0.0};
    float cons20[3] ={-0.29, 0.8,  0.0};

    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);
    
    makercubenobtm(  0,  .05, 0,  .3, .05, .3, colorwhite);

    glColor3fv(colorgrey1);
    glLineWidth(2.0);
    
    glBegin(GL_LINES);
	glVertex3fv(cons1);
	glVertex3fv(cons2);

	glVertex3fv(cons3);
	glVertex3fv(cons4);

	glVertex3fv(cons5);
	glVertex3fv(cons6);

	glVertex3fv(cons7);
	glVertex3fv(cons8);
    glEnd();


    glBegin(GL_LINE_LOOP);
	glVertex3fv(cons2);
	glVertex3fv(cons8);
	glVertex3fv(cons6);
	glVertex3fv(cons4);
    glEnd();

    glBegin(GL_LINE_LOOP);
	glVertex3fv(cons9);
	glVertex3fv(cons10);
	glVertex3fv(cons11);
	glVertex3fv(cons12);
    glEnd();

    glBegin(GL_LINE_LOOP);
	glVertex3fv(cons13);
	glVertex3fv(cons14);
	glVertex3fv(cons15);
	glVertex3fv(cons16);
    glEnd();

    glBegin(GL_LINE_LOOP);
	glVertex3fv(cons17);
	glVertex3fv(cons18);
	glVertex3fv(cons19);
	glVertex3fv(cons20);
    glEnd();
    
    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw factory smokestacks                                      */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawBuilding11(int detailOn)
    {
    makercubenobtm(  0,  .05, 0,  .3, .05, .3, colorgrey1);

    glPushMatrix();
	glTranslatef(-.25,  .8,  -.1);
	glScalef(.1,  .8,  .1);
	drawClosedCylinder(colorgrey2,  colorgrey3,  0, detailOn);
    glPopMatrix();

    glPushMatrix();
	glTranslatef(.05,  .8,  -.1);
	glScalef(.1,  .8,  .1);
	drawClosedCylinder(colorgrey2,  colorgrey3,  0, detailOn);
    glPopMatrix();
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw factory                                                  */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
   
GLuint makebuilding12()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    makercubenobtm(  0,  .4, 0,  .3, .4, .3, colorbrown);
    makercubenobtmnotop(  0,  .5, 0.02,  .302, .1, .3, colorblack);

    glColor3fv(colorblack);
    
    wxplus(0.303,  .15,  -.15,  .15,  .05);
    wxminus(-0.303,  .15,  -.15,  .15,  .05);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw control tower                                            */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makebuilding14()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);
    makercubenobtmnotop(  0,  .55, 0,  .15, .55, .15, colorbeige);
    makercubenobtm(  0,  1.55, 0,  .3, .05, .3, colorbeige);
    
    makeitPyr(5, colorbrown,  0,  1.1, 0,  .3, .4, .3);
    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw strip-mall store                                         */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawBuilding15(float * buildingColour,  float * awningColour)
    {
    makeitPyr(4, awningColour,  +.1,  .54, 0,  .3, .25, .297);

    makercubenobtm(  -.1,  .4, 0,  .3, .4, .3, buildingColour);
    
    glColor3fv(colorblack);
    
    wxplus(0.203,  .15,  -.15,  .15,  .05);
    wxminus(-0.403,  .15,  -.15,  .15,  .05);

    wxplus(0.203,  .15,  .10,  .08,  .12);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw end of city hall                                         */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makebuilding19()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);
    
    makercubenobtmnotop(  0,  .3, 0,  .3, .3, .3, colorbrown);
    makeitPyr(4, colorbeige,  0,  .7, 0,  .3, .1, .3);
    
    glColor3fv(colorblack);
    
    wxplus(.303,  .4,  -.15,  .08,  .05);
    wxplus(.303,  .2,  -.15,  .08,  .05);
    wxplus(.303,  .4,  +.15,  .08,  .05);
    wxplus(.303,  .2,  +.15,  .08,  .05);

    wxminus(-.303,  .4,  -.15,  .08,  .05);
    wxminus(-.303,  .2,  -.15,  .08,  .05);
    wxminus(-.303,  .4,  +.15,  .08,  .05);
    wxminus(-.303,  .2,  +.15,  .08,  .05);

    glEndList();
    return(O);
    }


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw middle of city hall                                      */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
   
GLuint makebuilding20()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    makercubenobtmnotop(  0,  .3, 0,  .3, .3, .3, colorbrown);
    makeitPyr(4, colorbeige,  0,  .7, 0,  .3, .1, .3);
    makeitPyr(6, colorbeige,  0,  .7, 0,  .3, .1, .3);
    
    glColor3fv(colorblack);
    
    wxplus(.303,  .4,  -.15,  .08,  .05);
    wxplus(.303,  .2,  -.15,  .08,  .05);
    wxplus(.303,  .4,  +.15,  .08,  .05);
    wxplus(.303,  .2,  +.15,  .08,  .05);

    wxminus(-.303,  .4,  -.15,  .08,  .05);
    wxminus(-.303,  .2,  -.15,  .08,  .05);
    wxminus(-.303,  .4,  +.15,  .08,  .05);
    wxminus(-.303,  .2,  +.15,  .08,  .05);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw front of city hall                                       */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makebuilding21()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);
    
    makercubenobtmnotop(  -.2,  .3, 0,  .1, .3, .3, colorbrown);
    makeitPyr(6, colorbeige,  0,  .7, 0,  .3, .1, .3);
    makercubenobtm(  0,  .05, 0,  .29, .05, .29, colorgrey1);
    
    glColor3fv(colorblack);
    
    wxplus(-.098,  .22,  -.10,  .12,  .05);
    wxplus(-.098,  .22,  +.10,  .12,  .05);

    wxminus(-.303,  .4,  -.15,  .08,  .05);
    wxminus(-.303,  .2,  -.15,  .08,  .05);
    wxminus(-.303,  .4,  +.15,  .08,  .05);
    wxminus(-.303,  .2,  +.15,  .08,  .05);
    
    makercubenobtmnotop(  0.25,  .3, 0.25,  .03, .3, .03, colorwhite);
    makercubenobtmnotop(  0.25,  .3, -0.25,  .03, .3, .03, colorwhite);

    makercubenobtmnotop(  0.0,  .3, 0.25,  .03, .3, .03, colorwhite);
    makercubenobtmnotop(  0.0,  .3, -0.25,  .03, .3, .03, colorwhite);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw office building                                          */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawBuilding22(float * color)
    {
    makercubenobtm(0,  .75, 0,  .3, .75, .3, color);    
    makercubenobtmnotop(0,  .4, 0,  .307, .1, .307, colorblack);
    makercubenobtmnotop(0,  .8, 0,  .307, .1, .307, colorblack);
    makercubenobtmnotop(0,  1.2, 0,  .307, .1, .307, colorblack);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw satellite dish                                           */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawBuilding25()
    {
    long backNow;
    GLUquadricObj *qobj;
    
    /******************/
    /* satellite dish */
    /******************/

    float satSphere[4] = {0, 0.4, 0, 0.075};

    float sat0[3] = { 0.0,  0.35, 0.0};
    float sat1[3] = { 0.0,  0.0,  0.35};
    float sat2[3] = { 0.0, -0.35, 0.0};
    float sat3[3] = { 0.35, 0.0,  0.0};
    float sat4[3] = {-0.35, 0.0,  0.0};
  
    backNow = glIsEnabled(GL_CULL_FACE);
    
    makercubenobtm(  0,  .2, 0,  .05, .2, .05, colorwhite);
        
    glColor3fv(colorgrey2);
    andysphdraw(satSphere, 4);
    
    glLineWidth(3.0);    
    glColor3fv(colorwhite);
    
    glPushMatrix();
	glDisable(GL_CULL_FACE);
	
	glTranslatef(0,  .4,   0);
	glRotatef(-45, 1, 0, 0);

	qobj = gluNewQuadric();
	gluDisk( qobj, 0.,   0.35, 32, 1);
	gluDeleteQuadric(qobj);

	if (backNow)
	    glEnable(GL_CULL_FACE);
	else
	    glDisable(GL_CULL_FACE);
	
	glColor3fv(colorgrey1);

	glBegin(GL_LINE_STRIP);
	    glVertex3fv(sat0);
	    glVertex3fv(sat1);
	    glVertex3fv(sat2);	
	glEnd();

	glBegin(GL_LINE_STRIP);
	    glVertex3fv(sat3);
	    glVertex3fv(sat1);
	    glVertex3fv(sat4);	
	glEnd();
    glPopMatrix();
    
    glColor3fv(colorblack);
    
    glPushMatrix();
	glTranslatef(0,  0,   0);
	glRotatef(-90, 1, 0, 0);

	qobj = gluNewQuadric();
	gluDisk( qobj, 0.,   0.3, 32, 1);
	gluDeleteQuadric(qobj);

    glPopMatrix();
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw drive in theatre screen                                  */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
  
void drawBuilding26(int rorl, int detailOn)
    {
    GLboolean backNow;

    /***************************/
    /* theatre screen supports */
    /***************************/

    float screen0[3] = {-0.39, 0.01, -0.28};
    float screen1[3] = {-0.39, 0.01,  0.28};
    float screen2[3] = { 0.39, 0.01,  0.28};
    float screen3[3] = { 0.39, 0.01, -0.28};
    float screen4[3] = {-0.39, 0.79,  0.28};
    float screen5[3] = { 0.39, 0.79,  0.28};
    float screen6[3] = { 0.39, 0.01, -0.28};


    static float vec1[3]={0,1,0};
    static float vec2[3]={1,1,0};
    static float vec3[3]={1,0,0};
    static float vec4[3]={0,0,0};
    
    static float tv1[2] = {0,1};
    static float tv2[2] = {1,1};
    static float tv3[2] = {1,0};
    static float tv4[2] = {0,0};

   backNow = glIsEnabled(GL_CULL_FACE);

    /* supports for the screen */
    
    glColor4fv(colorgrey2);
    glLineWidth(3.0);
    
    glBegin(GL_LINE_LOOP);
	glVertex3fv(screen0);
	glVertex3fv(screen1);
	glVertex3fv(screen2);
	glVertex3fv(screen3);
    glEnd();

    glBegin(GL_LINE_LOOP);
	glVertex3fv(screen0);
	glVertex3fv(screen4);
	glVertex3fv(screen5);
	glVertex3fv(screen6);
    glEnd();


    /* back of the screen */    
    makercubenobtm( 0, 0.42, 0.28, 0.4,0.42, 0.01, colorwhite);

    if ((detailOn > 0) &&  (picleft != NULL) && (picright != NULL))
	{	
	glDisable(GL_CULL_FACE);


	glPushMatrix();
	    glColor4fv(colorwhite);

	
	    if (rorl == 0)
		glCallList(leftScreen);
	    else
		glCallList(rightScreen);
		
	    glEnable(GL_TEXTURE_2D);
	
	
	    glTranslatef(0.4, 0, 0.3);
	    glScalef(0.8, 0.8,  0.01);
	
	    glRotatef(180, 0, 1, 0);
	
	    glBegin(GL_QUADS);

		glTexCoord2fv(tv1);
		glVertex3fv(vec1);
		
		glTexCoord2fv(tv2);
		glVertex3fv(vec2);
		
		glTexCoord2fv(tv3);
		glVertex3fv(vec3);
		
		glTexCoord2fv(tv4);
		glVertex3fv(vec4);
	    
	    glEnd();
	
	    glDisable(GL_TEXTURE_2D);


	glPopMatrix();
	
 	if (backNow)
	    glEnable(GL_CULL_FACE);
	else
	    glDisable(GL_CULL_FACE);
    
	}         
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw fountain                                                 */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawBuilding29(int itsChristmas)
    {
    makercubenobtm(  0,  .05, 0,  .3, .05, .3, colorwhite);

    makercubenobtm(  .25,  .1, 0,  .05, .1, .3, colorwhite);
    makercubenobtm(  -.25,  .1, 0,  .05, .1, .3, colorwhite);
    makercubenobtm(  0,  .1, .25,  .3, .1, .05, colorwhite);
    makercubenobtm(  0,  .1, -.25,  .3, .1, .05, colorwhite);

    makeitPyr(3, colorgrey1,  0,  0.3, 0,  0.1, 0.3, 0.1);
    
    if (!itsChristmas)
	{
	glEnable(GL_BLEND);
	    makercubenobtm(  0,  .1, 0,  .19, .11, .19, colormaserblue);
	glDisable(GL_BLEND);
	}
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw maser emplacement                                        */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makebuilding31()
    {
    GLUquadricObj *qobj;
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);
    
    makercubenobtm(  0,  .095, 0,  .36, .095, .36, colorgrey1);

    makercubenobtm(  .35,  .1, .35,  .03, .1, .03, colorblue);
    makercubenobtm(  -.35,  .1, .35,  .03, .1, .03, colorblue);
    makercubenobtm(  .35,  .1, -.35,  .03, .1, .03, colorblue);
    makercubenobtm(  -.35,  .1, -.35,  .03, .1, .03, colorblue);

    glColor3fv(colorwhite);
    
    glPushMatrix();
	glTranslatef(0,  .2,   0);
	glRotatef(-90, 1, 0, 0);

	qobj = gluNewQuadric();
	gluDisk( qobj, 0.,   0.3, 32, 1);
	gluDeleteQuadric(qobj);
    glPopMatrix();

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw helicopter pad                                           */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makebuilding32()
    {
    GLUquadricObj *qobj;
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);
    
    
    makercubenobtm(  0,  .095, 0,  .36, .095, .36, colorgrey1);

    glColor3fv(coloryellow);
    
    glPushMatrix();
	glTranslatef(0,  .2,   0);
	glRotatef(-90, 1, 0, 0);

	qobj = gluNewQuadric();
	gluDisk( qobj, 0.,   0.3, 32, 1);
	gluDeleteQuadric(qobj);
    glPopMatrix();

    glColor3fv(colorgrey1);
    
    glPushMatrix();
	glTranslatef(0,  .21,   0);
	glRotatef(-90, 1, 0, 0);

	qobj = gluNewQuadric();
	gluDisk( qobj, 0.,   0.2, 32, 1);
	gluDeleteQuadric(qobj);
    glPopMatrix();

    glEndList();
    return(O);
    }

   
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw hero beam in effect                                      */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawBuilding33(int count, int detailOn)
    {
    float c[4], height;
   
    c[0] = colorred[0];
    c[1] = colorred[1] + (count/40.0);
    c[2] = colorred[2];
    c[3] = 1 - (count/20.0);
 
    height = .8 - 0.04*count;
    glEnable(GL_BLEND);
    
    glPushMatrix();
	glTranslatef(-.2,  height,  -.2);
	glScalef(.2,  height,  .2);
	drawClosedCylinder(c,  c,  0, detailOn);
    glPopMatrix();
    
    glDisable(GL_BLEND);
    }
 
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw power line tower                                         */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawTower(int death, int death2)
    {
    float v1[3], v2[3], v3[3], v4[3];
    float v5[3], v6[3], v7[3], v8[3];
    float va[3], vb[3], vc[3], vd[3];
    float ve[3], vf[3], vg[3];
    float vh[3], vi[3], vj[3];

    float amt,  amt2;
    float samt2,  samt,  camt2;
    float melt1, melt2;
    
    amt = 2 * death * DEG_TO_RAD;
    amt2 = death2 * DEG_TO_RAD;
       
    samt2   = sin(amt2);
    samt    = sin(amt);
    camt2   = cos(amt);
       
       
    melt1 = samt2 * 0.5*samt;
    melt2 = camt2 * 0.5*samt;
    
    if (death > 0)
	glColor3fv(colorwhite);
    else
	glColor3fv(colorgrey1);
    
    if (death == 0)
	v1[1] = v2[1] = v3[1] = v4[1] = 0.7;
    else
	v1[1] = v2[1] = v3[1] = v4[1] = 0.3 + 0.4 * camt2;

    v1[0] = v4[0] =  -0.06;   
    v1[2] = v2[2] =   0.06;  
    v2[0] = v3[0] =   0.06;
    v3[2] = v4[2] = - 0.06;
 
    v5[0] = v8[0] =  -0.3;
    v5[1] = v6[1] = v7[1] = v8[1] = 0.0;
    v5[2] = v6[2] =   0.3;    
    v6[0] = v7[0] =   0.3;
    v7[2] = v8[2] = - 0.3;
    
    if (death == 0)
	{
	va[1] = vb[1] = vc[1] = vd[1] = 1.5;
	va[0] = v1[0];
	va[2] = v1[2];

	vb[0] = v2[0];
	vb[2] = v2[2];

	vc[0] = v3[0];
	vc[2] = v3[2];

	vd[0] = v4[0];
	vd[2] = v4[2];
	}
    else
	{
	va[1] = vb[1] = vc[1] = vd[1] = 1.5 * camt2;
	va[0] = v1[0]+ melt1;
	va[2] = v1[2]+ melt2;

	vb[0] = v2[0]+ melt1;
	vb[2] = v2[2]+ melt2;

	vc[0] = v3[0]+ melt1;
	vc[2] = v3[2]+ melt2;

	vd[0] = v4[0]+ melt1;
	vd[2] = v4[2]+ melt2;
	}
  

    ve[1] = vf[1] = vc[1] - 0.2;
    ve[0] = vc[0];
    ve[2] = vc[2];

    vf[0] = vd[0];
    vf[2] = vd[2];
  
    vg[0] = (vc[0] + vd[0]) * 0.5;
    vg[1] = vc[1] - 0.1;
    vg[2] = vc[2] - .2;


    vh[0] = va[0];
    vh[1] = vi[1] = va[1] - 0.2;
    vh[2] = va[2];

    vi[0] = vb[0];
    vi[2] = vb[2];
  
    vj[0] = (va[0] + vb[0]) * 0.5;
    vj[1] = va[1] - 0.1;
    vj[2] = va[2] + .2;


    glLineWidth(3.0);

    /********/
    /* legs */
    /********/
   
    glBegin(GL_LINE_LOOP);
	glVertex3fv(v1); glVertex3fv(v2); glVertex3fv(v3); glVertex3fv(v4);
    glEnd();
    
    glBegin(GL_LINE_LOOP);
	glVertex3fv(v4); glVertex3fv(v5); glVertex3fv(v2); glVertex3fv(v7);
    glEnd();

    glBegin(GL_LINE_LOOP);
	glVertex3fv(v1); glVertex3fv(v6); glVertex3fv(v3); glVertex3fv(v8);
    glEnd();

 
    glLineWidth(2.0);

    /*******/
    /* top */
    /*******/

    glBegin(GL_LINE_LOOP);
	glVertex3fv(va); glVertex3fv(vb); glVertex3fv(vc); glVertex3fv(vd);
    glEnd();

    /*************************/
    /* supports and verticals*/
    /*************************/

    glBegin(GL_LINE_STRIP);
	glVertex3fv(v7); glVertex3fv(v3); glVertex3fv(vc); glVertex3fv(vg); glVertex3fv(ve);
    glEnd();

    glBegin(GL_LINE_STRIP);
	glVertex3fv(v8); glVertex3fv(v4); glVertex3fv(vd); glVertex3fv(vg); glVertex3fv(vf);
    glEnd();

    glBegin(GL_LINE_STRIP);
	glVertex3fv(v5); glVertex3fv(v1); glVertex3fv(va); glVertex3fv(vj); glVertex3fv(vh);
    glEnd();

    glBegin(GL_LINE_STRIP);
	glVertex3fv(v6); glVertex3fv(v2); glVertex3fv(vb); glVertex3fv(vj); glVertex3fv(vi);
    glEnd();


    glBegin(GL_LINE_LOOP);
	glVertex3fv(ve); glVertex3fv(vf); glVertex3fv(vh); glVertex3fv(vi);
    glEnd();    
    }


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* make object for battalion title                               */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeTitles()
    {
    GLuint O;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    /*****/
    /* b */
    /*****/

    makerlogo(-3.75, 3.75, 0,  .1,  .25, .2);
    makerlogo(-3.25, 3.25, 0,  .1,  .25, .2);
    makerlogo(-3.5,  3.5,  0,  .35, .1,  .2);
    makerlogo(-3.5,  3.,   0,  .35, .1,  .2);

    /*****/
    /* a */
    /*****/

    makerlogo(-2.75, 3.25, 0,  .1,   .3,  .2);
    makerlogo(-2.25, 3.25, 0,  .1,   .3,  .2);
    makerlogo(-2.5,  3.5,  0,  .35,  .1,  .2);
    makerlogo(-2.65, 3.,   0,  .20,  .1,  .2);

    /*****/
    /* t */
    /*****/

    makerlogo(-1.75, 3.5, 0,  .1,  .6,  .2);
    makerlogo(-1.5,  3.5, 0,  .3,  .1,  .2);
	
    /*****/
    /* t */
    /*****/
	
    makerlogo(-0.75, 3.5, 0,  .1,  .6,  .2);
    makerlogo(-0.5,  3.5, 0,  .3,  .1,  .2);

    /*****/
    /* a */
    /*****/
	
    makerlogo(0.25, 3.25, 0,  .1,   .3,  .2);
    makerlogo(0.75, 3.25, 0,  .1,   .3,  .2);
    makerlogo(0.5,  3.5,  0,  .35,  .1,  .2);
    makerlogo(0.35, 3.,   0,  .20,  .1,  .2);

    /*****/
    /* l */
    /*****/

    makerlogo(1.25, 3.5, 0,  .1,  .6,  .2);
	
    /*****/
    /* i */
    /*****/

    makerlogo(1.75, 3.25, 0,  .1,  .35,  .2);
	
    /*****/
    /* o */
    /*****/

    makerlogo(2.25, 3.25, 0,  .1,   .3,  .2);
    makerlogo(2.75, 3.25, 0,  .1,   .3,  .2);
    makerlogo(2.5,  3.5,  0,  .35,  .1,  .2);
    makerlogo(2.5,  3,    0,  .35,  .1,  .2);
	
    /*****/
    /* n */
    /*****/

    makerlogo(3.25, 3.25, 0,  .1,   .35,  .2);
    makerlogo(3.75, 3.25, 0,  .1,   .35,  .2);
    makerlogo(3.5,  3.5,  0,  .35,  .1,   .2);
	
    glEndList();
    return(O);
    }


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeBigPlane()
    {
    GLuint O;

    /*******************************/
    /* the battlefield in map view */
    /*******************************/

    float Bplane[4][3] = {
	- 200,  PLANEY,  - 200, 
	- 200,  PLANEY,  + 200, 
	+ 200,  PLANEY,  + 200, 
	+ 200,  PLANEY,  - 200};

    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    glBegin(GL_QUADS);
	glVertex3fv(Bplane[0]);
	glVertex3fv(Bplane[1]);
	glVertex3fv(Bplane[2]);
	glVertex3fv(Bplane[3]);
    glEnd();

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeLowDPlane()
    {
    GLuint O;

    /********************/
    /* the battlefield  */
    /********************/

    float Gplane[4][3] = {
	- PLANESIZE,  PLANEY,  - PLANESIZE, 
	- PLANESIZE,  PLANEY,  + PLANESIZE, 
	+ PLANESIZE,  PLANEY,  + PLANESIZE, 
	+ PLANESIZE,  PLANEY,  - PLANESIZE};

    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    glBegin(GL_QUADS);
	glVertex3fv(Gplane[0]);
	glVertex3fv(Gplane[1]);
	glVertex3fv(Gplane[2]);
	glVertex3fv(Gplane[3]);
    glEnd();

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeHighDPlane()
    {
    GLuint O;
    float ratio;
    register int i, j;
    float plane[4][3];
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

	ratio = PLANESIZE * 0.1;
	plane[0][1] = plane[1][1] = plane[2][1] = plane[3][1] = PLANEY;

	for (i=0;i<=19;i++)
	    for(j=0;j<=19;j++)
		{
		plane[0][0] = plane[1][0] = (i*ratio) - PLANESIZE;
		plane[2][0] = plane[3][0] = ((i+1)*ratio) - PLANESIZE;

		plane[0][2] = plane[3][2] = (j*ratio) - PLANESIZE;
		plane[1][2] = plane[2][2] = ((j+1)*ratio) - PLANESIZE;
		
		glBegin(GL_QUADS);
		    glVertex3fv(plane[0]);
		    glVertex3fv(plane[1]);
		    glVertex3fv(plane[2]);
		    glVertex3fv(plane[3]);
		glEnd();
		}

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw the square playing field                                 */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawBattlefield(struct road * roads,  float xshift,  float zshift, 
		    int detailOn, int itsChristmas, int view)
    {
    float theta, radius;
    float angle;

    /******************************/
    /* 'where is the town' arrow  */
    /******************************/

    static float arrow[4][3] =		{-0.2, PLANEY + 0.01, -1.0, 
				 	 -0.2, PLANEY + 0.01,  1.0, 
				  	  0.2, PLANEY + 0.01,  1.0, 
				  	  0.2, PLANEY + 0.01, -1.0};
			
    static float arrowhead[3][3] =	{0.0, PLANEY + 0.01, -1.75, 
					-0.5, PLANEY + 0.01, -1.0,
				 	 0.5, PLANEY + 0.01, -1.0};
         
    if (itsChristmas)
	glColor3fv(colorsnow);
    else
	glColor3fv(planeGreen);


    if (view == MAPVIEW)
	{
	glCallList(bigPlane);    
	}
    else
	{
	if (detailOn < 1)
	    glCallList(lowDPlane);
	else
	    glCallList(highDPlane);
	}
	
    /***************/
    /* draw roads  */
    /***************/

    drawRoads(roads, xshift, zshift, itsChristmas,view);
    
    radius = sqrt(xshift * xshift + zshift * zshift);
    
    if (radius > 36)
	{
        /**********************/
        /* draw town pointer  */
        /**********************/
	
	if (zshift == 0)
	    zshift = NEARZERO; 
		
	theta = atan(xshift / zshift);

	if (zshift > 0)
	    theta += PI;

	angle =  theta * RAD_TO_SMALL_DEG;
    
	glPushMatrix();
	    glRotatef(angle, 0, 1, 0);
    
	    glColor3fv(colorred);

	    glBegin(GL_QUADS);
		glVertex3fv(arrow[0]);
		glVertex3fv(arrow[1]);
		glVertex3fv(arrow[2]);
		glVertex3fv(arrow[3]);
	    glEnd();

	    glBegin(GL_TRIANGLES);
		glVertex3fv(arrowhead[0]);
		glVertex3fv(arrowhead[1]);
		glVertex3fv(arrowhead[2]);
	    glEnd();
	glPopMatrix();
	}
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw square lake segment                                      */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawLake0(int itsChristmas)
    {   
static    float lake[4][3] =	{-0.3,  0.0, -0.3, 
				  0.3,  0.0, -0.3, 
				  0.3,  0.0,  0.3, 
				 -0.3,  0.0,  0.3};

    if (itsChristmas)
	glColor3fv(colorblue);
    else
        glColor3fv(colorwater);
        
    glBegin(GL_QUADS);
	glVertex3fv(lake[3]);
	glVertex3fv(lake[2]);
	glVertex3fv(lake[1]);
	glVertex3fv(lake[0]);
    glEnd();
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw triangular lake segment                                  */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawLake1(int itsChristmas)
    {    
    float lake2[3][3] =		{-0.3,  0.0, -0.3, 
				  0.3,  0.0, -0.3, 
				 -0.3,  0.0,  0.3};

    if (itsChristmas)
	glColor3fv(colorblue);
    else
        glColor3fv(colorwater);
    
    glBegin(GL_TRIANGLES);
	glVertex3fv(lake2[2]);
	glVertex3fv(lake2[1]);
	glVertex3fv(lake2[0]);
    glEnd();
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw central hill segment                                     */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawHill0(int itsChristmas)
    {   
static     float hill[4][3] =	{-0.3, 0.6, -0.3, 
				  0.3, 0.6, -0.3, 
				  0.3, 0.6,  0.3, 
				 -0.3, 0.6,  0.3};


    if (itsChristmas)
	glColor3fv(colorsnow);
    else
        glColor3fv(planeGreen2);
        
    glBegin(GL_QUADS);
	glVertex3fv(hill[3]);
	glVertex3fv(hill[2]);
	glVertex3fv(hill[1]);
	glVertex3fv(hill[0]);
    glEnd();
    
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw side of hill                                             */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawHill1(int sidemod, int itsChristmas)
    {   
    float c[4];

static    float side[4][3] =	{-0.3, 0.6, -0.3, 
				  0.3, 0.6, -0.3, 
				  0.3, 0.0,  0.3, 
				 -0.3, 0.0,  0.3};
    
    if (itsChristmas)
	{
	c[0] =  colorsnow2[0];   
	c[1] =  colorsnow2[1];   
	c[2] =  colorsnow2[2];   
	}
    else
	{
	c[0] =  planeGreen3[0];   
	c[1] =  planeGreen3[1];   
	c[2] =  planeGreen3[2];  
	} 
	
    c[0] -= sidemod*0.04;
    c[1] -= sidemod*0.04;
    c[2] -= sidemod*0.04;

    if (c[0] < 0)
	c[0] = 0;
    if (c[1] < 0)
	c[1] = 0;
    if (c[2] < 0)
	c[2] = 0;
	    
    glColor3fv(c);
    
    glBegin(GL_QUADS);
	glVertex3fv(side[3]);
	glVertex3fv(side[2]);
	glVertex3fv(side[1]);
	glVertex3fv(side[0]);
    glEnd();

    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw corner of hill                                           */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawHill2(int sidemod, int itsChristmas)
    {   
    float c[4];

static    float corner[3][3] =	{-0.3, 0.6, -0.3, 
				  0.3, 0.0, -0.3, 
				 -0.3, 0.0,  0.3};
 
    if (itsChristmas)
	{
	c[0] =  colorsnow2[0];   
	c[1] =  colorsnow2[1];   
	c[2] =  colorsnow2[2];   
	}
    else
	{
	c[0] =  planeGreen3[0];   
	c[1] =  planeGreen3[1];   
	c[2] =  planeGreen3[2];  
	} 
 
    c[0] -= (sidemod*0.04 + 0.02);
    c[1] -= (sidemod*0.04 + 0.02);
    c[2] -= (sidemod*0.04 + 0.02);

    if (c[0] < 0)
	c[0] = 0;
    if (c[1] < 0)
	c[1] = 0;
    if (c[2] < 0)
	c[2] = 0;
 
    glColor3fv(c);
   
    glBegin(GL_TRIANGLES);
	glVertex3fv(corner[2]);
	glVertex3fv(corner[1]);
	glVertex3fv(corner[0]);
    glEnd();

    }
    
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw inside corner of hill                                    */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawHill3(int sidemod, int itsChristmas)
    {
   float c[4];

static    float insidecorner[4][3] =	{-0.3, 0.6, -0.3, 
				  0.3, 0.6, -0.3, 
				 -0.3, 0.6,  0.3, 
				  0.3, 0.0,  0.3 };
 
    if (itsChristmas)
	glColor3fv(colorsnow);
    else
        glColor3fv(planeGreen2);

    glBegin(GL_TRIANGLES);
	glVertex3fv(insidecorner[2]);
	glVertex3fv(insidecorner[1]);
	glVertex3fv(insidecorner[0]);
    glEnd();

    if (itsChristmas)
	{
	c[0] =  colorsnow2[0];   
	c[1] =  colorsnow2[1];   
	c[2] =  colorsnow2[2];   
	}
    else
	{
	c[0] =  planeGreen3[0];   
	c[1] =  planeGreen3[1];   
	c[2] =  planeGreen3[2];  
	} 
 
    c[0] -= (sidemod*0.04 + 0.02);
    c[1] -= (sidemod*0.04 + 0.02);
    c[2] -= (sidemod*0.04 + 0.02);

    if (c[0] < 0)
	c[0] = 0;
    if (c[1] < 0)
	c[1] = 0;
    if (c[2] < 0)
	c[2] = 0;
 
    glColor3fv(c);
 
    glBegin(GL_TRIANGLES);
	glVertex3fv(insidecorner[2]);
	glVertex3fv(insidecorner[3]);
	glVertex3fv(insidecorner[1]);
    glEnd();
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

 void drawWater(int shape,  int itsChristmas)
    {
    switch(shape){
	case 0:	    drawLake0(itsChristmas);
		    break;
		    
	case 1:	    drawLake1(itsChristmas);	/*   |/ */
		    break;
		    
	case 2:	    glRotatef(-90, 0, 1, 0);	/* \| */
		    drawLake1(itsChristmas);
		    break;
		    
	case 3:	    glRotatef(-180, 0, 1, 0);	/* /| */
		    drawLake1(itsChristmas);
		    break;
		    
	case 4:	    glRotatef(90, 0, 1, 0);	/* |\ */
		    drawLake1(itsChristmas);
		    break;
	}
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

 void drawHills(int shape,  int itsChristmas)
    {
    switch(shape){
	case 0:	    drawHill0(itsChristmas);
		    break;
		    
	case 1:	    drawHill1(0, itsChristmas); /* up neg Z */
		    break;
		    
	case 2:	    glRotatef(-90, 0, 1, 0);	/* up pos x */
		    drawHill1(1, itsChristmas);
		    break;
		    
	case 3:	    glRotatef(-180, 0, 1, 0);	/* up pos z */
		    drawHill1(2, itsChristmas);
		    break;
		    
	case 4:	    glRotatef(90, 0, 1, 0);	/* up neg x */
		    drawHill1(1, itsChristmas);
		    break;
		    
		    
	case 5:	    drawHill2(0,  itsChristmas); /* +x,+z corner */
		    break;
		    
	case 6:	    glRotatef(-90, 0, 1, 0);	/* up pos x */
		    drawHill2(0, itsChristmas);
		    break;
		    
	case 7:	    glRotatef(-180, 0, 1, 0);	/* up pos z */
		    drawHill2(1, itsChristmas);
		    break;
		    
	case 8:	    glRotatef(90, 0, 1, 0);	/* up neg x */
		    drawHill2(1, itsChristmas);
		    break;
		    
		    
	case 9:	    drawHill3(0, itsChristmas); /* up +x,-z */
		    break;
		    
	case 10:    glRotatef(-90, 0, 1, 0);	/* up +x,+z */
		    drawHill3(0, itsChristmas);
		    break;
		    
	case 11:    glRotatef(-180, 0, 1, 0);	/* up pos z */
		    drawHill3(1, itsChristmas);
		    break;
		    
	case 12:    glRotatef(90, 0, 1, 0);	/* up neg x */
		    drawHill3(1, itsChristmas);
		    break;

	}
    }


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makeRoundTreeShadow()
    {
    GLuint O;
    GLUquadricObj *qobj;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    glRotatef(-90, 1, 0, 0);

    qobj = gluNewQuadric();
    gluDisk( qobj, 0.,  0.3, 32, 1);
    gluDeleteQuadric(qobj);

    glEndList();
    return(O);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw all structures on plane (buildings,trees,hills,lakes)    */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawtrees(struct tree * allTreesOnPlane, int numTreesOnPlane, int counter, 
		int detailOn, int itsChristmas, int view)
    {
    
    float spheredat[4];
    float x, y, z;
    register int treeCounter;
    int sph;
    int dit;

    GLint shadeNow;
    
    glGetIntegerv(GL_SHADE_MODEL, &shadeNow);
  
  
    if (detailOn > 0)
	sph= 5;
    else
	sph= 4;

    if (glIsEnabled(GL_DITHER))
	dit = 0;
    else
	dit = 1;


    for (treeCounter=0; treeCounter < numTreesOnPlane; treeCounter++)
	{
	if (detailOn > 0)
	    glShadeModel(GL_SMOOTH);
	else
	    glShadeModel(GL_FLAT);


	if (((fabs(allTreesOnPlane[treeCounter].x) <= PLANESIZE) && (fabs(allTreesOnPlane[treeCounter].z) <= PLANESIZE)) || (view == MAPVIEW))
	    {
	    x = allTreesOnPlane[treeCounter].x;
	    y = allTreesOnPlane[treeCounter].y;
	    z = allTreesOnPlane[treeCounter].z;

	    /**********************************/
	    /* tree                           */
	    /**********************************/

	    if (allTreesOnPlane[treeCounter].type == 0)
		{	    
		if ((allTreesOnPlane[treeCounter].treeshape == 0) || (itsChristmas))
		    {
		    /*************/
		    /* pine tree */
		    /*************/
		    
		    makercubenobtmnotop( x, y+0.2, z, 0.075, 0.2, 0.075, colorbrown);
    
		    makeitPyr(1, treeColor, x, y+0.8, z, 0.2, 0.4, 0.2);
    
		    glColor4fv(colorblack);
		    
		    shadow(x, z, 0.2, 0.2);
		    
		    if (itsChristmas)
			{
			makercube( x+0.09, y+0.9, z+0.09, 0.025, 0.025, 0.025, coloryellow);
			makercube( x-0.12, y+0.7, z+0.12, 0.025, 0.025, 0.025, colorred);
			makercube( x-0.1,  y+0.9, z-0.1,  0.025, 0.025, 0.025, colormaserblue);
			makercube( x+0.12, y+0.7, z-0.12, 0.025, 0.025, 0.025, colororange);
			}
		    }
		else
		    /**************/
		    /* round tree */
		    /**************/
		    {
		    makercubenobtmnotop(x, y+0.4, z, 0.1, 0.4, 0.1, colorbrown);
    
		    glColor3fv(treeColor2);
		    spheredat[0] = x;
		    spheredat[1] = y+1;
		    spheredat[2] = z;
		    spheredat[3] = 0.3;
		    andysphdraw(spheredat, sph);
	
		    glPushMatrix();
			glColor3fv(colorblack);
			glTranslatef(x,  SHADOWS,   z);
			
			glCallList(roundTreeShadow);
			
    
		    glPopMatrix();
		    }
		}

	    /**********************************/
	    /* building                       */
	    /**********************************/
	    	    
	    if (allTreesOnPlane[treeCounter].type == 1)
		{
		glPushMatrix();

		    glTranslatef(x,  y,  z);
		    
		    if (allTreesOnPlane[treeCounter].treeshape <= 17)
			switch(allTreesOnPlane[treeCounter].treeshape){
			    case 0:	drawBuilding0(colorwhite);
					break;
			    case 1:	glCallList(building1Obj);
					break;
			    case 2:	glCallList(building2Obj);
					break;
			    case 3:	if (allTreesOnPlane[treeCounter].deathCount && allTreesOnPlane[treeCounter].death2)
					    drawTower(allTreesOnPlane[treeCounter].deathCount, allTreesOnPlane[treeCounter].death2);
					else
					    glCallList(powerTower);
					break;
			    case 4:	glEnable(GL_DITHER);
					glCallList(coolingTower);    /* cooling tower */
					if (dit)
					    glDisable(GL_DITHER);
					break;
			    case 5:	glCallList(building5Obj);			/* home */
					break;
			    case 6:	drawBuilding6(counter, colorred, coloryellow); /* fast food */
					break;
			    case 7:	glCallList(building7Obj);
					break;
			    case 8:	drawBuilding8(colorbeige,  colorbrown);
					break;
			    case 9:	glEnable(GL_DITHER);
					glCallList(building9Obj);	    /*water tower*/
					if (dit)
					    glDisable(GL_DITHER);
					break;
			    case 10:    glCallList(building10Obj);
					break;
			    case 11:    glEnable(GL_DITHER);
					drawBuilding11(detailOn);	    /* factory smokestacks*/
					if (dit)
					    glDisable(GL_DITHER);
					break;
			    case 12:    glCallList(building12Obj);
					break;
			    case 13:    glRotatef(180, 0, 1, 0);
					glCallList(building5Obj);
					break;
			    case 14:    glCallList(building14Obj);
					break;
			    case 15:    glCallList(strip1Obj); 	/* strip mall */
					break;
			    case 16:    glCallList(strip2Obj); 	/* strip mall */
					break;
			    case 17:    glCallList(strip3Obj); 	/* strip mall */
					break;
			    }
		    else
			switch(allTreesOnPlane[treeCounter].treeshape){
			    case 18:    glRotatef(90, 0, 1, 0);
					drawBuilding0(colorgrey1);
					break;
			    case 19:    glCallList(building19Obj);
					break;
			    case 20:    glCallList(building20Obj);
					break;
			    case 21:    glCallList(building21Obj);
					break;
			    case 22:    drawBuilding22(colorgrey1);
					break;
			    case 23:    drawBuilding22(colorgrey2);
					break;
			    case 24:    drawBuilding22(colorwhite);
					break;
			    case 25:    drawBuilding25();
					break;
			    case 26:    drawBuilding26(0, detailOn);
					break;
			    case 27:    drawBuilding26(1, detailOn);
					break;
			    case 28:    glRotatef(-90, 0, 1, 0);
					drawBuilding6(counter, colorgrey2, colorblue);
					break;
			    case 29:    drawBuilding29(itsChristmas);
					break;
			    case 30:    drawBuilding8(colorbeige,  colorgrey2);
					break;
			    case 31:    glCallList(building31Obj); /* maser battery */
					break;
			    case 32:    glCallList(building32Obj); /* helo pad */
					break;
			    case 33:    drawBuilding33(allTreesOnPlane[treeCounter].deathCount, detailOn); /* hero entrance */
					break;
			    default:    showError("Bogus Building in Tree List! (drawtrees)");
					break;
			}

		glPopMatrix();	
		}

	    /**********************************/
	    /* water                          */
	    /**********************************/
		
	    if (allTreesOnPlane[treeCounter].type == 2)
		{
		glPushMatrix();
		    glTranslatef(x,  ROADS,  z);
		    
		    drawWater(allTreesOnPlane[treeCounter].treeshape, itsChristmas);
		    
		glPopMatrix();
		}

	    /**********************************/
	    /* hills                          */
	    /**********************************/

	    if (allTreesOnPlane[treeCounter].type == 3)
		{
		glPushMatrix();
		    glTranslatef(x, PLANEY, z);		    
		    drawHills(allTreesOnPlane[treeCounter].treeshape, itsChristmas);		    
		glPopMatrix();
		}	    
	    }
	}
	glShadeModel(shadeNow);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw status display (energy and score)                        */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void showText(struct targetInfo * targets, float energy, int score, long winX, int paused)
    {
    float pixtoSpace;
    GLboolean currentZ;
    struct targetInfo * temptarget;
    float drop;

static    char energyEnglish[]		= "energy:";
static    char pausedEnglish[]		= "<p>aused";
    
static float energyBar[4][3] = {
	-4.0, 4.81, 0.0, 
	-4.0, 4.39, 0.0, 
	 0.0, 4.39, 0.0, 
	 0.0, 4.81, 0.0};

    currentZ = glIsEnabled(GL_DEPTH_TEST);
    
    glDisable(GL_DEPTH_TEST);
         
    pixtoSpace = 10.0 / winX;

    /* draw the energy bar */

    if (energy > (MAXLIFE / 3))
	glColor3fv(healthGreen);
    else if (energy > (MAXLIFE / 10))
	glColor3fv(colorbrown); 
    else
	glColor3fv(colorred); 
	
    energyBar[2][0] = energyBar[3][0] = energy / MAXLIFE * 3 - 4;

    glBegin(GL_QUADS);
	glVertex3fv(energyBar[0]);
	glVertex3fv(energyBar[1]);
	glVertex3fv(energyBar[2]);
	glVertex3fv(energyBar[3]);
    glEnd(); 

    energyBar[2][0] = energyBar[3][0] = -1;

    glColor3fv(colorwhite);	
	
    glBegin(GL_LINE_LOOP);
	glVertex3fv(energyBar[0]);
	glVertex3fv(energyBar[1]);
	glVertex3fv(energyBar[2]);
	glVertex3fv(energyBar[3]);
    glEnd(); 

    /************************************************/
    /* draw energy bar for any target on the screen */
    /************************************************/

    if (targets->next != NULL)
	{
	drop = 0;
	for(temptarget = targets->next; temptarget != NULL; temptarget = temptarget->next)
	    if ((fabs(temptarget->x) <= PLANESIZE) && (fabs(temptarget->z) <= PLANESIZE))
	    {
	    drop -=0.6;
    
	    glPushMatrix();
		glTranslatef(0, drop, 0);
    
		energy = temptarget->monster.energyRemaining;
    
		if (energy > (MAXLIFE / 3))
		    glColor3fv(healthGreen);
		else if (energy > (MAXLIFE / 10))
		    glColor3fv(colorbrown); 
		else
		    glColor3fv(colorred); 
		    
		energyBar[2][0] = energyBar[3][0] = energy / MAXLIFE * 3 - 4;
	    
		glBegin(GL_QUADS);
		    glVertex3fv(energyBar[0]);
		    glVertex3fv(energyBar[1]);
		    glVertex3fv(energyBar[2]);
		    glVertex3fv(energyBar[3]);
		glEnd(); 
	    
		energyBar[2][0] = energyBar[3][0] = -1;
	    
		glColor3fv(colorwhite);	
		    
		glBegin(GL_LINE_LOOP);
		    glVertex3fv(energyBar[0]);
		    glVertex3fv(energyBar[1]);
		    glVertex3fv(energyBar[2]);
		    glVertex3fv(energyBar[3]);
		glEnd(); 
    
	    glPopMatrix();
    
	    glPushMatrix();
		glTranslatef(-3.8,  4.4+drop,  0);
		
		switch(temptarget->monster.monster)
		    {
		    case GOOGELON:  tkDrawStr(strokeBase,"Googelon");
				    break;
		    case TECHS:	    tkDrawStr(strokeBase,"Techs");
				    break;
		    case VAPOUR:    tkDrawStr(strokeBase,"Vapour");
				    break;
		    case FLUTTER:   tkDrawStr(strokeBase,"Flutter");
				    break;
		    }
		glPopMatrix();
	    }	
	}
 
    glPushMatrix();
	glTranslatef(-3.8,  4.45,  0);
	tkDrawStr(strokeBase, energyEnglish);
    glPopMatrix();

    /***********************/
    /* print out the score */
    /***********************/


    sprintf(textline, "score: %1d", score);
    
    glPushMatrix();
	glTranslatef(1.9,  4.45,  0);
	tkDrawStr(strokeBase, textline);
    glPopMatrix();


    /****************************/
    /* print out the frame rate */
    /****************************/

#ifdef DEBUG
    sprintf(textline,  "%d",  winX);

    glPushMatrix();
	glTranslatef(0,  4.4,  0);
	tkDrawStr(strokeBase, textline);
    glPopMatrix();
#endif

    if (paused)
	{
	glPushMatrix();
	    glTranslatef(-0.7,  4.4,  0);	
	    tkDrawStr(strokeBase, pausedEnglish);
	glPopMatrix();

	}
	
    if(currentZ)
	glEnable(GL_DEPTH_TEST);
    else
	glDisable(GL_DEPTH_TEST);
    }   

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void showScores(int itsChristmas, struct score* gscore, struct score* vscore,
		struct score* tscore, struct score* fscore, 
		struct monsterInfo monster,  int counter,float offsetX)
    {
    char textString[256];
    struct monsterInfo tempMonster;

#ifndef MESAVERSION

static    float scoreBox[4][3] = {
	-1,  0.42, 7.1,
	-1, -0.6, 7.1,
	 1, -0.6, 7.1, 
	 1,  0.42, 7.1};

#endif
 
    /***********************************/
    /* these monsters are always alive */
    /***********************************/
   
    tempMonster 		= monster;
    tempMonster.energyRemaining = 100;
    tempMonster.monsterIsDead 	= 0;
    tempMonster.deadCount 	= 0;
        	
    /*************************************/
    /* draw transparent brown background */
    /*************************************/

    glDisable(GL_DEPTH_TEST);


#ifndef MESAVERSION

    glEnable(GL_BLEND);
    

    glColor4fv(colorbrown);

    glBegin(GL_QUADS);
	glVertex3fv(scoreBox[0]);
	glVertex3fv(scoreBox[1]);
	glVertex3fv(scoreBox[2]);
	glVertex3fv(scoreBox[3]);
    glEnd();		

    glDisable(GL_BLEND);

#endif


    /*****************/
    /* draw monsters */
    /*****************/

    glEnable(GL_DEPTH_TEST);
	    
    glPushMatrix();
	glTranslatef(-0.8,  0.14,  7.2);
	glScalef(.2,  .2,  .2);
	drawMonster(tempMonster, counter, itsChristmas);
    glPopMatrix();

    glPushMatrix();
	glTranslatef(-0.8,  -0.23,  7.2);
	glScalef(.2,  .2,  .2);
	drawVapour(tempMonster, itsChristmas);
    glPopMatrix();
	
    glPushMatrix();
	glTranslatef(+.14,  0.1,  7.2);
	glScalef(.2,  .2,  .2);
	drawTechs(tempMonster);
    glPopMatrix();


    glPushMatrix();
	glTranslatef(+.14,  -0.26,  7.2);
	glScalef(.2,  .2,  .2);
	drawFlutter(tempMonster, counter, itsChristmas, offsetX, OMNISCIENTVIEW);
    glPopMatrix();

    /*************/
    /* draw text */
    /*************/

    glColor3fv(colorwhite); 

   glDisable(GL_DEPTH_TEST);

    glPushMatrix();
	glTranslatef(-2,  1.4,  0);
	tkDrawStr(strokeBase, "High Scores");
    glPopMatrix();


    /*************************************/


    if (gscore[0].number > -1)
        {
	sprintf(textString, "%5d %s", gscore[0].number, gscore[0].name); 
	glPushMatrix();
	    glTranslatef(-4,  0.5,  0);
	    tkDrawStr(strokeBase, textString);
	glPopMatrix();
        }
    else
	{
	glPushMatrix();
	    glTranslatef(-4,  0.5,  0);
	    tkDrawStr(strokeBase, "  none");
	glPopMatrix();
	}
    
    if (gscore[1].number > -1)
        {
	sprintf(textString, "%5d %s", gscore[1].number, gscore[1].name); 
	glPushMatrix();
	    glTranslatef(-4,  0,  0);
	    tkDrawStr(strokeBase, textString);
	glPopMatrix();
       }
    
    if (gscore[2].number > -1)
        {
	sprintf(textString, "%5d %s", gscore[2].number, gscore[2].name); 
	glPushMatrix();
	    glTranslatef(-4,  -0.5,  0);
	    tkDrawStr(strokeBase, textString);
	glPopMatrix();
        }

    /*************************************/

    if (vscore[0].number > -1)
        {
	sprintf(textString, "%5d %s", vscore[0].number, vscore[0].name); 
	glPushMatrix();
	    glTranslatef(-4,  -1.5,  0);
	    tkDrawStr(strokeBase, textString);
	glPopMatrix();
	}
    else
	{
	glPushMatrix();
	    glTranslatef(-4,  -1.5,  0);
	    tkDrawStr(strokeBase, "  none");
	glPopMatrix();
	}
	
    if (vscore[1].number > -1)
        {
	sprintf(textString, "%5d %s", vscore[1].number, vscore[1].name); 
	glPushMatrix();
	    glTranslatef(-4,  -2,  0);
	    tkDrawStr(strokeBase, textString);
	glPopMatrix();
	}

    if (vscore[2].number > -1)
        {
	sprintf(textString, "%5d %s", vscore[2].number, vscore[2].name); 
	glPushMatrix();
	    glTranslatef(-4,  -2.5,  0);
	    tkDrawStr(strokeBase, textString);
	glPopMatrix();
	}
	
    /*************************************/

    if (tscore[0].number > -1)
        {
	sprintf(textString, "%5d %s", tscore[0].number, tscore[0].name); 
	glPushMatrix();
	    glTranslatef(0.6,  0.5,  0);
	    tkDrawStr(strokeBase, textString);
	glPopMatrix();
	}
    else
	{
	glPushMatrix();
	    glTranslatef(0.6,  0.5,  0);
	    tkDrawStr(strokeBase, "  none");
	glPopMatrix();
	}
	
   if (tscore[1].number > -1)
        {
	sprintf(textString, "%5d %s", tscore[1].number, tscore[1].name); 
	glPushMatrix();
	    glTranslatef(0.6,  0,  0);
	    tkDrawStr(strokeBase, textString);
	glPopMatrix();
	}
	
   if (tscore[2].number > -1)
        {
	sprintf(textString, "%5d %s", tscore[2].number, tscore[2].name); 
	glPushMatrix();
	    glTranslatef(0.6,  -0.5,  0);
	    tkDrawStr(strokeBase, textString);
	glPopMatrix();
	}
	
    /*************************************/

    if (fscore[0].number > -1)
        {
	sprintf(textString, "%5d %s", fscore[0].number, fscore[0].name); 
	glPushMatrix();
	    glTranslatef(0.6,  -1.5,  0);
	    tkDrawStr(strokeBase, textString);
	glPopMatrix();
	}
    else
	{
	glPushMatrix();
	    glTranslatef(0.6,  -1.5,  0);
	    tkDrawStr(strokeBase, "  none");
	glPopMatrix();
	}

    if (fscore[1].number > -1)
        {
	sprintf(textString, "%5d %s", fscore[1].number, fscore[1].name); 
	glPushMatrix();
	    glTranslatef(0.6,  -2,  0);
	    tkDrawStr(strokeBase, textString);
	glPopMatrix();
	}
	
    if (fscore[2].number > -1)
        {	
	sprintf(textString, "%5d %s", fscore[2].number, fscore[2].name); 
	glPushMatrix();
	    glTranslatef(0.6,  -2.5,  0);
	    tkDrawStr(strokeBase, textString);
	glPopMatrix();
	}

    glEnable(GL_DEPTH_TEST);
    }
    
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw list of views/options/controls)                          */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void showText2(long winX, int soundOn, int noSound, int musicOn, 
		int mode3D, int no3D, int detailOn, int paused,
		int itsChristmas)
    {
    float pixtoSpace;
    float right;

static    char viewsEnglish[]	= "Views:";
static    char views1English[]	= "-Monster";
static    char views2English[]	= "-Overview";
static    char views3English[]	= "-Army";

static    char onstring[]		= " (ON)";
static    char offstring[]		= " (OFF)";
static    char lowstring[]		= " (LOW)";
static    char highstring[]		= " (HIGH)";
static    char unavailablestring[] 	= " ( - )";

static    char moveEnglish[]		= "mouse/arrows";
static    char shootEnglish[]		= "left btn/ctrl";
static    char azEnglish[]		= "a z";
static    char videoEnglish[]		= "-3D";
static    char rotateEnglish[]		= "- Rotate Overview";
static    char ijklEnglish[]		= "ijkl";
static    char showcaseEnglish[]	= "-Help";
static    char pauseEnglish[]		= "-Pause";
static    char detailEnglish[]		= "-Detail";
static    char soundEnglish[]		= "-Sound";
static    char musicEnglish[]		= "-Music";

    
    pixtoSpace = 3.0/ winX;
          
    glDisable(GL_DEPTH_TEST);


    if (itsChristmas)
	glColor3fv(planeGreen); 
    else
	glColor3fv(coloryellow); 

    /*********/
    /* views */
    /*********/

    glPushMatrix();
	glTranslatef(-5.0,  +0.5,  0);
	tkDrawStr(strokeBase, viewsEnglish);
    glPopMatrix();

    glPushMatrix();
	glTranslatef(-4.8,  0,  0);
	tkDrawStr(strokeBase, "1");
	
	glTranslatef(0.2,  0,  0);
	tkDrawStr(strokeBase, views1English);
    glPopMatrix();
    
    glPushMatrix();
	glTranslatef(-4.8,  -0.5,  0);
	tkDrawStr(strokeBase, "2");
	
	glTranslatef(0.2,  0,  0);	
	tkDrawStr(strokeBase, views2English);
    glPopMatrix();    
    
    glPushMatrix();
	glTranslatef(-4.8,  -1,  0);
	tkDrawStr(strokeBase, "3");
	
	glTranslatef(0.2,  0,  0);
	tkDrawStr(strokeBase, views3English);
    glPopMatrix();    


    /************/
    /* controls */
    /************/

    if (mode3D)
	right = 0.2;
    else
	right = -1.0;


    glPushMatrix();
	glTranslatef(right+0.3,  -2,  0);
	tkDrawStr(strokeBase, "Controls:");
    glPopMatrix();

    glPushMatrix();
	glTranslatef(right + 0.5,  -2.5,  0);
	tkDrawStr(strokeBase, moveEnglish);
    glPopMatrix();
    glPushMatrix();
	glTranslatef(right + 4.1,  -2.5,  0);
	tkDrawStr(strokeBase, "-Move");
    glPopMatrix();
	

    glPushMatrix();
	glTranslatef(right + 0.5,  -3,  0);
	tkDrawStr(strokeBase, shootEnglish);
    glPopMatrix();
    glPushMatrix();
	glTranslatef(right + 4.1,  -3,  0);
	tkDrawStr(strokeBase, "-Attack");
    glPopMatrix();
   

    glPushMatrix();
	glTranslatef(right+0.5,  -3.5,  0);
	tkDrawStr(strokeBase, azEnglish);
    glPopMatrix();
    glPushMatrix();
	glTranslatef(right + 3.25,  -3.5,  0);
	tkDrawStr(strokeBase, "-Tilt Head");
    glPopMatrix();


    glPushMatrix();
	glTranslatef(right+0.5,  -4,  0);
	tkDrawStr(strokeBase, ijklEnglish);
    glPopMatrix();
    glPushMatrix();
	glTranslatef(right+1.5,  -4,  0);
	tkDrawStr(strokeBase, rotateEnglish);
    glPopMatrix();

    /***********/
    /* options */
    /***********/


    glPushMatrix();
	glTranslatef(-5,  -2,  0);
	tkDrawStr(strokeBase, "Options:");
    glPopMatrix();



    glPushMatrix();
	glTranslatef(-4.8,  -2.5,  0);
	tkDrawStr(strokeBase, "d");

	glTranslatef(0.2,  0,  0);
	tkDrawStr(strokeBase, detailEnglish);
    glPopMatrix();
    glPushMatrix();
	glTranslatef(-2.75,  -2.5,  0);
	detailOn ? tkDrawStr(strokeBase, highstring) : tkDrawStr(strokeBase, lowstring);
    glPopMatrix();
    
    


    glPushMatrix();
	glTranslatef(-4.8,  -3,  0);
	tkDrawStr(strokeBase, "s");

	glTranslatef(0.2,  0,  0);
	tkDrawStr(strokeBase, soundEnglish);
    glPopMatrix();

    glPushMatrix();
	glTranslatef(-2.75,  -3,  0);

	if (noSound)
	    tkDrawStr(strokeBase,unavailablestring);
	else
	    soundOn ? tkDrawStr(strokeBase,onstring) : tkDrawStr(strokeBase,offstring);
    glPopMatrix();


    glPushMatrix();
	glTranslatef(-4.8,  -3.5,  0);
	tkDrawStr(strokeBase, "m");

	glTranslatef(0.2,  0,  0);
	tkDrawStr(strokeBase, musicEnglish);
    glPopMatrix();

    glPushMatrix();
	glTranslatef(-2.75,  -3.5,  0);

	if (noSound)
	    tkDrawStr(strokeBase,unavailablestring);
	else
	    musicOn ? tkDrawStr(strokeBase,onstring) : tkDrawStr(strokeBase,offstring);
    glPopMatrix();
	
	
    glPushMatrix();
	glTranslatef(-4.8,  -4,  0);
	tkDrawStr(strokeBase, "p");

	glTranslatef(0.2,  0,  0);
	tkDrawStr(strokeBase, pauseEnglish);
    glPopMatrix();

    glPushMatrix();
	glTranslatef(-2.75,  -4,  0);
	paused ? tkDrawStr(strokeBase,onstring) : tkDrawStr(strokeBase,offstring);
    glPopMatrix();

		
    glPushMatrix();
	glTranslatef(-4.8,  -4.5,  0);
	tkDrawStr(strokeBase, "v");

	glTranslatef(0.2,  0,  0);
	tkDrawStr(strokeBase, videoEnglish);
    glPopMatrix();

    glPushMatrix();
	glTranslatef(-2.75,  -4.5,  0);

	if (no3D)
	    tkDrawStr(strokeBase,unavailablestring);
	else
	    mode3D ? tkDrawStr(strokeBase,onstring) : tkDrawStr(strokeBase,offstring);

    glPopMatrix();

    glPushMatrix();
	glTranslatef(-4.8,  -5,  0);
	tkDrawStr(strokeBase, "h");

	glTranslatef(0.2,  0,  0);
	tkDrawStr(strokeBase, showcaseEnglish);
    glPopMatrix();

#ifndef SGIVERSION
    glPushMatrix();
	glTranslatef(-2.75,  -5,  0);

	tkDrawStr(strokeBase,unavailablestring);

    glPopMatrix();
#endif

    glEnable(GL_DEPTH_TEST);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw the 'andy johnson's battalion' title                     */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void showText3()
    {
static    char andyEnglish[]		= "andy johnson's";
static    char versionEnglish[]		= "1.2";

    /************************/
    /* print battalion logo */
    /************************/

    glCallList(titleObj);
	
    glColor3fv(colorwhite); 

    /**************************/
    /* print "andy johnsons'" */
    /**************************/

    glPushMatrix();
	glTranslatef(1.6 ,  +3.85,  0);
	glScalef(0.57, 0.83, 1);
	tkDrawStr(strokeBase, andyEnglish);
    glPopMatrix();

    /************************/
    /* print version number */
    /************************/

    glPushMatrix();
	glTranslatef(4.3,  -5.1,  0);
	glScalef(0.75, 0.75, 1);
	tkDrawStr(strokeBase, versionEnglish);
    glPopMatrix();
   }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw 'press spacebar to begin'                                */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void showText4()
    {
static    char spaceEnglish[]		= "Press the spacebar to begin";

    glColor3fv(colorwhite); 

    glPushMatrix();
	glTranslatef(-3.85,  2.3,  0);
	tkDrawStr(strokeBase, spaceEnglish);
    glPopMatrix();
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw all tanks currently dying                                */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawSlagTanks(struct tank * allSlags, int counter, int detailOn)
    {    
    int c;
    float angle2;
    struct tank * ttank;
    
    for(ttank = allSlags->next;ttank != NULL;ttank = ttank->next)
	{
	if ((fabs(ttank->x) <= PLANESIZE) && (fabs(ttank->z) <= PLANESIZE))
	    {
	    angle2 = ttank->theta * RAD_TO_SMALL_DEG;

	    c = ttank->count;
		    
	    glPushMatrix();
	
	    switch(ttank->type){
		case TANK:	glTranslatef(ttank->x, ttank->y-0.015, ttank->z);
				glScalef(1+0.015*c,  1-0.015*c,  1+0.015*c);
				glRotatef(angle2, 0, 1, 0);
				glCallList(slagtank);
				break;
	
		case LAUNCHER:	glTranslatef(ttank->x, ttank->y-0.015, ttank->z);
				glScalef(1+0.015*c,  1-0.015*c,  1+0.015*c);
				glRotatef(angle2, 0, 1, 0);
				glCallList(slaglaunchertank);
				break;
	
		    	    
		case MASERTANK:	glTranslatef(ttank->x, ttank->y-0.015, ttank->z);
				glScalef(0.15+0.002*c,  0.15-0.004*c,  0.15+0.002*c);
				glRotatef(angle2, 0, 1, 0);
				glCallList(slagmasertank);
				break;
  
		case HELO:	glTranslatef(ttank->x, ttank->y, ttank->z);
				glRotatef(c*4.0, 1, 0, 0);
				glRotatef(c*1.5, 0, 0, 1);
				glRotatef(angle2+180+(c*10), 0, 1, 0);
				drawHelo((counter*9) % 360, 1);
				break;

		case CHH:	glTranslatef(ttank->x, ttank->y, ttank->z);
				glRotatef(c*4.0, 1, 0, 0);
				glRotatef(c*1.5, 0, 0, 1);
				glRotatef(angle2+(c*10), 0, 1, 0);
				makeCHH(0);
				break;

		case MECHAG:	glTranslatef(ttank->x, 0, ttank->z);
				glRotatef(angle2, 0, 1, 0);
				drawMechaMonster(0, counter);
				break;
				
		case HERO:	glTranslatef(ttank->x, 0, ttank->z);
				glRotatef(angle2, 0, 1, 0);
				if (ttank->subtype == 0)
				    drawHeroDude(0, ttank->walking, ttank->maserCount, c, detailOn);
				else
				    drawHeroDude2(0, ttank->walking, ttank->maserCount, c, detailOn);
				break;
				
		case AIRPLANE:	glTranslatef(ttank->x, ttank->y, ttank->z);
				glRotatef(c*1.5, 0, 0, 1);
				glRotatef(angle2+180+(c*10), 0, 1, 0);
				glScalef(3,  3,  3);
				drawAirplane((counter*2) % 360);
				break;

		case FIGHTER:	glTranslatef(ttank->x, ttank->y, ttank->z);
				glRotatef(c*1.5, 0, 0, 1);
				glRotatef(angle2+180+(c*10), 0, 1, 0);
				glScalef(2,  2,  2);
				drawFighter();
				break;
				
		default:	showError("Bogus Vehicle in Tank List! (drawSlagTanks)");
				break;
		}
	    	    
	    glPopMatrix();
	    }
	}
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw maser beams                                              */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawMaser(float sourceX, float sourceY, float sourceZ,
		int shooter, float mX, float mZ, float mHeight, float mBottom, 
		float r1, float r2, float r3, int width, int view)

    {
    float beamLoc1[3],  beamLoc2[3];

    beamLoc1[0] = sourceX;
    beamLoc1[1] = sourceY;
    beamLoc1[2] = sourceZ;

    beamLoc2[0] = mX + r1;
    beamLoc2[1] = 0.5 * (mHeight - mBottom) + mBottom + r2;
    beamLoc2[2] = mZ + r3;

    if ((view == MONSTERVIEW) || (view == ARMYVIEW))
	glLineWidth(width * 0.0057);
    else
	glLineWidth(width * 0.0029);
    
    
    glColor3fv(colorwhite);

    glBegin(GL_LINES);
	glVertex3fv(beamLoc1);
	glVertex3fv(beamLoc2);

    glEnd();


    switch(shooter)
	{
	case MASERTANK:	    glColor3fv(colormaserblue);
			    break;
			    
	case CHH:	    glColor3fv(colormaseryellow);
			    break;
			    
	case MECHAG:	    glColor3fv(colorred);
			    break;
			    
	default:	    showError("Invalid Vehicle Type (drawMaser)");
			    break;
	}
	    
    glEnable(GL_BLEND);
    
    if ((view == MONSTERVIEW) || (view == ARMYVIEW))
	glLineWidth(width * 0.011);
    else
	glLineWidth(width * 0.0057);

    glBegin(GL_LINES);

	glVertex3fv(beamLoc1);
	glVertex3fv(beamLoc2);
    glEnd();
	
    glDisable(GL_BLEND);
    } 

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw all tanks on the battlefield                             */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawTanks(struct tank * allTanks,  int counter, struct monsterInfo G,
		struct targetInfo * targs, int detailOn, int view, int wid)

    {
    struct tank cTank;
    struct tank * temptank;
    float angle2;
    int monsterIsDead;
    float height, bottom;
    float xloc,  zloc;
    float radToNearestTarget, rad;
    struct targetInfo * nearestTarget;
    struct monsterInfo * nearestMonster;
    struct targetInfo * temptarget;
    

    for(temptank = allTanks->next;temptank != NULL;temptank = temptank->next)
	{
	cTank = *temptank;
	
	if (((fabs(cTank.x) <= PLANESIZE) && (fabs(cTank.z) <= PLANESIZE)) || (view == MAPVIEW))
	    {
	    
	    
	/* need to find the nearest target */
	
	radToNearestTarget = 10000;
	nearestTarget = NULL;
    	for(temptarget = targs->next;temptarget != NULL;temptarget = temptarget->next)
	    {
	    rad = sqrt((cTank.x-temptarget->x) * (cTank.x-temptarget->x) + (cTank.z-temptarget->z) * (cTank.z-temptarget->z));
	    if (rad < radToNearestTarget)
		{
		radToNearestTarget = rad;
		nearestTarget = temptarget;
		nearestMonster = &(temptarget->monster);
		}
	    }

	/* need to compute radius to player's monster */

	rad = sqrt(cTank.x * cTank.x + cTank.z * cTank.z);

	if (rad < radToNearestTarget)
	    {
	    radToNearestTarget = rad;
	    nearestMonster = NULL;
	    nearestTarget = NULL;
	    }

	if (nearestMonster == NULL)
	    {
	    monsterIsDead = G.monsterIsDead;
	    height = G.height;
	    bottom = G.bottom;
	    xloc = 0;
	    zloc = 0;
	    }
	else
	    {
	    monsterIsDead = nearestMonster->monsterIsDead;
	    height = nearestMonster->height;
	    bottom = nearestMonster->bottom;
	    xloc = nearestTarget->x;
	    zloc = nearestTarget->z;
	    }


	    /**********************************/
	    /* aim vehicle                    */
	    /**********************************/

	    angle2 = cTank.theta * RAD_TO_SMALL_DEG;
	    
	    /**********************************/
	    /* draw vehicle                   */
	    /**********************************/
		    
	    glPushMatrix();

	    switch (cTank.type)
		{
		case TANK:	glTranslatef(cTank.x, cTank.y, cTank.z);
  				glRotatef(angle2, 0, 1, 0);
				glCallList(plaintank);
				break;

		case LAUNCHER:	glTranslatef(cTank.x, cTank.y, cTank.z);
  				glRotatef(angle2, 0, 1, 0);
				glCallList(launchertank);
				break;
			
		case MASERTANK:	glTranslatef(cTank.x, cTank.y, cTank.z);
  				glRotatef(angle2, 0, 1, 0);
				glScalef(0.15,  0.15,  0.15);
				glCallList(masertank);
				break;

		case HELO:	glTranslatef(cTank.x, cTank.y, cTank.z);
  				glRotatef(angle2+180, 0, 1, 0);
				drawHelo((counter*9) % 360,  0);
				break;

		case AIRPLANE:	glTranslatef(cTank.x, cTank.y, cTank.z);
  				glRotatef(angle2+180, 0, 1, 0);
				glScalef(3,  3,  3);
				drawAirplane((counter*2) % 360);
				break;

		case FIGHTER:	glTranslatef(cTank.x, cTank.y, cTank.z);
  				glRotatef(angle2+180, 0, 1, 0);
				glScalef(2,  2,  2);
				drawFighter();
				break;

		case CHH:	glTranslatef(cTank.x, cTank.y, cTank.z);
  				glRotatef(angle2, 0, 1, 0);
				makeCHH(cTank.damage);
				break;
				
		case MECHAG:	glTranslatef(cTank.x, 0, cTank.z);
  				glRotatef(angle2, 0, 1, 0);
				drawMechaMonster(cTank.damage, counter);
				break;

		case HERO:	glTranslatef(cTank.x, 0, cTank.z);
  				glRotatef(angle2, 0, 1, 0);
				if (cTank.subtype == 0)
				    drawHeroDude(cTank.damage, cTank.walking, cTank.maserCount, 0, detailOn);
				else
				    drawHeroDude2(cTank.damage, cTank.walking, cTank.maserCount, 0, detailOn);
				break;
				
		default:	showError("Bogus Vehicle in Tank List! (drawTanks)");
				break;
		}
	    
	    glPopMatrix();	
  	
	    /**********************************/
	    /* draw shadow                    */
	    /**********************************/

	    glPushMatrix();
		glTranslatef(cTank.x, 0, cTank.z);
		glRotatef(angle2, 0, 1, 0);

		switch (cTank.type){
		    case TANK:
		    case LAUNCHER:
		    case MASERTANK:	glCallList(tankShadow);
					break;
		    
		    case HELO:	    	glColor4fv(colorblack);
					shadow (0, 0, 0.14, 0.18);
					shadow (0, -0.22, 0.04, 0.1);
					break;
		    
		    case MECHAG:	break;
		    
		    case CHH:		glColor4fv(colorblack);
					shadow (0, 0, 0.14, 0.22);
					break;
		    
		    case HERO:		glColor4fv(colorblack);
					shadow (0, 0, 0.12, 0.08);
					break;
		    
		    case AIRPLANE:	glCallList(planeShadow);
					break;

		    case FIGHTER:	glCallList(fighterShadow);	
					break;

		    default:		showError("Bogus Vehicle in Tank List! (drawTanks)");
					break;
		}
	    glPopMatrix();

  
	    if ((cTank.maserCount > 0) && (cTank.rad <= cTank.range) && (cTank.rad >= 0.5) && (!monsterIsDead))
		{
		/**********************************/
		/* mechaGoogelon firing maser     */
		/**********************************/

		if (cTank.type == MECHAG)
		    drawMaser(cTank.x, cTank.y + 0.8, cTank.z, cTank.type, xloc, zloc, height, bottom, cTank.rand1, cTank.rand2, cTank.rand3, wid, view);
  
		/**********************************/
		/* 009CHH firing maser            */
		/**********************************/
	
		if (cTank.type == CHH)
		    drawMaser(cTank.x, cTank.y, cTank.z, cTank.type, xloc, zloc, height, bottom, cTank.rand1, cTank.rand2, cTank.rand3, wid, view);
  		
		/**********************************/
		/* tank firing maser              */
		/**********************************/

		if (cTank.type == MASERTANK)
		    drawMaser(cTank.x, cTank.y + 0.375, cTank.z, cTank.type, xloc, zloc, height, bottom, cTank.rand1, cTank.rand2, cTank.rand3, wid, view);
  
		/**********************************/
		/* hero firing its weapon         */
		/**********************************/

		if ((cTank.type == HERO) && (cTank.subtype == 1) && (cTank.maserCount > 10) && (cTank.maserCount < 30))
		    if (nearestTarget)
    			drawHeroWeapon(nearestTarget->x, nearestTarget->z, cTank.x, cTank.y + 0.275, cTank.z, colormaserblue, height, bottom);
		    else
    			drawHeroWeapon(0, 0, cTank.x, cTank.y + 0.275, cTank.z, colormaserblue, height, bottom);

  		} 
	    }  
	}  
    }

 
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw hero energy beam                                         */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawHeroWeapon(float targetx, float targetz, float x, float y,
		    float z, float * color, float height, float bottom)
    {
    float loc1[3],  loc2[3];
    float rad,  angle,  r;
    float midPoint;
    GLboolean backNow;
    
    GLint shadeNow;
    
    glGetIntegerv(GL_SHADE_MODEL, &shadeNow);
    backNow = glIsEnabled(GL_CULL_FACE);
    
    rad = sqrt(x * x + z * z);
    
    if (rad == 0)
	rad = NEARZERO;
	
    r = 0.16 / rad;
    
    if (z == 0)
	z = NEARZERO;

    angle = atan(x / z);

    if (z > 0)
	angle += PI;
   
    angle += PI;
     
    midPoint = 0.5 * (height - bottom) + bottom;
    
    glShadeModel(GL_SMOOTH);
    glDisable(GL_CULL_FACE);
    
    glBegin(GL_QUADS);
	glColor3fv(color);
 	loc1[0] = (rad - 0.22) * sin(angle + r);
	loc1[1] = y;
	loc1[2] = (rad - 0.22) * cos(angle + r);
	glVertex3fv(loc1);
	    
 	loc1[0] = (rad - 0.22) * sin(angle - r);
	loc1[2] = (rad - 0.22) * cos(angle - r);
	glVertex3fv(loc1);
	    
	glColor3fv(colorwhite);	
	loc2[0] = targetx - 0.04;
	loc2[2] = targetz - 0.04;
	loc2[1] = midPoint;
	glVertex3fv(loc2);
	    
	loc2[0] = targetx + 0.04;
	loc2[2] = targetz + 0.04;
	glVertex3fv(loc2);
    glEnd();

    /* make beam viewable from side */

    glBegin(GL_QUADS);
	glColor3fv(color);
 	loc1[0] = (rad - 0.22) * sin(angle);
	loc1[1] = y + 0.03;
	loc1[2] = (rad - 0.22) * cos(angle);
	glVertex3fv(loc1);
	    
	loc1[1] = y - 0.03;
	glVertex3fv(loc1);
	    
	glColor3fv(colorwhite);	
	loc2[0] = targetx;
	loc2[2] = targetz;
	loc2[1] = midPoint - 0.02;
	glVertex3fv(loc2);
	    
	loc2[1] = midPoint + 0.02;
	glVertex3fv(loc2);
    glEnd();
	
    if (backNow)
	glEnable(GL_CULL_FACE);
    else
	glDisable(GL_CULL_FACE);
	
    glShadeModel(shadeNow);
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void makeBooms()
{
    int counter;
    GLuint O;

    float spheredat[4];
	spheredat[0] = 0;
	spheredat[1] = 0;
	spheredat[2] = 0;
    
    for(counter=1;counter<=10;counter++)
	{
	O = glGenLists(1);
	glNewList(O, GL_COMPILE);
	   
	spheredat[3] = 0.03 * counter;

#ifdef MESAVERSION

	andysphdraw(spheredat, 2);

#else

	andysphdraw(spheredat, 3);

#endif 
	glEndList();

	switch(counter)
	    {
	    case 1: boom1Obj = O;
		    break;
	    case 2: boom2Obj = O;
		    break;
	    case 3: boom3Obj = O;
		    break;
	    case 4: boom4Obj = O;
		    break;
	    case 5: boom5Obj = O;
		    break;
	    case 6: boom6Obj = O;
		    break;
	    case 7: boom7Obj = O;
		    break;
	    case 8: boom8Obj = O;
		    break;
	    case 9: boom9Obj = O;
		    break;
	    case 10: boom10Obj = O;
		    break;
	    }

	}
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw explosions                                               */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawBooms(struct boom * boomers, int detailOn)
    {
    struct boom  * tempboom;
    struct boom b;

    if (detailOn > 0)
	{
	glEnable(GL_BLEND);
	}

    glColor3fv(coloryellow);

    for(tempboom = boomers->next;tempboom != NULL;tempboom = tempboom->next)
	{
	b = *tempboom;
		
	if (detailOn > 0)
	    {
	    coloryellow[3] = (11 - b.count) * 0.1;
	    glColor4fv(coloryellow);
	    }
	
	glPushMatrix();
	    glTranslatef(b.x, b.y, b.z);
	    	    
	    switch(b.count)
		{
		case 1: glCallList(boom1Obj);
			break;
		case 2: glCallList(boom2Obj);
			break;
		case 3: glCallList(boom3Obj);
			break;
		case 4: glCallList(boom4Obj);
			break;
		case 5: glCallList(boom5Obj);
			break;
		case 6: glCallList(boom6Obj);
			break;
		case 7: glCallList(boom7Obj);
			break;
		case 8: glCallList(boom8Obj);
			break;
		case 9: glCallList(boom9Obj);
			break;
		case 10: glCallList(boom10Obj);
			break;
		}
	glPopMatrix();
	}
	
    if (detailOn > 0)
	{
	glDisable(GL_BLEND);
	}
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw googelon/Flutter's energy beam                           */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawBeam(float x, float z, int horz, int vert, int monsterName)
    {
    float loc1[3],  loc2[3],  loc3[3];
    float c[4] = {0, 0, 0, 0};
    float * col;
    float R;
    register int i;

    GLint shadeNow;

    glGetIntegerv(GL_SHADE_MODEL, &shadeNow);
    
    if (monsterName == FLUTTER)
	col = colororange;
    else
	col = colorblue;
	    
    /**********************************/
    /* draw beam                      */
    /**********************************/

    glLineWidth(5.0);

    if (vert < 175)
	R = 4;
    else
	R = 1.2 / (cos((900 - vert) * BIG_DEG_TO_RAD));

    if (R < 0)
	R = 0;
    if (R > 4)
	R = 4;

    if (vert < 0)
	loc3[1] = PLANEY + 1.2 + R * sin(fabs(vert * BIG_DEG_TO_RAD));
    else
	loc3[1] = PLANEY + 1.2 - R * sin(fabs(vert * BIG_DEG_TO_RAD));

    loc1[0] = x;
    loc1[2] = z;
    loc1[1] = PLANEY + 1.2;

/* this doesnt really work ... beam has xz value of 4 no matter what y is (> plane)
 * so beam will be longer than 4 as it gets higher up in the sky
 */
 
    loc3[0] = x+R * -cos((900 + horz) * BIG_DEG_TO_RAD);
    loc3[2] = z+R * sin((900 + horz) * BIG_DEG_TO_RAD);

    if (loc3[1] < PLANEY)
	loc3[1] = PLANEY;

    if (monsterName == FLUTTER)
	c[0] = 0.95;
    else
	c[2] = 0.95;

    glShadeModel(GL_SMOOTH);

    for (i=0;i<40;i++)
	{
	loc2[0] = loc3[0] + randy(0.04);
	loc2[1] = loc3[1] + randy(0.04);
	loc2[2] = loc3[2] + randy(0.04);

	c[1] = 0.5 + randy(0.5);
	
	glBegin(GL_LINES);
	    glColor3fv(c);
	    glVertex3fv(loc2);
	    glColor3fv(col);
	    glVertex3fv(loc1);
	glEnd();
	}
	
    glShadeModel(shadeNow);
	
    /**********************************/
    /* shadow of beam                 */
    /**********************************/

    glColor3fv(colorblack);
    loc1[1] = SHADOWS;
    loc3[1] = SHADOWS;

    glBegin(GL_LINES);
	glVertex3fv(loc1);
	glVertex3fv(loc3);
    glEnd();
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw option menu for choosing monster                         */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void doOptions(struct monsterInfo monster,  long xWin,  int counter,
		int itsChristmas, float offsetX)
    {
    float pixtoSpace;
    struct monsterInfo tempMonster;

static    char googelonEnglish[]	= "Googelon-6";    
static    char techsEnglish[]		= "Techs-7";    
static    char vapourEnglish[]		= "The Vapour-8";    
static    char flutterEnglish[]		= "Flutter-9";

    static float optionsBox[4][3] = {
	-0.85,  0.5, 7.1,
	-0.85, -1.0, 7.1,
	 0.85, -1.0, 7.1, 
	 0.85,  0.5, 7.1};
 
    /***********************************/
    /* these monsters are always alive */
    /***********************************/
   
    tempMonster 		= monster;
    tempMonster.energyRemaining = 100;
    tempMonster.monsterIsDead 	= 0;
    tempMonster.deadCount 	= 0;
        	
    /*************************************/
    /* draw transparent brown background */
    /*************************************/

    glDisable(GL_DEPTH_TEST);

    glColor4fv(colorbrown);

#ifdef MESAVERSION

    glBegin(GL_QUADS);
	glVertex3fv(optionsBox[0]);
	glVertex3fv(optionsBox[1]);
	glVertex3fv(optionsBox[2]);
	glVertex3fv(optionsBox[3]);
    glEnd();		

#else

    glEnable(GL_BLEND);
    
    glBegin(GL_QUADS);
	glVertex3fv(optionsBox[0]);
	glVertex3fv(optionsBox[1]);
	glVertex3fv(optionsBox[2]);
	glVertex3fv(optionsBox[3]);
    glEnd();		

    glDisable(GL_BLEND);

#endif


    /*************/
    /* draw text */
    /*************/

    pixtoSpace = 2.0 / xWin;

    glColor3fv(colorwhite); 

    glPushMatrix();
	glTranslatef(-2.72,  1.75,  0);	
	tkDrawStr(strokeBase, "Choose your monster:");
    glPopMatrix();

    glPushMatrix();
	glTranslatef(-3.72,  -.6,  0);
	tkDrawStr(strokeBase, googelonEnglish);
    glPopMatrix();

    glPushMatrix();
	glTranslatef(1.2,  -.6,  0);
	tkDrawStr(strokeBase, techsEnglish);
    glPopMatrix();

    glPushMatrix();
	glTranslatef(-4,  -4,  0);
	tkDrawStr(strokeBase, vapourEnglish);
    glPopMatrix();

    glPushMatrix();
	glTranslatef(1.1,  -4,  0);
	tkDrawStr(strokeBase, flutterEnglish);
    glPopMatrix();


    /*****************/
    /* draw monsters */
    /*****************/

    glEnable(GL_DEPTH_TEST);
	    
    glPushMatrix();
	glTranslatef(-.5,  0.25,  7.2);
	glScalef(.25,  .25,  .25);
	drawMonster(tempMonster, counter, itsChristmas);
    glPopMatrix();
	
    glPushMatrix();
	glTranslatef(+.5,  0.25,  7.2);
	glScalef(.25,  .25,  .25);
	drawTechs(tempMonster);
    glPopMatrix();

    glPushMatrix();
	glTranslatef(-.5,  -0.4,  7.2);
	glScalef(.25,  .25,  .25);
	drawVapour(tempMonster, itsChristmas);
    glPopMatrix();

    glPushMatrix();
	glTranslatef(+.5,  -0.4,  7.2);
	glScalef(.25,  .25,  .25);
	drawFlutter(tempMonster, counter, itsChristmas, offsetX, OMNISCIENTVIEW);
    glPopMatrix();
   }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw summary of kills                                         */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void doSummary(int monster,  int deadTime, long winX, int killtanks,
		int killmtanks, int killhelos,
		int killCHHs, int killmechags,
		int killheros, int killplanes, int killlaunchers,
		int killfighters,
		int counter, int detailOn, int moreThanOne)
    {    
    int angle;
    float pixtoSpace;
    char resultString[15];
    char monsterString[40];

static    float summaryBox[4][3] = {
	-0.97,  0.25,  7.0,
	-0.97, -1.05,  7.0,
	 0.97, -1.05,  7.0, 
	 0.97,  0.25,  7.0};

    pixtoSpace = 2.0 / winX;

    angle = (deadTime * 10) % 3600;

    glDisable(GL_DEPTH_TEST);

    glColor4fv(colorbrown);

#ifdef MESAVERSION

    
    glBegin(GL_QUADS);
	glVertex3fv(summaryBox[0]);
	glVertex3fv(summaryBox[1]);
	glVertex3fv(summaryBox[2]);
	glVertex3fv(summaryBox[3]);
    glEnd();		

#else

    glEnable(GL_BLEND);
    
    glBegin(GL_QUADS);
	glVertex3fv(summaryBox[0]);
	glVertex3fv(summaryBox[1]);
	glVertex3fv(summaryBox[2]);
	glVertex3fv(summaryBox[3]);
    glEnd();		

    glDisable(GL_BLEND);

#endif


    glColor3fv(colorwhite); 

    if ((killtanks > 0) || (killlaunchers > 0) || (killmtanks > 0) || (killhelos > 0) ||
	(killmechags > 0) || (killfighters > 0) || (killCHHs > 0) || (killheros > 0) || (killplanes > 0))
	    strcpy(resultString, ":");
    else
	    strcpy(resultString, " nothing.");

    if (moreThanOne)    
	{
	 sprintf(monsterString, "The monsters destroyed %s", resultString);
	}
    else
	{
	switch(monster){
	    case GOOGELON:  sprintf(monsterString, "Googelon destroyed %s", resultString);
			    break;
	    case VAPOUR:    sprintf(monsterString, "The Vapour destroyed %s", resultString);
			    break;
	    case TECHS:     sprintf(monsterString, "Techs destroyed %s", resultString);
			    break;
	    case FLUTTER:   sprintf(monsterString, "Flutter destroyed %s", resultString);
			    break;
	    default:	    showError("Bogus Monster! (doSummary)");
			    break;
	    }
	}

    glPushMatrix();
	glTranslatef(-4.25, .5,  0);
	tkDrawStr(strokeBase, monsterString);
    glPopMatrix();


    if (killfighters > 0)
	{
    glPushMatrix();
	glTranslatef(-2.9-1.3,  -2.3,  0);
	if (killfighters > 1)
		sprintf(textline,  "%1u Fighters", killfighters);
	else
		sprintf(textline,  "%1u Fighter", killfighters);
	tkDrawStr(strokeBase, textline);
    glPopMatrix();
	}

    if (killtanks > 0)
	{
    glPushMatrix();
	glTranslatef(-3-1.1,  -1,  0);
	if (killtanks > 1)
		sprintf(textline,  "%1u Tanks", killtanks);
	else
		sprintf(textline,  "%1u Tank", killtanks);
	tkDrawStr(strokeBase, textline);
    glPopMatrix();
	}

    if (killlaunchers > 0)
	{
    glPushMatrix();
	glTranslatef(2.6-1.6,  -2.3,  0);
	if (killlaunchers > 1)
		sprintf(textline,  "%1u Launchers", killlaunchers);
	else
		sprintf(textline,  "%1u Launcher", killlaunchers);
	tkDrawStr(strokeBase, textline);
    glPopMatrix();
	}
	
    if (killhelos > 0)
	{
    glPushMatrix();
	glTranslatef(3.1-1.0,  -1,  0);
	if (killhelos > 1)
		sprintf(textline,  "%1u Helos", killhelos);
	else
		sprintf(textline,  "%1u Helo", killhelos);
	tkDrawStr(strokeBase, textline);
    glPopMatrix();
	}

    if (killmtanks > 0)
	{
    glPushMatrix();
    	glTranslatef(-0.2-1.2, -2.8,  0);
	if (killmtanks > 1)
		sprintf(textline,  "%1u Masers", killmtanks);
	else
		sprintf(textline,  "%1u Maser", killmtanks);
	tkDrawStr(strokeBase, textline);
    glPopMatrix();
	}


    if (killplanes > 0)
	{
    glPushMatrix();
	glTranslatef(0-1.4,  -1,  0);
	if (killplanes > 1)
		sprintf(textline,  "%1u Bombers", killplanes);
	else
		sprintf(textline,  "%1u Bomber", killplanes);
	tkDrawStr(strokeBase, textline);
    glPopMatrix();
	}
	
	
    if (killmechags > 0)
	{
    glPushMatrix();
	glTranslatef(2.8-1.4,  -4.7,  0);
	if (killmechags > 1)
		sprintf(textline,  "%1u MechaGs", killmechags);
	else
		sprintf(textline,  "%1u MechaG", killmechags);
	tkDrawStr(strokeBase, textline);
    glPopMatrix();
	}
	
    if (killCHHs > 0)
	{
    glPushMatrix();
	glTranslatef(0-1.3,  -4.7,  0);
	if (killCHHs > 1)
		sprintf(textline,  "%1u Hunters", killCHHs);
	else
		sprintf(textline,  "%1u Hunter", killCHHs);
	tkDrawStr(strokeBase, textline);
    glPopMatrix();
	}

    if (killheros > 0)
	{
    glPushMatrix();
	glTranslatef(-3-1.0,  -4.7,  0);
	if (killheros > 1)
		sprintf(textline,  "%1u Heros", killheros);
	else
		sprintf(textline,  "%1u Hero", killheros);
	tkDrawStr(strokeBase, textline);
    glPopMatrix();
	}

    glEnable(GL_DEPTH_TEST);

    if (killfighters > 0)
	{
	glPushMatrix();
	    glTranslatef(-0.65,  -.3,  7.1);
	    glRotatef(.1*angle + 180, 0, 1, 0);
	    glScalef(.6,  .6,  .6);
	    drawFighter();
	glPopMatrix();
	}

    if (killtanks > 0)
	{
	glPushMatrix();
	    glTranslatef(-.65,  -.1,  7.1);
	    glRotatef(.1*angle + 270, 0, 1, 0);
	    glScalef(0.33,  0.33,  0.33);
	    glCallList(plaintank);
	glPopMatrix();
	}

    if (killlaunchers > 0)
	{
	glPushMatrix();
	    glTranslatef(.5,  -.35,  7.1);
	    glRotatef(.1*angle + 270, 0, 1, 0);
	    glScalef(0.33,  0.33,  0.33);
	    glCallList(launchertank);
	glPopMatrix();
	}
 	
    if (killmtanks > 0)
	{
	glPushMatrix();
	    glTranslatef(-0.1,  -.42,  7.1);
	    glRotatef(.1*angle + 45, 0, 1, 0);
	    glScalef(0.05,  0.05,  0.05);
	    glCallList(masertank);
	glPopMatrix();
	}
 
    if (killhelos > 0)
	{
	glPushMatrix();
	    glTranslatef(.65,  0,  7.1);
	    glRotatef(.1*angle + 180, 0, 1, 0);
	    glScalef(.3,  .3,  .3);
	    drawHelo((counter*9) % 360,  0);
	glPopMatrix();
	}

    if (killplanes > 0)
	{
	glPushMatrix();
	    glTranslatef(0,  0,  7.1);
	    glRotatef(.1*angle, 0, 1, 0);
	    glScalef(.75,  .75,  .75);
	    drawAirplane((counter*2) % 360);
	glPopMatrix();
	}

    if (killmechags > 0)
	{
	glPushMatrix();
	    glTranslatef(0.6,  -.6,  7.1);
	    glRotatef(.1*angle + 90, 0, 1, 0);
	    glScalef(.25,  .25,  .25);
	    drawMechaMonster(50, counter);
	glPopMatrix();
	}

    if (killCHHs > 0)
	{
	glPushMatrix();
	    glTranslatef(-0.1,  -.8,  7.1);
	    glRotatef(.1*angle + 180, 0, 1, 0);
	    glScalef(.3,  .3,  .3);
	    makeCHH(20);
	glPopMatrix();
	}

    if (killheros > 0)
	{
	glPushMatrix();
	    glTranslatef(-.6,  -.61,  7.1);
	    glRotatef(.1*angle + 180, 0, 1, 0);
	    glScalef(.25,  .25,  .25);
	    drawHeroDude2(100, counter, 0, 0, detailOn);
	glPopMatrix();
	}
    }

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

GLuint makePlaneDots()
    {
    GLuint O;
    float grass1[3], grass2[3], grass3[3], grass4[3];
    register int j, i;

    grass1[1] = grass2[1] = grass3[1] = grass4[1] = PLANEY;
    
    O = glGenLists(1);
    glNewList(O, GL_COMPILE);

    glBegin(GL_LINES);

    for(i=-PLANESIZE+1; i<=PLANESIZE; i+=1)
	{
	grass1[0] = grass3[0] = i - 0.015;
	grass2[0] = grass4[0] = i + 0.015;

	for(j=-PLANESIZE + 1; j <= PLANESIZE; j += 1)
	    {
	    grass1[2] = grass4[2] = j - 0.015;
	    grass2[2] = grass3[2] = j + 0.015;

	    glVertex3fv(grass1);
	    glVertex3fv(grass2);

	    glVertex3fv(grass3);
	    glVertex3fv(grass4);
	    }
	}
    
    glEnd();

    glEndList();
    return(O);
    }


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw roads on the battlefield                                 */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawRoads(struct road * roads, float xshift, float zshift, int itsChristmas,int view)
    {
    register int i;
    float displaySize;
    float square[4][3];
    float v1[3];
    float v2[3];
    float v3[3];
    float v4[3];
    float xplus, xminus, zplus, zminus;
    int ropCounter;

    float c, d;
    float cprime,  dprime;

#ifndef MESAVERSION 
    float xlinemin, xlinemax, zlinemin, zlinemax;
    float xlinemin2, xlinemax2, zlinemin2, zlinemax2; 
#endif
    
    xplus   = xshift + 0.25;
    xminus  = xshift - 0.25;
    zplus   = zshift + 0.25;
    zminus  = zshift - 0.25;
    
    v1[1] = v2[1] = v3[1] = v4[1] = ROADS + 0.001;
    
    /***********************************/
    /* Draw 'motion' dots on the plane */
    /***********************************/


    if (view != MAPVIEW)
	{
	 c = xshift - (int) xshift;
	 d = zshift - (int) zshift;
    
	if (itsChristmas)
	    glColor3fv(colorblack);
	else
	    glColor3fv(coloryellow);
	    
	if (c > 0)
	    cprime = c-1;
	else
	    cprime = c;
	
	if (d > 0)
	    dprime = d-1;
	else
	    dprime = d;
    
	glLineWidth(1.0);
	
	glPushMatrix();
	    glTranslatef(cprime, 0, dprime);
	    glCallList(planeDotsObj);
	glPopMatrix();
	}


    if (view == MAPVIEW)
	displaySize = 50;
    else
	displaySize = PLANESIZE+0.25;

    /***********************************/
    /* find all the roads on the plane */
    /***********************************/

    ropCounter = 0;
    for(i=0;roads[i].type != NULLROAD;i++)
	{
	if ((fabs(roads[i].x+xshift) <= displaySize) && (fabs(roads[i].y+zshift) <= displaySize))
	    {
	    roadsOnPlane[ropCounter] = roads[i];
	    ropCounter++;
	    
	    if (ropCounter >= MAXROADSONPLANE)
		ropCounter = MAXROADSONPLANE - 1;
	    }
	}

	
    square[0][1] = square[1][1] = square[2][1] = square[3][1] = ROADS;

    /********************/
    /* Draw black roads */
    /********************/
    
    glColor3fv(colorblack);

    glBegin(GL_QUADS);
    
    for(i=0; i < ropCounter; i++)
	{
	if (roadsOnPlane[i].type < 3)
	    {
	    square[0][0] = square[3][0] = roadsOnPlane[i].x+xplus;
	    square[1][0] = square[2][0] = roadsOnPlane[i].x+xminus;
    
	    square[0][2] = square[1][2] = roadsOnPlane[i].y+zplus;
	    square[2][2] = square[3][2] = roadsOnPlane[i].y+zminus;
    
	    glVertex3fv(square[3]);
	    glVertex3fv(square[2]);
	    glVertex3fv(square[1]);
	    glVertex3fv(square[0]);
	    }
	}

    glEnd();

    /*******************/
    /* Draw grey roads */
    /*******************/

    glColor3fv(colorgrey4);
    
    glBegin(GL_QUADS);
    
    for(i=0; i < ropCounter; i++)
	{
	if (roadsOnPlane[i].type >= 3)
	    {
	    square[0][0] = square[3][0] = roadsOnPlane[i].x+xplus;
	    square[1][0] = square[2][0] = roadsOnPlane[i].x+xminus;
    
	    square[0][2] = square[1][2] = roadsOnPlane[i].y+zplus;
	    square[2][2] = square[3][2] = roadsOnPlane[i].y+zminus;
    	    
	    glVertex3fv(square[3]);
	    glVertex3fv(square[2]);
	    glVertex3fv(square[1]);
	    glVertex3fv(square[0]);
	    
	    }
	}

    glEnd();

#ifndef MESAVERSION 

    /**************************/
    /* draw they yellow lines */
    /**************************/
 
    xlinemin = xshift-ROADLINELENGTH;
    xlinemax = xshift+ROADLINELENGTH;
    zlinemin = zshift-ROADLINETHICKNESS;
    zlinemax = zshift+ROADLINETHICKNESS;

    xlinemin2 = xshift-ROADLINETHICKNESS;
    xlinemax2 = xshift+ROADLINETHICKNESS;
    zlinemin2 = zshift-ROADLINELENGTH;
    zlinemax2 = zshift+ROADLINELENGTH; 

    glColor3fv(coloryellow);

    glBegin(GL_QUADS);
    
    for(i=0; i < ropCounter; i++)
	{
	if(roadsOnPlane[i].type == 0)
	    {
	    v1[0] = v4[0] = roadsOnPlane[i].x + xlinemin;
	    v2[0] = v3[0] = roadsOnPlane[i].x + xlinemax;
	    
	    v2[2] = v1[2] = roadsOnPlane[i].y + zlinemin;
	    v3[2] = v4[2] = roadsOnPlane[i].y + zlinemax;
	    
	    glVertex3fv(v1);
	    glVertex3fv(v4);
	    glVertex3fv(v3);
	    glVertex3fv(v2);
	    }
				    
	else if(roadsOnPlane[i].type == 1)
	    {			
	    v1[2] = v4[2] = roadsOnPlane[i].y + zlinemin2;
	    v2[2] = v3[2] = roadsOnPlane[i].y + zlinemax2;
	    
	    v2[0] = v1[0] = roadsOnPlane[i].x + xlinemin2;
	    v3[0] = v4[0] = roadsOnPlane[i].x + xlinemax2;

	    glVertex3fv(v1);
	    glVertex3fv(v2);
	    glVertex3fv(v3);
	    glVertex3fv(v4);
	    
	    }
	}
	
    glEnd();

#endif
    }
    
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
/* draw projectiles in flight                                    */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void drawProjectiles(struct projectile * allProjs, int counter, 
		    struct fireType * fires, int fireCounter, int itsChristmas)
    {
    struct projectile *temp;
    float col[4] = {1.0, 0, 0, 0};
    float v[3], v2[3];
    float x, y, z;
    float floatRatio;
    register int i;
    register int rotRatio;
    int beamCounter;

static     float beamhitx[MAXBEAMS], beamhitz[MAXBEAMS];

    /***********************************/
    /* make standard projectile object */
    /***********************************/
  
    rotRatio = (counter*100) % 3600;
    
    floatRatio = rotRatio * 0.1;

    glDeleteLists( shellObj, 1);
    glNewList(shellObj, GL_COMPILE);
    
	makerrotcubexy(0.05,  0.05,  0.05, rotRatio, colorwhite);	
	if (itsChristmas)
	    {
	    makerrotcubexy(0.01, 0.051, 0.051, rotRatio, colorred);
	    makerrotcubexy(0.051, 0.051, 0.01, rotRatio, colorred);
	    }
	    
    glEndList();

    beamCounter = 0;
    for (temp = allProjs->next;temp != NULL;temp = temp->next)
	if ((fabs(temp->x) <= PLANESIZE) && (fabs(temp->z) <= PLANESIZE))
	    {
	    x = temp->x;
	    y = temp->y;
	    z = temp->z;
    
	    /**********************************/
	    /* draw bomb                      */
	    /**********************************/
		
	    switch(temp->type){
		case PROJTANK:
		case PROJROCKET:glPushMatrix();		/* white cube shells */
				    glTranslatef(x,  y,  z);
				    glCallList(shellObj);			
				glPopMatrix();
				glColor4fv(colorblack);
				shadow (x, z, 0.05, 0.05);
				break;
				
		case PROJTECHS: glPushMatrix();		/* techs shell */
				    glTranslatef(x,  y,  z);
				    glRotatef(floatRatio, 1, 0, 0);
				    glRotatef(floatRatio, 0, 1, 0);
				    glCallList(shell2Obj);
				glPopMatrix();
				glColor4fv(colorblack);
				shadow (x, z, 0.05, 0.05);
				break;
				
		case PROJFIRE:  break;			/* flames */
								
		case PROJSCAR:  beamhitx[beamCounter] = x;	/* monster beam scar */
				beamhitz[beamCounter] = z;
				beamCounter += 1;
				if (beamCounter >= MAXBEAMS)
				    beamCounter -= 1;
				break;
				    
		case PROJWATER: glPushMatrix();		/* water */
				    glTranslatef(x,  y,  z);
				    glCallList(watershellObj);
				glPopMatrix();
				break;

		case PROJHERO:  glPushMatrix();
				    glTranslatef(x,  y,  z);
				    glRotatef(floatRatio, 1, 0, 0);
				    glRotatef(floatRatio, 0, 1, 0);
				    glCallList(heroshellObj);
				glPopMatrix();
				glColor4fv(colorblack);
				shadow (x, z, 0.05, 0.05);
				break;
    
		default:	showError("Bogus Projectile in Projectile List! (drawProjectiles)");
				break;
		}
	    }


    /**********************************/
    /* draw fires                     */
    /**********************************/
	    
    for (i=0;i<fireCounter;i++)
	{
	col[1] = fires[i].col;
	if ((fabs(fires[i].x) <= PLANESIZE) && (fabs(fires[i].z) <= PLANESIZE))
	    makeitPyr(12, col, fires[i].x, PLANEY+fires[i].height, fires[i].z,
		fires[i].xwid, fires[i].height, fires[i].zwid);
	}

    /**********************************/
    /* draw scar from monster beam    */
    /**********************************/
    
    glColor3fv(colorblack);

    glLineWidth(2.0);

    v[1] = v2[1] = SHADOWS;
    
    v2[0] = beamhitx[0];
    v2[2] = beamhitz[0];
    
    for(i=1; i<beamCounter; i++)
	{
	v[0] = beamhitx[i];
	v[2] = beamhitz[i];
	
	if ((fabs(v[0] - v2[0]) < 0.3) && (fabs(v[2] - v2[2]) < 0.3))
	    {
	    glBegin(GL_LINES);	
		glVertex3fv(v);
		glVertex3fv(v2);	
	    glEnd();
	    }
	    
	v2[0] = v[0];
	v2[2] = v[2];	
	}
    }


/*
#define J_SPACE 32
#define J_DASH 34

#define J_1 50
#define J_2 51
#define J_3 52
#define J_4 53
#define J_5 54
#define J_6 55
#define J_7 56
#define J_8 57
#define J_9 58


#define J_H_A 65

#define J_K_A 145
#define J_K_I 146
#define J_K_U 147
#define J_K_E 148
#define J_K_O 149

#define J_K_KA 150
#define J_K_KI 151
#define J_K_KU 152
#define J_K_KE 153
#define J_K_KO 154

#define J_K_SA 155
#define J_K_SI 156
#define J_K_SU 157
#define J_K_SE 158
#define J_K_SO 159

#define J_K_TA 160
#define J_K_TI 161
#define J_K_TU 162
#define J_K_TE 163
#define J_K_TO 164

#define J_K_NA 165
#define J_K_NI 166
#define J_K_NU 167
#define J_K_NE 168
#define J_K_NO 169

#define J_K_HA 170
#define J_K_HI 171
#define J_K_HU 172
#define J_K_HE 173
#define J_K_HO 174

#define J_K_MA 175
#define J_K_MI 176
#define J_K_MU 177
#define J_K_ME 178
#define J_K_MO 179

#define J_K_YA 180
#define J_K_YU 182
#define J_K_YO 184

#define J_K_RA 185
#define J_K_RI 186
#define J_K_RU 187
#define J_K_RE 188
#define J_K_RO 189

#define J_K_GA 200
#define J_K_GI 201
#define J_K_GU 202
#define J_K_GE 203
#define J_K_GO 204

#define J_K_ZA 205
#define J_K_ZI 206
#define J_K_ZU 207
#define J_K_ZE 208
#define J_K_ZO 209

#define J_K_DA 210
#define J_K_DE 213
#define J_K_DO 214

#define J_K_BA 215
#define J_K_BI 216
#define J_K_BU 217
#define J_K_BE 218
#define J_K_BO 219

#define J_K_PA 220
#define J_K_PI 221
#define J_K_PU 222
#define J_K_PE 223
#define J_K_PO 224


    char energyJapanese[]	= {J_K_E, J_K_NE, J_K_RU, J_K_GI, 0};
    char googelonJapanese[]	= {J_K_GU, J_K_GE, J_K_RO, J_SPACE, J_6, 0};
    char techsJapanese[]	= {J_K_TE, J_K_TU, J_K_KU, J_K_SU, J_SPACE, J_7, 0};
    char flutterJapanese[]  	= {J_K_HU, J_K_RA, J_K_TU, J_K_TA, J_SPACE, J_9, 0};
    char vapourJapanese[]   	= {J_K_ZA, J_DASH, J_K_BE, J_DASH, J_K_PA, J_DASH, J_SPACE, J_8, 0};
*/
