/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/********************************/
/* Introstory fr TERROID       */
/* (C) Jul 1996 by Michael Haar */
/********************************/

#include <stdlib.h>
#include <string.h>
#include <dn.h>
#include "DEFS.H"
#include "VARS.H"
#include "FUNCS.H"

/* globale Variablen */
char storytxt[8][100] =
{
	"ORBO - A PEACEFUL WORLD",
	"WITH UNPLEASANT NEIGHBOURS",   
	"  WHO STRIP PLANETS OF THEIR  POPULATION",
	"AND LEAVE ASHES IN THEIR WAKE.",
	"RETURNING FROM SPACE PATROL",
	"YOU FIND WHAT THEY HAVE LEFT",
	" ...AND A MESSAGE IN A BOTTLE TELLING A NIGHTMARE STORY.",
	"YOU ARE THE LAST SLIM HOPE FORYOUR PEOPLE. YOUR COURSE: THE SLAVETAKER WORLD OF XRIMA."
};

extern FONT endetickerfont;

extern FLI *fliptr;

/* Funktionsprototypen */
void story_text(FONT *font, const char *txt);
void story();
void ende_story();
void training_story();
void orbit_story();
void wueste_story();
void city_story();
void demo_story();

/* Funktionen */
void story_text(FONT *font, const char *txt)
{
	int i, x;
	int len;
	char showtext[80];

	len = strlen(txt);
	if(strlen(txt) * font->char_w > screen_width)
		len = screen_width / font->char_w - 2;
	for(i = 0; i < strlen(txt); i += len)
	{
		if(i + len > strlen(txt))
			x = screen_width / 2 - (strlen(txt) - i) * font->char_w / 2;
		else
			x = screen_width / 2 - len * font->char_w / 2;
		strncpy(showtext, &txt[i], len);
		showtext[len] = 0;
		ticker_text(font, x, 180 - strlen(txt) / len * font->char_h + i / len * font->char_h, showtext, FALSE);
	}
}

void story()
{
	void *pix;

	cls(0);
	memset(screen_addr, 0, screen_len * 4) ;
	Copy2Screen();

	pix = malloc(64000);

	load_pic("INTRO1.PIX", pix, alt_rgb);
	SetPalette(alt_rgb);
	pixel_in(pix);
	story_text(&gamefont, storytxt[0]);
	wait_keys(750);
	// Abbruch wenn Taste
	if(!keyTest(KEY_SPACE) && !keyTest(KEY_ESC))
	{
		load_pic("INTRO2.PIX", pix, alt_rgb);
		SetPalette(alt_rgb);
		pixel_in(pix);
		story_text(&gamefont, storytxt[1]);
		press_key(750);
		load_pic("INTRO3.PIX", pix, alt_rgb);
		SetPalette(alt_rgb);
		pixel_in(pix);
		story_text(&gamefont, storytxt[2]);
		press_key(750);
		load_pic("INTRO4.PIX", pix, alt_rgb);
		SetPalette(alt_rgb);
		pixel_in(pix);
		story_text(&gamefont, storytxt[3]);
		press_key(750);
		load_pic("INTRO5.PIX", pix, alt_rgb);
		SetPalette(alt_rgb);
		pixel_in(pix);
		story_text(&gamefont, storytxt[4]);
		press_key(750);
		load_pic("INTRO6.PIX", pix, alt_rgb);
		SetPalette(alt_rgb);
		pixel_in(pix);
		story_text(&gamefont, storytxt[5]);
		press_key(750);
		load_pic("INTRO7.PIX", pix, alt_rgb);
		SetPalette(alt_rgb);
		pixel_in(pix);
		story_text(&gamefont, storytxt[6]);
		press_key(750);
		load_pic("INTRO8.PIX", pix, alt_rgb);
		SetPalette(alt_rgb);
		pixel_in(pix);
		story_text(&gamefont, storytxt[7]);
		press_key(750);
	}

	free(pix);
}

void ende_story()
{
	ClearPalette(alt_rgb);
	cls(0);
	wait_retrace();
	SetPalette(alt_rgb);
	Copy2Screen();

	PaletteFadeOut(gamepal);

	stop_sound();
	free_mod();
	md_numchn = 4;
	if((mymod = ML_LoadFN("ENDE.XM")))
	{
		md_numchn += mymod->numchn;
		start_mod(TRUE, 0, 5);
	}
	else
		puts("\7");

	if(!play_fli("ENDE.FLI", FALSE, 0))
	{
		load_pic("ENDE.PIX", screen_addr, alt_rgb);	// Fr die Palette
		wait_retrace();
		SetPalette(alt_rgb);
		Copy2Screen();
		story_text(&gamefont, "FREE AGAIN THE PEOPLE OF ORBO FOUND A FRIENDLY, EMPTY HOME-      WORLD TO START A NEW       CIVILISATION ...");
	}
	else
	{
		GetPalette(alt_rgb);
		story_text(&gamefont, "FREE AGAIN THE PEOPLE OF ORBO FOUND A FRIENDLY, EMPTY HOME-      WORLD TO START A NEW       CIVILISATION ...");
	}

	press_key(2000);

	PaletteFadeOut(alt_rgb);
	ClearPalette(alt_rgb);
	SetPalette(alt_rgb);
	cls(0);
	Copy2Screen();
}

void training_story()
{
	long t, speed;
	BOOLEAN ende;
	GFXBLK textpix;

	load_pic("TRAINTXT.PIX", screen_addr, alt_rgb);
//	textpix.mem = NULL;
	get(9, 10, 279, 69, &textpix);

  fliptr = load_fli("TRAINING.FLI", FLI_DISK);
	if(fliptr != NULL)
	{
		t = timer();
		ende = FALSE;
		while(!ende)
		{
			if(keyTest(KEY_ESC) || keyTest(KEY_SPACE) || keyTest(KEY_ENTER) || keyTest(KEY_RCTRL) || keyTest(KEY_LCTRL) || joy1_b1())
				ende = TRUE;
			if(fliptr->current >= fliptr->frames - 1)
				ende = TRUE;
	
			speed = timer();
			play_frame(fliptr, (char *) screen_addr, 320);

			objput(screen_width / 2 - textpix.w / 2, screen_height / 2 - textpix.h / 2, &textpix);

			while(timer() - speed < fliptr->speed * 2)
				;
	
			wait_retrace();
			Copy2Screen();
		}

		close_fli(fliptr);
	}

	GetPalette(alt_rgb);
	PaletteFadeOut(alt_rgb);
	cls(0);
	Copy2Screen();
}

void orbit_story()
{
	long t, speed;
	BOOLEAN ende;
	GFXBLK textpix;

	load_pic("ORBITTXT.PIX", screen_addr, alt_rgb);
//	textpix.mem = NULL;
	get(39, 10, 269, 39, &textpix);

  fliptr = load_fli("ORBIT.FLI", FLI_DISK);
	if(fliptr != NULL)
	{
		t = timer();
		ende = FALSE;
		while(!ende)
		{
			if(keyTest(KEY_ESC) || keyTest(KEY_SPACE) || keyTest(KEY_ENTER) || keyTest(KEY_RCTRL) || keyTest(KEY_LCTRL) || joy1_b1())
				ende = TRUE;
			if(fliptr->current >= fliptr->frames - 1)
				ende = TRUE;
	
			speed = timer();
			play_frame(fliptr, (char *) screen_addr, 320);

			objput(screen_width / 2 - textpix.w / 2, screen_height / 2 - textpix.h / 2, &textpix);

			while(timer() - speed < fliptr->speed * 2)
				;
	
			wait_retrace();
			Copy2Screen();
		}

		close_fli(fliptr);
	}

	GetPalette(alt_rgb);
	PaletteFadeOut(alt_rgb);
	cls(0);
	Copy2Screen();
}

void wueste_story()
{
	long t, speed;
	BOOLEAN ende;
	GFXBLK textpix;

	load_pic("WUESTTXT.PIX", screen_addr, alt_rgb);
//	textpix.mem = NULL;
	get(83, 54, 223, 84, &textpix);

  fliptr = load_fli("WUESTE.FLI", FLI_DISK);
	if(fliptr != NULL)
	{
		t = timer();
		ende = FALSE;
		while(!ende)
		{
			if(keyTest(KEY_ESC) || keyTest(KEY_SPACE) || keyTest(KEY_ENTER) || keyTest(KEY_RCTRL) || keyTest(KEY_LCTRL) || joy1_b1())
				ende = TRUE;
			if(fliptr->current >= fliptr->frames - 1)
				ende = TRUE;
	
			speed = timer();
			play_frame(fliptr, (char *) screen_addr, 320);

			objput(screen_width / 2 - textpix.w / 2, screen_height / 2 - textpix.h / 2, &textpix);

			while(timer() - speed < fliptr->speed * 2)
				;
	
			wait_retrace();
			Copy2Screen();
		}

		close_fli(fliptr);
	}

	GetPalette(alt_rgb);
	PaletteFadeOut(alt_rgb);
	cls(0);
	Copy2Screen();
}

void city_story()
{
	long t, speed;
	BOOLEAN ende;
	GFXBLK textpix;

	load_pic("CITYTXT.PIX", screen_addr, alt_rgb);
//	textpix.mem = NULL;
	get(55, 100, 265, 128, &textpix);

  fliptr = load_fli("CITY.FLI", FLI_DISK);
	if(fliptr != NULL)
	{
		t = timer();
		ende = FALSE;
		while(!ende)
		{
			if(keyTest(KEY_ESC) || keyTest(KEY_SPACE) || keyTest(KEY_ENTER) || keyTest(KEY_RCTRL) || keyTest(KEY_LCTRL) || joy1_b1())
				ende = TRUE;
			if(fliptr->current >= fliptr->frames - 1)
				ende = TRUE;
	
			speed = timer();
			play_frame(fliptr, (char *) screen_addr, 320);

			objput(screen_width / 2 - textpix.w / 2, screen_height / 2 - textpix.h / 2, &textpix);

			while(timer() - speed < fliptr->speed * 2)
				;
	
			wait_retrace();
			Copy2Screen();
		}

		close_fli(fliptr);
	}

	GetPalette(alt_rgb);
	PaletteFadeOut(alt_rgb);
	cls(0);
	Copy2Screen();
}

void demo_story()
{
//	void *old_screen = screen_addr;
	GFXBLK leuchtepix[3];
	int i;

	cls(0);
	Copy2Screen();
	ClearPalette(alt_rgb);
	SetPalette(alt_rgb);

//	leuchtepix[0].mem = NULL;
//	leuchtepix[1].mem = NULL;
	load_pic("BILDSCH2.PIX", screen_addr, alt_rgb);
	get(0, 0, screen_width, screen_height, & leuchtepix[2]) ;
	put(0, 0, & leuchtepix[2]) ;
	get(9, 58, 23, 70, &leuchtepix[1]);
	load_pic("BILDSCHI.PIX", screen_addr, alt_rgb);
	get(9, 58, 23, 70, &leuchtepix[0]);
	Copy2Screen();
	PaletteFadeIn(alt_rgb);

  ticker_text(& gamefont, 36, 60, "CONGRATULATIONS! YOU HAVE", FALSE);
  ticker_text(& gamefont, 36, 70, "FINISHED THE DEMO VERSION", FALSE);
  ticker_text(& gamefont, 36, 80, "OF   TERROID...  IF   YOU", FALSE);
  ticker_text(& gamefont, 36, 90, "ENJOYED IT, YOU WILL LOVE", FALSE);
  ticker_text(& gamefont, 36, 100, "THE FULL  GAME, SO  WRITE", FALSE);
  ticker_text(& gamefont, 36, 110, "TO US FOR INFO NOW!", FALSE);
  ticker_text(& gamefont, 36, 130, "            - THE DN TEAM", FALSE);

	i = 0;
	while(!keyTest(KEY_SPACE) && !keyTest(KEY_ESC) && !keyTest(KEY_ENTER)
	  && !keyTest(KEY_RCTRL) && !keyTest(KEY_LCTRL))
	{
		i++;
		wait_retrace();
		put(9, 58, &leuchtepix[(i % 32) / 16]);
		Copy2Screen() ;
	}

	while(keyTest(KEY_SPACE) || keyTest(KEY_ESC) || keyTest(KEY_ENTER)
	  || keyTest(KEY_RCTRL) || keyTest(KEY_LCTRL))
		;

	free_blk(& leuchtepix[0]);
	free_blk(& leuchtepix[1]);
	free_blk(& leuchtepix[2]) ;

	PaletteFadeOut(alt_rgb) ;
}
