/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*********************************/
/* Startmenu for TERROID         */
/* (C) July 1996 by Michael Haar */
/*********************************/

#include <stdlib.h>
#include <string.h>
#include <dn.h>

#include "DEFS.H"
#include "FUNCS.H"
#include "VARS.H"

#define RASTER_GR 10
#define LINCOL1 0

#define CONTINUE_PRICE 50000

/* globale Variablen */

/* Prototypen */
void viewoptions();
void schwierigkeit();
BOOLEAN startmenu();
BOOLEAN buy_continue();

extern void spieler_neu();

/* Funktionen */
void lines(int x, int y, int zoom)
{
	int i, xp, yp;

	// erstes Raster
	xp = x % RASTER_GR;
	yp = y % RASTER_GR;
	for(i = -RASTER_GR; i <= screen_width; i += zoom)
		line(i + xp, -RASTER_GR + yp, i + xp, screen_height + yp + RASTER_GR, LINCOL1, FALSE);
	for(i = -RASTER_GR; i <= screen_height; i += zoom)
		line(-RASTER_GR + xp, i + yp, screen_width + xp + RASTER_GR, i + yp, LINCOL1, FALSE);
}

void viewoptions()
{
//	void *old_screen = screen_addr;
	GFXBLK leuchtepix[3];
	int i;

	cls(0);
	Copy2Screen();
	ClearPalette(alt_rgb);
	SetPalette(alt_rgb);

//	leuchtepix[0].mem = NULL;
//	leuchtepix[1].mem = NULL;
	load_pic("BILDSCH2.PIX", screen_addr, alt_rgb);
	get(9, 58, 23, 70, &leuchtepix[1]);
	load_pic("BILDSCHI.PIX", screen_addr, alt_rgb);
	get(9, 58, 23, 70, &leuchtepix[0]);
	get(0, 0, 320, 200, & leuchtepix[2]) ;
	put(0, 0, & leuchtepix[2]) ;
	Copy2Screen();
	PaletteFadeIn(alt_rgb);

	do
	{
		ticker_text(&gamefont, 50, 40, "SOME OPTION-FUN:", FALSE);
		ticker_text(&gamefont, 40, 60, "-A- FULL: ALL GFX", game_view == FULL);
		ticker_text(&gamefont, 40, 70, "-B- HIGH: NO EFFECTS", game_view == HIGH);
		ticker_text(&gamefont, 40, 80, "-C- MEDI: NO BACKGROUND", game_view == MEDIUM);
		ticker_text(&gamefont, 40, 90, "-D- MINI: ONLY ENEMIES", game_view == MINI);
		if(sounddevice != 4)
		{
			ticker_text(&gamefont, 40, 110, "-E- MUSIC AND SOUNDFX", !no_music);
			ticker_text(&gamefont, 40, 120, "-F- SOUNDFX ONLY", no_music);
			ticker_text(&gamefont, 50, 140, "PRESS ESC TO EXIT!", FALSE);
		}
		else
			ticker_text(&gamefont, 50, 110, "PRESS ESC TO EXIT!", FALSE);
	
//		screen_addr = (void *)0xA0000;
	
		i = 0;
		while(!keyTest(KEY_A) && !keyTest(KEY_B) && !keyTest(KEY_C) && !keyTest(KEY_D) && !keyTest(KEY_E) && !keyTest(KEY_F) && !keyTest(KEY_G) && !keyTest(KEY_H) && !keyTest(KEY_ESC))
		{
			i++;
			wait_retrace();
			put(9, 58, &leuchtepix[(i % 32) / 16]);
			Copy2Screen() ;
		}
		if(keyTest(KEY_A))
		{
			if (sounddevice != 4) start_sample(bloinksnd, md_numchn - 1);
			game_view = FULL;
		}
		else if(keyTest(KEY_B))
		{
			if (sounddevice != 4) start_sample(bloinksnd, md_numchn - 1);
			game_view = HIGH;
		}
		else if(keyTest(KEY_C))
		{
			if (sounddevice != 4) start_sample(bloinksnd, md_numchn - 1);
			game_view = MEDIUM;
		}
		else if(keyTest(KEY_D))
		{
			if (sounddevice != 4) start_sample(bloinksnd, md_numchn - 1);
			game_view = MINI;
		}
		else if(sounddevice != 4)
		{
			if(keyTest(KEY_E) && no_music)
			{
				if (sounddevice != 4) start_sample(bloinksnd, md_numchn - 1);
				no_music = FALSE;
		
				stop_sound();
				free_mod();
				md_numchn = 4;
				mymod = ML_LoadFN("TERROID.XM");
				md_numchn += mymod->numchn;
				start_mod(TRUE, 100, 0);
			}
			else if(keyTest(KEY_F) && !no_music)
			{
				if (sounddevice != 4) start_sample(bloinksnd, md_numchn - 1);
				no_music = TRUE;
				stop_sound();
				free_mod();
				md_numchn = 4;
				MD_PlayStart();
			}
		}
	
		while(keyTest(KEY_A) || keyTest(KEY_B) || keyTest(KEY_C) || keyTest(KEY_D) || keyTest(KEY_E) || keyTest(KEY_F))
			;
	
//		screen_addr = old_screen;
	}
	while(!keyTest(KEY_ESC));
	if (sounddevice != 4) start_sample(bloinksnd, md_numchn - 1);

	free_blk(& leuchtepix[0]);
	free_blk(& leuchtepix[1]);
	free_blk(& leuchtepix[2]) ;

	PaletteFadeOut(alt_rgb);
	cls(0);
	Copy2Screen();
}

void schwierigkeit()
{
//	void *old_screen = screen_addr;
	GFXBLK leuchtepix[3];
	int i;

	cls(0);
	Copy2Screen();
	ClearPalette(alt_rgb);
	SetPalette(alt_rgb);

//	leuchtepix[0].mem = NULL;
//	leuchtepix[1].mem = NULL;
	load_pic("BILDSCH2.PIX", screen_addr, alt_rgb);
	get(9, 58, 23, 70, &leuchtepix[1]);
	load_pic("BILDSCHI.PIX", screen_addr, alt_rgb);
	get(9, 58, 23, 70, &leuchtepix[0]);
	get(0, 0, 320, 200, & leuchtepix[2]) ;
	put(0, 0, & leuchtepix[2]) ;
	Copy2Screen();
	PaletteFadeIn(alt_rgb);

	ticker_text(&gamefont, 50, 40, "CHOOSE YOUR GAME:", FALSE);
	ticker_text(&gamefont, 50, 60, "-A- BEGINNER", FALSE);
	ticker_text(&gamefont, 50, 70, "-B- EASY", FALSE);
	ticker_text(&gamefont, 50, 80, "-C- NORMAL", FALSE);
	ticker_text(&gamefont, 50, 100, "-D- TRAINING", FALSE);
	ticker_text(&gamefont, 50, 120, "WAITING FOR KEY!", FALSE);

//	screen_addr = (void *)0xA0000;

	i = 0;
	while(!keyTest(KEY_A) && !keyTest(KEY_B) && !keyTest(KEY_C) && !keyTest(KEY_D) && !keyTest(KEY_ESC))
	{
		i++;
		wait_retrace();
		put(9, 58, &leuchtepix[(i % 32) / 16]);
		Copy2Screen() ;
	}
	if(keyTest(KEY_A))
	{
		if (sounddevice != 4) start_sample(bloinksnd, md_numchn - 1);
		game_difficulty = BABY;
	}
	else if(keyTest(KEY_B))
	{
		if (sounddevice != 4) start_sample(bloinksnd, md_numchn - 1);
		game_difficulty = BEGINNER;
	}
	else if(keyTest(KEY_C))
	{
		if (sounddevice != 4) start_sample(bloinksnd, md_numchn - 1);
		game_difficulty = NORMAL;
	}
	else
	{
		if (sounddevice != 4) start_sample(bloinksnd, md_numchn - 1);
		game_difficulty = TRAINING;
	}

	while(keyTest(KEY_A) || keyTest(KEY_B) || keyTest(KEY_C) || keyTest(KEY_D) || keyTest(KEY_ESC))
		;

//	screen_addr = old_screen;

	free_blk(& leuchtepix[0]);
	free_blk(& leuchtepix[1]);
	free_blk(& leuchtepix[2]) ;

/*	PaletteFadeOut(alt_rgb);
	cls(0);
	Copy2Screen(); */
}

BOOLEAN startmenu()
{
	char save_cheat[10] ;
	GFXBLK onpix[4];
	int sel;
	void *menupic;
	BOOLEAN ende, key_pressed;
	RGB menupal[256];
	long time;

	strcpy(cheatmode, "") ;
//	onpix[0].mem = NULL;
//	onpix[1].mem = NULL;
//	onpix[2].mem = NULL;
//	onpix[3].mem = NULL;

	ClearPalette(alt_rgb);
	SetPalette(alt_rgb);
	cls(0);
	Copy2Screen();

	if(!load_pic("MENUON.PIX", screen_addr, menupal))
		puts("\7");
	get(0, 0, 319, 49, &onpix[0]);
	get(0, 50, 319, 99, &onpix[1]);
	get(0, 100, 319, 149, &onpix[2]);
	get(0, 150, 319, 199, &onpix[3]);
	if(!load_pic("MENUOFF.PIX", screen_addr, menupal))
		puts("\7");
	menupic = malloc(screen_height * screen_width);
	getvollbild(menupic);

	sel = 0;
	putvollbild(menupic);
	objput(0, 50 * sel, &onpix[sel]);
	Copy2Screen();
	PaletteFadeIn(menupal);

	ende = FALSE;
	key_pressed = FALSE;
	time = timer();
	while((timer() - time < 2000) && !keyTest(KEY_F1) && !keyTest(KEY_ESC) && ((!keyTest(KEY_ENTER) && !keyTest(KEY_RCTRL) && !keyTest(KEY_LCTRL) && !keyTest(KEY_SPACE) && !joy1_b1()) || (sel == 1) || (sel == 2)))
	{
		if(keyTest(KEY_UP) || joy1_up())
		{
			time = timer();
			if(!key_pressed)
				if(sel > 0)
				{
					sel--;

					if (sounddevice != 4) start_sample(bloinksnd, md_numchn - 1);
				}
			key_pressed = TRUE;
		}
		else if(keyTest(KEY_DOWN) || joy1_down())
		{
			time = timer();
			if(!key_pressed)
				if(sel < 3)
				{
					sel++;

					if (sounddevice != 4) start_sample(bloinksnd, md_numchn - 1);
				}
			key_pressed = TRUE;
		}
		else if(keyTest(KEY_ENTER) || keyTest(KEY_RCTRL) || keyTest(KEY_LCTRL) || keyTest(KEY_SPACE) || joy1_b1())
		{
			if(sel == 1)
			{
				PaletteFadeOut(menupal);

				viewoptions();
				// und wieder Menu
				putvollbild(menupic);
				objput(0, 50 * sel, &onpix[sel]);
				Copy2Screen();
				PaletteFadeIn(menupal);
			}
			else if(sel == 2)
			{
				PaletteFadeOut(menupal);

				// Introgeschichte
				story();

				// keine Eintragung!
				spieler.punkte = 0;
				strcpy(save_cheat, cheatmode) ;
				strcpy(cheatmode, "IAMGOD") ;
				hiscore();
				strcpy(cheatmode, save_cheat) ;
				// und wieder Menu
				putvollbild(menupic);
				objput(0, 50 * sel, &onpix[sel]);
				Copy2Screen();
				PaletteFadeIn(menupal);
			}

			time = timer();
			key_pressed = TRUE;
		}
		else if(keyTest(KEY_H))
			strcpy(cheatmode, "H");
		else if(keyTest(KEY_E) && !strcmp(cheatmode, "H"))
			strcpy(cheatmode, "HE");
		else if(keyTest(KEY_L) && !strcmp(cheatmode, "HE"))
			strcpy(cheatmode, "HEL");
		else if(keyTest(KEY_P) && !strcmp(cheatmode, "HEL"))
			strcpy(cheatmode, "HELP");
		else if(keyTest(KEY_M) && !strcmp(cheatmode, "HELP"))
			strcpy(cheatmode, "HELPM");
		else if(keyTest(KEY_E) && !strcmp(cheatmode, "HELPM"))
		{
			strcpy(cheatmode, "HELPME");

			wait_retrace();
			SetPalette(redpal[3]);
			wait_retrace();
			SetPalette(menupal);

			time = timer();
			key_pressed = TRUE;
		}
		else if(keyTest(KEY_I))
			strcpy(cheatmode, "I");
		else if(keyTest(KEY_A) && !strcmp(cheatmode, "I"))
			strcpy(cheatmode, "IA");
		else if(keyTest(KEY_M) && !strcmp(cheatmode, "IA"))
			strcpy(cheatmode, "IAM");
		else if(keyTest(KEY_G) && !strcmp(cheatmode, "IAM"))
			strcpy(cheatmode, "IAMG");
		else if(keyTest(KEY_O) && !strcmp(cheatmode, "IAMG"))
			strcpy(cheatmode, "IAMGO");
		else if(keyTest(KEY_D) && !strcmp(cheatmode, "IAMGO"))
		{
			strcpy(cheatmode, "IAMGOD");

			wait_retrace();
			SetPalette(whitepal);
			wait_retrace();
			SetPalette(menupal);

			time = timer();
			key_pressed = TRUE;
		}
		else
			key_pressed = FALSE;
		putvollbild(menupic);
		objput(0, 50 * sel, &onpix[sel]);
		Copy2Screen();
	}
	if((timer() - time >= 1000) || keyTest(KEY_F1))
	{
		game_mode = DEMO;
	}
	else
	{
		if (sounddevice != 4) start_sample(bloinksnd, md_numchn - 1);

		game_mode = PLAY;
		if((sel == 3) || keyTest(KEY_ESC))
			ende = TRUE;
	}
	while(keyTest(KEY_ESC) || keyTest(KEY_ENTER) || keyTest(KEY_RCTRL) || keyTest(KEY_LCTRL) || keyTest(KEY_SPACE) || joy1_b1())
		;

	free(menupic);
	free_blk(& onpix[0]);
	free_blk(& onpix[1]);
	free_blk(& onpix[2]);
	free_blk(& onpix[3]);

	if(sel == 0)
		SoundFading(-5);

//	PaletteFadeOut(alt_rgb);
//	cls(0);
//	Copy2Screen();

	return(ende);
}

BOOLEAN buy_continue()
{
//	void *old_screen = screen_addr;
	GFXBLK leuchtepix[2];
	int i;
	char txt[80], str[10];
	BOOLEAN r;

	if(spieler.punkte < CONTINUE_PRICE)
		return(FALSE);
	if((game_level == 0) || (game_level == MAX_LEVEL))
		return(FALSE);

	cls(0);
	Copy2Screen();
	ClearPalette(alt_rgb);
	SetPalette(alt_rgb);

//	leuchtepix[0].mem = NULL;
//	leuchtepix[1].mem = NULL;
	load_pic("BILDSCH2.PIX", screen_addr, alt_rgb);
	get(9, 58, 23, 70, &leuchtepix[1]);
	load_pic("BILDSCHI.PIX", screen_addr, alt_rgb);
	get(9, 58, 23, 70, &leuchtepix[0]);
	Copy2Screen();
	PaletteFadeIn(alt_rgb);

	strcpy(txt, "YOU GOT ");
	itoa(spieler.punkte, str, 10);
	strcat(txt, str);
	strcat(txt, " POINTS!!!");
	ticker_text(&gamefont, 50, 40, txt, FALSE);
	ticker_text(&gamefont, 40, 60, "DO YOU WANT TO BUY 3", FALSE);
	ticker_text(&gamefont, 40, 70, "NEW SPACEFIGHTERS FOR", FALSE);
	ticker_text(&gamefont, 40, 80, "50000 POINTS:", FALSE);
	ticker_text(&gamefont, 40, 100, "-A- YES, I WILL BE", FALSE);
	ticker_text(&gamefont, 40 + 4 * gamefont.char_w, 110, "BETTER THIS TIME!", FALSE);
	ticker_text(&gamefont, 40, 120, "-B- NO, I WANT MY", FALSE);
	ticker_text(&gamefont, 40 + 4 * gamefont.char_w, 130, "HIGHSCORE!", FALSE);
	ticker_text(&gamefont, 50, 150, "WAITING FOR KEY!", FALSE);

//	screen_addr = (void *)0xA0000;
	i = 0;
	while(!keyTest(KEY_A) && !keyTest(KEY_B) && !keyTest(KEY_ESC))
	{
		i++;
		wait_retrace();
		put(9, 58, &leuchtepix[(i % 32) / 16]);
		Copy2Screen() ;
	}
	if(keyTest(KEY_A))
	{
		if (sounddevice != 4) start_sample(bloinksnd, md_numchn - 1);
		r = TRUE;
	}
	else
	{
		if (sounddevice != 4) start_sample(bloinksnd, md_numchn - 1);
		r = FALSE;
	}
	while(keyTest(KEY_A) || keyTest(KEY_B) || keyTest(KEY_ESC))
		;

//	screen_addr = old_screen;

	free_blk(& leuchtepix[0]);
	free_blk(& leuchtepix[1]);

	PaletteFadeOut(alt_rgb);
	cls(0);
	Copy2Screen();

	if(r)
	{
		spieler.punkte -= 25000;
		spieler_neu();
		spieler.leben = 3;
		start_game(game_level);
	}

	return(r);
}
