/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*****************************************/
/* Hintergrund-Sternefliegen fr TERROID */
/* (C) August 1996 by Michael Haar       */
/*****************************************/

#include <stdlib.h>
#include <dn.h>
#include "DEFS.H"
#include "VARS.H"
#include "FUNCS.H"

#define MAX_STERNE 200

/* globale Variablen */
struct
{
	int x, y, geschw;
} stern[MAX_STERNE];

/* Funktionsprototypen */
void init_sterne();
void sterne();

/* Funktionen */
void init_sterne()
{
	int i;

	for(i = 0; i < MAX_STERNE; i++)
	{
		stern[i].x = (rand() % screen_width) * KURVENFAC;
		stern[i].y = (rand() % screen_height);
		stern[i].geschw = (rand() % (game_scrollgeschw * KURVENFAC - 3)) + 2;
	}
}

void new_sterne()
{
	int i;

	for(i = 0; i < MAX_STERNE; i++)
		if(stern[i].x / KURVENFAC < 0)
		{
			stern[i].x = (screen_width - 1) * KURVENFAC;
/*			stern[i].y = (rand() % screen_height);
			stern[i].geschw = (rand() % (game_scrollgeschw * KURVENFAC)) -1;
			if(stern[i].geschw < 1)
				stern[i].geschw = 1; */
		}
}

void sterne()
{
	int i, color_offset;
	char *starput;

	if(game_level < 3)
		color_offset = 0;
	else if(game_level < 6)
		color_offset = 96;
	else
		return;
	
	if (do_draw)
	  {
	    for(i = 0; i < MAX_STERNE; i++)
		if(stern[i].x / KURVENFAC >= 0)
		{
			starput = (char *)((long)screen_addr + stern[i].x / KURVENFAC + stern[i].y * screen_width);
			if(stern[i].geschw < 4)
			{
				// Nur anzeigen, wo noch keine andere Grafik wenn lahmer Stern
				if(!(*starput))
					*starput = ((stern[i].geschw + 4) * 2) % 32 + color_offset;
			}
			else
				*starput = ((stern[i].geschw + 4) * 2) % 32 + color_offset;
			stern[i].x -= stern[i].geschw;
		}
	  } /* if (do_draw) */

	new_sterne();
}
