/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**********************************/
/* ballerspiel-Schiessen          */
/* (C) April 1996 by Michael Haar */
/**********************************/

/* nderungen: */

#include <stdlib.h>
#include <math.h>
#include <dn.h>
#include "DEFS.H"
#include "FUNCS.H"
#include "VARS.H"

/* globale Variablen */

/* Funktionsprototypen */
int zielrakete_gegnersuchen(void);
void neuer_schuss(int x, int y, unsigned char r, unsigned char art);
void schiessen(OBJEKT *obj);

/* Funktionen */
int zielrakete_gegnersuchen(void)
{
	int i, xr, yr, min_x, min_y, o;

	o = -1;
	min_x = 1000000;
	min_y = 1000000;
	for(i = 0; i < MAX_OBJEKTE; i++)
		if(objekt[i].nr && (objekt[i].art > 1) && (objekt[i].art < 100) && (objekt[i].energie < 100000))
		{
			xr = abs(spieler.x - objekt[i].bahn.x / KURVENFAC);
			yr = abs(spieler.y - objekt[i].bahn.y / KURVENFAC);
			if(xr + yr < min_x + min_y)
			{
				o = i;
				min_x = xr;
				min_y = yr;
			}
		}
	return(o);
}

void neuer_schuss(int x, int y, unsigned char r, unsigned char art)
{
	int i;
	int sinus, cosinus, w;

	i = 0;
	while((i < MAX_OBJEKTE) && objekt[i].nr)
		i++;

	if(i < MAX_OBJEKTE)
	{
		switch(art)
		{
			case 0:
			case 1:
			case 2:
			case 3:
				// normaler Schuss
				objekt[i].nr = SCHUSSPICS + 1 + art;
				objekt[i].art = 100;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 200 * SPEED_FAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				objekt[i].bahn.kurve[0].xpl = (6 * SPEED_FAC + art * 2) * KURVENFAC * KURVENFAC;
				objekt[i].bahn.kurve[0].ypl = 0;
				objekt[i].bahn.kurve[0].xxpl = 0;
				objekt[i].bahn.kurve[0].yypl = 0;
				objekt[i].energie = 15 * (art + 1);
				if(art == 3)
					objekt[i].energie = 150;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 4:
				// kleiner schneller Gegnerschuss (MG)
				objekt[i].nr = GEGNERPICS + 14;
				objekt[i].art = 101;
				objekt[i].anistufe = r * ANIFAC;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 40 * SPEED_FAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				set_richtung(&objekt[i].bahn, 0, r, 12 * SPEED_FAC);
				objekt[i].energie = 5;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 5:
				// Spielerlaser
				objekt[i].art = 100;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				// genauere Bahnen ...
				switch(r)
				{
					case 0:
						objekt[i].nr = SCHUSSPICS + 6;
						objekt[i].bahn.anz = 1;
						objekt[i].bahn.kurve[0].len = 20 * SPEED_FAC;
						objekt[i].bahn.x = x * KURVENFAC;
						objekt[i].bahn.y = y * KURVENFAC;
						set_richtung(&objekt[i].bahn, 0, 2, 24 * SPEED_FAC);
						objekt[i].energie = 4;
						break;
					case 1:
						objekt[i].nr = SCHUSSPICS + 6;
						objekt[i].bahn.anz = 1;
						objekt[i].bahn.kurve[0].len = 20 * SPEED_FAC;
						objekt[i].bahn.x = x * KURVENFAC;
						objekt[i].bahn.y = y * KURVENFAC;
						objekt[i].bahn.kurve[0].xpl = 24 * SPEED_FAC * KURVENFAC * KURVENFAC;
						objekt[i].bahn.kurve[0].xxpl = 0;
						if(y < spieler.y)
						{
							objekt[i].bahn.kurve[0].ypl = -2 * SPEED_FAC * KURVENFAC * KURVENFAC;
							objekt[i].bahn.kurve[0].yypl = 4 * SPEED_FAC * KURVENFAC;
						}
						else
						{
							objekt[i].bahn.kurve[0].ypl = 2 * SPEED_FAC * KURVENFAC * KURVENFAC;
							objekt[i].bahn.kurve[0].yypl = -4 * SPEED_FAC * KURVENFAC;
						}
						objekt[i].energie = 6;
						break;
					case 2:
						objekt[i].nr = SCHUSSPICS + 7;
						objekt[i].bahn.anz = 1;
						objekt[i].bahn.kurve[0].len = 20 * SPEED_FAC;
						objekt[i].bahn.x = x * KURVENFAC;
						objekt[i].bahn.y = y * KURVENFAC;
						set_richtung(&objekt[i].bahn, 0, 2, 24 * SPEED_FAC);
						objekt[i].energie = 8;
						break;
					case 3:
						objekt[i].nr = SCHUSSPICS + 7;
						objekt[i].bahn.anz = 1;
						objekt[i].bahn.kurve[0].len = 20 * SPEED_FAC;
						objekt[i].bahn.x = x * KURVENFAC;
						objekt[i].bahn.y = y * KURVENFAC;
						objekt[i].bahn.kurve[0].xpl = 24 * SPEED_FAC * KURVENFAC * KURVENFAC;
						objekt[i].bahn.kurve[0].xxpl = 0;
						if(y < spieler.y)
						{
							objekt[i].bahn.kurve[0].ypl = -2 * SPEED_FAC * KURVENFAC * KURVENFAC;
							objekt[i].bahn.kurve[0].yypl = 4 * SPEED_FAC * KURVENFAC;
						}
						else
						{
							objekt[i].bahn.kurve[0].ypl = 2 * SPEED_FAC * KURVENFAC * KURVENFAC;
							objekt[i].bahn.kurve[0].yypl = -4 * SPEED_FAC * KURVENFAC;
						}
						objekt[i].energie = 8;
						break;
					case 4:
						objekt[i].nr = SCHUSSPICS + 8;
						objekt[i].bahn.anz = 1;
						objekt[i].bahn.kurve[0].len = 20 * SPEED_FAC;
						objekt[i].bahn.x = x * KURVENFAC;
						objekt[i].bahn.y = y * KURVENFAC;
						set_richtung(&objekt[i].bahn, 0, 2, 24 * SPEED_FAC);
						objekt[i].energie = 10;
						break;
					case 5:
						objekt[i].nr = SCHUSSPICS + 8;
						objekt[i].bahn.anz = 1;
						objekt[i].bahn.kurve[0].len = 20 * SPEED_FAC;
						objekt[i].bahn.x = x * KURVENFAC;
						objekt[i].bahn.y = y * KURVENFAC;
						objekt[i].bahn.kurve[0].xpl = 24 * SPEED_FAC * KURVENFAC * KURVENFAC;
						objekt[i].bahn.kurve[0].xxpl = 0;
						if(y < spieler.y)
						{
							objekt[i].bahn.kurve[0].ypl = -2 * SPEED_FAC * KURVENFAC * KURVENFAC;
							objekt[i].bahn.kurve[0].yypl = 4 * SPEED_FAC * KURVENFAC;
						}
						else
						{
							objekt[i].bahn.kurve[0].ypl = 2 * SPEED_FAC * KURVENFAC * KURVENFAC;
							objekt[i].bahn.kurve[0].yypl = -4 * SPEED_FAC * KURVENFAC;
						}
						objekt[i].energie = 12;
						break;
				}
				objekt[i].bahn.akt = 0;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 7:
				// Grosser Richtungsgegnerschuss
				objekt[i].nr = GEGNERPICS + 31;
				objekt[i].art = 101;
				objekt[i].anistufe = r * ANIFAC;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 100 * SPEED_FAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				set_richtung(&objekt[i].bahn, 0, r, 4 * SPEED_FAC);
				objekt[i].energie = 10;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 8:
				// Spielerrakete
				objekt[i].nr = SCHUSSPICS + 9;
				objekt[i].art = 102;
				objekt[i].anistufe = 2 * ANIFAC;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 200;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				objekt[i].bahn.kurve[0].xpl = 90;
				objekt[i].bahn.kurve[0].ypl = 90;
				objekt[i].bahn.kurve[0].xxpl = 1;
				objekt[i].bahn.kurve[0].yypl = 1;
				objekt[i].energie = r;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				// Zweckentfremdung:
				objekt[i].weapon_fire = zielrakete_gegnersuchen();
				break;
			case 9:
				// Gegnerrakete
				objekt[i].nr = GEGNERPICS + 64;
				objekt[i].art = 103;
				objekt[i].anistufe = 6 * ANIFAC;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 100;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				objekt[i].bahn.kurve[0].xpl = 270;
				objekt[i].bahn.kurve[0].ypl = 270;
				objekt[i].bahn.kurve[0].xxpl = 1;
				objekt[i].bahn.kurve[0].yypl = 1;
				objekt[i].energie = 10;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 10:
				// kleiner Kugelschuss
				objekt[i].nr = GEGNERPICS + 181;
				objekt[i].art = 104;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 80 * SPEED_FAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				set_richtung(&objekt[i].bahn, 0, r, 4 * SPEED_FAC);
				objekt[i].energie = 2;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 11:
				//kleine mine
				objekt[i].nr = GEGNERPICS + 154;
				objekt[i].art = 13;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 3;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 200 * SPEED_FAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				objekt[i].bahn.kurve[0].xpl = - KURVENFAC * KURVENFAC;
				objekt[i].bahn.kurve[0].ypl = 0;
				objekt[i].bahn.kurve[0].xxpl = 0;
				objekt[i].bahn.kurve[0].yypl = 0;
				objekt[i].energie = 10;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 12:
				// roter Spielerseitenschuss
				objekt[i].art = 100;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 100 * SPEED_FAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				switch(r)
				{
					case 1:
						objekt[i].nr = SCHUSSPICS + 17;
						objekt[i].bahn.kurve[0].xpl = (4 * SPEED_FAC) * KURVENFAC * KURVENFAC;
						objekt[i].bahn.kurve[0].ypl = -(4 * SPEED_FAC) * KURVENFAC * KURVENFAC;
						break;
					case 3:
						objekt[i].nr = SCHUSSPICS + 18;
						objekt[i].bahn.kurve[0].xpl = (4 * SPEED_FAC) * KURVENFAC * KURVENFAC;
						objekt[i].bahn.kurve[0].ypl = (4 * SPEED_FAC) * KURVENFAC * KURVENFAC;
						break;
					case 6:
						objekt[i].nr = SCHUSSPICS + 19;
						objekt[i].bahn.kurve[0].xpl = -(4 * SPEED_FAC) * KURVENFAC * KURVENFAC;
						objekt[i].bahn.kurve[0].ypl = 0;
						break;
					case 5:
						objekt[i].nr = SCHUSSPICS + 21;
						objekt[i].bahn.kurve[0].xpl = -(4 * SPEED_FAC) * KURVENFAC * KURVENFAC;
						objekt[i].bahn.kurve[0].ypl = (4 * SPEED_FAC) * KURVENFAC * KURVENFAC;
						break;
					case 7:
						objekt[i].nr = SCHUSSPICS + 20;
						objekt[i].bahn.kurve[0].xpl = -(4 * SPEED_FAC) * KURVENFAC * KURVENFAC;
						objekt[i].bahn.kurve[0].ypl = -(4 * SPEED_FAC) * KURVENFAC * KURVENFAC;
						break;
				}
				objekt[i].bahn.kurve[0].xxpl = 0;
				objekt[i].bahn.kurve[0].yypl = 0;
				objekt[i].energie = 25;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 13:
				// Spielerminen
				objekt[i].nr = SCHUSSPICS + 27;
				objekt[i].art = 105;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 3;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 50 * SPEED_FAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				objekt[i].bahn.kurve[0].xpl = -2 * KURVENFAC * KURVENFAC;
				objekt[i].bahn.kurve[0].ypl = 0;
				objekt[i].bahn.kurve[0].xxpl = 0;
				objekt[i].bahn.kurve[0].yypl = 0;
				objekt[i].energie = 10;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 14:
				// Flammgegnerschuss
				objekt[i].nr = GEGNERPICS + 182;
				objekt[i].art = 104;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 6;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 6 * ANIFAC * SPEED_FAC / 3;
				objekt[i].bahn.kurve[0].xpl = -6 * SPEED_FAC * KURVENFAC * KURVENFAC;
				objekt[i].bahn.kurve[0].ypl = 0;
				objekt[i].bahn.kurve[0].xxpl = 0;
				objekt[i].bahn.kurve[0].yypl = 0;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				objekt[i].energie = 10;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 15:
				// Riesenendgegnerrakete
				objekt[i].nr = GEGNERPICS + 230;
				objekt[i].art = 4;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 60 * SPEED_FAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				objekt[i].bahn.kurve[0].xpl = -8 * KURVENFAC * KURVENFAC;
				objekt[i].bahn.kurve[0].ypl = 0;
				objekt[i].bahn.kurve[0].xxpl = -1 * KURVENFAC;
				objekt[i].bahn.kurve[0].yypl = 0;
				objekt[i].energie = 50;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 16:
				// kleiner Kugelschuss rotierend gefeuert
				objekt[i].nr = GEGNERPICS + 181;
				objekt[i].art = 104;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 80 * SPEED_FAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				sinus = sintab[(main_counter * 5) % 360];
				cosinus = sintab[((main_counter * 5) % 360) + 90];
				objekt[i].bahn.kurve[0].xpl = (r * KURVENFAC * KURVENFAC * sinus) >> SINFAC;
				objekt[i].bahn.kurve[0].ypl = (r * KURVENFAC * KURVENFAC * -cosinus) >> SINFAC;
				objekt[i].bahn.kurve[0].xxpl = 0;
				objekt[i].bahn.kurve[0].yypl = 0;
				objekt[i].energie = 2;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 17:
				// Scheibenschuss lahm auf Spieler gefeuert
				objekt[i].nr = GEGNERPICS + 241;
				objekt[i].art = 104;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 320 * SPEED_FAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				w = winkel(spieler.x - x, spieler.y - y);
				sinus = sintab[w % 360];
				cosinus = sintab[(w % 360) + 90];
				objekt[i].bahn.kurve[0].xpl = ((r * KURVENFAC * KURVENFAC / 2 * sinus) >> SINFAC) - game_scrollgeschw * KURVENFAC * KURVENFAC;
				objekt[i].bahn.kurve[0].ypl = (r * KURVENFAC * KURVENFAC / 2 * -cosinus) >> SINFAC;
				objekt[i].bahn.kurve[0].xxpl = 0;
				objekt[i].bahn.kurve[0].yypl = 0;
				objekt[i].energie = 1;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 18:
				// Rckschuss
				objekt[i].nr = GEGNERPICS + 242;
				objekt[i].art = 4;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 40 * SPEED_FAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				objekt[i].bahn.kurve[0].xpl = -4 * KURVENFAC * KURVENFAC;
				objekt[i].bahn.kurve[0].ypl = 0;
				objekt[i].bahn.kurve[0].xxpl = -2 * KURVENFAC;
				objekt[i].bahn.kurve[0].yypl = 0;
				objekt[i].energie = 25;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 19:
				// Miniflieger - spielersuchend
				objekt[i].nr = GEGNERPICS + 247;
				objekt[i].art = 26;
				objekt[i].anistufe = 6 * ANIFAC;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 200;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				objekt[i].bahn.kurve[0].xpl = 270;
				objekt[i].bahn.kurve[0].ypl = 270;
				objekt[i].bahn.kurve[0].xxpl = 1;
				objekt[i].bahn.kurve[0].yypl = 1;
				objekt[i].energie = 25;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 20:
				// kleiner Kugelschuss langsam auf Spieler gefeuert
				objekt[i].nr = GEGNERPICS + 181;
				objekt[i].art = 104;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 320 * SPEED_FAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				w = winkel(spieler.x - x, spieler.y - y);
				sinus = sintab[w % 360];
				cosinus = sintab[(w % 360) + 90];
				objekt[i].bahn.kurve[0].xpl = ((r + game_scrollgeschw) * KURVENFAC * KURVENFAC * sinus) >> SINFAC;
				objekt[i].bahn.kurve[0].ypl = (r * KURVENFAC * KURVENFAC * -cosinus) >> SINFAC;
				objekt[i].bahn.kurve[0].xxpl = 0;
				objekt[i].bahn.kurve[0].yypl = 0;
				objekt[i].energie = 2;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 21:
				// Torpedo auf Spieler gefeuert
				objekt[i].nr = GEGNERPICS + 246;
				objekt[i].art = 4;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 320 * SPEED_FAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				w = min(360 - 60, max(360 - 120, winkel(spieler.x - x, spieler.y - y)));
				sinus = sintab[w % 360];
				cosinus = sintab[(w % 360) + 90];
				objekt[i].bahn.kurve[0].xpl = ((r + game_scrollgeschw) * KURVENFAC * KURVENFAC * sinus) >> SINFAC;
				objekt[i].bahn.kurve[0].ypl = (r * KURVENFAC * KURVENFAC * -cosinus) >> SINFAC;
				objekt[i].bahn.kurve[0].xxpl = 0;
				objekt[i].bahn.kurve[0].yypl = 0;
				objekt[i].energie = 25;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 22:
				// Zerbatzteil/Mine
				objekt[i].nr = GEGNERPICS + 272;
				objekt[i].art = 30;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 160 / r * SPEED_FAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				objekt[i].bahn.kurve[0].xpl = -r * KURVENFAC * KURVENFAC;
				objekt[i].bahn.kurve[0].ypl = 0;
				objekt[i].bahn.kurve[0].xxpl = 0;
				objekt[i].bahn.kurve[0].yypl = 0;
				objekt[i].energie = 25;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 23:
				// Flammenwerfer
				if(r == 0)
					objekt[i].nr = GEGNERPICS + 283;
				else
					objekt[i].nr = GEGNERPICS + 288;
				objekt[i].art = 106;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 5;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 5 * ANIFAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				objekt[i].bahn.kurve[0].xpl = -game_scrollgeschw * KURVENFAC * KURVENFAC;
				objekt[i].bahn.kurve[0].ypl = 0;
				objekt[i].bahn.kurve[0].xxpl = 0;
				objekt[i].bahn.kurve[0].yypl = 0;
				objekt[i].energie = 100;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 24:
				// Gegnergefeuerter dicker Spielerlaser
				objekt[i].nr = SCHUSSPICS + 8;
				objekt[i].art = 4;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 50 * SPEED_FAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				objekt[i].bahn.kurve[0].xpl = -6 * KURVENFAC * KURVENFAC;
				objekt[i].bahn.kurve[0].ypl = 0;
				objekt[i].bahn.kurve[0].xxpl = 0;
				objekt[i].bahn.kurve[0].yypl = 0;
				objekt[i].energie = 10000;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 25:
				// Endgegner7minen
				objekt[i].nr = GEGNERPICS + 310;
				objekt[i].art = 13;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 130 * SPEED_FAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				objekt[i].bahn.kurve[0].xpl = -game_scrollgeschw * 2 * KURVENFAC * KURVENFAC;
				if(r == 7)
					objekt[i].bahn.kurve[0].ypl = -game_scrollgeschw * 2 * KURVENFAC;
				else if(r == 5)
					objekt[i].bahn.kurve[0].ypl = game_scrollgeschw * 2 * KURVENFAC;
				objekt[i].bahn.kurve[0].xxpl = 0;
				objekt[i].bahn.kurve[0].yypl = 0;
				objekt[i].energie = 500;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 26:
				// Greiferschrott
				objekt[i].nr = GEGNERPICS + 309 - r / 4;
				objekt[i].art = 4;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 60 * SPEED_FAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				objekt[i].bahn.kurve[0].xpl = 0;
				objekt[i].bahn.kurve[0].ypl = (-4 + r / 4 * 8) * KURVENFAC * KURVENFAC;
				objekt[i].bahn.kurve[0].xxpl = 0;
				objekt[i].bahn.kurve[0].yypl = 0;
				objekt[i].energie = 250;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
			case 27:
				// suchende Flammen
				objekt[i].nr = GEGNERPICS + 203;
				objekt[i].art = 17;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 250 * SPEED_FAC;
				objekt[i].bahn.x = x * KURVENFAC;
				objekt[i].bahn.y = y * KURVENFAC;
				objekt[i].bahn.kurve[0].xpl = 0;
				objekt[i].bahn.kurve[0].ypl = 0;
				objekt[i].bahn.kurve[0].xxpl = 0;
				objekt[i].bahn.kurve[0].yypl = 0;
				objekt[i].energie = 50;
				objekt[i].extra_listnr = -1;
				objekt[i].extra = 0;
				break;
		}
	}
}

void schiessen(OBJEKT *obj)
{
	int x, y, r, xpl, xent, yent;
	int sinus, cosinus;

	if(obj->weapon_ok)
		obj->weapon_ok--;
	else
	{
		switch(obj->art)
		{
			case 5:
				// Drehgegner mit DoppelMG
				r = get_richtung(&obj->bahn, obj->bahn.akt);
				// WARUM?????? (8 - r)
				if((obj->nr >= 134) && (obj->nr <= 142))
					xent = 20;
				else
					xent = 32;
				yent = xent * 2 / 3;
				sinus = sintab[(8 - r) * 45];
				cosinus = sintab[(8 - r) * 45 + 90];
				xpl = rand() % (6 * SPEED_FAC);
				x = ((sinus * (-yent ) + cosinus * (-xent + xpl)) >> SINFAC) + obj->bahn.x / KURVENFAC;
				y = ((cosinus * (-yent ) - sinus * (-xent + xpl)) >> SINFAC) + obj->bahn.y / KURVENFAC;
				neuer_schuss(x, y, r, 4);
				x = ((sinus * (-yent) + cosinus * (yent + xpl)) >> SINFAC) + obj->bahn.x / KURVENFAC;
				y = ((cosinus * (-yent) - sinus * (yent + xpl)) >> SINFAC) + obj->bahn.y / KURVENFAC;
				neuer_schuss(x, y, r, 4);
				break;
			case 6:
				// Drehgeschtz
				r = ziel_richtung(&obj->bahn);
				// WARUM?????? (8 - r)
				sinus = sintab[(8 - r) * 45];
				cosinus = sintab[(8 - r) * 45 + 90];
				x =  ((sinus * (-40)) >> SINFAC) + obj->bahn.x / KURVENFAC;
				y =  ((cosinus * (-40)) >> SINFAC) + obj->bahn.y / KURVENFAC;
				neuer_schuss(x, y, r, 7);
				break;
			case 8:
				// Raketenturm
				neuer_schuss(obj->bahn.x / KURVENFAC + 1, obj->bahn.y / KURVENFAC - 8, 6, 9);
				neuer_schuss(obj->bahn.x / KURVENFAC + 1, obj->bahn.y / KURVENFAC + 8, 6, 9);
				break;
			case 11:
				// hochfahrende Geschtzstellung
				neuer_schuss(obj->bahn.x / KURVENFAC - 38, obj->bahn.y / KURVENFAC - 6, 6, 4);
				neuer_schuss(obj->bahn.x / KURVENFAC - 38, obj->bahn.y / KURVENFAC + 3, 6, 4);
				break;
			case 12:
				//streuender gegner
				r = obj->anistufe / ANIFAC;
				sinus = sintab[(r) * 45];
				cosinus = sintab[(r) * 45 + 90];
				x = ((sinus * 30) >> SINFAC) + obj->bahn.x / KURVENFAC;
				y = -((cosinus * 30) >> SINFAC) + obj->bahn.y / KURVENFAC;
				neuer_schuss(x, y, r, 10);
				break;
			case 15:
				//mine layer
				r = obj->anistufe / ANIFAC;
				sinus = sintab[(r) * 45];
				cosinus = sintab[(r) * 45 + 90];
				x = -((sinus * 30) >> SINFAC) + obj->bahn.x / KURVENFAC;
				y = ((cosinus * 30) >> SINFAC) + obj->bahn.y / KURVENFAC;
				neuer_schuss(x, y, r, 11);
				break;
			case 18:
				// U-Boot
				neuer_schuss(obj->bahn.x / KURVENFAC, obj->bahn.y / KURVENFAC, 6, 9);
				break;
			case 20:
				// kleine Kugelschsse kreisfoermig
				x = obj->bahn.x / KURVENFAC;
				y = obj->bahn.y / KURVENFAC;
				neuer_schuss(x, y, 8, 16);
				break;
			case 21:
				// kleine Kugelschsse nach vorne
				neuer_schuss(obj->bahn.x / KURVENFAC - 40, obj->bahn.y / KURVENFAC, 6, 10);
				break;
			case 22:
			case 23:
			case 24:
				// Scheibenablassen
				neuer_schuss(obj->bahn.x / KURVENFAC, obj->bahn.y / KURVENFAC, 1, 17);
				break;
			case 25:
				// Rckschiessen
				neuer_schuss(obj->bahn.x / KURVENFAC - 20, obj->bahn.y / KURVENFAC, 6, 18);
				break;
			case 27:
				// Normalanigegner mit kleinem Kugelschuss - spielersuchend
				neuer_schuss(obj->bahn.x / KURVENFAC, obj->bahn.y / KURVENFAC, 2, 20);
				break;
			case 28:
				// Uboote mit nach vorne spielersuchenden/setzenden Torpedos
				neuer_schuss(obj->bahn.x / KURVENFAC - 64, obj->bahn.y / KURVENFAC, 2, 21);
				break;
			case 31:
				// Launchflieger - Minifliegerfeuernd
				neuer_schuss(obj->bahn.x / KURVENFAC, obj->bahn.y / KURVENFAC, 6, 19);
				break;
			case 32:
				// Schiessteil fr lahme Kreisschsse
				neuer_schuss(obj->bahn.x / KURVENFAC - 16, obj->bahn.y / KURVENFAC, 1, 17);
				break;
			case 33:
				// Zerbatzteile legen
				neuer_schuss(obj->bahn.x / KURVENFAC, obj->bahn.y / KURVENFAC, 2, 22);
				break;
			case 34:
				// Doppelkanone-drehend
				r = ziel_richtung(&obj->bahn);
				// WARUM?????? (8 - r)
				sinus = sintab[(8 - r) * 45];
				cosinus = sintab[(8 - r) * 45 + 90];
				x = ((sinus * -30 + cosinus * -3) >> SINFAC) + obj->bahn.x / KURVENFAC;
				y = ((cosinus * -30 - sinus * -3) >> SINFAC) + obj->bahn.y / KURVENFAC;
				neuer_schuss(x, y, r, 10);
				x = ((sinus * -30 + cosinus * 5) >> SINFAC) + obj->bahn.x / KURVENFAC;
				y = ((cosinus * -30 - sinus * 5) >> SINFAC) + obj->bahn.y / KURVENFAC;
				neuer_schuss(x, y, r, 10);
				break;
			case 35:
				// Flammenwerfer
				if(obj->nr < GEGNERPICS + 280)
					neuer_schuss(obj->bahn.x / KURVENFAC + 2, obj->bahn.y / KURVENFAC - 84, 0, 23);	// hoch
				else
					neuer_schuss(obj->bahn.x / KURVENFAC - 4, obj->bahn.y / KURVENFAC + 84, 4, 23);	// runter
				break;
			case 37:
				// Launcher fuer Miniflieger
				neuer_schuss(obj->bahn.x / KURVENFAC, obj->bahn.y / KURVENFAC, 6, 19);
				break;
			case 38:
				// Greifer mit Schrott
				// schiessen und Schrott vom Greifer weg und umdrehen
				if(obj->nr == GEGNERPICS + 311)
				{
					obj->nr = GEGNERPICS + 306;
					obj->bahn.y -= 9 * KURVENFAC;
					neuer_schuss(obj->bahn.x / KURVENFAC - 96, obj->bahn.y / KURVENFAC + 32, 4, 26);	// runter
				}
				else
				{
					obj->nr = GEGNERPICS + 307;
					obj->bahn.y += 6 * KURVENFAC;
					neuer_schuss(obj->bahn.x / KURVENFAC - 96, obj->bahn.y / KURVENFAC - 32, 0, 26);	// hoch
				}
				obj->bahn.kurve[0].xpl = -obj->bahn.kurve[0].xpl;
					obj->weapon_fire = -1;
				break;
			case 50:
				// erster Endgegner
				if(!endgegner1_kanonen_da())
					neuer_schuss(obj->bahn.x / KURVENFAC, obj->bahn.y / KURVENFAC, 1, 17);
				break;
			case 51:
				// zweiter Endgegner
				neuer_schuss(obj->bahn.x / KURVENFAC - 96, obj->bahn.y / KURVENFAC - 28, 0, 14);
				neuer_schuss(obj->bahn.x / KURVENFAC - 96, obj->bahn.y / KURVENFAC + 28, 0, 14);
				if(rand() % 3 == 0)
					neuer_schuss(obj->bahn.x / KURVENFAC + 72, obj->bahn.y / KURVENFAC, 2, 19);
				break;
			case 52:
				// Endgegner - Schiff - streuende Kanone oben
				if(!endgegner4_rakwerfer_da())
				{
					r = main_counter % 8;
					sinus = sintab[(r) * 45];
					cosinus = sintab[(r) * 45 + 90];
					x = ((sinus * 30) >> SINFAC) + obj->bahn.x / KURVENFAC;
					y = -((cosinus * 30) >> SINFAC) + obj->bahn.y / KURVENFAC;
					neuer_schuss(x, y, r, 10);
				}
				break;
			case 53:
				// Schiffsraketenwerfer
				neuer_schuss(obj->bahn.x / KURVENFAC - 80, obj->bahn.y / KURVENFAC, 6, 15);
				break;
			case 54:
				// erster Endgegner
				neuer_schuss(obj->bahn.x / KURVENFAC - 100, obj->bahn.y / KURVENFAC, 0, 14);
				break;
			case 55:
				// dritter Endgegner
				if(rand() % 2 == 0)
				{
					neuer_schuss(obj->bahn.x / KURVENFAC - 12, obj->bahn.y / KURVENFAC - 55, 7, 4);
					neuer_schuss(obj->bahn.x / KURVENFAC - 18, obj->bahn.y / KURVENFAC - 50, 7, 4);
					neuer_schuss(obj->bahn.x / KURVENFAC - 24, obj->bahn.y / KURVENFAC - 45, 7, 4);
					neuer_schuss(obj->bahn.x / KURVENFAC - 24, obj->bahn.y / KURVENFAC + 45, 5, 4);
					neuer_schuss(obj->bahn.x / KURVENFAC - 18, obj->bahn.y / KURVENFAC + 50, 5, 4);
					neuer_schuss(obj->bahn.x / KURVENFAC - 12, obj->bahn.y / KURVENFAC + 55, 5, 4);
					neuer_schuss(obj->bahn.x / KURVENFAC + 60, obj->bahn.y / KURVENFAC - 8, 2, 4);
					neuer_schuss(obj->bahn.x / KURVENFAC + 60, obj->bahn.y / KURVENFAC - 2, 2, 4);
					neuer_schuss(obj->bahn.x / KURVENFAC + 60, obj->bahn.y / KURVENFAC + 4, 2, 4);
				}
				else
					neuer_schuss(obj->bahn.x / KURVENFAC - 16, obj->bahn.y / KURVENFAC, 2, 20);
				break;
			case 56:
				// 5. Endgegner - Riesenschiff mit Kanonen
				// vorne
				neuer_schuss(obj->bahn.x / KURVENFAC + 132, obj->bahn.y / KURVENFAC - 4, 2, 10);
				neuer_schuss(obj->bahn.x / KURVENFAC + 132, obj->bahn.y / KURVENFAC + 4, 2, 10);
				// Seite oben
				neuer_schuss(obj->bahn.x / KURVENFAC - 12, obj->bahn.y / KURVENFAC - 46, 0, 10);
				neuer_schuss(obj->bahn.x / KURVENFAC - 4, obj->bahn.y / KURVENFAC - 46, 0, 10);
				// Seite unten
				neuer_schuss(obj->bahn.x / KURVENFAC - 12, obj->bahn.y / KURVENFAC + 46, 4, 10);
				neuer_schuss(obj->bahn.x / KURVENFAC - 4, obj->bahn.y / KURVENFAC + 46, 4, 10);
				// hinten oben
				neuer_schuss(obj->bahn.x / KURVENFAC - 116, obj->bahn.y / KURVENFAC - 36, 7, 10);
				neuer_schuss(obj->bahn.x / KURVENFAC - 108, obj->bahn.y / KURVENFAC - 40, 7, 10);
				// hinten unten
				neuer_schuss(obj->bahn.x / KURVENFAC - 116, obj->bahn.y / KURVENFAC + 36, 5, 10);
				neuer_schuss(obj->bahn.x / KURVENFAC - 108, obj->bahn.y / KURVENFAC + 40, 5, 10);
				break;
			case 57:
				// Endgegner 6 - Panzerstation mit Kugeln und Lasern
				neuer_schuss(obj->bahn.x / KURVENFAC + 32, obj->bahn.y / KURVENFAC, 2, 20);
				neuer_schuss(obj->bahn.x / KURVENFAC - 60, obj->bahn.y / KURVENFAC - 76, 6, 24);
				neuer_schuss(obj->bahn.x / KURVENFAC - 60, obj->bahn.y / KURVENFAC + 76, 6, 24);
				break;
			case 58:
				// Endgegner 7 - Station mit Greifern und Minen
				neuer_schuss(obj->bahn.x / KURVENFAC + 4, obj->bahn.y / KURVENFAC - 20, 7, 25);
				neuer_schuss(obj->bahn.x / KURVENFAC + 4, obj->bahn.y / KURVENFAC + 20, 5, 25);
				// eventuell Raketen schiessen
				if(spieler.x < 50)
					neuer_schuss(obj->bahn.x /KURVENFAC, obj->bahn.y / KURVENFAC, 6, 9);
				break;
			case 59:
				// Endgegner 6 - Drohne
				neuer_schuss(obj->bahn.x / KURVENFAC, obj->bahn.y / KURVENFAC, 2, 20);
				break;
			case 60:
				// suchende Flammen bei Endgegner 9
				x = rand() % 10;
				for(r = 0; r < x; r++)
					neuer_schuss(obj->bahn.x / KURVENFAC + (rand() % 40) - 20, obj->bahn.y / KURVENFAC + (rand() % 40) - 20, 6, 27);
				break;
			case 62:
				// Drehgeschtz beim Endgegner
				r = ziel_richtung(&obj->bahn);
				// WARUM?????? (8 - r)
				sinus = sintab[(8 - r) * 45];
				cosinus = sintab[(8 - r) * 45 + 90];
				x =  ((sinus * (-40)) >> SINFAC) + obj->bahn.x / KURVENFAC;
				y =  ((cosinus * (-40)) >> SINFAC) + obj->bahn.y / KURVENFAC;
				neuer_schuss(x, y, r, 10);
				break;
		}
		obj->weapon_ok = obj->weapon_fire;
	}
}
