/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/***********************************/
/* ballerspiel-platformroutinen */
/* (C) May 1996 by Ulrich Haar  */
/***********************************/

/* nderungen: */

#include <stdlib.h>
#include <string.h>

#include <dn.h>
#include "DEFS.H"
#include "FUNCS.H"
#include "VARS.H"

#define ANZ_PLATTFORMPICS 3
#define ANZ_PLATFORMANIS 20
#define PLATFANIFAC 5

typedef struct
{
	int start;
	int len;
} PLATFANI;

/* globale Variablen */
GFXBLK platfpix[ANZ_PLATTFORMPICS * 8 * 5];
GFXBLK platfanipix[ANZ_PLATFORMANIS * 5];
int platform[MAX_PLATFORMBREITE][5];
int max_platform;
int platformanicnt;
PLATFANI platformani[ANZ_PLATTFORMPICS * 8 * 5];

/* funktionsprototypen */
BOOLEAN init_platforms(int level);
void plattformen();
void show_platforms();
void edit_platforms();

/* funktionen */
BOOLEAN init_platforms(int level)
{
	int i, cnt1, cnt2;

	// Erstmal alle loeschen - fuer neues Level
	for(i = 0; i < 200; i++)
		for(cnt1 = 0; cnt1 < 5; cnt1++)
			platform[i][cnt1] = 0;

	platformanicnt = 0;
	if(level == 0)
	{
		// Zufallssteine fr unterste Ebene
		if(!load_pic("STEINE.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(6, 3, 63, 50, &objpix[PLATTFORMPICS + 0]);
		get(74, 5, 126, 48, &objpix[PLATTFORMPICS + 1]);
		get(19, 52, 56, 92, &objpix[PLATTFORMPICS + 2]);
		get(81, 58, 112, 80, &objpix[PLATTFORMPICS + 3]);
		// weiter mit 4

		for(i = 0; i < ANZ_PLATTFORMPICS * 8 * 5;i++)
		{
			platformani[i].start = -1;
			platformani[i].len = -1;
		}
		platformani[47].start = 0;
		platformani[47].len = 5;
		platformani[16].start = 4;
		platformani[16].len = 3;
		platformani[17].start = 6;
		platformani[17].len = 3;
		platformani[18].start = 8;
		platformani[18].len = 3;
		platformani[67].start = 10;
		platformani[67].len = 3;
		platformani[68].start = 12;
		platformani[68].len = 3;
		platformani[69].start = 14;
		platformani[69].len = 3;
		platformani[70].start = 16;
		platformani[70].len = 3;
		platformani[71].start = 18;
		platformani[71].len = 3;
		platformani[72].start = 20;
		platformani[72].len = 3;
		platformani[73].start = 22;
		platformani[73].len = 3;
		platformani[74].start = 24;
		platformani[74].len = 3;
		platformani[75].start = 26;
		platformani[75].len = 3;
	
		for(i = 0; i < ANZ_PLATTFORMPICS; i++)
		{
			strcpy(txt, "PLATFOR");
			itoa(i + 1, str, 10);
			strcat(txt, str);
			strcat(txt, ".PIX");
			load_pic(txt, screen_addr, alt_rgb);
			max_platform = 8;
			for(cnt1 = 0; cnt1 < 8; cnt1++)
				for(cnt2 = 0; cnt2 < 5; cnt2++)
					get(cnt1 * 40, cnt2 * 40, cnt1 * 40 + 39, cnt2 * 40  + 39, &platfpix[cnt1 + cnt2 * 8 + i * 8 * 5]);
		}
	
		load_pic("plafani1.pix" , screen_addr, alt_rgb);
	
		for(cnt1 = 0; cnt1 < 8; cnt1++)
			for(cnt2 = 0; cnt2 < 4; cnt2++)
				get(cnt1 * 40, cnt2 * 40, cnt1 * 40 + 39, cnt2 * 40  + 39, &platfanipix[cnt1 + cnt2 * 8 ]);
	}

	return(TRUE);
}

void plattformen()
{
	int i;

	if(game_view == FULL)
	{
		// Neue Zufallssteine erzeugen
		if(rand() % 50 == 0)
		{
			i = 0;
			while((i < MAX_OBJEKTE) && objekt[i].nr)
				i++;
			if(i < MAX_OBJEKTE)
			{
				if(game_difficulty == TRAINING)
					objekt[i].nr = GEGNERPICS + 218 + rand() % 6;
				else
					objekt[i].nr = PLATTFORMPICS + rand() % 4;
				objekt[i].art = 1;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 400 * SPEED_FAC;
				objekt[i].bahn.x = (340 + rand() % 50) * KURVENFAC;
				objekt[i].bahn.y = (-20 + rand() % 240) * KURVENFAC;
				objekt[i].bahn.kurve[0].xpl = -(rand() % 2 + 1) * SPEED_FAC * KURVENFAC * KURVENFAC;
				objekt[i].bahn.kurve[0].ypl = 0;
				objekt[i].bahn.kurve[0].xxpl = 0;
				objekt[i].bahn.kurve[0].yypl = 0;
				objekt[i].extra_listnr = -1;
			}
		}
	
		// Ebene anzeigen
		for(i = 0; i < MAX_OBJEKTE; i++)
			if(objekt[i].nr && (objekt[i].art == 1))
			{
				if (do_draw)
				  {
				    show_objekt(&objekt[i]);
				  }
				standardsteuern(&objekt[i]);
				objekt[i].bahn.x -= MITTE_SCROLLGESCHW;
			}
	}

	// 'richtige' Plattformebene
	if( (game_view == FULL) || (game_view == HIGH) ||
	  (game_view == MEDIUM) )
		show_platforms();
}

void show_platforms()
{
	int cnt1,cnt2,x;

	platformanicnt++;
	if (platformanicnt >= 40320 * PLATFANIFAC)
		platformanicnt = 0;

	if((endmonster.art_da == 52) || (endmonster.art_da == 56) || (endmonster.art_da == 59))
	{
		// nix mehr scrollen, da Meer!
		x = -((game_scrollpos % 40 + endmonster.start_x) * 1) % 40;
		cnt1 = ((game_scrollpos % 40 + endmonster.start_x) * 1) / 40;
	}
	else if((endmonster.art_da == 57) || (endmonster.art_da == 60))
	{
		// garnix mehr scrollen, da Endgegnerteil!
		x = -endmonster.start_x % 40;
		cnt1 = endmonster.start_x / 40;
	}
	else
	{
		x = -(game_scrollpos * 1) % 40;
		cnt1 = (game_scrollpos * 1) / 40;
	}
	// Ende noch nicht erreicht?
	if(cnt1 < MAX_PLATFORMBREITE - screen_width / 40)
	{
		while(x < 320)
		{
			for(cnt2 = 0; cnt2 < 5; cnt2++)
			{
				if(platform[cnt1][cnt2] > 0)
				{
				    if (do_draw)
				      {
					if (platformani[platform[cnt1][cnt2] - 1].start == -1)
						objput( x, cnt2 * 40, &platfpix[platform[cnt1][cnt2] - 1]);
					else
					{
						if((platformanicnt / PLATFANIFAC) % platformani[platform[cnt1][cnt2] - 1].len == 0)
							objput(x, cnt2 * 40, &platfpix[platform[cnt1][cnt2] - 1]);
						else
							objput(x, cnt2 * 40, &platfanipix[platformani[platform[cnt1][cnt2] - 1].start + (platformanicnt / PLATFANIFAC) % platformani[platform[cnt1][cnt2] - 1].len - 1]);
					}
				      } /* if (do_draw) */
				}
			}
			x += 40;
			cnt1++;
		}
	}
}
void edit_platforms()
{
	int cx,cy,fnum;

	cx = game_scrollpos / 40;
	cy = 0;
	fnum = 1;
	while(!keyTest(KEY_ESC))
	{
		if((keyTest(KEY_LEFT)) && (cx > 0))
		{
			cx--;
			if(cx < game_scrollpos / 40)
				game_scrollpos -= 40;
			delay(100);
		}
		else if (keyTest(KEY_RIGHT))
		{
			if(cx < MAX_PLATFORMBREITE)
			{
				cx++;
				if(cx >= game_scrollpos / 40 + screen_width / 40)
				{
					game_scrollpos += 40;
					if( cx >= max_platform )
						max_platform = cx + 1;
				}
			}
			delay(100);
		}
		if ((keyTest(KEY_UP)) && (cy > 0))
		{
			cy--;
			delay(100);
		}
		else if (keyTest(KEY_DOWN) && (cy < 4))
		{
			cy++;
			delay(100);
		}
		else if((keyTest(KEY_RALT) || keyTest(KEY_PADMINUS) || keyTest(KEY_MINUS)) && (fnum > 0))
		{
			fnum--;
			delay(100);
		}
		else if ((keyTest(KEY_RCTRL) || keyTest(KEY_PADPLUS) || keyTest(KEY_PLUS)) && (fnum < ANZ_PLATTFORMPICS * 5 * 8 - 1))
		{
			fnum++;
			delay(100);
		}
		else if (keyTest(KEY_SPACE))
		{
			platform[cx][cy] = fnum;
			delay(100);
		}
		else if(keyTest(KEY_ENTER))
		{
			fnum = platform[cx][cy];
			delay(100);
		}

		hintergrund();
		show_platforms();

		if (fnum > 0)
			objput(( cx * 40 - game_scrollpos ), cy * 40, &platfpix[fnum - 1]);
		box((cx * 40 - game_scrollpos), cy * 40,(cx * 40 - game_scrollpos) + 39, cy * 40 +39, 31, FALSE, FALSE);

		Copy2Screen();
	}
   delay(150);
}
