/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*****************************************/
/* ballerspiel-Objektroutinen            */
/* (C) April 1996 by Michael/Ulrich Haar */
/*****************************************/

/* nderungen: */

#include <stdlib.h>
#include <string.h>
#include <dn.h>
#include "DEFS.H"
#include "FUNCS.H"
#include "VARS.H"

/* globale Variablen */
OBJEKT objekt[MAX_OBJEKTE];
GFXBLK objpix[ANZ_OBJPICS];

/* Funktionsprototypen */
BOOLEAN init_objekte(unsigned char level);
void show_attack();
void neue_objekte();
void objekte();
void show_objekt(OBJEKT *obj);
void delete_objekt(OBJEKT *obj);
void wolken();
void kill_all_objects();
BOOLEAN alle_tot(OBJEKT *obj);
void meteore();
void alles_sprengen(int x, int y, int radius);

/* Funktionen */
BOOLEAN init_objekte(unsigned char level)
{
	int i;

	for(i = 0; i < MAX_OBJEKTE; i++)
		objekt[i].nr = 0;

	if(level < 3)
	{
		// Meteore
		if(!load_pic("METEOR.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(187, 14, 295, 101, &objpix[WOLKEPICS + 0]);
		get(2, 1, 169, 104, &objpix[WOLKEPICS + 1]);
	}
	else
	{
		// Wolken
		if(!load_pic("WOLKE1.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(0, 0, 131, 79, &objpix[WOLKEPICS + 0]);
		if(!load_pic("WOLKE2.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(0, 0, 202, 174, &objpix[WOLKEPICS + 1]);
	}

	if(level == 0)
	{
		// Schsse
		if(!load_pic("SCHUESSE.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(0, 0, 21, 17, &objpix[SCHUSSPICS]);

		if(!load_pic("NEWSHOT.PIX", screen_addr, alt_rgb))
			return(FALSE);
		// Gegnerrckschuss
		get(12, 8, 35, 24, &objpix[GEGNERPICS + 242]);
		// Powerbeam
		get(196, 16, 231, 29, &objpix[SCHUSSPICS + 1]);
		get(185, 55, 249, 73, &objpix[SCHUSSPICS + 2]);
		get(172, 98, 256, 126, &objpix[SCHUSSPICS + 3]);
		get(165, 152, 264, 182, &objpix[SCHUSSPICS + 4]);

		if(!load_pic("SCHUESSE.PIX", screen_addr, alt_rgb))
			return(FALSE);
/*		get(23, 74, 56, 80, &objpix[SCHUSSPICS + 1]);
		get(15, 87, 59, 95, &objpix[SCHUSSPICS + 2]);
		get(11, 102, 61, 113, &objpix[SCHUSSPICS + 3]);
		get(1, 120, 64, 136, &objpix[SCHUSSPICS + 4]); */
		// Kanone
		get(3, 141, 53, 156, &objpix[SCHUSSPICS + 5]);
		// Laser
		get(13, 178, 51, 190, &objpix[SCHUSSPICS + 6]);
		get(6, 161, 58, 174, &objpix[SCHUSSPICS + 7]);
		get(67, 159, 125, 175, &objpix[SCHUSSPICS + 8]);
		// Rakete
		get(1, 21, 38, 53, &objpix[SCHUSSPICS + 9]);
		get(41, 21, 78, 53, &objpix[SCHUSSPICS + 10]);
		get(81, 21, 118, 53, &objpix[SCHUSSPICS + 11]);
		get(121, 21, 158, 53, &objpix[SCHUSSPICS + 12]);
		get(161, 21, 198, 53, &objpix[SCHUSSPICS + 13]);
		get(201, 21, 238, 53, &objpix[SCHUSSPICS + 14]);
		get(241, 21, 278, 53, &objpix[SCHUSSPICS + 15]);
		get(281, 21, 318, 53, &objpix[SCHUSSPICS + 16]);
		if(!load_pic("SCHUSS.PIX", screen_addr, alt_rgb))
			return(FALSE);
		// Rotschuss
		get(0, 1, 32, 30, &objpix[SCHUSSPICS + 17]);
		get(0, 33, 32, 62, &objpix[SCHUSSPICS + 18]);
		get(137, 123, 159, 158, &objpix[SCHUSSPICS + 19]);
		get(132, 47, 164, 76, &objpix[SCHUSSPICS + 20]);
		get(132, 79, 164, 108, &objpix[SCHUSSPICS + 21]);
		// Mine
		get(85, 6, 115, 32, &objpix[SCHUSSPICS + 27]);	// Achtung  - WOLKEPICS!!!!!!!!!!
		get(121, 6, 151, 32, &objpix[SCHUSSPICS + 28]);
		get(157, 7, 187, 32, &objpix[SCHUSSPICS + 29]);

		// Gegner kipp/komet/orca
		if(!load_pic("GEG_1_1.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(0, 0, 61, 41, &objpix[GEGNERPICS]);
		get(0, 42, 61, 42 + 47, &objpix[GEGNERPICS + 1]);
		get(0, 90, 61, 90 + 41, &objpix[GEGNERPICS + 2]);
		get(62, 0, 62 + 71, 35, &objpix[GEGNERPICS + 3]);
		get(62, 36, 147, 88, &objpix[GEGNERPICS + 22]);
		// Drehgeschtz
		get(78, 97, 125, 139, &objpix[GEGNERPICS + 23]);
		get(128, 97, 175, 139, &objpix[GEGNERPICS + 24]);
		get(178, 97, 225, 139, &objpix[GEGNERPICS + 25]);
		get(228, 97, 275, 139, &objpix[GEGNERPICS + 26]);
		get(78, 142, 125, 184, &objpix[GEGNERPICS + 27]);
		get(128, 142, 175, 184, &objpix[GEGNERPICS + 28]);
		get(178, 142, 225, 184, &objpix[GEGNERPICS + 29]);
		get(228, 142, 275, 184, &objpix[GEGNERPICS + 30]);
		// GrosserSchuss
		get(158, 8, 169, 44, &objpix[GEGNERPICS + 31]);
		get(172, 9, 198, 36, &objpix[GEGNERPICS + 32]);
		get(201, 16, 237, 27, &objpix[GEGNERPICS + 33]);
		get(242, 13, 268, 40, &objpix[GEGNERPICS + 34]);
		get(159, 51, 170, 87, &objpix[GEGNERPICS + 35]);
		get(177, 50, 203, 77, &objpix[GEGNERPICS + 36]);
		get(215, 59, 251, 70, &objpix[GEGNERPICS + 37]);
		get(264, 55, 290, 82, &objpix[GEGNERPICS + 38]);
		// kleiner Kugelschuss
		get(16, 147, 21, 152, &objpix[GEGNERPICS + 181]);
		// kleiner Kippgegner in andere Richtung
		get(277, 15, 309, 40, &objpix[GEGNERPICS + 193]);
		// kleiner Richtungsflammschuss
		get(29, 144, 36, 152, &objpix[GEGNERPICS + 203]);
		get(55, 145, 65, 154, &objpix[GEGNERPICS + 204]);
		get(41, 173, 49, 180, &objpix[GEGNERPICS + 205]);
		get(42, 157, 52, 166, &objpix[GEGNERPICS + 206]);
		get(29, 157, 36, 165, &objpix[GEGNERPICS + 207]);
		get(56, 158, 66, 167, &objpix[GEGNERPICS + 208]);
		get(26, 173, 34, 180, &objpix[GEGNERPICS + 209]);
		get(40, 144, 50, 153, &objpix[GEGNERPICS + 210]);
		// flacher Scheibenschuss
		get(8, 158, 24, 172, &objpix[GEGNERPICS + 241]);

		// Gegner Gross/klein
		if(!load_pic("GEG_1_2.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(160, 0, 240, 85, &objpix[GEGNERPICS + 5]);
		// Flammgegnerschuss
		get(169, 96, 257, 104, &objpix[GEGNERPICS + 182]);
		get(166, 111, 236, 138, &objpix[GEGNERPICS + 183]);
		get(166, 141, 234, 171, &objpix[GEGNERPICS + 184]);
		get(255, 8, 308, 40, &objpix[GEGNERPICS + 185]);
		get(258, 39, 289, 60, &objpix[GEGNERPICS + 186]);
		get(260, 66, 282, 83, &objpix[GEGNERPICS + 187]);		

		// Gegner drehbar/schiessend
		if(!load_pic("GEG_1_3.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(2, 4, 73, 39, &objpix[GEGNERPICS + 6]);
		get(78, 0, 146, 56, &objpix[GEGNERPICS + 7]);
		get(154, 0, 199, 58, &objpix[GEGNERPICS + 8]);
		get(202, 0, 269, 58, &objpix[GEGNERPICS + 9]);
		get(5, 79, 77, 115, &objpix[GEGNERPICS + 10]);
		get(86, 69, 153, 125, &objpix[GEGNERPICS + 11]);
		get(169, 71, 213, 129, &objpix[GEGNERPICS + 12]);
		get(231, 78, 299, 134, &objpix[GEGNERPICS + 13]);
		// Schuss dazu
		get(8, 138, 10, 150, &objpix[GEGNERPICS + 14]);
		get(18, 139, 27, 148, &objpix[GEGNERPICS + 15]);
		get(34, 148, 48, 149, &objpix[GEGNERPICS + 16]);
		get(58, 139, 67, 148, &objpix[GEGNERPICS + 17]);
		get(74, 139, 76, 150, &objpix[GEGNERPICS + 18]);
		get(83, 139, 92, 148, &objpix[GEGNERPICS + 19]);
		get(105, 143, 120, 145, &objpix[GEGNERPICS + 20]);
		get(126, 141, 135, 150, &objpix[GEGNERPICS + 21]);
		// Rakete
		get(1, 157, 38, 189, &objpix[GEGNERPICS + 64]);
		get(41, 157, 78, 189, &objpix[GEGNERPICS + 65]);
		get(81, 157, 118, 189, &objpix[GEGNERPICS + 66]);
		get(121, 157, 158, 189, &objpix[GEGNERPICS + 67]);
		get(161, 157, 198, 189, &objpix[GEGNERPICS + 68]);
		get(201, 157, 238, 189, &objpix[GEGNERPICS + 69]);
		get(241, 157, 278, 189, &objpix[GEGNERPICS + 70]);
		get(281, 157, 318, 189, &objpix[GEGNERPICS + 71]);
		// Drehflieger
		if(!load_pic("GEG_1_5.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(6, 17, 54, 57, &objpix[GEGNERPICS + 54]);
		get(61, 20, 106, 58, &objpix[GEGNERPICS + 55]);
		get(117, 16, 165, 56, &objpix[GEGNERPICS + 56]);
		get(176, 16, 221, 54, &objpix[GEGNERPICS + 57]);
		get(7, 74, 55, 114, &objpix[GEGNERPICS + 58]);
		get(70, 71, 115, 109, &objpix[GEGNERPICS + 59]);
		get(120, 70, 169, 110, &objpix[GEGNERPICS + 60]);
		get(182, 72, 227, 109, &objpix[GEGNERPICS + 61]);
		// Dornen
		get(232, 13, 271, 141, &objpix[GEGNERPICS + 62]);
		get(277, 61, 316, 189, &objpix[GEGNERPICS + 63]);
		// Raketenstellung
		if(!load_pic("GEG_1_6.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(1, 1, 57, 46, &objpix[GEGNERPICS + 39]);
		get(60, 1, 116, 46, &objpix[GEGNERPICS + 40]);
		get(119, 1, 175, 46, &objpix[GEGNERPICS + 41]);
		get(178, 1, 234, 46, &objpix[GEGNERPICS + 42]);
		get(237, 1, 293, 46, &objpix[GEGNERPICS + 43]);
		get(1, 49, 57, 94, &objpix[GEGNERPICS + 44]);
		get(60, 49, 116, 94, &objpix[GEGNERPICS + 45]);
		get(119, 49, 175, 94, &objpix[GEGNERPICS + 46]);
		get(1, 97, 57, 142, &objpix[GEGNERPICS + 47]);
		get(60, 97, 116, 142, &objpix[GEGNERPICS + 48]);
		get(119, 97, 175, 142, &objpix[GEGNERPICS + 49]);
		// Ufos
		if(!load_pic("GEG_1_7.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(97, 5, 149, 49, &objpix[GEGNERPICS + 50]);
		get(166, 7, 218, 51, &objpix[GEGNERPICS + 51]);
		get(236, 7, 288, 51, &objpix[GEGNERPICS + 52]);
		get(96, 57, 148, 101, &objpix[GEGNERPICS + 53]);
		get(23, 71, 52, 95, &objpix[GEGNERPICS + 192]); // verkleinertes UFO
		// Dreh-X-Wings
		if(!load_pic("GEG_1_8.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(8, 9, 41, 45, &objpix[GEGNERPICS + 72]);
		get(48, 12, 80, 42, &objpix[GEGNERPICS + 73]);
		get(92, 11, 125, 43, &objpix[GEGNERPICS + 74]);
		// Hochfahrkanonenstellung
		get(5, 156, 47, 197, &objpix[GEGNERPICS + 75]);
		get(53, 156, 95, 197, &objpix[GEGNERPICS + 76]);
		get(101, 156, 143, 197, &objpix[GEGNERPICS + 77]);
		get(149, 156, 191, 197, &objpix[GEGNERPICS + 78]);
		get(194, 156, 241, 197, &objpix[GEGNERPICS + 79]);
		get(243, 156, 297, 197, &objpix[GEGNERPICS + 80]);
		get(11, 108, 64, 149, &objpix[GEGNERPICS + 81]);
		get(65, 108, 123, 149, &objpix[GEGNERPICS + 82]);
		if(!load_pic("RKAN.PIX", screen_addr, alt_rgb))
			return(FALSE);
		// streukanone
		get(0, 0, 66, 54, &objpix[GEGNERPICS + 90]);
		get(67, 0, 133, 54, &objpix[GEGNERPICS + 83]);
		get(134, 0, 200, 54, &objpix[GEGNERPICS + 84]);
		get(201, 0, 267, 54, &objpix[GEGNERPICS + 85]);
		get(0, 55, 66, 109, &objpix[GEGNERPICS + 86]);
		get(67, 55, 133, 109, &objpix[GEGNERPICS + 87]);
		get(134, 55, 200, 109, &objpix[GEGNERPICS + 88]);
		get(201, 55, 267, 109, &objpix[GEGNERPICS + 89]);

		// panzer hoch
		if(!load_pic("PANZER1.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(0, 0, 44, 71, &objpix[GEGNERPICS + 91]);
		get(45, 0, 130, 71, &objpix[GEGNERPICS + 92]);
		get(131, 0, 216, 71, &objpix[GEGNERPICS + 93]);
		get(217, 0, 302, 71, &objpix[GEGNERPICS + 94]);
		get(0, 72, 44, 143, &objpix[GEGNERPICS + 95]);
		get(45, 72, 130, 143, &objpix[GEGNERPICS + 96]);
		get(131, 72, 216, 143, &objpix[GEGNERPICS + 97]);
		get(217, 72, 302, 143, &objpix[GEGNERPICS + 98]);

		if(!load_pic("FAHRZ1.PIX", screen_addr, alt_rgb))
			return(FALSE);
		// vehicle 1 
		get(2, 8, 39, 45, &objpix[GEGNERPICS + 99]);
		get(53, 4, 104, 47, &objpix[GEGNERPICS + 100]);
		get(123, 11, 167, 43, &objpix[GEGNERPICS + 101]);
		get(177, 8, 227, 50, &objpix[GEGNERPICS + 102]);
		get(238, 9, 274, 46, &objpix[GEGNERPICS + 103]);
		get(6, 56, 54, 98, &objpix[GEGNERPICS + 104]);
		get(69, 60, 113, 90, &objpix[GEGNERPICS + 105]);
		get(125, 52, 175, 93, &objpix[GEGNERPICS + 106]);
		//mine
		get(0, 104, 40, 138, &objpix[GEGNERPICS + 107]);
		get(41, 104, 81, 138, &objpix[GEGNERPICS + 108]);
		get(82, 104, 122, 138, &objpix[GEGNERPICS + 109]);
		get(123, 104, 163, 138, &objpix[GEGNERPICS + 110]);
		get(164, 104, 204, 138, &objpix[GEGNERPICS + 111]);
		// Drehflieger 2
		get(24, 162, 60, 196, &objpix[GEGNERPICS + 211]);
		get(68, 163, 104, 194, &objpix[GEGNERPICS + 212]);
		get(112, 168, 148, 190, &objpix[GEGNERPICS + 213]);
		get(160, 164, 196, 195, &objpix[GEGNERPICS + 215]);
		get(204, 169, 240, 189, &objpix[GEGNERPICS + 214]);

		//panzer links
		if(!load_pic("PANZER2.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(0, 0, 85, 71, &objpix[GEGNERPICS + 112]);
		get(86, 0, 172, 71, &objpix[GEGNERPICS + 113]);
		get(172, 0, 257, 34, &objpix[GEGNERPICS + 114]);
		get(172, 35, 257, 106, &objpix[GEGNERPICS + 115]);
		get(0, 72, 85, 143, &objpix[GEGNERPICS + 116]);
		get(86, 72, 171, 143, &objpix[GEGNERPICS + 117]);
		get(0, 144, 85, 178, &objpix[GEGNERPICS + 118]);
		get(172, 107, 257, 178, &objpix[GEGNERPICS + 119]);

		//bodenstecher
		if(!load_pic("FELS.PIX", screen_addr, alt_rgb))
			return(FALSE);
		for(i = 0;i < 7;i++)
			get(i * 40, 160, (i + 1) * 40 - 1, 199, &objpix[GEGNERPICS + 120 + i]);
		get(6 * 40, 160, (6 + 1) * 40 - 1, 199, &objpix[GEGNERPICS + 120 + 7]);
		// Drehfelsenklops
		get(9, 11, 47, 43, &objpix[GEGNERPICS + 194]);
		get(52, 11, 92, 43, &objpix[GEGNERPICS + 195]);
		get(101, 11, 139, 43, &objpix[GEGNERPICS + 196]);
		// Felsengreifzacken
		get(159, 13, 207, 105, &objpix[GEGNERPICS + 197]);
		get(244, 21, 294, 114, &objpix[GEGNERPICS + 198]);
		// kleines Wurmteil fuer unterplattform
		get(15, 68, 29, 80, &objpix[GEGNERPICS + 216]);

		//grosse fliege
		if(!load_pic("FLY.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(4, 3, 84, 99, &objpix[GEGNERPICS + 128]);
		get(92, 5, 172, 98, &objpix[GEGNERPICS + 129]);
		get(180, 5, 260, 97, &objpix[GEGNERPICS + 130]);
		get(236, 98, 317, 194, &objpix[GEGNERPICS + 131]);

		// little fly
		if(!load_pic("FLY2.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(32, 15, 81, 42, &objpix[GEGNERPICS + 132]);
		get(101, 17, 146, 54, &objpix[GEGNERPICS + 133]);
		get(162, 14, 195, 56, &objpix[GEGNERPICS + 134]);
		get(205, 24, 250, 62, &objpix[GEGNERPICS + 135]);
		get(10, 76, 62, 104, &objpix[GEGNERPICS + 136]);
		get(82, 80, 127, 117, &objpix[GEGNERPICS + 137]);
		get(145, 78, 178, 119, &objpix[GEGNERPICS + 138]);
		get(190, 80, 235, 118, &objpix[GEGNERPICS + 139]);
		// klein fuer Unterlayer
		get(27, 146, 55, 168, &objpix[GEGNERPICS + 199]);
		get(65, 142, 95, 175, &objpix[GEGNERPICS + 200]);
		get(104, 145, 148, 177, &objpix[GEGNERPICS + 201]);

		//grosser brummer
		if(!load_pic("GEGNERX.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(191, 31, 257, 71, &objpix[GEGNERPICS + 140]);
		get(31, 19, 96, 67, &objpix[GEGNERPICS + 141]);
		get(115, 23, 180, 62, &objpix[GEGNERPICS + 142]);
		//kleiner nurfluegler
		get(100, 89, 117, 126, &objpix[GEGNERPICS + 143]);
		get(31, 83, 50, 131, &objpix[GEGNERPICS + 144]);
		get(67, 88, 85, 125, &objpix[GEGNERPICS + 145]);
		// kette
		get(143, 96, 177, 124, &objpix[GEGNERPICS + 188]);
		get(191, 99, 217, 121, &objpix[GEGNERPICS + 189]);
		get(227, 99, 253, 121, &objpix[GEGNERPICS + 190]);
		// kleiner brummer fuer Unterebene
		get(24, 152, 73, 181, &objpix[GEGNERPICS + 202]);

		if(!load_pic("MINEL.PIX", screen_addr, alt_rgb))
			return(FALSE);
		//minelayer
		get(2, 9, 30, 66, &objpix[GEGNERPICS + 146]);
		get(48, 25, 105, 73, &objpix[GEGNERPICS + 147]);
		get(113, 31, 183, 55, &objpix[GEGNERPICS + 148]);
		get(192, 13, 251, 62, &objpix[GEGNERPICS + 149]);
		get(270, 12, 299, 69, &objpix[GEGNERPICS + 150]);
		get(7, 85, 64, 133, &objpix[GEGNERPICS + 151]);
		get(90, 87, 159, 111, &objpix[GEGNERPICS + 152]);
		get(170, 73, 229, 122, &objpix[GEGNERPICS + 153]);
	
		//little mine
		get(8, 156, 24, 170, &objpix[GEGNERPICS + 154]);
		get(30, 156, 46, 170, &objpix[GEGNERPICS + 155]);
		get(52, 156, 68, 170, &objpix[GEGNERPICS + 156]);

		if(!load_pic("SCHUSS.PIX", screen_addr, alt_rgb))
			return(FALSE);
		//schrott
		get(12, 77, 26, 93, &objpix[GEGNERPICS + 157]);
		get(37, 80, 53, 94, &objpix[GEGNERPICS + 158]);
		get(61, 80, 75, 96, &objpix[GEGNERPICS + 159]);
		get(83, 83, 99, 97, &objpix[GEGNERPICS + 160]);

		get(2, 109, 23, 123, &objpix[GEGNERPICS + 161]);
		get(35, 108, 49, 130, &objpix[GEGNERPICS + 162]);
		get(61, 114, 83, 129, &objpix[GEGNERPICS + 163]);
		get(97, 109, 112, 131, &objpix[GEGNERPICS + 164]);

		get(8, 147, 20, 161, &objpix[GEGNERPICS + 165]);
		get(27, 148, 41, 160, &objpix[GEGNERPICS + 166]);
		get(51, 149, 63, 163, &objpix[GEGNERPICS + 167]);
		get(75, 150, 89, 162, &objpix[GEGNERPICS + 168]);

		get(5, 177, 20, 190, &objpix[GEGNERPICS + 169]);
		get(27, 175, 41, 190, &objpix[GEGNERPICS + 170]);
		get(50, 174, 65, 188, &objpix[GEGNERPICS + 171]);
		get(72, 176, 84, 191, &objpix[GEGNERPICS + 172]);

		// allererster Drehgegner
		if(!load_pic("GEG_1_4.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(70, 7, 110, 46, &objpix[GEGNERPICS + 173]);
		get(87, 59, 134, 99, &objpix[GEGNERPICS + 174]);
		get(134, 13, 182, 47, &objpix[GEGNERPICS + 175]);
		get(200, 17, 247, 57, &objpix[GEGNERPICS + 176]);
		get(23, 98, 63, 137, &objpix[GEGNERPICS + 177]);
		get(126, 106, 173, 144, &objpix[GEGNERPICS + 178]);
		get(148, 58, 195, 92, &objpix[GEGNERPICS + 179]);
		get(8, 41, 55, 80, &objpix[GEGNERPICS + 180]);
		// zweiter Plattformendgegner
		if(!load_pic("ENDGEGN2.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(82, 44, 204, 145, &objpix[GEGNERPICS + 191]);

		// 3. Endgegner
		if(!load_pic("ENDGEGN3.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(5, 2, 143, 100, &objpix[GEGNERPICS + 217]);
		// Kanone dazu
		get(179, 10, 217, 29, &objpix[GEGNERPICS + 239]);

		// Meteore
		if(!load_pic("KOMETEN.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(12, 15, 39, 31, &objpix[GEGNERPICS + 218]);
		get(52, 16, 64, 28, &objpix[GEGNERPICS + 219]);
		get(78, 16, 102, 27, &objpix[GEGNERPICS + 220]);
		get(112, 15, 130, 29, &objpix[GEGNERPICS + 221]);
		get(142, 14, 162, 29, &objpix[GEGNERPICS + 222]);
		get(15, 42, 30, 51, &objpix[GEGNERPICS + 223]);

		// U-Boote
		if(!load_pic("UBOOT.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(10, 11, 108, 40, &objpix[GEGNERPICS + 224]);
		get(11, 60, 97, 86, &objpix[GEGNERPICS + 225]);
		get(136, 11, 234, 41, &objpix[GEGNERPICS + 226]);
		get(143, 59, 230, 85, &objpix[GEGNERPICS + 227]);

		// Endgegner - Schiff
		if(!load_pic("ENDGEGN4.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(82, 47, 270, 119, &objpix[GEGNERPICS + 228]);
		get(144, 26, 224, 42, &objpix[GEGNERPICS + 229]);
		get(132, 148, 225, 160, &objpix[GEGNERPICS + 230]);

		// Carrier, ...
		if(!load_pic("SHIP2.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(65, 81, 278, 173, &objpix[GEGNERPICS + 231]);
		// Fighter
		get(18, 19, 65, 52, &objpix[GEGNERPICS + 232]);
		get(74, 22, 121, 50, &objpix[GEGNERPICS + 233]);
		get(134, 29, 181, 57, &objpix[GEGNERPICS + 234]);
		// Hubi
		if(!load_pic("SHIPS.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(20, 140, 81, 186, &objpix[GEGNERPICS + 235]);
		get(88, 140, 149, 186, &objpix[GEGNERPICS + 236]);
		get(156, 140, 217, 186, &objpix[GEGNERPICS + 237]);
		// Destroyer - klein
		get(14, 4, 105, 34, &objpix[GEGNERPICS + 238]);

		// 1. Endgegner - Schiff mit Kanonen
		if(!load_pic("ENDGEGN1.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(6, 5, 170, 162, &objpix[GEGNERPICS + 4]);
		get(197, 8, 308, 30, &objpix[GEGNERPICS + 240]);

		// Absetzer fr Rckwrtsschuss
		if(!load_pic("GEG_1_10.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(135, 55, 167, 95, &objpix[GEGNERPICS + 243]);
		// kleine Barriere
		get(20, 64, 45, 86, &objpix[GEGNERPICS + 244]);
		// U-Boot-Torpedo
		get(79, 71, 112, 80, &objpix[GEGNERPICS + 246]);
		// Miniflieger
		get(83, 10, 101, 25, &objpix[GEGNERPICS + 247]);
		get(116, 20, 132, 34, &objpix[GEGNERPICS + 248]);
		get(145, 19, 163, 35, &objpix[GEGNERPICS + 249]);
		get(176, 20, 192, 34, &objpix[GEGNERPICS + 250]);
		get(211, 29, 229, 44, &objpix[GEGNERPICS + 251]);
		get(248, 28, 264, 42, &objpix[GEGNERPICS + 252]);
		get(13, 3, 31, 19, &objpix[GEGNERPICS + 253]);
		get(52, 12, 68, 26, &objpix[GEGNERPICS + 254]);
		// grosser Absetzer
		get(172, 50, 243, 120, &objpix[GEGNERPICS + 255]);
		get(228, 127, 298, 198, &objpix[GEGNERPICS + 256]);
		// Abstosser
		get(15, 135, 65, 179, &objpix[GEGNERPICS + 257]);
		get(74, 135, 124, 179, &objpix[GEGNERPICS + 258]);
		get(133, 135, 183, 179, &objpix[GEGNERPICS + 259]);

		// grosse Barriere
		if(!load_pic("GEG_1_9.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(7, 24, 55, 64, &objpix[GEGNERPICS + 245]);
		// Anzieher
		get(79, 28, 112, 53, &objpix[GEGNERPICS + 260]);
		get(124, 29, 157, 53, &objpix[GEGNERPICS + 261]);
		get(168, 30, 201, 54, &objpix[GEGNERPICS + 262]);
		// Zerbatzteil/Mine
		get(116, 75, 146, 102, &objpix[GEGNERPICS + 272]);
		// Schiessteil/station
		get(41, 76, 97, 99, &objpix[GEGNERPICS + 273]);

		// Endgegner 5 - Riesenschiff mit Kanonen
		if(!load_pic("ENDGEGN5.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(6, 37, 279, 128, &objpix[GEGNERPICS + 263]);
		// Kanone
		if(!load_pic("SHIP3.PIX", screen_addr, alt_rgb))
			return(FALSE);
		for(i = 0; i < 8; i++)
			get((i % 5) * 61, (i / 5) * 49, (i % 5) * 61 + 60, (i / 5) * 49 + 50, &objpix[GEGNERPICS + 264 + i]);

		// rollende Rohrteile
		if(!load_pic("ROEHRE.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(12, 9, 53, 64, &objpix[GEGNERPICS + 274]);
		get(66, 9, 106, 64, &objpix[GEGNERPICS + 275]);
		get(126, 9, 167, 64, &objpix[GEGNERPICS + 276]);
		// Hochflammenwerfer
		get(174, 6, 193, 106, &objpix[GEGNERPICS + 277]);
		get(196, 6, 215, 106, &objpix[GEGNERPICS + 278]);
		get(218, 6, 237, 106, &objpix[GEGNERPICS + 279]);
		// Runterflammenwerfer
		get(249, 13, 268, 113, &objpix[GEGNERPICS + 280]);
		get(271, 13, 290, 113, &objpix[GEGNERPICS + 281]);
		get(294, 13, 313, 113, &objpix[GEGNERPICS + 282]);

		// Flammenwerferschuss hoch
		if(!load_pic("FLAMMUNG.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(0, 0, 33, 103, &objpix[GEGNERPICS + 283]);
		get(33, 0, 66, 103, &objpix[GEGNERPICS + 284]);
		get(66, 0, 99, 103, &objpix[GEGNERPICS + 285]);
		get(99, 0, 132, 103, &objpix[GEGNERPICS + 286]);
		get(132, 96, 165, 199, &objpix[GEGNERPICS + 287]);
		// Flammenwerferschuss runter
		get(286, 0, 319, 103, &objpix[GEGNERPICS + 288]);
		get(253, 0, 286, 103, &objpix[GEGNERPICS + 289]);
		get(220, 0, 253, 103, &objpix[GEGNERPICS + 290]);
		get(187, 0, 220, 103, &objpix[GEGNERPICS + 291]);
		get(154, 0, 187, 103, &objpix[GEGNERPICS + 292]);

		// Drehplatten
		if(!load_pic("DREHPLAT.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(1, 0, 64, 26, &objpix[GEGNERPICS + 293]);
		get(6, 27, 63, 53, &objpix[GEGNERPICS + 294]);
		get(16, 54, 50, 80, &objpix[GEGNERPICS + 295]);
		get(31, 82, 35, 107, &objpix[GEGNERPICS + 296]);
		get(14, 108, 49, 134, &objpix[GEGNERPICS + 297]);
		get(4, 135, 60, 161, &objpix[GEGNERPICS + 298]);

		// Launcher
		if(!load_pic("LAUNCHER.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(13, 10, 53, 44, &objpix[GEGNERPICS + 299]);
		get(10, 62, 56, 100, &objpix[GEGNERPICS + 300]);
		get(7, 113, 59, 157, &objpix[GEGNERPICS + 301]);
		get(67, 2, 125, 52, &objpix[GEGNERPICS + 302]);
		get(64, 54, 128, 108, &objpix[GEGNERPICS + 303]);

		// Endgegner 7
		if(!load_pic("ENDGEGN6.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(0, 0, 92, 199, &objpix[GEGNERPICS + 304]);

		// Endgegner 8
		if(!load_pic("ENDGEGN7.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(249, 0, 319, 199, &objpix[GEGNERPICS + 305]);	// Station
		get(6, 4, 244, 40, &objpix[GEGNERPICS + 306]);	// Greifer 1
		get(0, 149, 238, 184, &objpix[GEGNERPICS + 307]); // Greifer 2
		get(91, 72, 140, 119, &objpix[GEGNERPICS + 308]); // Schrott gross
		get(157, 80, 200, 117, &objpix[GEGNERPICS + 309]); // Schrott 2
		get(35, 70, 55, 86, &objpix[GEGNERPICS + 310]);	// Mine

		// Greifer mit Schrott
		if(!load_pic("GREIFER.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(39, 17, 289, 72, &objpix[GEGNERPICS + 311]);	// oben
		get(36, 140, 281, 188, &objpix[GEGNERPICS + 312]);	// unten

		// Endgegner 6
		if(!load_pic("PIEKSER.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(6, 3, 11, 7, &objpix[GEGNERPICS + 313]);	// Piekser
		get(14, 2, 31, 16, &objpix[GEGNERPICS + 314]);
		get(35, 1, 64, 24, &objpix[GEGNERPICS + 315]);
		get(67, 1, 106, 32, &objpix[GEGNERPICS + 316]);
		get(109, 1, 156, 40, &objpix[GEGNERPICS + 317]);
		get(159, 1, 212, 44, &objpix[GEGNERPICS + 318]);
		get(109, 1, 156, 40, &objpix[GEGNERPICS + 319]);
		get(67, 1, 106, 32, &objpix[GEGNERPICS + 320]);
		get(35, 1, 64, 24, &objpix[GEGNERPICS + 321]);
		get(14, 2, 31, 16, &objpix[GEGNERPICS + 322]);
		get(6, 3, 11, 7, &objpix[GEGNERPICS + 323]);
		get(11, 54, 81, 112, &objpix[GEGNERPICS + 324]);	// Schiessdrohne

		// Endgegner 8 - Bodenhaus
		if(!load_pic("ENDGEGN8.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(121, 20, 309, 178, &objpix[GEGNERPICS + 325]);
		// Endgegner 8 - schiessende Pyramide
		if(!load_pic("ENDGEG8B.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(9, 11, 91, 79, &objpix[GEGNERPICS + 326]);
		get(104, 11, 186, 79, &objpix[GEGNERPICS + 327]);
		get(205, 12, 287, 80, &objpix[GEGNERPICS + 328]);
		get(9, 90, 91, 158, &objpix[GEGNERPICS + 329]);
		get(104, 91, 186, 159, &objpix[GEGNERPICS + 330]);

		// weiter mit 331 - Maximum 365
	}

	return(TRUE);
}

BOOLEAN attack_defeated()
{
	int i;

	// Alle tot?
	for(i = 0; i < MAX_OBJEKTE; i++)
		if(objekt[i].nr && (objekt[i].art > 2) && (objekt[i].art < 100))
			return(FALSE);

	return(TRUE);
}

void show_attack()
{
	if(attack.wait > 0)
	{
		put_text(&redfont, screen_width / 2 - 5 * redfont.char_w, screen_height / 2 - 2 * redfont.char_h, "ATTACK WAVE");
		sprintf(txt, "- %d -", attack.nr);
		put_text(&redfont, screen_width / 2 - strlen(txt) / 2 * redfont.char_w, screen_height / 2 + redfont.char_h, txt);
	}
}

void training_neue_objekt()
{
	int i, t, o, extra_nr;
	int bereich, anz_bereichsketten;
	static int letzter = 0;

	attack.wait--;
	if(attack.wait > 0)
		return;	
	else if(attack.wait == 0)
		attack.dauer = 200 + 50 * attack.nr;	// Und los!

	attack.dauer--;
	if(attack.dauer <= 0)
	{
		// Attacke zu Ende und alles weg?
		if(attack_defeated())
		{
			// ja: Neue ankndigen
			attack.nr++;
			attack.wait = ATTACK_WAIT_LEN;
			letzter = 0;
		}
		return; // Und keine Neuen mehr, da zuende!
	}

	// Nicht jedesmal 'ne neue Kette!
	if(rand() % max(10, 100 - game_scrollpos / 500) > 0)
		return;

	// passende Gegnerkette suchen
	bereich = (spieler.punkte / 10000 + 1) * 1000;
	anz_bereichsketten = 0;
	for(i = 0; i < anz_ketten; i++)
		if((startkette[i].start_x > 0) && (startkette[i].start_x < bereich))
				anz_bereichsketten++;

	if(anz_bereichsketten == 0)
		return;

	// i als Auswahl
	t = anz_bereichsketten;
	for(i = 0; i < anz_ketten; i++)
		if((startkette[i].start_x > 0) && (startkette[i].start_x < bereich))
		{
			t--;
			if(t == 0)
				i = 0;	// Entweder der letzte: Neustart
			else if((rand() % anz_bereichsketten == 0) && ((i != letzter) || (anz_bereichsketten == 1)))
				break;	// oder irgendeiner mittendrin
			
		}

	// Wenn keine da:
	if((i < 0) || (i > anz_ketten))
		return;

	letzter = i;

	// Objekte erzeugen
	for(t = 0; t < startkette[i].anz_objekte; t++)
	{
		// alle anderen Gegner
		o = 0;
		while((o < MAX_OBJEKTE) && objekt[o].nr)
			o++;

		if(o < MAX_OBJEKTE)
		{
			objekt[o] = startkette[i].obj;

			objekt[o].startpause = startkette[i].obj.startpause * t;
			objekt[o].weapon_ok = objekt[o].weapon_fire;
			// Extra eintragen
			if(t == 0)
				extra_nr = objekt[o].extra_listnr = extra_start(startkette[i].anz_objekte, startkette[i].obj.extra);
			else
				objekt[o].extra_listnr = extra_nr;
		}
	}
}

void neue_objekte(void)
{
	int i, t, o, extra_nr, b, wink;
	int game_xpos, w;

	// Training-Mode-Gegner kommen anders!
	if(game_difficulty == TRAINING)
	{
		training_neue_objekt();
		return;
	}

	// Keine mehr, wenn Endgegner 57 und 58 (Stationen) tot
	if((endmonster.art_da == 57) || (endmonster.art_da == 58))
		if(level_over < 100)
			return;

	// Welche kommen?
	if((endmonster.art_da == 56) || (endmonster.art_da == 57) || (endmonster.art_da == 58) || (endmonster.art_da == 59))
	{
		// Ketten immer wieder - xpos MODULO
		game_xpos = endmonster.start_x + 41 + (game_scrollpos % 640);
	}
	else
		game_xpos = game_scrollpos;

	for(i = 0; i < anz_ketten; i++)
		if(startkette[i].start_x == game_xpos)
		{
			// Objekte erzeugen
			for(t = 0; t < startkette[i].anz_objekte; t++)
			{
				if(startkette[i].obj.art == 16)
				{
					// Drehschleuderketten
					wink = winkel(startkette[i].obj.bahn.kurve[0].xpl, startkette[i].obj.bahn.kurve[0].ypl);
					for(b = 0;b < startkette[i].obj.bahn.kurve[0].len; b++)
					{
						o = 0;
						while((o < MAX_OBJEKTE) && objekt[o].nr)
							o++;
						if(o < MAX_OBJEKTE)
						{
							objekt[o] = startkette[i].obj;
							objekt[o].anistufe = 0;
							objekt[o].startpause = startkette[i].obj.startpause * t;
							objekt[o].bahn.kurve[0].xpl = startkette[i].obj.bahn.x;
							objekt[o].bahn.kurve[0].ypl = startkette[i].obj.bahn.y;
							objekt[o].bahn.kurve[0].xxpl = (startkette[i].obj.bahn.kurve[0].xpl + startkette[i].obj.bahn.kurve[0].ypl) * b;
							objekt[o].bahn.kurve[0].yypl = wink;
							objekt[o].weapon_ok = objekt[o].weapon_fire;
							if(b == startkette[i].obj.bahn.kurve[0].len - 1)
								objekt[o].nr -= 2;
							else if( b > 0)
								objekt[o].nr -= 1;
							objekt[o].extra_listnr = -1;
						}				
					}
				}
				else
				{
					// alle anderen Gegner
					o = 0;
					while((o < MAX_OBJEKTE) && objekt[o].nr)
						o++;

					if(o < MAX_OBJEKTE)
					{
						objekt[o] = startkette[i].obj;
						// Schwierigkeitsgrad
						if(game_difficulty == BABY)
							objekt[o].energie /= 2;
						if(game_difficulty == BEGINNER)
							objekt[o].energie = objekt[o].energie * 3 / 4;

						// Gegnerspezialaction ...
						if(endmonster.art_da == 56)
							objekt[o].bahn.y = spieler.y * KURVENFAC;	// Alle Ketten kommen beim Spieler
						else if(objekt[o].art == 38)
						{
							// Greiferabwurf bestimmen
							w = objekt[o].weapon_fire;
							objekt[o].weapon_fire = (objekt[o].bahn.x / KURVENFAC - 96 - spieler.x) / (-objekt[o].bahn.kurve[0].xpl / (KURVENFAC * KURVENFAC));
							if(objekt[o].weapon_fire > w)
								objekt[o].weapon_fire = w;
						}

						objekt[o].startpause = startkette[i].obj.startpause * t;
						objekt[o].weapon_ok = objekt[o].weapon_fire;
						// Extra eintragen
						if(t == 0)
							extra_nr = objekt[o].extra_listnr = extra_start(startkette[i].anz_objekte, startkette[i].obj.extra);
						else
							objekt[o].extra_listnr = extra_nr;
					}
					// Fuer Endgegner zum Beispiel Kanonen erzeugen
					endgegner_specialaction(&startkette[i]);
				}
			}
		}
}

void show_objekt(OBJEKT *obj)
{
	int pixnr,h,br;

	if (!do_draw)
	  {
	    return ;
	  } /* if (!do_draw) */

	// kleine Lavaflammspielersuchschuesse nicht schon stehend anzeigen
	if((obj->art == 17) && obj->startpause)
		return;
	// Bodenpiekser nicht unausgefahren!
	if((obj->art == 14) && obj->startpause)
		return;

	pixnr = obj->nr + obj->anistufe / ANIFAC;
	if(obj->art < 200)
		objput(obj->bahn.x / KURVENFAC - objpix[pixnr].w / 2, obj->bahn.y / KURVENFAC - objpix[pixnr].h / 2, &objpix[pixnr]);
	else
	{
		br = objpix[pixnr].w * 50 / obj->bahn.kurve[0].yypl;
		h = objpix[pixnr].h * 50 / obj->bahn.kurve[0].yypl;
//		if((br > 1) && (h > 1))
//			objzoom(obj->bahn.x / KURVENFAC - br / 2, obj->bahn.y / KURVENFAC - h / 2, br, h, &objpix[pixnr]);
	}
}

void delete_objekt(OBJEKT *obj)
{
	// Extra erzeugen
	if(obj->energie > 0)
		extra_new(obj->extra_listnr, obj->bahn.x / KURVENFAC, obj->bahn.y / KURVENFAC, 0);
	else
		extra_new(obj->extra_listnr, obj->bahn.x / KURVENFAC, obj->bahn.y / KURVENFAC, obj->extra);
	// Objekt loeschen
	obj->nr = 0;
}

void objekte()
{
	int i;

	// Plattformstehende anzeigen:
	for(i = 0; i < MAX_OBJEKTE; i++)
		if(objekt[i].nr && (objekt[i].art > 1) && (objekt[i].art < 100))
		{
			switch(objekt[i].art)
			{
				case 6:
				case 8:
				case 11:
				case 12:
				case 14:
				case 16:
				case 18:
				case 20:
				case 21:
				case 28:
				case 29:
				case 30:
				case 32:
				case 34:
				case 35:
				case 37:
				case 38:
				case 39:
				case 50:
				case 56:
				case 61:
					if (do_draw)
					  {
					    show_objekt(&objekt[i]);
					  } /* if (do_draw) */
					break;
			}
		}
	// Flieger anzeigen:
	for(i = 0; i < MAX_OBJEKTE; i++)
		if(objekt[i].nr && (objekt[i].art > 1) && (objekt[i].art < 100))
		{
			switch(objekt[i].art)
			{
				case 3:
				case 4:
				case 5:
				case 7:
				case 9:
				case 10:
				case 13:
				case 15:
				case 17:
				case 19:
				case 22:
				case 23:
				case 24:
				case 25:
				case 26:
				case 27:
				case 31:
				case 33:
				case 36:
				case 60:
				case 62:
					if (do_draw)
					  {
					    show_objekt(&objekt[i]);
					  } /* if (do_draw) */
					break;
			}
		}

	// Endgegner anzeigen:
	for(i = 0; i < MAX_OBJEKTE; i++)
		if(objekt[i].nr && (objekt[i].art > 50) && (objekt[i].art < 100) && (objekt[i].art != 56) && (objekt[i].art != 60) && (objekt[i].art != 61) && (objekt[i].art != 62))
				show_objekt(&objekt[i]);

	// Schsse anzeigen:
	for(i = 0; i < MAX_OBJEKTE; i++)
		if(objekt[i].nr && (objekt[i].art >= 100))
			show_objekt(&objekt[i]);

	for(i = 0; i < MAX_OBJEKTE; i++)
		if(objekt[i].nr && (objekt[i].art > 1))
		{
			// Endgegnerenergieanzeige usw.
			if((objekt[i].art >= 50) && (objekt[i].art < 100))
				endgegner_start(&objekt[i]);

			// Steuerung
			switch(objekt[i].art)
			{
				case 3:
					// Kippgegner
					standardkollision(&objekt[i]);
					kippsteuern(&objekt[i]);
					break;
				case 4:
					// Normalanigegner
					standardkollision(&objekt[i]);
					standardsteuern(&objekt[i]);
					break;
				case 5:
					// Drehgegner mit Schuss
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					drehsteuern(&objekt[i]);
					break;
				case 6:
					// DrehGeschtzturm
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					schiffrichtung_zielsteuern(&objekt[i]);
					break;
				case 7:
					// SpielerRakete
					schusskollision(&objekt[i]);
					spieler_zielraketen_steuern(&objekt[i]);
					break;
				case 8:
					// Raketenturm
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					raketenturmsteuern(&objekt[i]);
					break;
				case 9:
					// Drehgegner
					standardkollision(&objekt[i]);
					drehsteuern(&objekt[i]);
					break;
				case 10:
					// sehr schnell animierte Gegner
					standardkollision(&objekt[i]);
					schnellanisteuern(&objekt[i]);
					break;
				case 11:
					// hochfahrende Kanonenstellung
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					kanonenstellungsteuern(&objekt[i]);
					break;
				case 12:
					//streuende gegner
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					streusteuern(&objekt[i]);					
					break;
				case 13:
					//mine
					standardkollision(&objekt[i]);
					minesteuern(&objekt[i]);					
					break;
				case 14:
					// hochfahrende Piekser
					if(objekt[i].weapon_ok)
						objekt[i].weapon_ok--;
					else
					{
						objekt[i].weapon_ok = 0;
						standardkollision(&objekt[i]);
					}
					kanonenstellungsteuern(&objekt[i]);
					break;
				case 15:
					// Flammengegnerschuss
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					drehsteuern(&objekt[i]);
					break;
				case 16:
					// kette
					standardkollision(&objekt[i]);
					kettesteuern(&objekt[i]);
					break;
				case 17:
					// kleine spielersuchende Flamme
					if(objekt[i].startpause == 0)
						standardkollision(&objekt[i]);
					spielersuchsteuern(&objekt[i]);
					break;
				case 18:
					// Raketenschiessende U-Boote
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					standardsteuern(&objekt[i]);
					break;
				case 19:
					// Gegnerraketen
					standardkollision(&objekt[i]);
					zielraketensteuern(&objekt[i]);
					break;
				case 20:
					// Kreisfeuergegner
					standardkollision(&objekt[i]);
					if((objekt[i].bahn.kurve[objekt[i].bahn.akt].xpl / (KURVENFAC * KURVENFAC) == -game_scrollgeschw) && (objekt[i].bahn.kurve[objekt[i].bahn.akt].ypl / (KURVENFAC * KURVENFAC) == 0))
						schiessen(&objekt[i]);	// Bei Stillstand: Kreisfeuern
					standardsteuern(&objekt[i]);
					break;
				case 21:
					// Schiff mit Kugelschssen nach vorn
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					standardsteuern(&objekt[i]);
					break;
				case 22:
					// Normalanigegner mit Lahmschussabsetzen
					standardkollision(&objekt[i]);
					if(objekt[i].bahn.kurve[objekt[i].bahn.akt].xpl / (KURVENFAC * KURVENFAC) == -game_scrollgeschw)
						schiessen(&objekt[i]);	// Bei Stillstand: Lahmscheibenschuss feuern
					standardsteuern(&objekt[i]);
					break;
				case 23:
					// Kippgegner mit Lahmschussabsetzen
					standardkollision(&objekt[i]);
					if(objekt[i].bahn.kurve[objekt[i].bahn.akt].xpl / (KURVENFAC * KURVENFAC) == -game_scrollgeschw)
						schiessen(&objekt[i]);	// Bei Stillstand: Lahmscheibenschuss feuern
					kippsteuern(&objekt[i]);
					break;
				case 24:
					// Drehgegner mit Lahmschussabsetzen
					standardkollision(&objekt[i]);
					if(objekt[i].bahn.kurve[objekt[i].bahn.akt].xpl / (KURVENFAC * KURVENFAC) == -game_scrollgeschw)
						schiessen(&objekt[i]);	// Bei Stillstand: Lahmscheibenschuss feuern
					drehsteuern(&objekt[i]);
					break;
				case 25:
					// Absetzer fr Rckschsse
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					standardsteuern(&objekt[i]);
					break;
				case 26:
					// Miniflieger - spielersuchend
					standardkollision(&objekt[i]);
					zielraketensteuern(&objekt[i]);
					break;
				case 27:
					// Normalanigegner mit kleinem Kugelschuss - spielersuchend
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					standardsteuern(&objekt[i]);
					break;
				case 28:
					// U-Boote mit Torpedo - spielersuchend nach vorne
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					standardsteuern(&objekt[i]);
					break;
				case 29:
					// Abstosser
					standardkollision(&objekt[i]);
					abstossersteuern(&objekt[i]);
					break;
				case 30:
					// Zerbatzkugel/Mine
					standardkollision(&objekt[i]);
					zerbatzsteuern(&objekt[i]);
					break;
				case 31:
					// Absetzer fr kleine Spielersuchflieger
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					standardsteuern(&objekt[i]);
					break;
				case 32:
					// Schiessteil fr lahme Kreisschsse
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					standardsteuern(&objekt[i]);
					break;
				case 33:
					// Absetzer fr Zerbatzteile
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					standardsteuern(&objekt[i]);
					break;
				case 34:
					// Drehdoppelkanone
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					schiffrichtung_zielsteuern(&objekt[i]);
					break;
				case 35:
					// Flammenwerfer
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					standardsteuern(&objekt[i]);
					break;
				case 36:
					// Drehplatten
					standardkollision(&objekt[i]);
					mittelschnellsteuern(&objekt[i]);
					break;
				case 37:
					// Minifliegerlauncher
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					minilaunchersteuern(&objekt[i]);
					break;
				case 38:
					// Greifer mit Schrott
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					standardsteuern(&objekt[i]);
					break;
				case 39:
					// Magnet
					standardkollision(&objekt[i]);
					magnetsteuern(&objekt[i]);
					break;
				case 50:
					// Endgegner 1 - grosser Flieger
					standardkollision(&objekt[i]);
          schiessen(&objekt[i]);
					restartsteuern(&objekt[i]);
					break;
				case 51:
					// Endgegner 2 - Riesenplattform
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					restartsteuern(&objekt[i]);
					break;
				case 52:
					// Endgegner 4 - Schiff
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					restartsteuern(&objekt[i]);
					break;
				case 53:
					// Endgn 4 - Schiffraketenwerfer
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					restartsteuern(&objekt[i]);
					break;
				case 54:
					// Endgegn 1 - grosser Flieger-Kanonen
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					restartsteuern(&objekt[i]);
					break;
				case 55:
					// Endgegn 3 - Flugstation schiessend mit 3 festen Kanonen
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					restartsteuern(&objekt[i]);
					break;
				case 56:
					// Endgegner 5 - Riesenschiff mit Kanonen dabei
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					restartsteuern(&objekt[i]);
					break;
				case 57:
					// Endgegner 6 - Station
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					restartsteuern(&objekt[i]);
					break;
				case 58:
					// Endgegner 7 - Station mit Greifern
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					restartsteuern(&objekt[i]);
					break;
				case 59:
					// Endgegner 5 - Hochfahrteil
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					restartsteuern(&objekt[i]);
					break;
				case 60:
					// Endgegner 9 - schiessende Pyramide
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					restartsteuern(&objekt[i]);
					break;
				case 61:
					// Haus unter Endgegner 9
					restartsteuern(&objekt[i]);
					break;
				case 62:
					// DrehGeschtzturm fr Endgegner 9
					standardkollision(&objekt[i]);
					schiessen(&objekt[i]);
					schiffrichtung_zielsteuern(&objekt[i]);
					break;
				case 100:
					// SpielerFlugschuss
					schusskollision(&objekt[i]);
					standardsteuern(&objekt[i]);
					break;
				case 101:
					// DrehSchuss
					standardkollision(&objekt[i]);
					drehsteuern(&objekt[i]);
					break;
				case 102:
					// Spielerraketen
					schusskollision(&objekt[i]);
					spieler_zielraketen_steuern(&objekt[i]);
					break;
				case 103:
					// Gegnerraketen
					standardkollision(&objekt[i]);
					zielraketensteuern(&objekt[i]);
					break;
				case 104:
					// Flammgegnerschuss
					standardkollision(&objekt[i]);
					schnellanisteuern(&objekt[i]);
					break;
				case 105:
					// Spielermine
					schusskollision(&objekt[i]);
					minesteuern(&objekt[i]);
					break;
				case 106:
					// Flammenwerferschuss
					standardkollision(&objekt[i]);
					standardsteuern(&objekt[i]);
					break;
				case 200:
					//schrott
					schrottsteuern(&objekt[i]);
					break;
			}
//			objekt[i].bahn.x -= MITTE_SCROLLGESCHW * KURVENFAC;
		}
}

void wolken(void)
{
	int i;

	if((game_view == FULL) || (game_view == HIGH))
	{
		// Neue Meteore
	/*	if(rand() % 25 == 0)
		{
			i = 0;
			while((i < MAX_OBJEKTE) && objekt[i].nr)
				i++;
			if(i < MAX_OBJEKTE)
			{
				objekt[i].nr = GEGNERPICS + 218 + rand() % 6;
				objekt[i].art = 0;
				objekt[i].anistufe = 0;
				objekt[i].anz_anistufen = 1;
				objekt[i].startpause = 0;
				objekt[i].bahn.anz = 1;
				objekt[i].bahn.akt = 0;
				objekt[i].bahn.kurve[0].len = 150 * SPEED_FAC;
				objekt[i].bahn.x = (340 + rand() % 50) * KURVENFAC;
				objekt[i].bahn.y = (-20 + rand() % 240) * KURVENFAC;
				objekt[i].bahn.kurve[0].xpl = -(rand() % 4 + 2) * SPEED_FAC * KURVENFAC * KURVENFAC;
				objekt[i].bahn.kurve[0].ypl = 0;
				objekt[i].bahn.kurve[0].xxpl = 0;
				objekt[i].bahn.kurve[0].yypl = 0;
			}
		} */
	
		// Steuern und anzeigen
		for(i = 0; i < MAX_OBJEKTE; i++)
			if(objekt[i].nr && (objekt[i].art == 0))
			{
				show_objekt(&objekt[i]);
				standardsteuern(&objekt[i]);
				objekt[i].bahn.x -= MITTE_SCROLLGESCHW;
			}
	}
}

void kill_all_objects()
{
	int i, x, y, pixnr;

	for(i = 0; i < MAX_OBJEKTE; i++)
		if(objekt[i].nr && (objekt[i].art > 1))
		{
			x = objekt[i].bahn.x / KURVENFAC;
			y = objekt[i].bahn.y / KURVENFAC;
			pixnr = objekt[i].nr + objekt[i].anistufe / ANIFAC;
			if((x > -32) && (x < screen_width + 32) && (y > -32) && (y < screen_height + 32))
			{
				spieler.punkte += 5;
				if(objekt[i].art < 50)
				{
					if(objekt[i].energie < 1000)
					{
						explode(x, y, objpix[pixnr].w, objpix[pixnr].h, 0);	// normaler Gegner
						objekt[i].energie = 0;
						delete_objekt(&objekt[i]);
					}
				}
				else if(objekt[i].art < 100)
				{
					// Endgegner
					objekt[i].energie /= 2;					
				}
				else
				{
					explode(x, y, objpix[pixnr].w, objpix[pixnr].h, 1);	// Gegnerschuss
					objekt[i].energie = 0;
					delete_objekt(&objekt[i]);
				}
			}
		}
}

BOOLEAN alle_tot(OBJEKT *obj)
{
	int i;

	for(i = 0; i < MAX_OBJEKTE; i++)
		if(objekt[i].nr && (objekt[i].art == obj->art))
			if(memcmp(obj, &objekt[i], sizeof(OBJEKT)) != 0) // nicht das Objekt selber!
				return(FALSE);

	return(TRUE);
}

void alles_sprengen(int x, int y, int radius)
{
	int i, xr, yr, xw, yh, pixnr;

	for(i = 0; i < MAX_OBJEKTE; i++)
		if(objekt[i].nr && (objekt[i].art > 1) && (objekt[i].art < 100))
		{
			xr = abs(x - objekt[i].bahn.x / KURVENFAC);
			yr = abs(y - objekt[i].bahn.y / KURVENFAC);
			pixnr = objekt[i].nr + objekt[i].anistufe / ANIFAC;
			xw = objpix[pixnr].w / 3 + radius;
			yh = objpix[pixnr].h / 3 + radius;

			if((xr < xw) && (yr < yh))
			{
				spieler.punkte += 5;
				explode(x, y, objpix[pixnr].w, objpix[pixnr].h, 1);	// Gegnerschuss
				objekt[i].energie -= 100;
				if(objekt[i].energie <= 0)
				{
					spieler.punkte += 10;
					explode(objekt[i].bahn.x / KURVENFAC, objekt[i].bahn.y / KURVENFAC, objpix[pixnr].w, objpix[pixnr].h, 0);
					endgegner_tot(&objekt[i]);
					delete_objekt(&objekt[i]);
				}
			}
		}
}
