/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/************************************\
* My own palette routines - not yet  *
* the best I know, but OK.           *
* Written for Digital Nightmares.    *
* Copyright 1996 Michael Thayer      *
\************************************/

#include <stdlib.h>
#include <dn.h>
#include "mjt_func.h"

/* variables for palette routines */

short palette_deltas[256][3] ;
short palette_fixed_point[256][3] ;
int palette_steps_left ;

void pal_setup_fade(RGB dest[256], RGB src[256])
{
        int i ;

        for (i = 0 ; i < 256 ; i++)
          {
                palette_fixed_point[i][0] = src[i].r << 8 ;
                palette_fixed_point[i][1] = src[i].g << 8 ;
                palette_fixed_point[i][2] = src[i].b << 8 ;
                palette_deltas[i][0] = dest[i].r - src[i].r ;
                palette_deltas[i][1] = dest[i].g - src[i].g ;
                palette_deltas[i][2] = dest[i].b - src[i].b ;
          } /* for */
        palette_steps_left = 256 ;
} /* pal_setup_fade */

int pal_do_fade(RGB pal[256], int steps)
{
        int i, j ;

        i = 0 ;
        while (i < min(steps, palette_steps_left))
          {
                for (j = 0 ; j < 256 ; j++)
                  {
                        palette_fixed_point[j][0] += palette_deltas[j][0] ;
                        palette_fixed_point[j][1] += palette_deltas[j][1] ;
                        palette_fixed_point[j][2] += palette_deltas[j][2] ;
                  } /* for */
                i++ ;
          } /* while */
        if (palette_steps_left > steps)
          {
                palette_steps_left -= steps ;
          }
        else
          {
                palette_steps_left = 0 ;
          }
        for (i = 0 ; i < 256 ; i++)
          {
                pal[i].r = palette_fixed_point[i][0] >> 8 ;
                pal[i].g = palette_fixed_point[i][1] >> 8 ;
                pal[i].b = palette_fixed_point[i][2] >> 8 ;
          } /* for */
        return(palette_steps_left) ;
}
