/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**************************************\
* My own mapping / scaling routines,   *
* NOT definitive versions.             *
* Written for Digital Nightmares.      *
* Copyright 1996 Michael Thayer        *
\**************************************/

#include <stdlib.h>
#include <dn.h>
#include "mjt_func.h"

/* arrays used for mapping */

short scan_start[screen_h] ;    /* scan conversion structure */
short scan_end[screen_h] ;
short tex_x_start[screen_h] ;   /* texture co-ordinates at each */
short tex_x_end[screen_h] ;     /* scan-line end-point */
short tex_y_start[screen_h] ;
short tex_y_end[screen_h] ;
short mult_table[256] ;                 /* texture height MUST be less than 256 */

/* this fn does what it says... incorrect perspective, but (hopefully) fast */
void map_quad(int x[4], int y[4], OLDBLK * texture)
{
        int tex_x[4] ;
        int tex_y[4] ;

        int i, j, k, s ;
        int ds, tx, dtx1, ty, dty1 ;
        int min_scan, max_scan ;
        unsigned char * inner_src, * inner_dest_limit, * inner_dest ;

    if ( (* texture).h > 255)
      {
                return ;                    /* I wasn't joking about that... */
          }
        for (i = 0 ; i < (* texture).h ; i++)
          {
                mult_table[i] = i * (* texture).w ;
          } /* for */
        tex_x[0] = 0 ;                                  tex_y[0] = 0 ;
        tex_x[1] = (* texture).w ;              tex_y[1] = 0 ;
        tex_x[2] = (* texture).w ;              tex_y[2] = (* texture).h ;
        tex_x[3] = 0 ;                                  tex_y[3] = (* texture).h ;

        i = 3 ;                         /* scan convert */
        min_scan = screen_h ;
        max_scan = 0 ;
        for (j = 0 ; j < 4 ; j++)
          {
                if ( y[i] < min_scan)
                  {
                        min_scan = y[i] ;
                  }
                if (y[i] > max_scan)
                  {
                        max_scan = y[i] ;
                  }
                if (y[i] != y[j])
                  {
                        ds = (x[j] - x[i]) * 0x10000
                                / (y[j] - y[i]) ;
                        dtx1 = ( tex_x[j] - tex_x[i]) * 0x10000
                                / (y[j] - y[i]) ;
                        dty1 = ( tex_y[j] - tex_y[i]) * 0x10000
                                / (y[j] - y[i]) ;
                        if (y[j] > y[i])
                          {
                                s = x[i] * 0x10000 ;
                                tx = tex_x[i] * 0x10000 ;
                                ty = tex_y[i] * 0x10000 ;
                          } /* if */
                        else
                          {
                                s = x[j] * 0x10000 ;
                                tx = tex_x[j] * 0x10000 ;
                                ty = tex_y[j] * 0x10000 ;
                          } /* else */
                        k = min(y[i], y[j]) + 1 ;
                        while (k <= max(y[i], y[j]))
                          {
                                if ( (0 <= k) && (k < screen_h))
                                  {
                                        if (scan_start[k] != 0)
                                          {                                     /* don't overwrite previous pass */
                                                scan_end[k] = scan_start[k] ;
                                                tex_x_end[k] = tex_x_start[k] ;
                                                tex_y_end[k] = tex_y_start[k] ;
                                          } /* if */
                                        scan_start[k] = s / 0x10000 ;
                                        tex_x_start[k] = tx / 0x10000 ;
                                        tex_y_start[k] = ty / 0x10000 ;
                                  } /* if */
                                s += ds ;
                                tx += dtx1 ;
                                ty += dty1 ;
                                k++ ;
                          } /* while */
                  } /* if */
                else
                  {
                        scan_start[ y[i]] = x[i] ;
                        scan_end[ y[i]] = x[j] ;
                        tex_x_start[ y[i]] = tex_x[i] ;
                        tex_x_end[ y[i]] = tex_x[j] ;
                        tex_y_start[ y[i]] = tex_y[i] ;
                        tex_y_end[ y[i]] = tex_y[j] ;
                  } /* else */
                i = j ;
          } /* for (scan conversion loop) */

/* Thank God, that's finished... onto the actual mapping and let's hope that
        the thing will work! */
        i = min_scan;
        while (i <= max_scan)	
          {
                if (scan_start[i] != scan_end[i])
                  {
                        if (scan_start[i] > scan_end[i])
                          {
                                swap_int(scan_start[i], scan_end[i]) ;
                                swap_int(tex_x_start[i], tex_x_end[i]) ;
                                swap_int(tex_y_start[i], tex_y_end[i]) ;
                          } /* if */
                        if ( (scan_end[i] >= 0) && (scan_start[i] < screen_w))
                          {
                                tx = tex_x_start[i] * 0x10000 ;
                                ty = tex_y_start[i] * 0x10000 ;
                                dtx1 = (tex_x_end[i] - tex_x_start[i]) * 0x10000
                                        / (scan_end[i] - scan_start[i]) ;
                                dty1 = (tex_y_end[i] - tex_y_start[i]) * 0x10000
                                        / (scan_end[i] - scan_start[i]) ;
                                j = scan_start[i] ;
                                while (j < 0)           /* left clipping ; probably faster */
                                  {                 /* than calculating properly */
                                        tx += dtx1 ;
                                        ty += dty1 ;
                                        j++ ;
                                  } /* while (clipping loop) */
        /* OK, GCC doesn't optimise as well as I thought on CISC machines,
                so get everything possible precalculated by hand */
                                inner_src = (unsigned char *) (* texture).mem ;
                                inner_dest_limit = ( (unsigned char *) screen_addr) + (i * screen_w)
                                        + min(scan_end[i], screen_w) ;
                                inner_dest = ( (unsigned char *) screen_addr + (i * screen_w) + j) ;
        /* inner loop - should access as few variables as possible */
                                while (inner_dest < inner_dest_limit)
                                {
																	if(*(inner_src + mult_table[ty >> 16] + (tx >> 16)) != 0)
																		* (inner_dest) = * (inner_src + mult_table[ty >> 16] + (tx >> 16));
        /* maybe I can improve that by making the multiplication a power of 2 */
                                        tx += dtx1 ;
                                        ty += dty1 ;
                                        inner_dest++ ;
                                  } /* while (inner loop) */
                          } /* if */
                  } /* if */
                  i++ ;
          } /* while (outer loop) */
} /* map_quad */
