/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/********************************/
/* Zusatzfunktionen fr TERROID */
/* (C) Juli 1996, Michael Haar  */
/********************************/

#include <string.h>
#include <dn.h>
#include "DEFS.H"
#include "VARS.H"
#include "FUNCS.H"

/* globale Variablen */

/* Funktionsprototypen */
void clear_keys();
void wait_keys(long bis);
void press_key(long bis);
void pixel_in(void *pix);
void PaletteWhiteOut(RGB pal[256]);
void PaletteWhiteIn(RGB pal[256]);
void ticker_text(FONT *font, int x, int y, const char *txt, BOOLEAN mark);

/* Funktionen */
void clear_keys()
{
	while(keyTest(KEY_SPACE) || keyTest(KEY_ESC) || keyTest(KEY_ENTER) || keyTest(KEY_RCTRL) || keyTest(KEY_LCTRL) || joy1_b1())
		;
}

void wait_keys(long bis)
{
	long t;

	if(bis >= 0)
	{
		t = timer();
		while(!keyTest(KEY_SPACE) && !keyTest(KEY_ESC) && !keyTest(KEY_ENTER) && !keyTest(KEY_RCTRL) && !keyTest(KEY_LCTRL) && (timer() - t <= bis) && !joy1_b1())
			;
	}
	else if(bis == -1)
	{
		while(!keyTest(KEY_SPACE) && !keyTest(KEY_ESC) && !keyTest(KEY_ENTER) && !keyTest(KEY_RCTRL) && !keyTest(KEY_LCTRL))
			;
	}
}

void press_key(long bis)
{
	wait_keys(bis);
	clear_keys();
}

void pixel_in(void * pix)
{
	int i, t;
	int pos;
	GFXBLK blk ;

	t = timer();
	for(i = 0, pos = 0; i < (screen_width * screen_height); i++)
	  {
		*(((unsigned char *)screen_addr) + pos) = *(((unsigned char *)pix) + pos);
		pos += 7777 ;
		if(pos > (screen_width * screen_height))
		{
			pos -= (screen_width * screen_height);
		} /* if */
		if ( !(i & 2047))
		  {
			if (t > timer() - 2)
			  {
				while (t == timer()) ;
				t = timer() ;
				copy_frame_buffer() ;
			  } /* if */
			else
			  {
				++t ;
			  } /* else */
		  } /* if */
	  } /* for */
	get(0, 0, screen_width, screen_height, & blk) ;
	put(0, 0, & blk) ;
	Copy2Screen() ;
	free_blk(& blk) ;
} /* pixel_in */


void PaletteWhiteOut(RGB pal[256])
{
	int i, c;
	RGB fadepal[256];

	memcpy(fadepal, pal, sizeof(RGB) * 256);
	for(i = 0; i < 64; i++)
	{
		for(c = 0; c < 256; c++)
		{
			if(fadepal[c].r < 63)
				fadepal[c].r++;
			if(fadepal[c].g < 63)
				fadepal[c].g++;
			if(fadepal[c].b < 63)
				fadepal[c].b++;
		}
		SetPalette(fadepal);
	}
}

void PaletteWhiteIn(RGB pal[256])
{
	int i, c;
	RGB fadepal[256];

	memset(fadepal, 63, sizeof(RGB) * 256);
	for(i = 0; i < 64; i++)
	{
		for(c = 0; c < 256; c++)
		{
			if(fadepal[c].r > pal[c].r)
				fadepal[c].r--;
			if(fadepal[c].g > pal[c].g)
				fadepal[c].g--;
			if(fadepal[c].b > pal[c].b)
				fadepal[c].b--;
		}
		SetPalette(fadepal);
	}
}

void ticker_text(FONT *font, int x, int y, const char *txt, BOOLEAN mark)
{
//	void *old_screen = screen_addr;
	char i;
	long t;
	BOOLEAN key;
//	screen_addr = (void *)0xA0000;

	t = timer();
	i = 0;
	key = FALSE;
	while(txt[i])
	{
		if(keyTest(KEY_ESC) || keyTest(KEY_SPACE) || keyTest(KEY_ENTER) || keyTest(KEY_RCTRL) || keyTest(KEY_LCTRL)) // || joy1_b1())
			key = TRUE;
		while (timer() - t < 2) ;
		if (!key)
		  {
		    t += 2 ;
		  }

		if(!key)
		  {
		    if(txt[i] > 32)
		    if (sounddevice != 4) start_sample(beepsnd, md_numchn - 1);
		  }
		if(mark)
		  objput(x + i * redfont.char_w, y, &redfont.char_pic[txt[i] - 32]);
		else
		  objput(x + i * greenfont.char_w, y, &greenfont.char_pic[txt[i] - 32]);
		if(i > 0)
		  {
		    if(mark)
		      objput(x + (i - 1) * redfont.char_w, y, &redfont.char_pic[txt[i - 1] - 32]);
		    else
		      objput(x + (i - 1) * font->char_w, y, &font->char_pic[txt[i - 1] - 32]);
		  }
		i++;
		if (timer() - t < 2)
		  {
		    Copy2Screen() ;
		  } /* if */
	}
	// letztes Zeichen richtigmachen
	if(mark)
		objput(x + (i - 1) * redfont.char_w, y, &redfont.char_pic[txt[i - 1] - 32]);
	else
		objput(x + (i - 1) * font->char_w, y, &font->char_pic[txt[i - 1] - 32]);
	Copy2Screen() ;

//	screen_addr = old_screen;
}
