/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**********************************/
/* ballerspiel-Objektkollsionen   */
/* (C) April 1996 by Michael Haar */
/**********************************/

#include <stdlib.h>
#include <string.h>
#include <dn.h>
#include "DEFS.H"
#include "FUNCS.H"
#include "VARS.H"

#define ENERGIEABZUG_LAHM

/* globale Variablen */

/* Funktionsprototypen */
void standardkollision(OBJEKT *obj);
void schusskollision(OBJEKT *obj);

/* Funktionen */
void standardkollision(OBJEKT *obj)
{
	int xr, yr, xw, yh;
	int pixnr, i;

	if(spieler.energie <= 0)
		return;

	xr = abs(spieler.x - obj->bahn.x / KURVENFAC);
	yr = abs(spieler.y - obj->bahn.y / KURVENFAC);
	pixnr = obj->nr + obj->anistufe / ANIFAC;
	xw = objpix[pixnr].w / 3 + 20;	// etwas kleiner
	yh = objpix[pixnr].h / 3 + 15;	// als normal

	if((xr < xw) && (yr < yh) && (spieler.absturz == 0))
	{
		// Kollision mit Spieler
		spieler.punkte += 1;

		i = spieler.energie;
		// Wenn kein Schild und Endmonster noch nicht besiegt
		if((spieler.schild <= 0) && (level_over == 100) && strcmp(cheatmode, "IAMGOD"))
		{
#ifdef ENERGIEABZUG_LAHM
			if((obj->nr >= GEGNERPICS + 107) && (obj->nr <= GEGNERPICS + 111))
				spieler.energie = 0;	// Minenfelder tdlich
			else
				spieler.energie -= min(5, obj->energie);
			// Ruckeln
			spieler.x += (rand() % 11) - 5;
			spieler.y += (rand() % 11) - 5;
#else
			spieler.energie -= obj->energie;
#endif
			spieler.schild = -5 * SPEED_FAC;
		}
		// Flamm, Kugel und Scheibenschuss verschwinden nicht!
		if((obj->nr != 104) && (obj->nr != 106) && (obj->nr != GEGNERPICS + 241) && (obj->nr != GEGNERPICS + 181))
		{
//			// Bei spielerschild dem Endgegner nur wenig abziehen
//			if(spieler.schild && (obj->art >= 50) && (obj->art < 100))
				obj->energie -= 5;
//			else
//				obj->energie -= i;
		}

		// Explosion, ...
		if(obj->energie <= 0)
		{
			if(game_difficulty == BABY)
				spieler.punkte += 1;
			else if(game_difficulty == BEGINNER)
				spieler.punkte += 2;
			else
				spieler.punkte += 5;
			explode(obj->bahn.x / KURVENFAC, obj->bahn.y / KURVENFAC, objpix[pixnr].w, objpix[pixnr].h, 0);
			endgegner_tot(obj);
			delete_objekt(obj);
		}
	}
	// Kollision mit den Minen des Spielers
	for(i = 0; i < spieler.waffe[4]; i++)
	{
		xr = abs(spieler.mine[i].x - obj->bahn.x / KURVENFAC);
		yr = abs(spieler.mine[i].y - obj->bahn.y / KURVENFAC);
		pixnr = obj->nr + obj->anistufe / ANIFAC;
		xw = objpix[pixnr].w / 3 + 10;
		yh = objpix[pixnr].h / 3 + 10;

		if((xr < xw) && (yr < yh) && (spieler.absturz == 0))
		{
			// Kollision mit Mine
			spieler.punkte += 1;
	
			// Flammschuss verschwindet nicht!
			if((obj->nr != 104) && (obj->nr != 106))
				obj->energie -= spieler.mine[i].energie;
	
			// Explosion, ...
			if(obj->energie <= 0)
			{
				if(game_difficulty == BABY)
					spieler.punkte += 1;
				else if(game_difficulty == BEGINNER)
					spieler.punkte += 2;
				else
					spieler.punkte += 5;
				explode(obj->bahn.x / KURVENFAC, obj->bahn.y / KURVENFAC, objpix[pixnr].w, objpix[pixnr].h, 0);
				endgegner_tot(obj);
				delete_objekt(obj);
			}
			else
				explode(spieler.mine[i].x, spieler.mine[i].y, objpix[pixnr].w / 4, objpix[pixnr].h / 4, 2);
		}
	}

	// Kollision mit den Schuessen des Spielers in schusskollision der schuesse
}

void schusskollision(OBJEKT *obj)
{
	int xr, yr, xw, yh;
	int o, i, t, pixnr;

	if((obj->bahn.x / KURVENFAC < -32) || (obj->bahn.y / KURVENFAC < -32) || (obj->bahn.x / KURVENFAC > screen_width + 32) || (obj->bahn.y / KURVENFAC > screen_height + 32))
		return;

	for(o = 0; o < MAX_OBJEKTE; o++)
		if(objekt[o].nr)
			if((obj->art != objekt[o].art) && (objekt[o].art == 36))
			{
				// Drehplatten werden zum Beipiel zurckgesetzt
				xr = abs(objekt[o].bahn.x / KURVENFAC - obj->bahn.x / KURVENFAC);
				yr = abs(objekt[o].bahn.y / KURVENFAC - obj->bahn.y / KURVENFAC);
				i = obj->nr + obj->anistufe / ANIFAC;
				pixnr = objekt[o].nr + objekt[o].anistufe / ANIFAC;
				xw = objpix[i].w / 2 + objpix[pixnr].w / 3;	// etwas kleiner
				yh = objpix[i].h / 2 + objpix[pixnr].h / 3;	// als voll
	
				if((xr < xw) && (yr < yh))
				{
					if((obj->nr < SCHUSSPICS + 6) || (obj->nr > SCHUSSPICS + 8))
					{
						obj->energie -= objekt[o].energie;
						if(obj->energie <= 0)
							obj->nr = 0;
						// und wegsetzen
						objekt[o].bahn.x += 20 * KURVENFAC;
						explode(obj->bahn.x / KURVENFAC, obj->bahn.y / KURVENFAC, objpix[pixnr].w / 4, objpix[pixnr].h / 4, 2);
					}
					else
					{
						// bei Laser nix
						explode(obj->bahn.x / KURVENFAC, obj->bahn.y / KURVENFAC, objpix[pixnr].w / 4, objpix[pixnr].h / 4, 2);
					}
				}
			}
			else if((obj->art != objekt[o].art) && (objekt[o].art > 1) && (objekt[o].art < 100) && !((obj->art == 17) && obj->startpause))
			{
				// keine Selbst-/Wolken/Plattf-Kollision - und keine kleinen Flammschuesse
				if(endgegner_treffbar(&objekt[o]))
				{
					xr = abs(objekt[o].bahn.x / KURVENFAC - obj->bahn.x / KURVENFAC);
					yr = abs(objekt[o].bahn.y / KURVENFAC - obj->bahn.y / KURVENFAC);
					i = obj->nr + obj->anistufe / ANIFAC;
					pixnr = objekt[o].nr + objekt[o].anistufe / ANIFAC;
					xw = objpix[i].w / 2 + objpix[pixnr].w / 3;	// etwas kleiner
					yh = objpix[i].h / 2 + objpix[pixnr].h / 3;	// als voll
	
					if((xr < xw) && (yr < yh))
					{
						// Kollision mit objekt[o]
						if((obj->nr < SCHUSSPICS + 6) || (obj->nr > SCHUSSPICS + 8))
						{
							// Schuss
							t = obj->energie;
							obj->energie -= objekt[o].energie;
							spieler.punkte += 1;
							objekt[o].energie -= t;
						}
						else
						{
							// Laser
							if(game_difficulty == BABY)
								spieler.punkte += 1;
							else if(game_difficulty == BEGINNER)
								spieler.punkte += 2;
							else
								spieler.punkte += 5;
							objekt[o].energie -= obj->energie;
						}
						// Explosion, ...
						if(objekt[o].energie <= 0)
						{
							if(game_difficulty == BABY)
								spieler.punkte += 1;
							else if(game_difficulty == BEGINNER)
								spieler.punkte += 2;
							else
								spieler.punkte += 5;
							if((objekt[o].nr < GEGNERPICS + 203) || (objekt[o].nr > GEGNERPICS + 210))
								explode(objekt[o].bahn.x / KURVENFAC, objekt[o].bahn.y / KURVENFAC, objpix[pixnr].w, objpix[pixnr].h, 0);
							else	// kleine Flmmchen
								explode(objekt[o].bahn.x / KURVENFAC, objekt[o].bahn.y / KURVENFAC, objpix[pixnr].w, objpix[pixnr].h, 1);
							endgegner_tot(&objekt[o]);
							delete_objekt(&objekt[o]);
						}
						else
							explode(obj->bahn.x / KURVENFAC, obj->bahn.y / KURVENFAC, objpix[pixnr].w / 4, objpix[pixnr].h / 4, 2);

						if(obj->energie <= 0)
						{
							obj->nr = 0;	// ??? - keine delete?
							return;
						}
					}
				}
			}
}
