/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdlib.h>
#include <string.h>
#include <dn.h>
#include "mjt_func.h"

/* inline macros */

#define place_star(a) \
        stars_x[a] = Random(stars_max_x - stars_min_x) + stars_min_x ; \
        stars_y[a] = Random(stars_max_y - stars_min_y) + stars_min_y ; \
        stars_z[a] = Random(stars_max_z - stars_min_z) + stars_min_z ; \
        stars_col[a] = ( (stars_z[a] - stars_min_z) * (stars_max_col - 1) \
                        + 1 ) / (stars_max_z - stars_min_z) * stars_col_mult


/* constant paramaters for the intro */

#define num_stars 500

#define stars_min_x -10000000
#define stars_max_x 10000000
#define stars_min_y -7500000
#define stars_max_y 7500000
#define stars_min_z 50000
#define stars_max_z 100000

#define stars_max_col 4                         /* colours used for stars */
#define stars_col_mult (32 / stars_max_col)
                                                                        /* for palette effects */

#define delta_x 0
#define delta_y 0

#define credit_time 256                         /* the number of ticks that a credit
                                                                          screen is displayed for */
#define texture_frames 9                        /* number of frames in mapping bit */

/* variables */

int delta_z = -100 ;

int stars_x[num_stars] ;
int stars_y[num_stars] ;
int stars_z[num_stars] ;
int stars_pos[num_stars] ;              /* position (2d) of star on screen */
char stars_col[num_stars] ;     /* colour */

OLDBLK text_block[4] = {
        {0, 0, NULL}, {0, 0, NULL},     {0, 0, NULL}, {0, 0, NULL}} ;

int credit_positions[texture_frames * 2][8] =
  { {240, 320, 300, 260, 0, 100, 75, 25},
        {80, 240, 240, 80, 50, 50, 150, 150},
        {80, 240, 240, 80, 50, 50, 150, 150},
        {80, 240, 240, 80, 50, 50, 150, 150},
        {80, 240, 240, 80, 50, 50, 150, 150},
        {160, 160, 160, 160, 25, 75, 125, 175},
        {160, 160, 160, 160, 75, 25, 175, 125},
        {80, 240, 240, 80, 50, 50, 150, 150},
        {80, 240, 240, 80, 50, 50, 150, 150},
        {80, 240, 240, 80, 50, 50, 150, 150},
        {80, 240, 240, 80, 50, 50, 150, 150},
        {160, 160, 160, 160, 100, 100, 100, 100},
        {160, 160, 160, 160, 100, 100, 100, 100},
        {80, 240, 240, 80, 50, 50, 150, 150},
        {80, 240, 240, 80, 50, 50, 150, 150},
        {80, 240, 240, 80, 50, 50, 150, 150},
        {80, 240, 240, 80, 50, 50, 150, 150},
        {80, 160, 160, 60, 200, 210, 250, 240} } ;

int texture_number[texture_frames] =
  { 1, 1, 1, 2, 2, 2, 3, 3, 3 } ;

int map_x[4], map_y[4] ;
void *fli_pic;

extern FLI *fliptr;

/* function prototypes */

int do_logo(void) ;
void draw_stars(int steps) ;
void draw_stars_2d(void) ;
int init_intro(void) ;
void scroll_stars(int deplacement) ;
int do_intro(void);

int do_logo(void)
{
        int i ;
        RGB temp_palette[256] ;
        RGB temp_palette2[256] ;
        RGB alt_rgb2[256] ;

        if (!load_pic("dnlogo1.pcx", screen_addr, alt_rgb2))
          {
                return(0) ;
          }
        copy_frame_buffer() ;
        ClearPalette(temp_palette) ;
        for (i = 1 ; i < 128 ; i++)
          {
                wait_retrace() ;
                pal_set_colour(i, 63, 0, 0) ;
                temp_palette[i].r = 63 ;
                temp_palette2[i].r = 63 ;
                temp_palette2[i].g = 0 ;
                temp_palette2[i].b = 0 ;
                if (keyTest(KEY_SPACE) || keyTest(KEY_ESC))
                  {
                        return(-1) ;
                  }
          }
        temp_palette2[0].r = 0 ;
        temp_palette2[0].g = 0 ;
        temp_palette2[0].b = 0 ;
        for (i = 128 ; i < 256 ; i++)
          {
                temp_palette2[i].r = 63 ;
                temp_palette2[i].g = 63 ;
                temp_palette2[i].b = 63 ;
          }
        pal_setup_fade(temp_palette2, temp_palette) ;
        ClearPalette(temp_palette) ;
        i = 64 ;
        while (i > 0)
          {
                i = pal_do_fade(temp_palette2, 2) ;
                SetPalette(& temp_palette2[0]) ;
                if (keyTest(KEY_SPACE) || keyTest(KEY_ESC))
                  {
                        return(-1) ;
                  }
          }
        pal_setup_fade(alt_rgb2, temp_palette2) ;
        i = 64 ;
        while (i > 0)
          {
                i = pal_do_fade(temp_palette2, 2) ;
                SetPalette(& temp_palette2[0]) ;
                if (keyTest(KEY_SPACE) || keyTest(KEY_ESC))
                  {
                        return(-1) ;
                  }
          }
        pal_setup_fade(temp_palette, alt_rgb2) ;
        i = 64 ;
        while (i > 0)
          {
                i = pal_do_fade(temp_palette, 2) ;
                SetPalette(& temp_palette[0]) ;
                if (keyTest(KEY_SPACE) || keyTest(KEY_ESC))
                  {
                        return(-1) ;
                  }
          }
        return(-1) ;
}

/* this draws the stars in the background */
void draw_stars(int steps)
{
        int i, j, k ;

        cls(0) ;
        for (i = 0 ; i < num_stars ; i++)
          {
                for (j = 0 ; j < steps ; j++)
                  {
                        stars_x[i] += delta_x ;
                        stars_y[i] += delta_y ;
                        stars_z[i] += delta_z ;
                  }
                if (stars_z[i] < 1)
                  {                                                     /* safety check against zero divisions */
                        place_star(i) ;
                  }
                j = (stars_x[i] / stars_z[i]) + (320 / 2) ;
                k = (stars_y[i] / stars_z[i]) + (200 / 2) ;
                if ( (0 <= j) && (j < 320) && (0 <= k) && (k < 200))
                  {
										// stars must not overwrite the textures!
				             if(* ( ( (unsigned char *) screen_addr) + j + (320 * k)) == 0)
                        * ( ( (unsigned char *) screen_addr) + j + (320 * k)) = stars_col[i] ;
                  }
                else
                  {
                        place_star(i) ;
                  }
          }
}

void draw_stars_2d(void)
{
        int i ;

        cls(0) ;
        for (i = 0 ; i < num_stars ; i++)
          {
							// stars must not overwrite the textures!
             if(*((unsigned char *) screen_addr + stars_pos[i]) == 0)
                * ((unsigned char *) screen_addr + stars_pos[i]) = stars_col[i] ;
          }
}

int init_intro(void)
{
        int i ;

        ClearPalette(& alt_rgb[0]) ;
        if (!load_pic("intro1.pcx", screen_addr, alt_rgb))
          {
                return(0) ;
          }
        oldget(0, 0, 159, 99, & text_block[0]) ;
        oldget(160, 0, 319, 99, & text_block[1]) ;
        oldget(0, 100, 159, 199, & text_block[2]) ;
        oldget(160, 100, 319, 199, & text_block[3]) ;

/*	if(!load_pic("CODING.PIX", screen_addr, alt_rgb))
		return(0) ;
	oldget(0, 0, 319, 199, &text_block[1]);
	if(!load_pic("GFX.PIX", screen_addr, alt_rgb))
		return(0) ;
	oldget(0, 0, 319, 199, &text_block[2]);
	if(!load_pic("MUSIC.PIX", screen_addr, alt_rgb))
		return(0) ;
	oldget(0, 0, 319, 199, &text_block[3]); */

        for (i = 0 ; i < num_stars ; i++)
          {
                place_star(i) ;
          }
        return(-1) ;
}

void do_mapping_bit(void)
{
	int i, j, k, l;
	int play;

	if(fliptr != NULL)
		play_frame(fliptr, fli_pic, 320);
	else
	{
		load_pic("ABSPANN.PIX", fli_pic, alt_rgb);
		SetPalette(alt_rgb);
	}

	play = 0;
	for(k = 0; k < texture_frames; k++)
	{
//		i = timer();
		j = timer();
		while ((timer() - j) < credit_time)
		{
			i = timer();
			if(fliptr != NULL)
				if(play % 2 == 0)
					if(fliptr->current < fliptr->frames - 1)
						play_frame(fliptr, fli_pic, 320);
			putvollbild(fli_pic);
			play++;

//			draw_stars(timer() - i);

			for (l = 0 ; l < 4 ; l++)
			{
				map_x[l] = credit_positions[2 * k][l] +	(credit_positions[2 * k + 1][l] - credit_positions[2 * k][l]) * (i - j) / credit_time;
				map_y[l] = credit_positions[2 * k][l + 4] + (credit_positions[2 * k + 1][l + 4] - credit_positions[2 * k][l + 4]) * (i - j) / credit_time;
			} /* for */
			map_quad(&map_x[0], &map_y[0], &text_block[texture_number[k]]);

			while(timer() - i < 2)
				;

			wait_retrace();
			copy_frame_buffer();
			if(keyTest(KEY_SPACE) || keyTest(KEY_ESC))
				return;
		}
	} /* for */
} /* do_mapping_bit */

void scroll_stars(int deplacement)
{
        int i ;

        for (i = 0 ; i < num_stars ; i++)
          {
                stars_pos[i] += deplacement ;
                if (stars_pos[i] < 0)
                  {
                        stars_pos[i] += 320 * 200 ;
                  }
                if (stars_pos[i] > 320 * 200)
                  {
                        stars_pos[i] -= 320 * 200 ;
                  }
          } /* for */
}

int do_intro(void)
{
        int i, j ;
        short palette_timer = 256 ;

        RGB temp_palette[256] ;
        RGB temp_palette2[256] ;

        if (!init_intro())
          {
                return(0) ;
          }
/*        if (!do_logo())
          {
                return(0) ;
          } */

	if(keyTest(KEY_SPACE) || keyTest(KEY_ESC))
		return(1);

  fliptr = load_fli("SPIEL.FLI", FLI_DISK);

/*        clear_palette(temp_palette) ;
        pal_setup_fade(alt_rgb, temp_palette) ;
        i = timer() ;
        while (palette_timer > 0)
          {
                while (i == timer()) ;
                draw_stars(timer() - i) ;
                palette_timer = pal_do_fade(temp_palette2, (timer() - i) * 2) ;
                SetPalette(& temp_palette2[0]) ;
                i = timer() ;
                copy_frame_buffer() ;
                if (keyTest(KEY_SPACE) || keyTest(KEY_ESC))
                  {
                        return(-1) ;
                  }
          }
        j = timer() ;
        while ((i - j) < 512)
          {
                while (i == timer()) ;
                draw_stars(timer() - i) ;
                i = timer() ;
                copy_frame_buffer() ;
                if (keyTest(KEY_SPACE) || keyTest(KEY_ESC))
                  {
                        return(-1) ;
                  }
          }
        SetPalette(& alt_rgb[0]) ; */

	fli_pic = malloc(screen_width * screen_height);
  do_mapping_bit() ;
	free(fli_pic);
/*        if (keyTest(KEY_SPACE) || keyTest(KEY_ESC))
          {
                return(-1) ;
          }
        i = timer() ;
        while (delta_z < 0)
          {
                draw_stars(timer() - i) ;
                i = timer() ;
                delta_z++ ;
                copy_frame_buffer() ;
                if (keyTest(KEY_SPACE) || keyTest(KEY_ESC))
                  {
                        return(-1) ;
                  }
                while(i == timer()) ;
                draw_stars(timer() - i) ;
                i = timer() ;
                copy_frame_buffer() ;
                if (keyTest(KEY_SPACE) || keyTest(KEY_ESC))
                  {
                        return(-1) ;
                  }
                while(i == timer()) ;
          }
        for (i = 0 ; i < num_stars ; i++)
          {
                stars_pos[i] = (stars_x[i] / stars_z[i]) + (320 / 2) +
                        ((stars_y[i] / stars_z[i]) + (200 / 2)) * 320 ;
          } */

	if(fliptr != NULL)
		close_fli(fliptr);

        return(-1) ;
}
/*
int main(void)
{
        if (!init_gfx(0x13))
          {
                return(255) ;
          }
        if (!do_intro())
          {
                return(255) ;
          }
        exit_gfx() ;
        return(0) ;
} */
