/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*******************************/
/* Eine Highscore aus mehreren */
/* fr Terroid                 */
/* (C) 1996 by Michael Haar    */
/*******************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dn.h>

#define HISCORE_ENTRIES 10

/* globale Variablen */
struct
{
	int punkte;
	char name[20];
} highscore_entry[HISCORE_ENTRIES];

struct
{
	int punkte;
	char name[20];
} merge_entry[HISCORE_ENTRIES];

/* Funktionsprototypen */

/* Funktionen */
long hsc_checksum(BOOLEAN nur_punkte)
{
	int i, t;
	long sum;

	sum = 0;
	for(i = 0; i < HISCORE_ENTRIES; i++)
	{
		sum += highscore_entry[i].punkte;
		if(!nur_punkte)
			for(t = 0; t < strlen(highscore_entry[i].name); t++)
				sum += highscore_entry[i].name[t];
	}

	return(sum);
}

void encode_hiscore()
{
	int i, t;
	char buffer[2];

	for(i = 0; i < HISCORE_ENTRIES; i++)
	{
		// Vertauscher zur Sicherheit
		buffer[0] = highscore_entry[i].name[19];
		buffer[1] = highscore_entry[i].name[0];
		highscore_entry[i].name[0] = (char)((highscore_entry[i].punkte & 0xFF00) >> 8);
		highscore_entry[i].name[19] = (char)(highscore_entry[i].punkte & 0xFF);
		highscore_entry[i].punkte &= 0xFFFF0000;
		highscore_entry[i].punkte += ((int)buffer[0] << 8);
		highscore_entry[i].punkte += (int)buffer[1];

		// Alles invertieren
		highscore_entry[i].punkte = ~highscore_entry[i].punkte;
		for(t = 0; t < 20; t++)
			highscore_entry[i].name[t] = ~highscore_entry[i].name[t];
	}
}

void decode_hiscore()
{
	int i, t;
	char buffer[2];

	for(i = 0; i < HISCORE_ENTRIES; i++)
	{
		// Invertieren
		highscore_entry[i].punkte = ~highscore_entry[i].punkte;
		for(t = 0; t < 20; t++)
			highscore_entry[i].name[t] = ~highscore_entry[i].name[t];

		// Vertauscher
		buffer[0] = (char)((highscore_entry[i].punkte & 0xFF00) >> 8);
		buffer[1] = (char)(highscore_entry[i].punkte & 0xFF);
		highscore_entry[i].punkte &= 0xFFFF0000;
		highscore_entry[i].punkte += (int)(highscore_entry[i].name[0] << 8);
		highscore_entry[i].punkte += (int)highscore_entry[i].name[19];
		highscore_entry[i].name[0] = buffer[1];
		highscore_entry[i].name[19] = buffer[0];		
	}
}

void reset_hiscore()
{
	int i;

	for(i = 0; i < HISCORE_ENTRIES; i++)
	{
		highscore_entry[i].punkte = 100000 - i * 7500;
		if(i == 0)
			strcpy(highscore_entry[i].name, "MICHAEL HAAR");
		else if(i == 1)
			strcpy(highscore_entry[i].name, "ULRICH HAAR");
		else if(i == 2)
			strcpy(highscore_entry[i].name, "MICHAEL THAYER");
		else if(i == 3)
			strcpy(highscore_entry[i].name, "------------------");
		else if(i == 4)
			strcpy(highscore_entry[i].name, "      TERROID     ");
		else if(i == 5)
			strcpy(highscore_entry[i].name, "     THE GAME     ");
		else if(i == 6)
			strcpy(highscore_entry[i].name, "DIGITAL NIGHTMARES");
		else if(i == 7)
			strcpy(highscore_entry[i].name, "     - 1996 -     ");
		else if(i == 8)
			strcpy(highscore_entry[i].name, "------------------");
		else if(i == 9)
			strcpy(highscore_entry[i].name, "!NOT GOOD ENOUGH!");
	}
}

void save_hiscore()
{
	FILE *datei;
	long chksum;

	datei = fopen("HISCORE.DAT", "wb");
	if(datei)
	{
		// Check ohne Kodierung
		chksum = hsc_checksum(FALSE);
		fwrite(&chksum, sizeof(long), 1, datei);
		encode_hiscore();
		fwrite(&chksum, sizeof(long), 1, datei);
		fwrite(&highscore_entry[0], sizeof(highscore_entry[0]), HISCORE_ENTRIES / 2, datei);
		// Check mit Kodierung
		chksum = hsc_checksum(TRUE);
		fwrite(&chksum, sizeof(long), 1, datei);
		fwrite(&highscore_entry[HISCORE_ENTRIES / 2], sizeof(highscore_entry[0]), HISCORE_ENTRIES / 2, datei);
		fwrite(&chksum, sizeof(long), 1, datei);
		fclose(datei);

		decode_hiscore();
	}
}

void load_hiscore(int nr)
{
	FILE *datei;
	char hscname[128];
	long chksum, pruef_chksum;

	sprintf(hscname, "HISCORE.%d", nr);
	datei = fopen(hscname, "rb");
	if(datei == NULL)
	{
		puts("\7");
		reset_hiscore();
		save_hiscore();
	}
	else
	{
		fread(&pruef_chksum, sizeof(long), 1, datei);
		fread(&chksum, sizeof(long), 1, datei);
		fread(&highscore_entry[0], sizeof(highscore_entry[0]), HISCORE_ENTRIES / 2, datei);
		fread(&chksum, sizeof(long), 1, datei);
		fread(&highscore_entry[HISCORE_ENTRIES / 2], sizeof(highscore_entry[0]), HISCORE_ENTRIES / 2, datei);
		fread(&chksum, sizeof(long), 1, datei);
		fclose(datei);

		// Check mit Kodierung
		if(chksum != hsc_checksum(TRUE))
		{
			puts("\7");
			reset_hiscore();
			save_hiscore();
		}
		decode_hiscore();
		// Check ohne Kodierung
		if(pruef_chksum != hsc_checksum(FALSE))
		{
			puts("\7");
			reset_hiscore();
			save_hiscore();
		}
	}
}

void hiscore_eintragen(int nr)
{
	int i;
	int pos;

	for(i = 0; i < HISCORE_ENTRIES; i++)
		if(highscore_entry[i].punkte < merge_entry[nr].punkte)
			break;

	if(i < HISCORE_ENTRIES)
	{
		pos = i;
		// verschieben
		for(i = HISCORE_ENTRIES - 1; i > pos; i--)
			highscore_entry[i] = highscore_entry[i - 1];

		highscore_entry[pos].punkte = merge_entry[nr].punkte;
		strcpy(highscore_entry[pos].name, merge_entry[nr].name);
	}
}

/* Hauptprogramm */
int main()
{
	int i;

	printf("HIGHSCORE - MERGER for Terroid\n\n");
	printf("Merging files 'HISCORE.1' and 'HISCORE.2' to 'HISCORE.DAT' ...\n\n");

	load_hiscore(1);
	memcpy(merge_entry, highscore_entry, sizeof(highscore_entry[0]) * HISCORE_ENTRIES);

	load_hiscore(2);

	for(i = 0; i < HISCORE_ENTRIES; i++)
		hiscore_eintragen(i);

	printf("Saving new 'HISCORE.DAT' ...\n");

	save_hiscore();

	return(0);
}
