/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/***********************************/
/* ballerspiel-hintergrundroutinen */
/* (C) April 1996 by Michael Haar  */
/***********************************/

/* nderungen: */

#include <stdlib.h>
#include <string.h>
#include <dn.h>
#include "DEFS.H"
#include "FUNCS.H"
#include "VARS.H"

/* globale Variablen */
void *hintergrundpix[ANZ_HINTERGRUENDE];
GFXBLK bg_pix[ANZ_HINTERGRUENDE] ;
BOOLEAN is_init[ANZ_HINTERGRUENDE] ;
BOOLEAN initialised = FALSE ;

/* Funktionsprototypen */
BOOLEAN init_hintergrund(unsigned char level);
void hintergrund();

/* Funktionen */

/* Loads background (level/training) graphics, freeing previous if necessary */

BOOLEAN init_bg(unsigned char level)
{
	int i ;
	char name[20] ;

	for (i = 0 ; i < ANZ_HINTERGRUENDE ; i++) {
		if (initialised && is_init[i]) free_blk(& bg_pix[i]) ;
		is_init[i] = TRUE ;
		if (game_difficulty == TRAINING)
			sprintf(name, "thinter%d.pix", i + 1) ;
		else
			sprintf(name, "hinter%d%d.pix", level / 3 + 1, i + 1) ;
		if (load_pic(name, screen_addr, alt_rgb))
			get(0, 0, screen_width, screen_height, & bg_pix[i]) ;
		else {
			if (i == 0) return(FALSE) ;
			bg_pix[i] = bg_pix[0] ;
			is_init[i] = FALSE ;
		}
	}
	initialised = TRUE ;
	return(TRUE) ;
}


/* Draws the level background (very inefficient, should be fixed) */

void background(void)
{
	if (!do_draw) return ;
	if ((!game_view == FULL) && (!game_view == HIGH)) {
		cls(0) ;
		return ;
	}
	put(-(game_scrollpos / 2 % 320), 0, & bg_pix[game_scrollpos / 2
		/ 320 % ANZ_HINTERGRUENDE]) ;
	put(320 - (game_scrollpos / 2 % 320), 0, & bg_pix[(game_scrollpos
		/ 2 / 320 + 1) % ANZ_HINTERGRUENDE]) ;
}


BOOLEAN init_hintergrund(unsigned char level)
{
	int i;

	for(i = 0; i < ANZ_HINTERGRUENDE; i++)
	{
		if(level == 0)
			if(!hintergrundpix[i])
				hintergrundpix[i] = malloc(screen_width * screen_height);

		// je drei Level mit gleichem Hintergrund oder Trainingspiel
		if(game_difficulty == TRAINING)
			sprintf(txt, "THINTER%d.PIX", i + 1);
		else
			sprintf(txt, "HINTER%d%d.PIX", level / 3 + 1, i + 1);
		if(!load_pic(txt, hintergrundpix[i], alt_rgb))
		{
			if(i == 0)
				return(FALSE);
			else
				memmove(hintergrundpix[i], hintergrundpix[0], screen_width * screen_height);
		}
	}

	return(TRUE);
}

void hintergrund(void)
{
	int x1, x2, bis;
	unsigned char *rpos1, *rpos2, *wpos1, *wpos2;
	int h1, h2;

	if (do_draw)
	  {
	    if((game_view == FULL) || (game_view == HIGH))
	      {
		h1 = (game_scrollpos / 2 / 320) % ANZ_HINTERGRUENDE;
		h2 = (h1 + 1) % ANZ_HINTERGRUENDE;

		x1 = 320 - ((game_scrollpos / 2) % 320);
		x2 = 320 - x1;
		rpos1 = (unsigned char *)((long)hintergrundpix[h1] + x2);
		wpos1 = screen_addr;
		rpos2 = hintergrundpix[h2];
		wpos2 = (unsigned char *)((long)screen_addr + x1);
		bis = screen_height;
		while(bis--)
		{
			memmove(wpos1, rpos1, x1);
			rpos1 += 320;
			wpos1 += 320;
			memmove(wpos2, rpos2, x2);
			rpos2 += 320;
			wpos2 += 320;
		}
	      }
	    else
		cls(0);
	  } /* if (do_draw) */
}
