/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**************************************/
/* SternePIXextro fr Terroid         */
/* (C) September 1996 by Michael Haar */
/**************************************/

#include <stdlib.h>
#include <dn.h>

#define MAX_EXTROSTERNE 1000

/* globale Variablen */
struct
{
	int x;
	int y;
	int z;
} extrostern[MAX_EXTROSTERNE];

/* Funktionsprototypen */
void init_extrosterne();
void extrosterne();
void extro();

/* Funktionen */
void init_extrosterne()
{
	int i;

	for(i = 0; i < MAX_EXTROSTERNE; i++)
	{
		extrostern[i].x = (rand() % screen_width) - screen_width / 2;
		extrostern[i].y = (rand() % screen_height) - screen_height / 2;
		extrostern[i].z = rand() % 256;
	}
}

void extrosterne()
{
	int i, px, py;
	unsigned char *addr;

	for(i = 0; i < MAX_EXTROSTERNE; i++)
		if(extrostern[i].z)
		{
			px = extrostern[i].x * 256 / extrostern[i].z + screen_width / 2;
			py = extrostern[i].y * 256 / extrostern[i].z + screen_height / 2;
			if((px >= clip_x1) && (py >= clip_y1) && (px < clip_x2) && (py < clip_y2))
			{
				addr = (unsigned char *)((long)screen_addr + px + py * screen_width);
				if(*addr == 0)
					*addr = 31 - (extrostern[i].z * 31 / 256);
			}

			extrostern[i].z--;
			if(extrostern[i].z == 0)
				extrostern[i].z = 256;
		}
}

void extro()
{
	void *showpic[3];
	long t;
	BOOLEAN ende, key;
	int akt_pic, counter;

	showpic[0] = malloc(screen_width * screen_height);
	showpic[1] = malloc(screen_width * screen_height);
	showpic[2] = malloc(screen_width * screen_height);

	load_pic("CODING.PIX", screen_addr, alt_rgb);
	getvollbild(showpic[0]);
	load_pic("GFX.PIX", screen_addr, alt_rgb);
	getvollbild(showpic[1]);
	load_pic("MUSIC.PIX", screen_addr, alt_rgb);
	getvollbild(showpic[2]);

	init_extrosterne();

	putvollbild(showpic[0]);
	extrosterne();
	Copy2Screen();
	SetPalette(alt_rgb);

	t = timer();
	ende = FALSE;
	counter = akt_pic = 0;
	key = FALSE;
	while(!ende)
	{
		if(timer() - t > 1)
		{
			t = timer();

			putvollbild(showpic[akt_pic]);
			extrosterne();
			wait_retrace();
			Copy2Screen();

			counter++;
			if(counter > 1000)
			{
				counter = 0;
				akt_pic++;
				if(akt_pic > 2)
					ende = TRUE;
			}

			if(keyTest(KEY_ESC) || keyTest(KEY_RCTRL) || keyTest(KEY_LCTRL) || keyTest(KEY_SPACE) || keyTest(KEY_ENTER))
			{
				if(!key)
				{
					counter = 0;
					akt_pic++;
					if(akt_pic > 2)
						ende = TRUE;
					key = TRUE;
				}
			}
			else
				key = FALSE;
		}
	}

	free(showpic[0]);
	free(showpic[1]);
	free(showpic[2]);
}
