/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**********************************/
/* ballerspiel-Extraroutinen      */
/* (C) April 1996 by Michael Haar */
/**********************************/

#include <stdlib.h>
#include <string.h>
#include <dn.h>
#include "DEFS.H"
#include "FUNCS.H"
#include "VARS.H"

#define EXTRAFAC 4

/* globale Variablen */
EXTRA extra[MAX_EXTRAS];
GFXBLK extrapix[ANZ_EXTRAPICS];

/* Funktionsprototypen */
BOOLEAN extras_init(unsigned char level);
int extra_start(int anz, int art);
void extra_new(int nr, int x, int y, int art);
void delete_extra(int nr);
void extras(void);

/* Funktionen */
BOOLEAN extras_init(unsigned char level)
{
	int i;

	for(i = 0; i < MAX_EXTRAS; i++)
		extra[i].komm_zaehler = 99;

	if(level == 0)
	{
		// und laden
		if(!load_pic("EXTRA.PIX", screen_addr, alt_rgb))
			return(FALSE);
		for(i = 0; i < 5; i++)
		{
			get(0, 40 * i, 37, 40 * i + 36, &extrapix[i * ANZ_EXTRASTUFEN]);
			get(42, 40 * i, 74, 40 * i + 36, &extrapix[i * ANZ_EXTRASTUFEN + 1]);
			get(83, 40 * i, 112, 40 * i + 36, &extrapix[i * ANZ_EXTRASTUFEN + 2]);
			get(118, 40 * i, 143, 40 * i + 36, &extrapix[i * ANZ_EXTRASTUFEN + 3]);
			get(150, 40 * i, 179, 40 * i + 36, &extrapix[i * ANZ_EXTRASTUFEN + 4]);
			get(190, 40 * i, 222, 40 * i + 36, &extrapix[i * ANZ_EXTRASTUFEN + 5]);
		}
		if(!load_pic("EXTRA2.PIX", screen_addr, alt_rgb))
			return(FALSE);
		for(i = 0; i < 5; i++)
		{
			get(0, 40 * i, 37, 40 * i + 36, &extrapix[(i + 5) * ANZ_EXTRASTUFEN]);
			get(42, 40 * i, 74, 40 * i + 36, &extrapix[(i + 5) * ANZ_EXTRASTUFEN + 1]);
			get(83, 40 * i, 112, 40 * i + 36, &extrapix[(i + 5) * ANZ_EXTRASTUFEN + 2]);
			get(118, 40 * i, 143, 40 * i + 36, &extrapix[(i + 5) * ANZ_EXTRASTUFEN + 3]);
			get(150, 40 * i, 179, 40 * i + 36, &extrapix[(i + 5) * ANZ_EXTRASTUFEN + 4]);
			get(190, 40 * i, 222, 40 * i + 36, &extrapix[(i + 5) * ANZ_EXTRASTUFEN + 5]);
		}
	}

	return(TRUE);
}

int extra_start(int anz, int art)
{
	int i;

	i = 0;
	while((i < MAX_EXTRAS) && (extra[i].komm_zaehler < 99))
		i++;
	if(i < MAX_EXTRAS)
	{
		extra[i].nr = art;
		extra[i].komm_zaehler = anz;

		return(i);
	}
	else
		return(-1);
}

void extra_new(int nr, int x, int y, int art)
{
	if(nr > -1)
	{
		if(extra[nr].nr > 0)
			extra[nr].nr = art;
		extra[nr].anistufe = ANZ_EXTRASTUFEN * EXTRAFAC - 1;
		extra[nr].x = x;
		extra[nr].y = y;
		extra[nr].komm_zaehler--;
	}
}

void delete_extra(int nr)
{
	if(nr > -1)
		extra[nr].komm_zaehler = 99;
}

void extras(void)
{
	int i, pixnr;
	int xr, yr, xw, yh;

	for(i = 0; i < MAX_EXTRAS; i++)
		if(extra[i].komm_zaehler == 0)
		{
			// Extra zulaessig?
			if(extra[i].nr < 1)
				delete_extra(i);
			else
			{
				extra[i].anistufe -= 1;
				if(extra[i].anistufe < 0)
					extra[i].anistufe = ANZ_EXTRASTUFEN * EXTRAFAC - 1;
				pixnr = (extra[i].nr - 1) * ANZ_EXTRASTUFEN + extra[i].anistufe / EXTRAFAC;
				if (do_draw)
				  {
				    objput(extra[i].x - extrapix[pixnr].w / 2, extra[i].y - extrapix[pixnr].h / 2, &extrapix[pixnr]);
				  } /* if (do_draw) */
				extra[i].x -= (MITTE_SCROLLGESCHW + 1);

				// Exra aus Bild?	
				if(extra[i].x <= -32)
					delete_extra(i);
	
				// Aufgesammelt?
				xr = abs(spieler.x - extra[i].x);
				yr = abs(spieler.y - extra[i].y);
				xw = extrapix[extra[i].anistufe].w / 2 + 15;
				yh = extrapix[extra[i].anistufe].h / 2 + 10;
	
				if((xr < xw) && (yr < yh) && !spieler.absturz)
				{
					// Kollision mit Spieler
					delete_extra(i);
					switch(extra[i].nr)
					{
						case 1:
							// Laser
							if (sounddevice != 4) start_sample(extrasnd[8], md_numchn - 1);
							if(spieler.waffe[1] < ANZ_LASERSTUFEN)
								spieler.waffe[1]++;
							else if(game_difficulty == BABY)
								spieler.punkte += 250;
							else if(game_difficulty == BEGINNER)
								spieler.punkte += 375;
							else
							{
								spieler.punkte += 500;
								spieler.energie += 5;
							}
							break;
						case 3:
							// Raketen
							if (sounddevice != 4) start_sample(extrasnd[8], md_numchn - 1);
							if(spieler.waffe[2] < 3)	// im Moment 3 Stufen
								spieler.waffe[2]++; 
							else if(game_difficulty == BABY)
								spieler.punkte += 250;
							else if(game_difficulty == BEGINNER)
								spieler.punkte += 375;
							else
							{
								spieler.punkte += 500;
								spieler.energie += 5;
							}
							break;
						case 5:
							// Energie
							if (sounddevice != 4) start_sample(extrasnd[8], md_numchn - 1);
							if(spieler.energie <= 50)
								spieler.energie += 50;
							else
							{
								spieler.punkte += 5 * (spieler.energie - 50);
								spieler.energie = 100;
							}
							break;
						case 2:
							// Schild
							if (sounddevice != 4) start_sample(extrasnd[8], md_numchn - 1);
							if(spieler.schild < 0)
								SetColors(gamepal, 0, 256);
							spieler.schild += 250 * SPEED_FAC;
							break;
						case 4:
							// Bomb
							if (sounddevice != 4) start_sample(extrasnd[8], md_numchn - 1);
							if(spieler.smartbomb < 16)
							{
								if(spieler.smartbomb > 0)
									SetColors(gamepal, 0, 256);
								spieler.smartbomb = 16;
							}
							else if(game_difficulty == BABY)
								spieler.punkte += 250;
							else if(game_difficulty == BEGINNER)
								spieler.punkte += 375;
							else
							{
								spieler.punkte += 500;
								spieler.energie += 5;
							}
							break;
						case 6:
							// Tod
							if (sounddevice != 4) start_sample(warningsnd, md_numchn - 1);

							if(strcmp(cheatmode, "IAMGOD"))
							{
								spieler.absturz = (200 - spieler.y) / 2 + 60;
								spieler.schild = 0;
								spieler.energie = 0;
							}
							break;
						case 7:
							// roter V-Schuss
							if (sounddevice != 4) start_sample(extrasnd[8], md_numchn - 1);
							if(spieler.waffe[3] < 3)
								spieler.waffe[3]++;
							else if(game_difficulty == BABY)
								spieler.punkte += 250;
							else if(game_difficulty == BEGINNER)
								spieler.punkte += 375;
							else
							{
								spieler.punkte += 500;
								spieler.energie += 5;
							}
							break;
						case 8:
							// Minen
							if (sounddevice != 4) start_sample(extrasnd[8], md_numchn - 1);
							if(spieler.waffe[4] < MAX_PLAYERMINES)
								spieler.waffe[4]++;
							else if(game_difficulty == BABY)
								spieler.punkte += 250;
							else if(game_difficulty == BEGINNER)
								spieler.punkte += 375;
							else
							{
								spieler.punkte += 500;
								spieler.energie += 5;
							}
							break;
						case 9:
							// Bonuspunkte
							if (sounddevice != 4) start_sample(extrasnd[8], md_numchn - 1);
							if(game_difficulty == BABY)
								spieler.punkte += 500;
							else if(game_difficulty == BEGINNER)
								spieler.punkte += 750;
							else
								spieler.punkte += 1000;
							break;
						case 10:
							// Leben
							if (sounddevice != 4) start_sample(extrasnd[8], md_numchn - 1);
							spieler.leben++;
							break;
					}
					if(spieler.energie > 100)
						spieler.energie = 100;
				}
			}
		}
}
