/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**********************************/
/* ballerspiel-Explosionsarten    */
/* (C) April 1996 by Michael Haar */
/**********************************/

/* nderungen: */

#include <stdlib.h>
#include <dn.h>
#include "DEFS.H"
#include "FUNCS.H"
#include "VARS.H"

/* globale Variablen */
EXPLOSION explo[MAX_EXPLOS];
GFXBLK explopix[ANZ_EXPLOS];

/* Funktionsprototypen */
void reset_explosionen();
BOOLEAN init_explos(unsigned char level);
void explode(int x, int y, int w, int h, unsigned char art);
void explosionen(void);
void erzeuge_schrott(int x, int y);

/* Funktionen */
void reset_explosionen()
{
	int i;

	for(i = 0; i < MAX_EXPLOS; i++)
		explo[i].anistufe = 0;
}

BOOLEAN init_explos(unsigned char level)
{
	reset_explosionen();

	if(level == 0)
	{
		// und laden
		if(!load_pic("SCHUESSE.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(1, 56, 17, 69, &explopix[12]); // Rauch
		get(20, 56, 36, 69, &explopix[11]);
		get(39, 56, 55, 69, &explopix[10]);
		get(58, 56, 74, 69, &explopix[9]);
		get(77, 56, 92, 69, &explopix[8]);
		get(92, 68, 93, 69, &explopix[7]);
	
		if(!load_pic("EXPLO3.PIX", screen_addr, alt_rgb))
			return(FALSE);
	
		get(193, 10, 211, 27, &explopix[17]); //kleine explo
		get(219, 11, 236, 27, &explopix[16]);
		get(243, 10, 263, 29, &explopix[15]);
		get(190, 40, 211, 59, &explopix[14]);
		get(220, 41, 240, 60, &explopix[13]);
	
		get(22, 119, 43, 138, &explopix[6]);
		get(55, 111, 97, 146, &explopix[5]);
		get(108, 104, 158, 148, &explopix[4]);
		get(168, 107, 219, 150, &explopix[3]);
		get(228, 106, 281, 151, &explopix[2]);
		get(23, 44, 81, 84, &explopix[1]);
		get(90, 50, 143, 89, &explopix[0]);

		if(!load_pic("GEXPLO1.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(0, 0, 59, 54, &explopix[23]);
		get(64, 2, 160, 87, &explopix[22]);
		get(164, 6, 276, 104, &explopix[21]);
		get(2, 92, 125, 199, &explopix[20]);
		if(!load_pic("GEXPLO2.PIX", screen_addr, alt_rgb))
			return(FALSE);
		get(2, 4, 128, 115, &explopix[19]);
		get(145, 9, 282, 126, &explopix[18]);
	}

	return(TRUE);
}

void erzeuge_schrott(int x, int y)
{
	int i;

	x += (rand() % 30) - 15;
	y += (rand() % 30) - 15;

	i = 0;
	while((i < MAX_OBJEKTE) && objekt[i].nr)
		i++;

	if(i < MAX_OBJEKTE)
	{
		objekt[i].nr = GEGNERPICS + 157 + (rand() % 4) * 4 ;
		objekt[i].art = 200;
		objekt[i].anistufe = 0;
		objekt[i].anz_anistufen = 4;
		objekt[i].startpause = 0;
		objekt[i].bahn.anz = 1;
		objekt[i].bahn.akt = 0;
		objekt[i].bahn.kurve[0].len = 0; //unwichtig
		objekt[i].bahn.x = x * KURVENFAC;
		objekt[i].bahn.y = y * KURVENFAC;
		objekt[i].bahn.kurve[0].xpl = rand() % 10 + 25;
		objekt[i].bahn.kurve[0].ypl = rand() % 360;
		objekt[i].bahn.kurve[0].xxpl = -((rand() % 4) + 2);
		objekt[i].bahn.kurve[0].yypl = 40;
		objekt[i].energie = 100;
		objekt[i].extra_listnr = -1;
		objekt[i].extra = 0;
	}
}

void explode(int x, int y, int w, int h, unsigned char art)
{
	int i, n;

	i = 0;
	while((i < MAX_EXPLOS) && explo[i].anistufe)
		i++;
	if(i < MAX_EXPLOS)
	{
		explo[i].w = 0;
		explo[i].h = 0;
		switch(art)
		{
			case 0:
				// Gegner explodiert
				explo[i].nr = 0;
				explo[i].anistufe = 7 * ANIFAC;
				explo[i].w = w;
				explo[i].h = h;
				if(game_view == FULL)
					for (n = 0; n < (rand() % 5) + 6; n++)
						erzeuge_schrott(x, y);

				if (sounddevice != 4) start_sample(explo1snd, md_numchn - rand() % 2 - 3);
//				play_sound();

				break;
			case 1:
				// Raketenrauch
				explo[i].nr = 7;
				explo[i].anistufe = 6 * ANIFAC;
				break;
			case 2:
				// schuss explo
				explo[i].nr = 13;
				explo[i].anistufe = 5 * ANIFAC;

				if (sounddevice != 4) start_sample(scratchsnd, md_numchn - 2);
				break;
			case 3:
				// riesen explo
				explo[i].nr = 18;
				explo[i].anistufe = 5 * ANIFAC;
				break;
		}
		explo[i].x = x;
		explo[i].y = y;
	}
}

void explosionen(void)
{
	int i, pixnr;

	for(i = 0; i < MAX_EXPLOS; i++)
		if(explo[i].anistufe > 0)
		{
			explo[i].anistufe -= 2 * SPEED_FAC;
			pixnr = explo[i].nr + explo[i].anistufe / ANIFAC;
			if (do_draw)
			  {
//			    if((explo[i].w == 0) || (explo[i].h == 0))
				objput(explo[i].x - explopix[pixnr].w / 2, explo[i].y - explopix[pixnr].h / 2, &explopix[pixnr]);
//			    else
//				objzoom(explo[i].x - explopix[pixnr].w / 2, explo[i].y - explopix[pixnr].h / 2, explo[i].w, explo[i].h, &explopix[pixnr]);
			  } /* if (do_draw) */
			explo[i].x -= MITTE_SCROLLGESCHW;
		}
}
