/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/***********************************/
/* Endgegnerfunktionen fr TERROID */
/* (C) Juli 1996, Michael Haar     */
/***********************************/

#include <stdlib.h>
#include <dn.h>
#include "DEFS.H"
#include "VARS.H"
#include "FUNCS.H"

#define MAX_RESTARTOBJS 5

/* globale Variablen */
struct
{
	OBJEKT *obj;
	int x;
	int y;
} restart_koords[MAX_RESTARTOBJS];

/* Funktionsprototypen */
void endgegner_start(OBJEKT *obj);
void endgegner_specialaction(KETTENSTART *startkette);
BOOLEAN endgegner_treffbar(OBJEKT *obj);
int endgegner_energie();
void endgegner_restarten(OBJEKT *obj);
void endgegner_tot(OBJEKT *obj);
BOOLEAN endgegner4_rakwerfer_da();
BOOLEAN endgegner1_kanonen_da();

/* Funktionen */
void endgegner_start(OBJEKT *obj)
{
	if(endmonster.energie_max == 0)
	{
		// registrieren
		endmonster.energie_max = endgegner_energie();
		endmonster.art_da = obj->art;
		endmonster.start_x = (game_scrollpos / 40) * 40;
	}
	endmonster.energie_aktuell += obj->energie;
}

void endgegner_specialaction(KETTENSTART *startkette)
{
	int i, o;

	if(startkette->obj.art == 50)
	{
		// Kanonen bei Endgegnerschiff
		o = 0;
		for(i = 0; i < 4; i++)
		{
			while((o < MAX_OBJEKTE) && objekt[o].nr)
				o++;

			if(o < MAX_OBJEKTE)
			{
				objekt[o] = startkette->obj;
				objekt[o].art = 54;
				objekt[o].nr = GEGNERPICS + 240;
				switch(i)
				{
					case 0:
						objekt[o].bahn.x -= 10 * KURVENFAC;
						objekt[o].bahn.y -= 70 * KURVENFAC;
						break;
					case 1:
						objekt[o].bahn.x += 15 * KURVENFAC;
						objekt[o].bahn.y -= 45 * KURVENFAC;
						break;
					case 2:
						objekt[o].bahn.x += 15 * KURVENFAC;
						objekt[o].bahn.y += 45 * KURVENFAC;
						break;
					case 3:
						objekt[o].bahn.x -= 10 * KURVENFAC;
						objekt[o].bahn.y += 70 * KURVENFAC;
						break;
				}
				objekt[o].energie /= 4;
				objekt[o].weapon_fire = 64;
				objekt[o].weapon_ok = objekt[o].weapon_fire;
				objekt[o].extra_listnr = -1;
				objekt[o].startpause = 0;

				restart_koords[i].obj = &objekt[o];
				restart_koords[i].x = objekt[o].bahn.x;
				restart_koords[i].y = objekt[o].bahn.y;
			}
		}
	}
	else if(startkette->obj.art == 52)
	{
		// Raketenwerfer bei Endgegnerschiff

		// oberer
		o = 0;
		while((o < MAX_OBJEKTE) && objekt[o].nr)
			o++;

		if(o < MAX_OBJEKTE)
		{
			objekt[o] = startkette->obj;
			objekt[o].art = 53;
			objekt[o].nr += 1;
			objekt[o].bahn.y -= 30 * KURVENFAC;
			objekt[o].energie /= 4;
			objekt[o].weapon_fire = 64;
			objekt[o].weapon_ok = objekt[o].weapon_fire;
			objekt[o].extra_listnr = -1;
			objekt[o].startpause = 0;

			restart_koords[0].obj = &objekt[o];
			restart_koords[0].x = objekt[o].bahn.x;
			restart_koords[0].y = objekt[o].bahn.y;
		}
		// unterer
		while((o < MAX_OBJEKTE) && objekt[o].nr)
			o++;

		if(o < MAX_OBJEKTE)
		{
			objekt[o] = startkette->obj;
			objekt[o].art = 53;
			objekt[o].nr += 1;
			objekt[o].bahn.y += 30 * KURVENFAC;
			objekt[o].startpause = 0;
			objekt[o].energie /= 4;
			objekt[o].weapon_fire = 64;
			objekt[o].weapon_ok = objekt[o].weapon_fire;
			objekt[o].extra_listnr = -1;
			objekt[o].startpause = 0;

			restart_koords[1].obj = &objekt[o];
			restart_koords[1].x = objekt[o].bahn.x;
			restart_koords[1].y = objekt[o].bahn.y;
		}
	}
	else if(startkette->obj.art == 60)
	{
		// Haus bei 9. Endgegner
		o = 0;
		while((o < MAX_OBJEKTE) && objekt[o].nr)
			o++;

		if(o < MAX_OBJEKTE)
		{
			objekt[o] = startkette->obj;
			objekt[o].art = 61;
			objekt[o].anistufe = 0;
			objekt[o].anz_anistufen = 1;
			objekt[o].nr = GEGNERPICS + 325;
			objekt[o].weapon_fire = -1;
			objekt[o].extra_listnr = -1;
			objekt[o].startpause = 0;
			objekt[o].bahn.x -= 1 * KURVENFAC;
			objekt[o].bahn.y += 1 * KURVENFAC;

/*			restart_koords[0].obj = &objekt[o];
			restart_koords[0].x = objekt[o].bahn.x;
			restart_koords[0].y = objekt[o].bahn.y; */
		}
		// Kanonen bei 9. Endgegner
		for(i = 0; i < 4; i++)
		{
			o = 0;
			while((o < MAX_OBJEKTE) && objekt[o].nr)
				o++;
	
			if(o < MAX_OBJEKTE)
			{
				objekt[o] = startkette->obj;
				objekt[o].art = 62;
				objekt[o].nr = GEGNERPICS + 23;
				objekt[o].energie /= 2;
				objekt[o].weapon_fire = 64;
				objekt[o].weapon_ok = objekt[o].weapon_fire;
				objekt[o].extra_listnr = -1;
				objekt[o].startpause = 0;

				switch(i)
				{
					case 0:
						objekt[o].bahn.x -= 70 * KURVENFAC;
						objekt[o].bahn.y -= 60 * KURVENFAC;
						break;
					case 1:
						objekt[o].bahn.x += 70 * KURVENFAC;
						objekt[o].bahn.y -= 60 * KURVENFAC;
						break;
					case 2:
						objekt[o].bahn.x -= 70 * KURVENFAC;
						objekt[o].bahn.y += 60 * KURVENFAC;
						break;
					case 3:
						objekt[o].bahn.x += 70 * KURVENFAC;
						objekt[o].bahn.y += 60 * KURVENFAC;
						break;
				}
	
/*				restart_koords[i + 1].obj = &objekt[o];
				restart_koords[i + 1].x = objekt[o].bahn.x;
				restart_koords[i + 1].y = objekt[o].bahn.y; */
			}
		}
	}
}

BOOLEAN endgegner_treffbar(OBJEKT *obj)
{
	// Endgegner4 wird erst getroffen, wenn Rakwerfer weg!
	if(!((obj->art == 52) && endgegner4_rakwerfer_da())
	   && !((obj->art == 50) && endgegner1_kanonen_da())
		&& (obj->art != 61))
		return(TRUE);
	else
		return(FALSE);
}


int endgegner_energie()
{
	int i, energie;

	energie = 0;
	for(i = 0; i < MAX_OBJEKTE; i++)
		if(objekt[i].nr && (objekt[i].art >= 50) && (objekt[i].art < 100))
			energie += objekt[i].energie;

	return(energie);
}

void set_restart_koords(OBJEKT *obj)
{
	int o;

	o = 0;
	while((o < MAX_RESTARTOBJS) && (restart_koords[o].obj != obj))
		o++;
	if(o < MAX_RESTARTOBJS)
	{
		obj->bahn.x = restart_koords[o].x;
		obj->bahn.y = restart_koords[o].y;
	}
}

void endgegner_restarten(OBJEKT *obj)
{
	int i, fire, old_energie;

	fire = obj->weapon_ok;
	old_energie = obj->energie;
	// Startkette suchen und neustarten ...
	if((obj->art == 50) && !endgegner1_kanonen_da())
	{
		// Flieger ohne Kanonen - Sonderfall
		i = 0;
		while((i < anz_ketten) && !(startkette[i].start_x && (startkette[i].obj.art == 50)))
				i++;
		// weitersuchen fr 2. Bahn!
		i++;
		while((i < anz_ketten) && !(startkette[i].start_x && (startkette[i].obj.art == 50)))
				i++;
		if(i < anz_ketten)
		{
			*obj = startkette[i].obj;
//			set_restart_koords(obj);
			obj->startpause = 0;
		}
	}
	else if(obj->art == 52)
	{
		// Schiff (4. Endgegn.) kommt zufllig an y
		i = 0;
		while((i < anz_ketten) && !(startkette[i].start_x && (startkette[i].obj.nr == obj->nr)))
				i++;
		if(i < anz_ketten)
		{
			*obj = startkette[i].obj;
			obj->bahn.y = (screen_height / 2 + (rand() % 160) - 80) * KURVENFAC;
			obj->startpause = 0;

			// Raketenwerferrestarty auch umsetzen
			if(restart_koords[0].y < restart_koords[1].y)
			{
				restart_koords[0].y = obj->bahn.y - 30 * KURVENFAC;
				restart_koords[1].y = obj->bahn.y + 30 * KURVENFAC;
			}
			else
			{
				restart_koords[0].y = obj->bahn.y + 30 * KURVENFAC;
				restart_koords[1].y = obj->bahn.y - 30 * KURVENFAC;
			}
		}
	}
	else if(obj->art == 53)
	{
		// Schiffsraketenwerfer - Sonderfall
		i = 0;
		while((i < anz_ketten) && !(startkette[i].start_x && (startkette[i].obj.art == 52)))
				i++;
		if(i < anz_ketten)
		{
			*obj = startkette[i].obj;
			obj->art = 53;
			obj->nr += 1;
			set_restart_koords(obj);
			obj->weapon_fire = 64;
			obj->extra_listnr = -1;
			obj->startpause = 0;
		}
	}
	else if(obj->art == 54)
	{
		// Endgegner1fliegerkanonen - Sonderfall
		i = 0;
		while((i < anz_ketten) && !(startkette[i].start_x && (startkette[i].obj.art == 50)))
				i++;
		if(i < anz_ketten)
		{
			*obj = startkette[i].obj;
			obj->art = 54;
			obj->nr = GEGNERPICS + 240;
			set_restart_koords(obj);
			obj->weapon_fire = 64;
			obj->extra_listnr = -1;
			obj->startpause = 0;
		}
	}
	else if((obj->art == 55) || (obj->art == 56) || (obj->art == 57) || (obj->art == 58) || (obj->art == 60) || (obj->art == 61) || (obj->art == 62))
	{
		// Fliegerstation: Engegn 4 - eins weiter hinten restarten
		// ebenso: Endgegner 5 - Schiff mit Kanonen
		// 8 auch
		i = 0;
		while((i < anz_ketten) && !(startkette[i].start_x && (startkette[i].obj.nr == obj->nr)))
				i++;
		if(i < anz_ketten)
		{
			*obj = startkette[i].obj;
			obj->startpause = 0;
			obj->bahn.akt = 0;
			while(obj->bahn.kurve[obj->bahn.akt].len-- > 0)
			{
				obj->bahn.x += obj->bahn.kurve[obj->bahn.akt].xpl / KURVENFAC;
				obj->bahn.y += obj->bahn.kurve[obj->bahn.akt].ypl / KURVENFAC;

				obj->bahn.kurve[obj->bahn.akt].xpl += obj->bahn.kurve[obj->bahn.akt].xxpl;
				obj->bahn.kurve[obj->bahn.akt].ypl += obj->bahn.kurve[obj->bahn.akt].yypl;
			}
			obj->bahn.akt++;
		}
	}
	else
	{
		i = 0;
		while((i < anz_ketten) && !(startkette[i].start_x && (startkette[i].obj.nr == obj->nr)))
				i++;
		if(i < anz_ketten)
		{
			*obj = startkette[i].obj;
//			set_restart_koords(obj);
			obj->startpause = 0;
		}
	}
	obj->weapon_ok = fire;
	obj->energie = old_energie;
}

void endgegner_tot(OBJEKT *obj)
{
	int i, pixnr, xw, yh, anz;

	if((obj->art >= 50) && (obj->art < 100))
	{
		if(obj->art == 51)
		{
			// nur dann Ende, wenn KEINER von der Art mehr am Leben ...
			if(alle_tot(obj))
				level_over--;
		}
		else if((obj->art != 53) && (obj->art != 54) &&(obj->art != 61) && (obj->art != 62))	 // Nicht bei den Schiffsraketenwerfern usw.
			level_over--;

		// Bei Endgegner 7 (Station) auch Greifer zerstoeren
		if(obj->art == 58)
		{
			for(i = 0; i < MAX_OBJEKTE; i++)
				if(objekt[i].nr && (objekt[i].art == 38))
				{				
					explode(obj->bahn.x / KURVENFAC - 96, obj->bahn.y / KURVENFAC, 100, 50, 0);
					explode(obj->bahn.x / KURVENFAC, obj->bahn.y / KURVENFAC, 100, 50, 0);
					explode(obj->bahn.x / KURVENFAC + 32, obj->bahn.y / KURVENFAC, 100, 50, 0);
					delete_objekt(&objekt[i]);
				}
		}

		// Riesenexplo
		pixnr = obj->nr + obj->anistufe / ANIFAC;
		xw = objpix[pixnr].w / 3 + 20;	// etwas kleiner
		yh = objpix[pixnr].h / 3 + 15;	// als normal

		if((game_view == FULL) || (game_view == HIGH))
			anz = 50;
		else if(game_view == MEDIUM)
			anz = 25;
		else
			anz = 10;
		for(i = 0; i < anz; i++)
		{
			if((rand() % 50 < 2) && (game_view == FULL))
				explode(obj->bahn.x / KURVENFAC + (rand() % (xw * 2)) - xw, obj->bahn.y / KURVENFAC + (rand() % (yh * 2)) - yh, rand() % objpix[pixnr].w, rand() % objpix[pixnr].h, 3);
			else
				explode(obj->bahn.x / KURVENFAC + (rand() % (xw * 2)) - xw, obj->bahn.y / KURVENFAC + (rand() % (yh * 2)) - yh, rand() % objpix[pixnr].w, rand() % objpix[pixnr].h, 0);
		}
	}
}

BOOLEAN endgegner4_rakwerfer_da()
{
	int i;

	for(i = 0; i < MAX_OBJEKTE; i++)
		if(objekt[i].nr && (objekt[i].art == 53))
			return(TRUE);

	return(FALSE);
}

BOOLEAN endgegner1_kanonen_da()
{
	int i;

	for(i = 0; i < MAX_OBJEKTE; i++)
		if(objekt[i].nr && (objekt[i].art == 54))
			return(TRUE);

	return(FALSE);
}
